/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"
#include <stdio.h>

/***
 *  Function    :  hextostr
 *
 *  Description :  Convert an hexadecimal flow of bytes into
 *                 a string containing an hexadecimal representation.
 *
 *  Parameters  :  out   char *string
 *                 in    char *hexa
 *                 in    int  length        number of hexadecimal bytes
 *
 *  Return      :   0 if OK
 *                 -1 on error
 *
 *  OS/Compiler :  All
 ***/              
    
int hextostr( char *string, const char *hexa, int length )
    
{                    
  while ( length-- )
        { sprintf( string, "%02X", (unsigned char) *hexa++ );
          string += 2;
        }

  return 0;
}

