/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"


/***
 *  Function    :  strcpyb
 *
 *  Description :  Like strcpy but truncates trailing blanks and \n
 *                 and skip leading blanks.
 *
 *  Parameters  :  out   char * target
 *		   in    char * source
 *
 *  Return code :  like strcpy
 *
 *  OS/Compiler :  All
 ***/

char *strcpyb( char *target, const char *source )

{ int len;

  while ( *source++ == ' ' ); source--;

  len = strlen( source );
  while ( len && (source[len - 1] == ' ' || source[len - 1] == '\n') ) len--;
  strncpy( target, source, len );
  target[len] = '\0';

  return target;
}
