/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "tools.h"
#include <dos.h>
#include <direct.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

/*
 * Functions    : filedel
 *
 * Description  : Like 'unlink' but allows wildcards
 *
 * Remarks      : Change to target directory to delete files
 *                and come back to current one.
 *
 * Return       :  none
 *
 */

void filedel( const char *filename )

{ struct fcb Fcb;
  void far *pFcb = &Fcb;
  union REGS regs;
  struct SREGS sregs;
  char *ptr1, *ptr2;
  char curdir[_MAX_PATH] = " :/";


  if ( filename[1] == ':' ) Fcb.fcb_drive = toupper( *filename ) - 'A' + 1;
                       else Fcb.fcb_drive = getdisk();

  ptr1 = max( strrchr(filename, '\\'), strrchr(filename, '/') );

  if ( ptr1 ) { int result;
                char tmp;
                *curdir = Fcb.fcb_drive + 'A' - 1;
                getcurdir( Fcb.fcb_drive, curdir + 3 );
                tmp = *++ptr1;
                *ptr1 = '\0';
                result = chdir( filename );
                *ptr1 = tmp;
                if ( result ) return;
              }

  memset( Fcb.fcb_name, ' ', 11 );
  ptr2 = Fcb.fcb_name;
  while ( *ptr1 && (*ptr1 != '.') ) *ptr2++ = *ptr1++;
  ptr2 = Fcb.fcb_ext;
  if ( *ptr1++ )
     while ( *ptr1 ) *ptr2++ = *ptr1++;

        /*
        DOS Interrupt 13H
        Input:  DS:DX = pointer to fcb
        */

  sregs.ds  = FP_SEG( pFcb );
  regs.x.dx = FP_OFF( pFcb );
  regs.h.ah = 0x13;
  intdosx( &regs, &regs, &sregs );

  if ( *curdir != ' ' ) chdir( curdir );
}
