/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "tools.h"
#include <stdlib.h>
#include <string.h>
#include <dos.h>


/***
 *
 *  Function   :    gettmppath
 *
 *  Topics     :    Transforms a filename into a full pathname
 *                  relative to temporary directory.
 *
 *  Parameters :    in/out  char *filename    filename
 *
 *  Return     :    pointer to filename
 *
 ***/

char *gettmppath( char *filename )

{ char *ptr;

  ptr = getenv( "TEMP" );
  if ( ! ptr || ! *ptr ) ptr = getenv( "temp" );
  if ( ! ptr || ! *ptr ) ptr = getenv( "TMP" );
  if ( ! ptr || ! *ptr ) ptr = getenv( "tmp" );

  if ( ptr && *ptr ) { char buffer[_MAX_PATH];
                       strcpy( buffer, filename );
                       _makepath( filename, "", ptr, buffer, "");
                       strupr( filename );
                     }
                else getpgmpath( filename );

  return filename;
}


#ifdef MAIN

#include <stdio.h>
#include <conio.h>
void main( void )

{ char f[_MAX_PATH] = "abc.ext";

  putenv( "TEMP=e:\\tmp" );
  putenv( "TMP=c:\\tmp" );
  clrscr();
  printf( "%s\n", gettmppath(f) );
  getch();
}

#endif
