/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "date.h"
#include <time.h>


/***
 *
 *  Function  :    day_of_week
 *
 *  Return    :    0 = sunday, 1 = monday,...
 *
 *  Decisions :    If date is not valid, return -1.
 *
 ***/

int day_of_week( int day , int month , int year )

{ struct tm dtime ;

  if ( ! isdatevalid(day , month , year) ) return -1 ;

  dtime.tm_year = year - 1900 ;
  dtime.tm_mon  = month - 1 ;
  dtime.tm_mday = day ;
  dtime.tm_hour = 0;
  dtime.tm_min  = 0;
  dtime.tm_sec  = 1;
  dtime.tm_isdst = -1;

  /*  call mktime to fill in the weekday field of the structure */

  if ( mktime(&dtime) == -1 ) return -1 ;

  return dtime.tm_wday ;
  
/*
  const signed char calendar[12] = { 0 , 1 , -1 , 0 , 0 , 1 , 1 , 2 , 3 , 3 , 4 , 4 }
  
  return ( 365L * (year - 1) + (year - 1) / 4 - (year - 1) / 100 - (year - 1) / 400
          + (month - 1) * 30 + calendar[month - 1] 
          + isleapyear(year) && (month > 2)
          + day
         ) % 7 ;
*/

/*
  const signed char calendar[12] = { 6 , 2 , 2 , 5 , 0 , 3 , 5 , 1 , 4 , 6 , 2 , 4 }  
  int century ;
  long result = 0 ;
  if ( isleapyear(year) && (month < 3) ) result = -1 ;

  century = year / 100 ; year %= 100 ;

  result += ( century * 5 + century / 4 + year + year / 4 + day + calendar[month] ) % 7 ;

We can precompute x = (century * 5 + century / 4 + year + year / 4) % 7
and use result += ( x + day + calendar[month] ) % 7 


*/
}

              