/*******************************************************************
* TIMER.C - This program times the execution of two functions that *
* reside in the file TESTFUNC.C. You compile TESTFUNC.C using the  *
* type of optimization you wish to test. However, the switches you *
* use to compile this file, TIMER.C, should remain constant for    *
* all tests.                                                       *
*                                                                  *
* To compile without optimization: cl /Ox TIMER.C /Od TESTFUNC.C   *
* To compile with optimization: cl /Ox TIMER.C /Ozax TESTFUNC.C    *
*                                                                  *
* RHS 3/01/91                                                      *
*******************************************************************/
#include<time.h>
#include<process.h>
#include<stdio.h>
#include<stdlib.h>

#define DEF_ITERATIONS   10000000L
#define MICROSECONDS     1000000L
#define TRUE 1
#define FALSE 0

int testfunc1(void);
int testfunc2(void);
void emptyfunc(void);
void cdecl main(int argc, char **argv);

void cdecl main(int argc, char **argv)
    {
    long start = 0L, end = 0L, control_start = 0L, control_end = 0L;
    unsigned long iterations, setting = DEF_ITERATIONS;
    unsigned def = FALSE;
    double test1,test2,empty,op1,op2;

    if(argc < 2)
        def = TRUE;
    else
        {
        if(!atol(argv[1]))
            def = TRUE;
        else
            setting = atol(argv[1]);
        }

    if(def)
        printf("Testing with default iterations: %lu\n",setting);
    else
        printf("Testing with %lu iterations\n",setting);

    puts("Timing empty function...");
    iterations = setting;
    control_start = clock();
    for( ; iterations; iterations--)
        emptyfunc();
    control_end = clock();
    empty = (double)(control_end-control_start);
    empty /= CLOCKS_PER_SEC;

    puts("Testing testfunc1...");
    iterations = setting;
    start = clock();
    for( ; iterations; iterations--)
        testfunc1();
    end = clock();
    test1 = (double)(end-start);
    test1 /= CLOCKS_PER_SEC;
	 test1 = (test1 < empty) ? empty : test1;
	 op1 = (test1 - empty);

    puts("Testing testfunc2...");
    iterations = setting;
    start = clock();
    for( ; iterations; iterations--)
        testfunc2();
    end = clock();
    test2 = (double)(end-start);
    test2 /= CLOCKS_PER_SEC;
	 test2 = (test2 < empty) ? empty : test2;
	 op2 = (test2 - empty);

    printf("Test end:\n");
 	 printf(" Empty function required: %04.5f \n", empty);
	 printf("testfunc1 Gross required: %04.5f seconds\n", test1);
	 printf("  testfunc1 Net required: %04.5f seconds", op1);
	 printf(", %04.5f uSec. each\n", (op1/(setting/MICROSECONDS)));
	 printf("testfunc2 Gross required: %04.5f seconds\n", test2);
	 printf("  testfunc2 Net required: %04.5f seconds", op2);
	 printf(", %04.5f uSec. each\n", (op2/(setting/MICROSECONDS)));
    }
