;
; SCRPUTS.ASM
;
; From the book "Systems Progamming in Turbo C", by Michael J. Young
;
; These versions of ScrPutS and ScrPutWin are written specifically
; for CGA adapters that produce 'snow' when writing directly to the screen.

		EXTRN _VideoSeg:word		; external - see scr.h

		assume	cs:_text			; Medium,large,huge: replace '_text'
									; with 'filename_text'.

_text	segment byte public 'code'	; see above comment for other models


; ------------------------ ScrPutS() -------------------------------

public	_ScrPutS

_ScrPutS	proc near				; other models, replace 'near' w/ 'far'


h_retrace	macro					; Pauses until the beginning of a
			local	m01, m02		; horizontal retrace
m01:		in		al, dx			; loop to complete any retrace period
			test	al, 1			; in progress
			jnz		m01
m02:		in		al, dx			; loop until start of a new horizontal
			test	al, 1			; retrace
			jz		m02
			endm

sframe		struc					; template to access stack frame
BasePtr		dw		?				; Position of saved BP register
RetAd		dw		?				; Other models: replace 'dw' w/ 'dd'
str_ad		dw		?				; String adress: same comment as above
att			dw		?				; Display attribute
row			dw		?				; Starting row
col			dw		?				; Starting column
sframe		ends

frame		equ		[bp - BasePtr]	; Base for accessing stack frame

									; Standard initialization
			push	bp				; Set up base pointer to access frame
			mov		bp, sp
			sub		sp, BasePtr		; Adjust SP for local variables
			push	di				; Save C register variables
			push	si

			mov		si, frame.str_ad	; DS:SI point to start of source
										; string. Compact, Large, Huge:
										; replace this statement with:
										; lds	si, frame.str_ad

			mov		ax, _VideoSeg		; Set ES to CGA buffer
			mov		es, ax
									; Starting offset =
									;   (row * 160) + (col * 2)
			mov		di, frame.row	; Place row in DI & multiply by 160
			mov		ax, di
			mov		cl, 7
			shl		di, cl
			mov		cl, 5
			shl		ax, cl
			add		di, ax

			mov		ax, frame.col	; Multiply col by 2
			shl		ax, 1
			add		di, ax			; Add (col * 2) to DI

									; Attribute in BH
			mov		bh, byte ptr frame.att
			mov		dx, 03dah		; CRT status register

a01:
			cmp		byte ptr [si], 0	; Test for null termination
			je		a02
			mov		bl, [si]		; Move next character to BL
			inc		si
			cli						; Disable interrupts
			h_retrace				; Wait for horizontal retrace
			mov		es:[di], bl		; Move ASCII
			inc		di
			h_retrace				; Wait again
			mov		es:[di], bh		; Move ATTRIBUTE
			sti						; Restore interrupts
			inc		di				; Increment offset in video memory
			jmp		a01				; Go back for another character
a02:
			pop		si				; restore C register variables
			pop		di
			mov		sp, bp
			pop		bp
			ret						; Return to C program

_ScrPutS	endp

_text		ends
			end