/***********************************************************/
/* File Id.                  Qbox.C                        */
/* Author.                   Stan Milam                    */
/* Date Written.             11/13/88.                     */
/* Modifications:                                          */
/*                                                         */
/*           (c) Copyright 1989-90 by Stan Milam           */
/*                                                         */
/* Comments: This module will "box" or "frame" a portion of*/
/* the text screen.                                        */
/***********************************************************/

#include "pcwproto.h"

static int bdrfclr = LIGHTGRAY;
static int bdrbclr = BLACK;
static int btype   = 0;

static char corner [5][4] = {
   {201,187,200,188},
   {218,191,192,217},
   {213,184,212,190},
   {214,183,211,189},
   {32,32,32,32}
};

static char sides[5] = {186,179,179,186,32};
static char tpbt[5]  = {205,196,205,196,32};

int qbox(int urow, int ucol,int lrow,int lcol) {

     int mxr, mxc;

     if (btype < 0 || btype > 4) btype = 0;
     if (!chk_video_state(&mxr,&mxc)) return(0);

     qputchar(urow,ucol,bdrfclr,bdrbclr,corner[btype][0]);
     qputchar(urow,lcol,bdrfclr,bdrbclr,corner[btype][1]);
     qputchar(lrow,ucol,bdrfclr,bdrbclr,corner[btype][2]);
     qputchar(lrow,lcol,bdrfclr,bdrbclr,corner[btype][3]);

     qhchar(urow,ucol+1,bdrfclr,bdrbclr,tpbt[btype], (lcol-ucol)-1);
     qhchar(lrow,ucol+1,bdrfclr,bdrbclr,tpbt[btype], (lcol-ucol)-1);
     qvchar(urow+1,ucol,bdrfclr,bdrbclr,sides[btype],(lrow-urow)-1);
     qvchar(urow+1,lcol,bdrfclr,bdrbclr,sides[btype],(lrow-urow)-1);
     return(1);
}

void bordercolor(int fcolor, int bcolor) {

     bdrfclr = fcolor & 0x000f;
     bdrbclr = bcolor & 0x000f;
}

void setborder(int type) {

   if (type <0 || type > 4) return;
   else btype = type;
}
