/*****************************************************************************
   MODULE: rcbput.c
  PURPOSE: recio column delimited integral number output functions
COPYRIGHT: (C) 1994-1995, William Pierpoint
 COMPILER: Borland C Version 3.1
       OS: MSDOS Version 6.2
  VERSION: 2.12
  RELEASE: January 29, 1995
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "recio.h"

extern int _risready(REC *rp, int mode);
extern int _rputc(REC *rp, int ch);

#define rfp(rp)          ((rp)->r_fp)
#define rcol(rp)         ((rp)->r_colno)
#define rfldch(rp)       ((rp)->r_fldch)
#define rflags(rp)       ((rp)->r_flags)

#define uint             unsigned int
#define ulong            unsigned long
#define UNSIGNED         0
#define SIGNED           1

/****************************************************************************/
static void                  /* return nothing                              */
    _rcbputl(                /* put integral number to col delim rec stream */
        REC   *rp,           /* pointer to record stream                    */
        size_t begcol,       /* field inclusive beginning column            */
        size_t endcol,       /* field inclusive ending column               */
        int    base,         /* base (radix) (2 to 36)                      */
        int    sign,         /* signed number?                              */
        long   num)          /* number to put to stream                     */
/****************************************************************************/
{
    size_t sl;               /* length of _r_nsbuf */

    if (_risready(rp, R_WRITE)) { 
        if (endcol>=begcol && begcol>=rcolno(rp) && base>=2 && base<=36) {
            rfldno(rp)++;
            rflags(rp) &= ~_R_TXT;

            /* if colno < begcol, pad with spaces */
            while (rcolno(rp) < begcol) {
                if (_rputc(rp, ' ')) goto done;
            }

            /* based on sign, select conversion function */
            if (sign) {
                ltoa(num, _r_nsbuf, base);
            } else {
                ultoa((ulong)num, _r_nsbuf, base);
            }

            /* if converted string fits space */
            sl = strlen(_r_nsbuf); 
            if (sl <= (endcol-begcol+1)) { 

                /* right justify string */
                while (rcolno(rp) <= endcol-sl) { 
                    if (_rputc(rp, ' ')) goto done; 
                }
                
                /* output converted string */
                if (fputs(_r_nsbuf, rfp(rp))==EOF) { 
                    rseterr(rp, R_ENOPUT); 
                } else { 
                    rcol(rp) += sl; 
                } 

            /* else converted string too long for space */
            } else { 
                rsetwarn(rp, R_WWIDTH); 
                while (rcolno(rp) <= endcol) { 
                    if (_rputc(rp, '*')) goto done;
                } 
            } 

        } else { 
            rseterr(rp, R_EINVAL); 
        } 
    } 
done: 
}

/****************************************************************************/
/* column delimited integral number output functions                        */
/****************************************************************************/
void rcbputi(REC *rp, size_t begcol, size_t endcol, int base, int num)
{
    _rcbputl(rp, begcol, endcol, base, SIGNED, (long) num);
}

void rcbputui(REC *rp, size_t begcol, size_t endcol, int base, uint num)
{
    _rcbputl(rp, begcol, endcol, base, UNSIGNED, (long) num);
}

void rcbputl(REC *rp, size_t begcol, size_t endcol, int base, long num)
{
    _rcbputl(rp, begcol, endcol, base, SIGNED, num);
}

void rcbputul(REC *rp, size_t begcol, size_t endcol, int base, ulong num)
{
    _rcbputl(rp, begcol, endcol, base, UNSIGNED, (long) num);
}
