* Function: CLOSEAREA
* Author..: Richard Low
* Syntax..: CLOSEAREA( [ <expN..C>, ... ] )
* Returns.: True if requested work areas have been closed.  Notes the
*           currently SELECTed work area and returns control there.
*

FUNCTION CLOSEAREA
PARAMETERS p_1, p_2, p_3, p_4, p_5, p_6, p_7, p_8, p_9
PRIVATE f_numparms, f_cur_area, f_counter, f_parname, f_workarea

f_numparms = PCOUNT()                            && get number of parameters
f_cur_area = SELECT()                            && save current work area

IF f_numparms = 0                                && if no parameters passed
   USE                                           && close only current area
ELSE
   FOR f_counter = 1 TO f_numparms               && go thru each parameter
      f_parname = 'p_' + STR(f_counter,1,0)      && build parameter name string
      IF .NOT. TYPE(f_parname) $ 'NC'            && if parm is not number or character
         SELECT (f_cur_area)                     && return to current area
         RETURN (.F.)                            && bomb out
      ENDIF
      IF TYPE(f_parname) = 'N'                   && if parameter is numeric
         f_workarea = &f_parname                 && reference area by number
      ELSE                                       && parameter is character
         f_workarea = SELECT(&f_parname)         && get number for alias
         *-- if alias name is bad, it will SELECT 0, essentially doing nothing
      ENDIF
      SELECT (f_workarea)                        && select the work area
      USE                                        && close the database
   NEXT
ENDIF

SELECT (f_cur_area)                              && return to current area
RETURN (.T.)
