* Function: FORGET
* Author..: Richard Low
* Syntax..: FORGET()
* Notes...: Procedure to release all memory variables created with MEMORIZE


FUNCTION FORGET
PARAMETERS p_first, p_last
PRIVATE f_x, f_field

*-- if no fields in database or no file is open
IF FCOUNT() = 0
   *-- bomb out
   RETURN .F.
ENDIF

*-- see if they want a blank record (if parm is logical true) default = No
p_blank = IF( TYPE('p_blank') = 'L', p_blank, .F. )

*-- see if they specified a starting field number, default to 1st field
p_first = IF( TYPE('p_first') = 'N', p_first, 1 )

*-- see if they specified an ending field number, default to last field
p_last = IF( TYPE('p_last') = 'N', p_last, FCOUNT() )

*-- go thru all fields in database
FOR f_x = p_first TO p_last
   f_field = FIELD(f_x)
   RELEASE M->&f_field
NEXT f_x

RETURN .T.
