//--------------------------------------------------------------------------
//
//      EXAMPLE5.CPP: example for DOS multithreading library.
//      Copyright (c) J.English 1993.
//      Author's address: je@unix.brighton.ac.uk
//
//      Permission is granted to use copy and distribute the
//      information contained in this file provided that this
//      copyright notice is retained intact and that any software
//      or other document incorporating this file or parts thereof
//      makes the source code for the library of which this file
//      is a part freely available.
//
//--------------------------------------------------------------------------
//
//      This example is identical to the previous one, except that
//      it uses "bioskey(0)" instead of "getch()" to get characters.
//      This will crash if a memory manager is being too clever (e.g.
//      QEMM with the ST:M option).
//
//--------------------------------------------------------------------------

#include <stdio.h>
#include <bios.h>
#include "threads.h"
#include "buffers.h"

BoundedBuffer<char> buffer (20);        // a buffer of 20 characters

class Example5a : public DOSThread
{
  public:
    Example5a ()            { }
    ~Example5a ();

  protected:
    virtual void main ();
};

void Example5a::main ()
{
    char c;
    for (;;)
    {   if (!buffer.get (c))
            return;
        putchar (c);
    }
}

Example5a::~Example5a ()
{
    wait ();
    fputs ("\nEnd of thread A\n", stdout);
}

class Example5b : public DOSThread
{
  public:
    Example5b ()            { }
    ~Example5b ();

  protected:
    virtual void main ();
};

void Example5b::main ()
{
    char c;
    for (;;)
    {   if (!buffer.get (c))
            return;
        putchar ('*');
    }
}

Example5b::~Example5b ()
{
    wait ();
    fputs ("\nEnd of thread B\n", stdout);
}

void main ()
{
    Example5a A;
    Example5b B;

    if (A.run ())
        puts ("Thread A started");
    if (B.run ())
        puts ("Thread B started");

    puts ("Press ESC to terminate");

    char c;
    for (;;)
    {   c = bioskey(0) & 0xFF;          // slightly risky...
        if (c == 0x1B)
        {   buffer.close ();
            puts ("\nTerminating...");
            break;
        }
        else
            buffer.put (c);
    }
}
