/* -------------------------------------------------------------------- */
/* String++ Version 3.00                                       04/10/93 */
/*                                                                      */
/* Enhanced string class for Turbo C++/Borland C++.                     */
/* Copyright 1991-1993 by Carl W. Moreland                              */
/*                                                                      */
/* Derived from code Copyright 1988, Jim Mischel.  All rights reserved. */
/* regexp.h                                                             */
/* -------------------------------------------------------------------- */

#ifndef _REGEXP_H
#define _REGEXP_H

#if defined (__ZTC__)
#include <stream.hpp>			// Zortech
#else
#include <iostream.h>			// Borland
#endif

#include "parsestr.h"

extern int RSTART;
extern int RLENGTH;
extern int NF;

class RegExp
{
private:
  ParseString reExpression;		// holds the regular expression
  String      rePattern;		// holds the compiled version
  char* reLastChar;			// used in Match... functions

  const char* MakePattern(void);	// entry point to compile pattern
  const char* ParseExpression(String&);
  const char* ParseTerm(String&);
  const char* ParseFactor(String&);
  char        ParseEscape(void);
  int         ParseClosure(String&);
  const char* ParseCCL(String&);
  const char* ParseDASH(String&, char);

  int         IsFactor(void);
  const char* SkipTerm(char* pattern);

  int Match(const char*, const char*);	// entry point to match expression
  int MatchTerm(int, char*, char*);
  int MatchOR(int, char*, char*);
  int Match_0_1(int, char*, char*);
  int MatchClosure(int, char*, char*, char*);
  int MatchCCL(char, char*);

public:
  RegExp(void) {}
  RegExp(const String&);

  operator const char*()   { return reExpression(); }
  const char* operator()() { return reExpression(); }
  void operator=(const char*);
  void operator=(const String&);

  friend const char* SetFS(const String& s);
  friend int match(const String&, RegExp&);
  friend int operator==(const String& s, RegExp& re);
  friend int operator!=(const String& s, RegExp& re);
  friend ostream& operator<<(ostream&, const RegExp&);
};

typedef RegExp Regexp;			// allow the use of Regexp
extern RegExp FS;

inline int operator==(const String& s, RegExp& re)
{
  return (re.Match(s, re.rePattern) == -1) ? 0 : 1;
}

inline int operator!=(const String& s, RegExp& re)
{
  return (re.Match(s, re.rePattern) == -1) ? 1 : 0;
}

inline int match(const String& s, RegExp& re)
{
  return re.Match(s, re.rePattern);
}

int sub(RegExp& from, const String& to, String& str);
int gsub(RegExp& from, const String& to, String& str, unsigned count=10000);
int split(const String& s, String*& a, const RegExp& fs);
int index(const String& s, const RegExp& t);

#endif
