	.PRINTC 15		;CONTROL-O FOR EPSON 16.7 CPI
	.PAGE			;PAGING ON AT DEFAULT 58 LINES/PAGE
	.WIDTH 132		;WILL GET IT ALL ON WIDE PAPER
;
; Note:  .PRINTC and .PAGE were used in this file, but they don't print on
;        the output.  See the input TEST02.ASM.
;
;  TEST AND DEMONSTRATION FILE FOR SVASM02 6502/65C02 ASSEMBLER
;
	* = $1000		;TYPICAL START ADDRESS
;
	.LISTF			;LIST FALSE CONDITIONALS

;  PRECEEDING BLANK LINE SHOULD BE COUNTED
;
;  EQUATES
;
	START = *
START2	* = * + 6		;EQUIV TO INTEL DS 6
	LOWBYT = <$1234		;EXTRACT LOW BYTE...
	HIBYT = >$1234		;...AND THE HIGH
	QUOTE1='G'		;SINGLE QUOTE
	QUOTE2 = 'CQ'		;DOUBLE
	ONEBYT = $25		;ONE BYTE
	TWOBYT = $4455		;TWO BYTES
	ZERO = $00		;A ZERO
	TSTINC = $FF		;FOR COND. ASSEM. TEST
	PORT1 = $3002		;SAME
	PORT3 = $3004
	DAT1 = $3005
	DAT3 = $3006
;
;  Lower case is OK in comments, but NOT for mnemonics or directives
;  It's also good in quoted strings, such as:
	.BYTE 'This is a lower case string'
;
;  LEADING/TRAILING RADIX SPECIFIERS
;
	DECI = 4095		;NO SPECIFIER IS DECIMAL
;
	BVAL1 = 10011101B	;BINARY NUMBERS
	BVAL2 = %10011101
;
	OCTAL1 = @1377		;OCTAL
	OCTAL2 = 1377Q
;
	HEX1 = $80		;HEXADECIMAL
	HEX2 = 80H
;
;  ARITHMETIC
;
	DIFF = $120-$100
	MINUS = $100 - $120
	MIXED = OCTAL1+BVAL1-HEX1
	BIAS = 'A'-'9'-1
	MULT = 2 * 16
	DIV = HEX1/2
	SUM = BVAL2+HEX2
;
;  BYTE AND WORD DIRECTIVES
;
	.BYTE $0D,$0A,'SVENSON ELECTRONICS','$'
	.BYTE $45,$23,$31,$00
	.WORD TWOBYT,ONEBYT
;
	.INCLUDE TESTBOOL.ASM	;TEST .INCLUDE, LOGICAL OPS
	.INCLUDE ;TESB.ERR	;AND AGAIN
	.INCLUDE D:NODRIVE.ASM	;STILL AGAIN
	.INCLUDE TESTBOL.ASM	;LAST TIME
;
.IF TSTINC
;
;  THIS WILL ASSEMBLE, SINCE TSTINC IS NON-ZERO
;
	LDA PORT1
	AND #$FF
	STA DAT1
;
	.ELSE			;THIS WILL NOT ASSEMBLE, BUT
				;WILL LIST SINCE WE USED .LISTF
	LDA PORT3
	AND #$47
	STA DAT3
;
		.ENDIF		;LOCATION ON THE LINE IS UNIMPORTANT
;
.NOLIST				;YOU SHOULDN'T SEE NEXT LINE
;THIS LINE SHOULD NOT LIST UNLESS THERE IS A BUG IN .NOLIST
LIST	NOP			;SEE IF LABEL IS DEFINED AND
	BEQ *+6			;LINES ADVANCE
.LIST				;TURN IT BACK ON
;
;  UNIQUE CMOS (65C02) INSTRUCTIONS.  .CMOS IS DEFAULTED
;  OFF, SO ALL THE FOLLOWING SHOULD PRODUCE ERRORS.
;
	BRA *-126
;
	STZ 56			;ZERO PAGE
	STZ 56,X		;ZERO PAGE, INDEXED
	STZ 5678		;ABSOLUTE
	STZ 5678,X		;ABSOLUTE, X
;
	TSB $FF
	TRB $FF
	TSB $2012
	TRB $2012
;
	INA
	DEA
	PHY
	PLY
	PHX
	PLX
;
;  CMOS ADDRESSING MODES.  WILL ALSO PRODUCE ERRORS
;
	ORA (90)
	AND ($45)
	EOR ($80)
	ADC ($40)
	STA ($44)
	LDA ($90)
	CMP ($2E)
	SBC ($D4)
	BIT 120,X
	BIT #$34
	BIT $4123,X
	JMP ($4000,X)	
;
;  NOW TURN ON .CMOS, DO SAME INSTRUCTIONS
;
	.CMOS			;TURN ON CMOS
;
	BRA *-126
;
	STZ 56			;ZERO PAGE
	STZ 56,X		;ZERO PAGE, INDEXED
	STZ 5678		;ABSOLUTE
	STZ 5678,X		;ABSOLUTE, X
;
	TSB $FF
	TRB $FF
	TSB $2012
	TRB $2012
;
	INA
	DEA
	PHY
	PLY
	PHX
	PLX
;
;  CMOS ADDRESSING MODES
;
	ORA (90)
	AND ($45)
	EOR ($80)
	ADC ($40)
	STA ($44)
	LDA ($90)
	CMP ($2E)
	SBC ($D4)
	BIT 120,X
	BIT #$34
	BIT $4123,X
	JMP ($4000,X)	
;
;  NON-CMOS (6502) INSTRUCTIONS
;
ADCTST	ADC #40
	ADC ONEBYT
	ADC ONEBYT,X
	ADC TWOBYT
	ADC TWOBYT,X
	ADC TWOBYT,Y
	ADC ONEBYT,X)
	ADC (ONEBYT),Y
;
ANDTST	AND #40
	AND ONEBYT
	AND ONEBYT,X
	AND TWOBYT
	AND TWOBYT,X
	AND TWOBYT,Y
	AND (ONEBYT,X)
	AND (ONEBYT),Y
;
ASLTST	ASL A
	ASL ONEBYT
	ASL ONEBYT,X
	ASL TWOBYT
	ASL TWOBYT,X
;
BRTEST	BCC BRTEST
	BCS BRTEST
	BEQ BRTEST
;
BITEST	BIT ONEBYT
	BIT TWOBYT
;
	BMI BRTEST
	BNE BRTEST
	BPL BRTEST
;             The semicolon isn't required in blank lines, but it looks nice.
	BRK

	BVC BRTEST
	BVS BRTEST

	CLC
	CLD
	CLI
	CLV
;
CMPTST	CMP #40
	CMP ONEBYT
	CMP ONEBYT,X
	CMP TWOBYT
	CMP TWOBYT,X
	CMP TWOBYT,Y
	CMP (ONEBYT,X)
	CMP (ONEBYT),Y
;
CPXTST	CPX #40
	CPX ONEBYT
	CPX TWOBYT

	CPY #40
	CPY ONEBYT
	CPY TWOBYT

	DEC ONEBYT
	DEC ONEBYT,X
	DEC TWOBYT
	DEC TWOBYT,X

	DEX
	DEY

	EOR #40
	EOR ONEBYT
	EOR ONEBYT,X
	EOR TWOBYT
	EOR TWOBYT,X
	EOR TWOBYT,Y
	EOR (ONEBYT,X)
	EOR (ONEBYT),Y

	INC ONEBYT
	INC ONEBYT,X
	INC TWOBYT
	INC TWOBYT,X

	INX
	INY

	JMP START
	JMP (START)
	JSR START

	LDA #40
	LDA ONEBYT
	LDA ONEBYT,X
	LDA TWOBYT
	LDA TWOBYT,X
	LDA TWOBYT,Y
	LDA (ONEBYT,X)
	LDA (ONEBYT),Y

	LDX #40
	LDX ONEBYT
	LDX ONEBYT,Y
	LDX TWOBYT
	LDX TWOBYT,Y

	LDY #40
	LDY ONEBYT
	LDY ONEBYT,X
	LDY TWOBYT
	LDY TWOBYT,X

	LSR A
	LSR ONEBYT
	LSR ONEBYT,X
	LSR TWOBYT
	LSR TWOBYT,X

	NOP
;
	* = $2000		;SEE IF THE HEX FILE CATCHES A CHANGE IN PC
;
START3				;LABEL CAN BE ONLY THING ON A LINE, IF YOU LIKE
;
	ORA #40
	ORA ONEBYT
	ORA ONEBYT,X
	ORA TWOBYT
	ORA TWOBYT,X
	ORA TWOBYT,Y
	ORA (ONEBYT,X)
	ORA (ONEBYT),Y

	PHA
	PHP
	PLA
	PLP

	ROL A
	ROL ONEBYT
	ROL ONEBYT,X
	ROL TWOBYT
	ROL TWOBYT,X

	ROR A
	ROR ONEBYT	
	ROR ONEBYT,X
	ROR TWOBYT
	ROR TWOBYT,X

	RTI
	RTS

	SBC #40
	SBC ONEBYT
	SBC ONEBYT,X
	SBC TWOBYT
	SBC TWOBYT,X
	SBC TWOBYT,Y
	SBC (ONEBYT,X)
	SBC (ONEBYT),Y

	SEC
	SED
	SEI

	STA ONEBYT
	STA ONEBYT,X
	STA TWOBYT
	STA TWOBYT,X
	STA TWOBYT,Y
	STA (ONEBYT,X)
	STA (ONEBYT),Y

	STX ONEBYT
	STX ONEBYT,Y
	STX TWOBYT

	STY ONEBYT
	STY ONEBYT,X
	STY TWOBYT

	TAX
	TAY
	TYA
	TSX
	TXA
	TXS
;
;  EXAMPLES OF ERRORS NOT USED ELSEWHERE
;
	LDA ONEBGT		;UNDEFINED SYMBOL
	ONEBYT = $45		;SYMBOL PREVIOUSLY DEFINED
	STA			;SYNTAX ERROR
$CHEM	LDA PORT1		;ILLEGAL FIRST CHARACTER
	LDA FWDREF		;FORWARD REF TO PAGE ZERO
	ORA TWOBYTE		;SYMBOL >6 CHARACTERS
	* = FWDREF		;FORWARD REF IN EQUATE OR ORIGIN
	.PSGE 58		;UNIDENTIFIED DIRECTIVE
	QUOTE = 'KM2H'		;INVALID QUOTED STRING
	BEQ START		;BRANCH TARGET OUT OF RANGE
	HEXNUM = $12DS		;INVALID NUMERIC ARGUMENT
	OVERF = $FFFF + 1	;ARITHMETIC OVERFLOW
	LDA #260		;VALUE > 8 BITS
	ZERO1 = ONEBYT/ZERO	;DIVISION BY ZERO
	.ELSE			;NO OPEN IF
;
; MISC. TESTS
;
	BEQ *-126		;NO ERROR
	BEQ *-127		;BRANCH TARGET OUT OF RANGE
	BEQ *+129		;NO ERROR
	BEQ *+130		;BRANCH TARGET OUT OF RANGE
;
	JMP ONEBYT		;SHOULD USE ABSOLUTE
	JMP (ONEBYT)		;HERE TOO
	SBC ONEBYT,Y		;AND AGAIN
;
	.IF FWDREF		;FORWARD REFERENCE IN CONDITIONAL
;
	FWDREF = 127		;A PAGE ZERO DEFINITION
;
CHECKP	NOP			;ADDRESS AND VALUE IN TABLE SHOULD BE SAME
;
;	.END			;.END DIRECTIVE IS LAST (IT'S COMMENTED OUT)
