/*****************************************************************************
*  DVCLOCK.C (A public domain program.)                                      *
*                                                                            *
*  05/27/89 - D. Roseen - Initial version.  Clock for DESQview 2.2.  Setting *
*                         for memory size is only 13K RAM (if .EXE file is   *
*                         made with Turbo C V2.0 with debugging off).        *
*                         Operates with colors set for DESQview window and   *
*                         in military time.  The ESC key stops the process.  *
*                                                                            *
*  05/30/89 - D. Roseen - Rev. 1 to provide military (default) or standard   *
*                         time formats.  DESQview setting for memory size is *
*                         only 14K RAM (if .EXE file is made with Turbo C    *
*                         V2.0 with debugging off).  Optional argument is    *
*                         either MIL (military) or STD (standard).           * 
*                                                                            * 
*  05/31/89 - D. Roseen - Rev. 2 to add an optional argument for specifying  * 
*                         text attribute (colors -> foreground, background,  * 
*                         and blinking).  Uses the same 14K RAM setting.     * 
*                         The formats for running are as follows:            * 
*                                                                            * 
*                         DVCLOCK                                            * 
*                           or                                               * 
*                         DVCLOCK format                                     * 
*                           or                                               * 
*                         DVCLOCK format textattribute                       * 
*                                                                            * 
*                         where 'format' is either MIL (military) or STD     * 
*                         (standard).  And where 'textattribute' is an       * 
*                         integer in the range 0->255.  The decimal number   * 
*                         for your color choice can be determined from the   * 
*                         following chart:                                   * 
*                                                                            * 
*                           7 6 5 43 2 1 0 (bits)                           * 
*                          Ŀ                                 * 
*                          Bbbbffff                                 * 
*                                                           * 
*                                                                            * 
*                           ffff = 4-bit foreground color (0->15)            * 
*                            bbb = 3-bit background color (0->7)             * 
*                              B = blink enable bit                          * 
*                                                                            * 
*                           Colors 0->15 are as shown:                       * 
*                                                                            * 
*                           BLACK........0    DARKGRAY.....8                 * 
*                           BLUE.........1    LIGHTBLUE....9                 * 
*                           GREEN........2    LIGHTGREEN...10                * 
*                           CYAN.........3    LIGHTCYAN....11                * 
*                           RED..........4    LIGHTRED.....12                * 
*                           MAGENTA......5    LIGHTMAGENTA.13                * 
*                           BROWN........6    YELLOW.......14                * 
*                           LIGHTGRAY....7    WHITE........15                * 
*                                                                            * 
*                         Made the program run only in DESQview.  Also made  * 
*                         cursor turn on when pressing ESC so those who wish * 
*                         to execute this from the DOS prompt while in a     * 
*                         DESQview window will not loose their cursor.       * 
*                                                                            * 
*  07/13/89 - D. Roseen - Rev. 3 to give up remainder of time slice once a   *
*                         time check has been made.  It is a very noticeable *
*                         improvement while running other windows simul-     *
*                         taneously.  Also fixed a 'typo' in the arg_error() *
*                         function.  Uses the save 14K RAM setting.  The     *
*                         following DESQview 'Add a Program' example will    *
*                         create a file called CL-PIF.DVP that will work     *
*                         with DVCLOCK.EXE (use your path for DVCLOCK.EXE):  * 
*                                                                            * 
*                                                                            * 
* AddaProgramͻ * 
*                       Specify Program Information                        * 
*  Program Name............: Clock                                         * 
*  Keys to use on Open Menu: CL                   Memory Size (in K):  14  * 
* Ķ * 
*  Program...: c:\dv\dvclock.exe                                           * 
*  Parameters: std 31                                                      * 
*  Directory.:                                                             * 
* Ķ * 
*  Options:                                                                * 
*              Write text directly to screen......: [N]                    * 
*              Displays graphics information......: [N]                    * 
*              Virtualize text/graphics (Y,N,T)...: [Y]                    * 
*              Uses serial ports (Y,N,1,2)........: [N]                    * 
*              Requires floppy diskette...........: [N]                    * 
* ͼ * 
*                                                                            * 
* AddaProgramͻ * 
*               Specify Program Information Advanced Options               * 
*  System Memory (in K)......:   0  Max. Program Memory Size (in K).:      * 
*  Script Buffer Size......:     0  Max. Expanded Memory Size (in K):      * 
*  Text Pages: 1  Graphic Pages: 0  Initial Mode:    Interrupts: 00 to FF  * 
* Ķ * 
*  Window Position:                                                        * 
*   Maximum Height:  1      Starting Height:  1       Starting Row...:  1  * 
*   Maximum Width.: 10      Starting Width.: 10       Starting Column: 71  * 
* Ķ * 
*                            Shared Program                                * 
*  Pathname..:                                                             * 
*  Data......:                                                             * 
* Ķ * 
*  Close on exit (Y,N,blank)...: [Y]  Use its own colors............: [Y]  * 
*  Allow Close Window command..: [Y]  Runs in background (Y,N,blank): [ ]  * 
*  Uses math coprocessor.......: [N]  Keyboard conflict (0-4).......: [0]  * 
*  Share CPU when foreground...: [Y]  Share EGA when foreground/zoom: [Y]  * 
*  Can be swapped (Y,N,blank)..: [ ]  Protection level (0-3)........: [0]  * 
* ͼ * 
*****************************************************************************/ 


#include <ctype.h>
#include <dos.h>
#include <string.h>

main(argc, argv)

int argc;
char *argv[];

{
  int count;
  int format = 0, old_ti_sec = 0; /* DEFAULT IS MILITARY TIME.            */
  char temp[10];

  struct time now;                /* PREDIFINED TURBO C TIME STRUCTURE.   */
  union REGS regs;

  regs.x.ax = 0x2B01;             /* DO DATE SET AS DESQVIEW CHECK.       */
  regs.x.cx = 0x4445;             /* "DESQ" AN ILLEGAL DATE.              */
  regs.x.dx = 0x5351;
  int86(0x21, &regs, &regs);
  if (regs.h.al == 0xFF)          /* DESQVIEW CHECK.                      */
    {
    printf("\x07\nProgram requires DESQview!\n");
    exit(0);
    }

  gettime(&now);
  cursor_off();

  if (argc > 3)                   /* SEE IF TOO MANY ARGUMENTS PROVIDED.  */
    arg_error();                  /* TOO MANY ARGUMENTS.                  */

  if (argc > 1)                   /* SEE IF ARGUMENTS PROVIDED.           */
    {
    if ((strcmp(argv[1], "MIL")) && (strcmp(argv[1], "mil")) &&
        (strcmp(argv[1], "STD")) && (strcmp(argv[1], "std")))
      arg_error();                /* 'FORMAT' ARGUMENT IS NOT VALID.      */
    if (!((strcmp(argv[1], "STD")) && (strcmp(argv[1], "std"))))
      format = 1;                 /* SET FLAG TO SHOW STANDARD DESIRED.   */
    }

  if (argc == 3)                  /* SEE IF ALL ARGUMENTS WERE PROVIDED.  */
    {
    strcpy(temp, argv[2]);
    for (count = 0; count < strlen(temp); count++)
      if (!(isdigit(*(argv[2] + count))))
        arg_error();              /* FOUND A NON-DIGIT CHARACTER.         */
    if ((atoi(argv[2]) < 0) || (atoi(argv[2]) > 255)) /* CHECK RANGE.     */
      arg_error();                /* ALL DIGITS, BUT OUT OF RANGE.        */
    regs.h.ah = 9;                /* FUNCTION 9 OF VIDEO INTERRUPT.       */
    regs.h.al = 32;               /* SPACE CHARACTER.                     */
    regs.h.bh = 0;                /* PAGE NUMBER.                         */
    regs.h.bl = atoi(temp);       /* TEXT ATTRIBUTE.                      */
    regs.x.cx = 10;               /* WRITE TEN CHARACTERS.                */
    int86(0x10, &regs, &regs);    /* EXECUTE SOFTWARE INTERRUPT.          */
    }

  while (1)                       /* INFINITE LOOP.                       */
    {
    while (old_ti_sec == now.ti_sec)
      {
      if (kbhit())                /* CHECK TO SEE IF A KEY WAS PRESSED.   */
        if (getch() == 27)        /* CHECK TO SEE IF KEY WAS 'ESC' KEY.   */
          {
          cursor_on();            /* (JUST IN CASE EXECUTED FROM PROMPT)  */
          exit(0);                /* EXIT IF 'ESC' WAS PRESSED.           */
          }
      dv_pause();
      gettime(&now);
      }
    if (format == 1)              /* SEE IF STANDARD TIME IS DESIRED.     */
      if (now.ti_hour > 12)       /* CHECK FOR HOURS 13->23.              */
        now.ti_hour -= 12;        /* SHOW HOURS 13->23 AS HOURS 01->11.   */
      else if (now.ti_hour == 0)  /* CHECK FOR HOUR 00.                   */
        now.ti_hour = 12;         /* SHOW HOUR 00 AS HOUR 12.             */
    printf("\x08\x08\x08\x08\x08\x08\x08\x08\x08 %02d:%02d:%02d",
    now.ti_hour, now.ti_min, now.ti_sec);
    old_ti_sec = now.ti_sec;
    dv_pause();
    }
}

arg_error()                       /* SCREWED UP YOUR ARGUMENTS FUNCTION.  */

{
  printf("\x07\nUsage is:  DVCLOCK\n             or\n"
  "           DVCLOCK format\n             or\n"
  "           DVCLOCK format textattribute\n\n"
  "Where argument 'format' is MIL (military) or STD (standard).\n"
  "And where 'textattribute' is an integer from 0->255.\n"
  "Military time format and DESQview window colors are default.\n");
  exit(0);
}

cursor_off()                      /* TEXT CURSOR OFF FUNCTION.            */

{
  union REGS regs;

  regs.h.ah = 1;                  /* FUNCTION 1 OF VIDEO INTERRUPT.       */
  regs.h.ch = 32;                 /* SET BIT 5 IN CH TO TURN OFF CURSOR.  */
  int86(0x10, &regs, &regs);      /* EXECUTE SOFTWARE INTERRUPT.          */
  return;                         /* RETURN NO VALUE.                     */
}

cursor_on()                       /* TEXT CURSOR ON FUNCTION.             */

{
  union REGS regs;

  regs.h.ah = 1;                  /* FUNCTION 1 OF VIDEO INTERRUPT.       */
  regs.h.ch = 6;                  /* SET BEGINNING SCAN LINE TO 6.        */
  regs.h.cl = 7;                  /* SET ENDING SCAN LINE TO 7.           */
  int86(0x10, &regs, &regs);      /* EXECUTE SOFTWARE INTERRUPT.          */
  return;                         /* RETURN NO VALUE.                     */
}

dv_pause()                        /* GIVE UP REST OF TIME SLICE FUNCTION. */

{
  union REGS regs;

  regs.x.ax = 0x1000;             /* FUNCTION TO GIVE UP TIME SLICE.      */
  int86(0x15, &regs, &regs);      /* EXECUTE SOFTWARE INTERRUPT.          */
  return;
}

