; ------------- ceh.asm --------------------------------------------------
;       setCEH()        Install replacement Critical Error Handler to cause
;                       automatic "Fail" on drive-not-ready when testing
;                       empty floppy drives.  All other conditions are passed
;                       to the original handler
;
;       unsetCEH()      Use to deinstall our replacement CEH
;
;       use:    tasm /mx ceh.asm
;
;       written by Jesse Chisholm, 91.12.31
;       released to the Public Domain: 91.12.31
;       modified to use from C code by Jon Freivald, 92.01.12

;_STACK segment para stack 'STACK'
;       dw      100h dup (0)
;_STACK ends

_TEXT   segment word public 'CODE'

        assume  cs:_TEXT

        PUBLIC _setCEH, _unsetCEH

Oldint24        dd      0               ; store the original address

Newint24        dd      int24           ; address of new CEH

;
; This code is executed during program's initialization
; to install the new critical error handler.
;

_setCEH         proc    near

                push    bx              ; save some registers
                push    dx
                push    ds
                push    es

                mov     ax,3524h        ; get the original vector
                int     21h
                mov     word ptr Oldint24,bx
                mov     bx,es
                mov     word ptr Oldint24+2, bx

                lds     dx,Newint24     ; DS:DX == handler address
                mov     ax,2524h        ; set new vector
                int     21h             ; transfer to MS-DOS

                pop     es              ; restore registers
                pop     ds
                pop     dx
                pop     bx

                ret
_setCEH         endp

;
; This code is executed in the program's termination and cleanup code
;
_unsetCEH       proc    near

                push    dx                      ; save some registers
                push    ds

                mov     dx,word ptr Oldint24    ; check if vector ever set
                or      dx,word ptr Oldint24+2
                cmp     dx,0
                je      unsetCEHx               ; no, don't reset

                mov     ax,2524h                ; restore old address
                lds     dx,Oldint24
                int     21h

                xor     dx,dx                   ; zap address for next time
                mov     word ptr Oldint24,dx
                mov     word ptr Oldint24+2,dx

unsetCEHx:      pop     ds                      ; restore registers
                pop     dx

                ret
_unsetCEH       endp

;
; This is the replacement critical error handler.
; If the drive was not ready, it causes the MS-DOS function
; to "FAIL".  All other conditions are passed to the original
; int 24 handler.
;

int24           proc    far

                mov     ax,di           ; get error code
                cmp     al,02h          ; 02 == DRIVE NOT READY
                 je     FloppyNotReady
                jmp     far ptr [Oldint24]      ; go to original handler

FloppyNotReady:
                mov     al,03h          ; 03 == Fail function call in progress

                iret                            ; exit critical error handler
int24           endp

_TEXT   ends

        end

