


                                                                        1



                                        TIDY

                    A Computer Code for Renumbering and Editing
                              FORTRAN Source Programs
                           Version 6.32 - August 16, 1993

            by:

            Harry M. Murphy, Jr.
            Air Force Weapons Laboratory
            Kirtland AFB, New Mexico

            FORTRAN-77 Conversion by:
            Alan G. Stangenberger
            Dept. of Forestry & Resource Management
            University of California
            Berkeley, CA  94720
            (forags@nature.berkeley.edu)



            Copyright (C) 1989, The Regents of the University of
            California All Rights Reserved
            THE REGENTS OF THE UNIVERSITY OF CALIFORNIA MAKE NO
            REPRESENTATION OR WARRANTIES WITH RESPECT TO THE CONTENTS
            HEREOF AND SPECIFICALLY DISCLAIM ANY IMPLIED WARRANTIES OF
            MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE.
            Further, the Regents of the University of California reserve
            the right to revise this software and/or documentation and
            to make changes from time to time in the content hereof
            without obligation of the Regents of the University of
            California to notify any person of such revision or change.

            PERMISSION TO COPY AND DISTRIBUTE THIS PROGRAM, AND TO MAKE
            DERIVATIVE WORKS FROM IT, IS GRANTED PROVIDED THAT THIS
            COPYRIGHT NOTICE IS RETAINED IN ALL SOURCE CODE AND USER
            MANUALS.



            I.  Introduction

            The TIDY program renumbers and otherwise cleans up old and
            tired FORTRAN source programs.  TIDY accepts ANSI FORTRAN
            with 19 continuation cards as well as some IBM and CDC
            dialect FORTRAN statements. It is designed to work with ANSI
            FORTRAN-77, and will also accept FORTRAN II and FORTRAN IV
            statements. Certain FORTRAN II statements (such as READ
            INPUT TAPE) are automatically translated to their FORTRAN IV
            equivalents.  All lower case alphabetic characters are
            normally translated to upper case except for those in
            strings, Hollerith constants, and comment statements.










                                                                        2


            Although this manual is oriented to MS-DOS computers, this
            version of TIDY has been successfully installed under the
            UNIX (4.3 BSD) and IBM VM/CMS operating systems.

            I.1  Modifications

            Version 4.0:
            The statement continuation character can be set to a single
            character instead of sequential numbers 1, 2, ... if
            desired.

            Automatic generation of an END card at the end of the output
            file can be suppressed if desired.  This allows an INCLUDE
            file to be processed without automatically adding an END
            card to it.

            Hollerith constants (nHf) are normally converted to strings
            delimited by apostrophes.  Optionally, the CDC variants nLf
            and nRf can also be translated.  These features can be
            disabled if desired.

            Strings delimited by a character other than an apostrophe
            can be recognized and, optionally, translated to apostrophe-
            delimited strings.

            Strings delimited by asterisks (an old CDC feature) are no
            longer automatically recognized.  They can still be
            processed by the new "alternate delimiter" feature noted
            above.

            Version 5.0 - none

            Version 6.0:
            The character used to denote alternate return addresses in
            CALL statements can now be changed.  The ANSI standard is *,
            but other possibilities exist (IBM Fortran IV used &).
            Also, this character can be translated if desired.  NOTE
            THAT THE DEFAULT IS NOW *. EARLIER TIDY VERSIONS USED & (IBM
            Fortran IV form).

            Version 6.22: *FSPL, *BLAN, *HLOG options added. Non-ANSI
            warning for REAL*8 etc.

            Version 6.3: DO - ENDDO loops automatically translated to
            standard Fortran-77.

            Version 6.32: added *CASE option;  Handle DO 10,I=1,N;
            Limited DO WHILE support.

            I.2  Limitations:

            The only vendor extension to ANSI Fortran-77 which is
            supported is DO-ENDDO loops.  All other extensions are not
            supported.









                                                                        3



            II.  TIDY Control Cards:

            TIDY has certain commands which control the program's
            operation and output file formats. These commands may occur
            in the user control file, or anywhere in the FORTRAN source
            file, and may be used to negate a previous command. Default
            settings are listed where meaningful.

            TIDY commands must begin with an asterisk in column 1.  The
            remainder of the command consists of a four-letter keyword
            and possibly an equal sign followed by a numeric or
            alphabetic argument.  Commands are negated by prefacing the
            keyword with the letters NO.

            The commands which control statement numbering, indentation,
            and serial numbering are grouped separately, followed by
            miscellaneous commands.

            II.1.  Statement number control:

            TIDY numbers all statements in increasing order.  The user
            can specify the starting number for each routine, and the
            increment between statement numbers.  Additionally, the
            statement numbers can be left- or right-justified as
            desired.  The commands controlling statement numbering are:

            Command        Description
            *******        ***********

            *LEFT=n. /     Left adjust statement numbers to column n.
            *RIGHT=n.      *RIGHT right adjusts statement numbers to end
                           in column n. Default is *LEFT=2.

            *BASE=n. /     Initializes counter for statement label
            *NOBASE        numbers to n for each program unit.  *NOBASE
                           is equivalent to *BASE=0.  Default is
                           *NOBASE.

            *STAT=n.       Set the increment for statement numbers to n.
                           Default is *STAT=10.

            *REFE /        Make a cross-reference table between new
            *NOREFE        labels and old labels. *NOREFE suppresses the
                           cross-reference table. Default is *NOREFE.


















                                                                        4



            II.2.  Indentation:
            TIDY controls the starting column for FORTRAN statements
            with the *COLUMN option.  The default starting column is 7.
            If desired, the *INDENT option may be used to automatically
            indent the contents of DO-loops and IF-blocks.  The commands
            which control statement positioning are:


            Command        Description
            *******        ***********

            *COLU=n./      Start FORTRAN statements in column n. *NOCOLU
            *NOCOLU        leaves the first letter of the FORTRAN
                           statement in place. Default is *COLU=7.

            *INDEN=n.      Indents statements within DO-loops and IF-
            *NOINDEN       blocks. Maximum value for n is 10.  *NOINDEN
                           turns this option off.  Default is *NOINDEN.

            *FSPL /        This option controls the treatment of strings
            *NOFSPL        in FORMAT statements when indentation is used
                           and the FORMAT statements are not collected
                           at the end of each routine.  If *FSPL is
                           selected, a string which spans two cards will
                           be broken into two strings, and the
                           continuation card will be indented under the
                           FORMAT statement.  If *NOFSPL is selected,
                           the string will not be split into two parts,
                           and the continuation card's text will begin
                           in column 7. Since splitting strings in a
                           FORMAT statement may adversely affect
                           readability, the default is *NOFSPL.

            II.3.  Serialization control:

            Serialization consists of a 1-3 letter code in columns 73-
            75, a 4-digit serial number in columns 76-79, and a minus
            sign in column 80 of the END card.  The *SERIAL card is the
            master card which must be used to enable any of the
            serialization options.

            The label field can either be copied from columns 73-75 of
            each FUNCTION, SUBROUTINE, or PROGRAM card (*LABEL option),
            or it can be generated automatically (*NOLABEL option).  The
            automatic label sequence is A, B, ... , Z, AA, AB, ... .
            The user can choose where to start in this sequence with the
            *ROUT= card.

            To prepare a deck with serial numbers in columns 76-79, but
            with no label, use the *LABE option and leave columns 73-75
            of each FUNCTION, SUBROUTINE, or PROGRAM card blank.











                                                                        5


            Command        Description
            *******        ***********

            *SERI /        Begin or restore the punching of
            *NOSERI        serialization in columns 73-79. *NOSERI
                           cancels all labelling in columns 73-80.
                           Default is *NOSERI.

            *ROUT=xy       Reset the alphabetic label in columns 73 - 80
                           to the characters xy.

            *LABE /        Use the labelling from columns 73-75 of the
            *NOLABE        current FUNCTION, SUBROUTINE or PROGRAM card
                           for the sequencing in columns 73-80. *NOLABE
                           turns this option off.  Default is *NOLABE.

            *IDST=n. /     Set the serial number increment. *IDST and
            *IDIN=n.       *IDIN are identical. This option works only
                           when *SERI is in effect. Default is *IDST=1.

            II.4.  String translation:

            Since the Hollerith constant (nHf) is being phased out as a
            way to define strings, this version of TIDY can translate
            Hollerith constants to strings delimited by apostrophes.
            Any apostrophes embedded in such strings will be doubled
            (e.g. 1H' becomes '''').

            The following options control this process:

            Command        Description
            *******        ***********

            *HTRAN=n./     Selects types of Hollerith constants to be
            *NOHTRAN       changed to apostrophe-delimited strings.  1 =
                           Hollerith constants only, 2 = nLf and nRf
                           (CDC variants) only, 3 = all types.  *NOHTRAN
                           turns this option off. Default is *HTRAN=1.

            *HLOG /        As an aid to identifying variables which
            *NOHLOG        should be typed as CHARACTER in Fortran-77,
                           executable statements in which Hollerith
                           constants have been converted to delimited
                           strings can be identified in the listing
                           file. Default is *NOHLOG.

            *DEL1=x        Defines the primary character used to delimit
                           strings.  Default is apostrophe.















                                                                        6


            *DEL2=x /      Defines an alternate character used to
            *NODEL2        delimit strings. These strings may be
                           translated by the *DTRAN option.  *NODEL2
                           means no alternate string delimiter is
                           defined.  Default is *NODEL2.

            *DTRAN /       Causes strings delimited by a second type of
            *NODTRAN       delimiter (for example an asterisk) to be
                           changed to strings delimited by the primary
                           delimiter (normally an apostrophe).  Any
                           occurrences of the primary delimiter within
                           such strings will be properly duplicated (for
                           example *'* becomes ''''). *NODTRAN turns
                           this option off.  Default is *NODTRAN.

            II.5.  Miscellaneous commands:


            Command        Description
            *******        ***********

            *ANSI /        Issue warning messages for statements which
            *NOANSI        are not part of ANSI Standard FORTRAN-77.
                           *NOANSI suppresses such messages.  Default is
                           *ANSI.

            *ARET=x        The character used to denote alternate return
                           addresses in CALL statements (e.g. CALL F
                           (*1,*2) ) is set to x.  Default is * (ANSI
                           standard).

            *ARTRAN=x /    On output, the character used to denote
            *NOARTRAN      alternate return addresses in CALL statements
                           (see *ARET above) will be changed to x.
                           *NOARTRAN prevents this translation.  Default
                           is *NOARTRAN.

            *CARD /        Produce a punch file (file containing TIDY'd
            *NOCARD        code). *NOCARD suppresses the creation of the
                           punch file.  Default is *CARD.

            *CASE /        Translate all characters which are not in
            *NOCASE        strings or comment statements to upper case
                           (or to lower case, if the program is
                           recompiled to do so).  *NOCASE suppresses
                           case translation.  Default is *CASE.

            *CCHR=x /      Use the character specified as x as the
            *NOCCHR        continuation character for all continuation
                           lines of a statement.  Default (*NOCCHR) is
                           to number continuation lines as (1, 2, ... 9,
                           X).











                                                                        7


            *COLL /        Collect format statements at the end of the
            *NOCOLL        routine.  *NOCOLL leaves the format
                           statements in place. Default is *NOCOLL.

            *COMM /        Transmit comments to the output.  *NOCOMM
            *NOCOMM        deletes comments from output files. Default
                           is *COMM.

            *BLAN /        Retain blank lines in output files.  *NOBLAN
            *NOBLAN        deletes blank lines.  Default is *BLAN.

            *CONT /        Leave GOTO's and labeled CONTINUE's which are
            *NOCONT        not DO-loop terminators in the code. *NOCONT
                           deletes such CONTINUE's and re-routes GOTO's,
                           unless they are within an IF-block. Default
                           is *NOCONT.

            *EXEM /        Exempt non-executable statements from
            *NOEXEM        processing. *NOEXEM forces processing of all
                           statements. Default is *NOEXEM.

            *FEND /        *FEND forces an END statement to be written
            *NOFEND        at the end of each routine.  *NOFEND prevents
                           forcing an END statement if one is not needed
                           (such as in an INCLUDE file).  Default is
                           *FEND.

            *LIST /        Write original source to the TIDY listing
            *NOLIST        file. *NOLIST suppresses inclusion of the
                           original source. Default is *LIST.

            *LIST = 2. /   Write out TIDY'd code to listing file.
            *NOLIST = 2.   *NOLIST=2 suppresses the TIDY'd listing.
                           Default is LIST=2.

            *NEWRO         Reset everything to starting values.

            *SKIP          Skip processing to the end of the current
                           routine.

            III.  Files

            TIDY uses the following files:

            Unit Name        Description

            3    USRCON      User control file (optional).  This file,
                             if it exists, is processed before the
                             source file, and can only contain TIDY
                             commands.  It can be used to avoid having
                             to edit the same TIDY commands into every
                             file to be processed.











                                                                        8


            4    INFILE      The FORTRAN source file to be processed.
                             May also contain TIDY commands as needed.

            6    OUTFIL      List output file.  Normally contains
                             listing of the source file, TIDY
                             diagnostics, and a listing of the TIDY-
                             generated FORTRAN program.

            8    PUNFIL      The TIDY-generated FORTRAN program.

            Scratch and system files (no user prompting):

            1    SCFIL1      Scratch file used internally by TIDY.

            2    SCFIL2      Scratch file used internally by TIDY.

            0    STDERR      Console output (interactive systems only),
                             used to ask user to enter file names.

            0*   STDIN       Console input (interactive systems only),
                             used to interactively enter file names. *
                             On UNIX systems, set STDIN to 5.

            IV.  Input Statement Format

            TIDY accepts standard FORTRAN statements with statement
            numbers in columns 1-5, continuation code in column 6, and
            instructions in columns 7-72.

            TIDY also accepts statements in which a horizontal tab
            character in any of columns 1-6 means that the next
            character is in column 7.  Statements with an ampersand (&)
            in column 1 are interpreted as continuation lines.


            V.  Usage (MS-DOS Version)

            On an MS-DOS system, TIDY is executed by the command TIDY.
            All file definitions are handled interactively in the order
            listed above.  For the scratch files, the user only
            specifies the disk drive letter on which these files are to
            be written (it can be a RAM-disk if desired).  The scratch
            files are normally deleted at program termination.
            The TIDY.EXE file compiled under Professional Fortran
            requires a math coprocessor.  Error 4001 is returned if no
            coprocessor is found.

            VI.   Bugs

            Problems will arise if strings are delimited by asterisks
            and if the alternate return character in CALL statements is
            also an asterisk.

            VII.  Acknowledgments









                                                                        9



            Many programmers have worked on TIDY and its documentation
            since it was first published by Harry Murphy in 1966.  Among
            them are Gerry Tool (Lawrence Berkeley Laboratory), Alice
            Barlow (NASA Ames Research Center), and Roger Chaffee
            (Stanford Linear Accelerator Center).






















































