/*

	pccursor.hpp
	7-30-91
	Cursor shape class for IBM PC text modes.

	Copyright 1991
	John W. Small
	All rights reserved
	Use freely but acknowledge authorship and copyright.

	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072 USA

	John Small
	Voice : (703) 759-3838
	CIS: 73757,2233

*/

#ifndef PCCURSOR_HPP
#define PCCURSOR_HPP

#include <dos.h>

class CursorShape {
	unsigned origshape, prevshape;
protected:
	enum {
		CursorOffMask		=	0x2000,
		CursorOnMask		=	0xDFFF,
		BlockCursorMask		=	0x00FF,
		DefaultColorCursor	=	0x0607,
		DefaultMonoCursor	=	0x0C0D
	};
	unsigned  getshape() { _BH = 0x00; _AH = 0x03;
		geninterrupt(0x10); return _CX; }
	void putshape(unsigned shape);
	unsigned defaultshape() { _AH = 0x0F;
		geninterrupt(0x10); return (_AL == 7)?
		DefaultMonoCursor : DefaultColorCursor; }
public:
	void off() { putshape(getshape() | CursorOffMask); }
	void on()  { putshape(getshape() & CursorOnMask); }
	void block() { putshape(defaultshape() & BlockCursorMask); }
	void normal()  { putshape(defaultshape()); }
	void save()    { prevshape = getshape(); }
	void restore() { putshape(prevshape); }
	void saveOrig()  { origshape = getshape(); }
	void restoreOrig() { putshape(origshape); }
};

#endif
