/*----------------------------------------
   COSUSER.C -- Cosmetic Pen User Style
                (c) Charles Petzold, 1993
  ----------------------------------------*/

#include <windows.h>

char szClass [] = "CosUser" ;
char szTitle [] = "CosUser: Cosmetic Pen User Style" ;

void PaintRoutine (HWND hwnd, HDC hdc, int cxArea, int cyArea)
     {
     DWORD    dwBits [] = { 8, 8, 16, 8 } ;
     LOGBRUSH lb ;

     lb.lbStyle = BS_SOLID ;
     lb.lbColor = RGB (0, 0, 0) ;
     lb.lbHatch = 0 ;

     SelectObject (hdc,
          ExtCreatePen (PS_COSMETIC | PS_USERSTYLE, 1, &lb, 4, dwBits)) ;

     Rectangle (hdc, cxArea / 4, cyArea / 4, 3 * cxArea / 4, 3 * cyArea / 4) ;

     MoveToEx (hdc,     cxArea / 4,     cyArea / 4, NULL) ;
     LineTo   (hdc, 3 * cxArea / 4, 3 * cyArea / 4) ;

     MoveToEx (hdc,     cxArea / 4, 3 * cyArea / 4, NULL) ;
     LineTo   (hdc, 3 * cxArea / 4,     cyArea / 4) ;

     DeleteObject (SelectObject (hdc, GetStockObject (BLACK_PEN))) ;
     }
