#ifndef lint
static char *RCSid = "$Id: bitmap.c 3.38.2.42 1993/01/07 17:23:59 woo Exp woo $";
#endif


/* GNUPLOT - bitmap.c */
/*
 * Copyright (C) 1986 - 1993   Thomas Williams, Colin Kelley
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose with or without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and 
 * that both that copyright notice and this permission notice appear 
 * in supporting documentation.
 *
 * Permission to modify the software is granted, but not the right to
 * distribute the modified code.  Modifications are to be distributed 
 * as patches to released version.
 *  
 * This software is provided "as is" without express or implied warranty.
 * 
 *
 * AUTHORS
 * 
 *   Original Software:
 *     Jyrki Yli-Nokari <jty@intrin.UUCP>
 *     Ronald J. Hartranft <rjh2@ns.cc.lehigh.edu>
 *     Russell Lang <rjl@monu1.cc.monash.edu.au>
 * 
 * There is a mailing list for gnuplot users. Note, however, that the
 * newsgroup 
 *	comp.graphics.gnuplot 
 * is identical to the mailing list (they
 * both carry the same set of messages). We prefer that you read the
 * messages through that newsgroup, to subscribing to the mailing list.
 * (If you can read that newsgroup, and are already on the mailing list,
 * please send a message info-gnuplot-request@dartmouth.edu, asking to be
 * removed from the mailing list.)
 *
 * The address for mailing to list members is
 *	   info-gnuplot@dartmouth.edu
 * and for mailing administrative requests is 
 *	   info-gnuplot-request@dartmouth.edu
 * The mailing list for bug reports is 
 *	   bug-gnuplot@dartmouth.edu
 * The list of those interested in beta-test versions is
 *	   info-gnuplot-beta@dartmouth.edu
 */

/*
** General raster plotting routines.
** Raster routines written and copyrighted 1987 by
** Jyrki Yli-Nokari (jty@intrin.UUCP)
** Intrinsic, Ltd.
**
** You may use this code for anything you like as long as
** you are not selling it and the credit is given and
** this message retained.
**
*/

/* Bitmap plotting routines derived from above raster plotting routines
 * Russell Lang, 1990
 */

#include <stdio.h>
#include "plot.h"
#include "bitmap.h"

bitmap *b_p = (bitmap *)NULL;	/* global pointer to bitmap */
unsigned int b_currx, b_curry;	/* the current coordinates */
unsigned int b_xsize, b_ysize;	/* the size of the bitmap */
unsigned int b_planes;			/* number of color planes */
unsigned int b_psize;			/* size of each plane */
unsigned int b_rastermode;		/* raster mode rotates -90deg */
unsigned int b_linemask = 0xffff;	/* 16 bit mask for dotted lines */
unsigned int b_value = 1;		/* colour of lines */
unsigned int b_hchar;			/* width of characters */
unsigned int b_hbits;			/* actual bits in char horizontally */
unsigned int b_vchar;			/* height of characters */
unsigned int b_vbits;			/* actual bits in char vertically */
unsigned int b_angle;			/* rotation of text */
char_box b_font[FNT_CHARS];	/* the current font */
unsigned int b_pattern[] = {0xffff, 0x1111,
	0xffff, 0x5555, 0x3333, 0x7777, 0x3f3f, 0x0f0f, 0x5f5f};
int b_maskcount = 0;
unsigned int b_lastx, b_lasty;	/* last pixel set - used by b_line */

#define IN(i,size)  ((unsigned)i < (unsigned)size)

/* 5x9 font, bottom row first, left pixel in lsb */
char_row GPFAR fnt5x9[FNT_CHARS][FNT5X9_VBITS] = {
  /* */  {000000,000000,000000,000000,000000,000000,000000,000000,000000},
  /*!*/  {000000,000000,0x0004,000000,0x0004,0x0004,0x0004,0x0004,0x0004},
  /*"*/  {000000,000000,000000,000000,000000,000000,0x000a,0x000a,0x000a},
  /*#*/  {000000,000000,0x000a,0x000a,0x001f,0x000a,0x001f,0x000a,0x000a},
  /*$*/  {000000,000000,0x0004,0x000f,0x0014,0x000e,0x0005,0x001e,0x0004},
  /*%*/  {000000,000000,0x0018,0x0019,0x0002,0x0004,0x0008,0x0013,0x0003},
  /*&*/  {000000,000000,0x0016,0x0009,0x0015,0x0002,0x0005,0x0005,0x0002},
  /*'*/  {000000,000000,000000,000000,000000,0x0002,0x0004,0x0006,0x0006},
  /*(*/  {000000,000000,0x0008,0x0004,0x0002,0x0002,0x0002,0x0004,0x0008},
  /*)*/  {000000,000000,0x0002,0x0004,0x0008,0x0008,0x0008,0x0004,0x0002},
  /***/  {000000,000000,0x0004,0x0015,0x000e,0x001f,0x000e,0x0015,0x0004},
  /*+*/  {000000,000000,000000,0x0004,0x0004,0x001f,0x0004,0x0004,000000},
  /*,*/  {000000,0x0002,0x0004,0x0006,0x0006,000000,000000,000000,000000},
  /*-*/  {000000,000000,000000,000000,000000,0x001f,000000,000000,000000},
  /*.*/  {000000,000000,0x0006,0x0006,000000,000000,000000,000000,000000},
  /*-/-*/{000000,000000,000000,0x0001,0x0002,0x0004,0x0008,0x0010,000000},
  /*0*/  {000000,000000,0x000e,0x0011,0x0013,0x0015,0x0019,0x0011,0x000e},
  /*1*/  {000000,000000,0x000e,0x0004,0x0004,0x0004,0x0004,0x0006,0x0004},
  /*2*/  {000000,000000,0x001f,0x0001,0x0001,0x000e,0x0010,0x0011,0x000e},
  /*3*/  {000000,000000,0x000e,0x0011,0x0010,0x000c,0x0010,0x0011,0x000e},
  /*4*/  {000000,000000,0x0008,0x0008,0x001f,0x0009,0x000a,0x000c,0x0008},
  /*5*/  {000000,000000,0x000e,0x0011,0x0010,0x0010,0x000f,0x0001,0x001f},
  /*6*/  {000000,000000,0x000e,0x0011,0x0011,0x000f,0x0001,0x0002,0x000c},
  /*7*/  {000000,000000,0x0001,0x0001,0x0002,0x0004,0x0008,0x0010,0x001f},
  /*8*/  {000000,000000,0x000e,0x0011,0x0011,0x000e,0x0011,0x0011,0x000e},
  /*9*/  {000000,000000,0x0006,0x0008,0x0010,0x001e,0x0011,0x0011,0x000e},
  /*:*/  {000000,000000,000000,0x0006,0x0006,000000,0x0006,0x0006,000000},
  /*;*/  {000000,0x0001,0x0002,0x0006,0x0006,000000,0x0006,0x0006,000000},
  /*<*/  {000000,000000,0x0008,0x0004,0x0002,0x0001,0x0002,0x0004,0x0008},
  /*=*/  {000000,000000,000000,000000,0x001f,000000,0x001f,000000,000000},
  /*>*/  {000000,000000,0x0002,0x0004,0x0008,0x0010,0x0008,0x0004,0x0002},
  /*?*/  {000000,000000,0x0004,000000,0x0004,0x0008,0x0010,0x0011,0x000e},
  /*@*/  {000000,000000,0x000e,0x0015,0x0015,0x0016,0x0010,0x0011,0x000e},
  /*A*/  {000000,000000,0x0011,0x0011,0x001f,0x0011,0x0011,0x000a,0x0004},
  /*B*/  {000000,000000,0x000f,0x0012,0x0012,0x000e,0x0012,0x0012,0x000f},
  /*C*/  {000000,000000,0x000e,0x0011,0x0001,0x0001,0x0001,0x0011,0x000e},
  /*D*/  {000000,000000,0x000f,0x0012,0x0012,0x0012,0x0012,0x0012,0x000f},
  /*E*/  {000000,000000,0x001f,0x0001,0x0001,0x0007,0x0001,0x0001,0x001f},
  /*F*/  {000000,000000,0x0001,0x0001,0x0001,0x0007,0x0001,0x0001,0x001f},
  /*G*/  {000000,000000,0x001e,0x0011,0x0011,0x0019,0x0001,0x0001,0x001e},
  /*H*/  {000000,000000,0x0011,0x0011,0x0011,0x001f,0x0011,0x0011,0x0011},
  /*I*/  {000000,000000,0x000e,0x0004,0x0004,0x0004,0x0004,0x0004,0x000e},
  /*J*/  {000000,000000,0x000e,0x0011,0x0010,0x0010,0x0010,0x0010,0x0010},
  /*K*/  {000000,000000,0x0011,0x0009,0x0005,0x0003,0x0005,0x0009,0x0011},
  /*L*/  {000000,000000,0x001f,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001},
  /*M*/  {000000,000000,0x0011,0x0011,0x0011,0x0015,0x0015,0x001b,0x0011},
  /*N*/  {000000,000000,0x0011,0x0011,0x0011,0x0019,0x0015,0x0013,0x0011},
  /*O*/  {000000,000000,0x000e,0x0011,0x0011,0x0011,0x0011,0x0011,0x000e},
  /*P*/  {000000,000000,0x0001,0x0001,0x0001,0x000f,0x0011,0x0011,0x000f},
  /*Q*/  {000000,0x0018,0x000e,0x0015,0x0011,0x0011,0x0011,0x0011,0x000e},
  /*R*/  {000000,000000,0x0011,0x0009,0x0005,0x000f,0x0011,0x0011,0x000f},
  /*S*/  {000000,000000,0x000e,0x0011,0x0010,0x000e,0x0001,0x0011,0x000e},
  /*T*/  {000000,000000,0x0004,0x0004,0x0004,0x0004,0x0004,0x0004,0x001f},
  /*U*/  {000000,000000,0x000e,0x0011,0x0011,0x0011,0x0011,0x0011,0x0011},
  /*V*/  {000000,000000,0x0004,0x0004,0x000a,0x000a,0x0011,0x0011,0x0011},
  /*W*/  {000000,000000,0x0011,0x001b,0x0015,0x0011,0x0011,0x0011,0x0011},
  /*X*/  {000000,000000,0x0011,0x0011,0x000a,0x0004,0x000a,0x0011,0x0011},
  /*Y*/  {000000,000000,0x0004,0x0004,0x0004,0x0004,0x000a,0x0011,0x0011},
  /*Z*/  {000000,000000,0x001f,0x0001,0x0002,0x0004,0x0008,0x0010,0x001f},
  /*[*/  {000000,000000,0x000e,0x0002,0x0002,0x0002,0x0002,0x0002,0x000e},
  /*\*/  {000000,000000,000000,0x0010,0x0008,0x0004,0x0002,0x0001,000000},
  /*]*/  {000000,000000,0x000e,0x0008,0x0008,0x0008,0x0008,0x0008,0x000e},
  /*^*/  {000000,000000,000000,000000,000000,000000,0x0011,0x000a,0x0004},
  /*_*/  {000000,000000,0x001f,000000,000000,000000,000000,000000,000000},
  /*`*/  {000000,000000,000000,000000,000000,0x0008,0x0004,0x000c,0x000c},
  /*a*/  {000000,000000,0x001e,0x0011,0x001e,0x0010,0x000e,000000,000000},
  /*b*/  {000000,000000,0x000d,0x0013,0x0011,0x0013,0x000d,0x0001,0x0001},
  /*c*/  {000000,000000,0x000e,0x0011,0x0001,0x0011,0x000e,000000,000000},
  /*d*/  {000000,000000,0x0016,0x0019,0x0011,0x0019,0x0016,0x0010,0x0010},
  /*e*/  {000000,000000,0x000e,0x0001,0x001f,0x0011,0x000e,000000,000000},
  /*f*/  {000000,000000,0x0004,0x0004,0x0004,0x000e,0x0004,0x0014,0x0008},
  /*g*/  {0x000e,0x0011,0x0016,0x0019,0x0011,0x0019,0x0016,000000,000000},
  /*h*/  {000000,000000,0x0011,0x0011,0x0011,0x0013,0x000d,0x0001,0x0001},
  /*i*/  {000000,000000,0x000e,0x0004,0x0004,0x0004,0x0006,000000,0x0004},
  /*j*/  {0x0006,0x0009,0x0008,0x0008,0x0008,0x0008,0x000c,000000,0x0008},
  /*k*/  {000000,000000,0x0009,0x0005,0x0003,0x0005,0x0009,0x0001,0x0001},
  /*l*/  {000000,000000,0x000e,0x0004,0x0004,0x0004,0x0004,0x0004,0x0006},
  /*m*/  {000000,000000,0x0015,0x0015,0x0015,0x0015,0x000b,000000,000000},
  /*n*/  {000000,000000,0x0011,0x0011,0x0011,0x0013,0x000d,000000,000000},
  /*o*/  {000000,000000,0x000e,0x0011,0x0011,0x0011,0x000e,000000,000000},
  /*p*/  {0x0001,0x0001,0x000d,0x0013,0x0011,0x0013,0x000d,000000,000000},
  /*q*/  {0x0010,0x0010,0x0016,0x0019,0x0011,0x0019,0x0016,000000,000000},
  /*r*/  {000000,000000,0x0001,0x0001,0x0001,0x0013,0x000d,000000,000000},
  /*s*/  {000000,000000,0x000f,0x0010,0x000e,0x0001,0x001e,000000,000000},
  /*t*/  {000000,000000,0x0008,0x0014,0x0004,0x0004,0x001f,0x0004,0x0004},
  /*u*/  {000000,000000,0x0016,0x0019,0x0011,0x0011,0x0011,000000,000000},
  /*v*/  {000000,000000,0x0004,0x000a,0x0011,0x0011,0x0011,000000,000000},
  /*w*/  {000000,000000,0x000a,0x0015,0x0015,0x0011,0x0011,000000,000000},
  /*x*/  {000000,000000,0x0011,0x000a,0x0004,0x000a,0x0011,000000,000000},
  /*y*/  {0x000e,0x0010,0x001e,0x0011,0x0011,0x0011,0x0011,000000,000000},
  /*z*/  {000000,000000,0x001f,0x0002,0x0004,0x0008,0x001f,000000,000000},
  /*{*/  {000000,000000,0x0008,0x0004,0x0004,0x0002,0x0004,0x0004,0x0008},
  /*|*/  {000000,000000,0x0004,0x0004,0x0004,000000,0x0004,0x0004,0x0004},
  /*}*/  {000000,000000,0x0002,0x0004,0x0004,0x0008,0x0004,0x0004,0x0002},
  /*~*/  {000000,000000,000000,000000,000000,000000,0x0008,0x0015,0x0002},
  /*DEL*/{000000,000000,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f,0x001f},
};

/* 9x17 font, bottom row first, left pixel in lsb */
char_row GPFAR fnt9x17[FNT_CHARS][FNT9X17_VBITS] = {
  /* */  {000000,000000,000000,000000,000000,000000,000000,000000,000000,
          000000,000000,000000,000000,000000,000000,000000,000000},
  /*!*/  {000000,000000,000000,000000,0x0010,000000,000000,000000,0x0010,
          0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010},
  /*"*/  {000000,000000,000000,000000,000000,000000,000000,000000,000000,
          000000,000000,000000,0x0044,0x0044,0x0044,0x0044,0x0044},
  /*#*/  {000000,000000,000000,000000,0x0044,0x0044,0x0044,0x0044,0x01ff,
          0x0044,0x0044,0x0044,0x01ff,0x0044,0x0044,0x0044,0x0044},
  /*$*/  {000000,000000,000000,000000,0x0010,0x0010,0x007e,0x0091,0x0110,
          0x0090,0x007c,0x0012,0x0011,0x0112,0x00fc,0x0010,0x0010},
  /*%*/  {000000,000000,000000,000000,0x0080,0x0141,0x0081,0x0002,0x0004,
          0x0008,0x0010,0x0020,0x0040,0x0080,0x0102,0x0105,0x0002},
  /*&*/  {000000,000000,000000,000000,0x011c,0x00a2,0x0041,0x00c1,0x0141,
          0x0022,0x001c,0x0014,0x0022,0x0022,0x001c,000000,000000},
  /*'*/  {000000,000000,000000,000000,000000,000000,000000,000000,000000,
          000000,000000,0x0004,0x0008,0x0010,0x0030,0x0038,0x0010},
  /*(*/  {000000,000000,000000,000000,0x0040,0x0020,0x0010,0x0008,0x0008,
          0x0004,0x0004,0x0004,0x0008,0x0008,0x0010,0x0020,0x0040},
  /*)*/  {000000,000000,000000,000000,0x0004,0x0008,0x0010,0x0020,0x0020,
          0x0040,0x0040,0x0040,0x0020,0x0020,0x0010,0x0008,0x0004},
  /***/  {000000,000000,000000,000000,0x0010,0x0010,0x0111,0x0092,0x0054,
          0x0038,0x01ff,0x0038,0x0054,0x0092,0x0111,0x0010,0x0010},
  /*+*/  {000000,000000,000000,000000,000000,000000,0x0010,0x0010,0x0010,
          0x0010,0x01ff,0x0010,0x0010,0x0010,0x0010,000000,000000},
  /*,*/  {000000,000000,0x0004,0x0008,0x0010,0x0030,0x0038,0x0010,000000,
          000000,000000,000000,000000,000000,000000,000000,000000},
  /*-*/  {000000,000000,000000,000000,000000,000000,000000,000000,000000,
          000000,0x01ff,000000,000000,000000,000000,000000,000000},
  /*.*/  {000000,000000,000000,000000,0x0010,0x0038,0x0010,000000,000000,
          000000,000000,000000,000000,000000,000000,000000,000000},
  /*-/-*/{000000,000000,000000,000000,000000,000000,0x0001,0x0002,0x0004,
          0x0008,0x0010,0x0020,0x0040,0x0080,0x0100,000000,000000},
  /*0*/  {000000,000000,000000,000000,0x007c,0x0082,0x0101,0x0103,0x0105,
          0x0109,0x0111,0x0121,0x0141,0x0181,0x0101,0x0082,0x007c},
  /*1*/  {000000,000000,000000,000000,0x007c,0x0010,0x0010,0x0010,0x0010,
          0x0010,0x0010,0x0010,0x0010,0x0010,0x001c,0x0018,0x0010},
  /*2*/  {000000,000000,000000,000000,0x01ff,0x0001,0x0001,0x0001,0x0001,
          0x0002,0x007c,0x0080,0x0100,0x0100,0x0101,0x0082,0x007c},
  /*3*/  {000000,000000,000000,000000,0x007c,0x0082,0x0101,0x0100,0x0100,
          0x0080,0x0078,0x0080,0x0100,0x0100,0x0101,0x0082,0x007c},
  /*4*/  {000000,000000,000000,000000,0x0040,0x0040,0x0040,0x0040,0x0040,
          0x01ff,0x0041,0x0042,0x0044,0x0048,0x0050,0x0060,0x0040},
  /*5*/  {000000,000000,000000,000000,0x007c,0x0082,0x0101,0x0100,0x0100,
          0x0100,0x0080,0x007f,0x0001,0x0001,0x0001,0x0001,0x01ff},
  /*6*/  {000000,000000,000000,000000,0x007c,0x0082,0x0101,0x0101,0x0101,
          0x0081,0x007f,0x0001,0x0001,0x0001,0x0002,0x0084,0x0078},
  /*7*/  {000000,000000,000000,000000,0x0001,0x0001,0x0001,0x0002,0x0004,
          0x0008,0x0010,0x0020,0x0040,0x0080,0x0100,0x0100,0x01ff},
  /*8*/  {000000,000000,000000,000000,0x007c,0x0082,0x0101,0x0101,0x0101,
          0x0082,0x007c,0x0082,0x0101,0x0101,0x0101,0x0082,0x007c},
  /*9*/  {000000,000000,000000,000000,0x001c,0x0022,0x0040,0x0080,0x0100,
          0x0100,0x01fc,0x0102,0x0101,0x0101,0x0101,0x0082,0x007c},
  /*:*/  {000000,000000,000000,000000,000000,000000,0x0010,0x0038,0x0010,
          000000,000000,000000,0x0010,0x0038,0x0010,000000,000000},
  /*;*/  {000000,000000,000000,0x0004,0x0008,0x0010,0x0030,0x0038,0x0010,
          000000,000000,000000,0x0010,0x0038,0x0010,000000,000000},
  /*<*/  {000000,000000,000000,000000,0x0040,0x0020,0x0010,0x0008,0x0004,
          0x0002,0x0001,0x0002,0x0004,0x0008,0x0010,0x0020,0x0040},
  /*=*/  {000000,000000,000000,000000,000000,000000,000000,000000,0x01ff,
          000000,000000,000000,0x01ff,000000,000000,000000,000000},
  /*>*/  {000000,000000,000000,000000,0x0004,0x0008,0x0010,0x0020,0x0040,
          0x0080,0x0100,0x0080,0x0040,0x0020,0x0010,0x0008,0x0004},
  /*?*/  {000000,000000,000000,0x0010,0x0038,0x0010,000000,0x0010,0x0010,
          0x0020,0x0040,0x0080,0x0100,0x0100,0x0101,0x0082,0x007c},
  /*@*/  {000000,000000,000000,000000,0x007c,0x0002,0x0001,0x01f9,0x0145,
          0x0145,0x0145,0x0179,0x0101,0x0101,0x0101,0x0082,0x007c},
  /*A*/  {000000,000000,000000,000000,0x0101,0x0101,0x0101,0x0101,0x01ff,
          0x0101,0x0082,0x0082,0x0044,0x0044,0x0028,0x0028,0x0010},
  /*B*/  {000000,000000,000000,000000,0x007f,0x0084,0x0104,0x0104,0x0104,
          0x0084,0x007c,0x0084,0x0104,0x0104,0x0104,0x0084,0x007f},
  /*C*/  {000000,000000,000000,000000,0x007c,0x0082,0x0101,0x0001,0x0001,
          0x0001,0x0001,0x0001,0x0001,0x0001,0x0101,0x0082,0x007c},
  /*D*/  {000000,000000,000000,000000,0x007f,0x0084,0x0104,0x0104,0x0104,
          0x0104,0x0104,0x0104,0x0104,0x0104,0x0104,0x0084,0x007f},
  /*E*/  {000000,000000,000000,000000,0x01ff,0x0001,0x0001,0x0001,0x0001,
          0x0001,0x001f,0x0001,0x0001,0x0001,0x0001,0x0001,0x01ff},
  /*F*/  {000000,000000,000000,000000,0x0001,0x0001,0x0001,0x0001,0x0001,
          0x0001,0x001f,0x0001,0x0001,0x0001,0x0001,0x0001,0x01ff},
  /*G*/  {000000,000000,000000,000000,0x00fc,0x0102,0x0101,0x0101,0x0101,
          0x0101,0x01c1,0x0001,0x0001,0x0001,0x0001,0x0102,0x00fc},
  /*H*/  {000000,000000,000000,000000,0x0101,0x0101,0x0101,0x0101,0x0101,
          0x0101,0x01ff,0x0101,0x0101,0x0101,0x0101,0x0101,0x0101},
  /*I*/  {000000,000000,000000,000000,0x007c,0x0010,0x0010,0x0010,0x0010,
          0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x007c},
  /*J*/  {000000,000000,000000,000000,0x007c,0x0082,0x0101,0x0100,0x0100,
          0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0100,0x0180},
  /*K*/  {000000,000000,000000,000000,0x0101,0x0081,0x0041,0x0021,0x0011,
          0x0009,0x0005,0x000b,0x0011,0x0021,0x0041,0x0081,0x0101},
  /*L*/  {000000,000000,000000,000000,0x01ff,0x0101,0x0001,0x0001,0x0001,
          0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001},
  /*M*/  {000000,000000,000000,000000,0x0101,0x0101,0x0101,0x0101,0x0101,
          0x0101,0x0111,0x0111,0x0129,0x0145,0x0145,0x0183,0x0101},
  /*N*/  {000000,000000,000000,000000,0x0101,0x0101,0x0101,0x0181,0x0141,
          0x0141,0x0121,0x0111,0x0109,0x0105,0x0105,0x0103,0x0101},
  /*O*/  {000000,000000,000000,000000,0x007c,0x0082,0x0101,0x0101,0x0101,
          0x0101,0x0101,0x0101,0x0101,0x0101,0x0101,0x0082,0x007c},
  /*P*/  {000000,000000,000000,000000,0x0001,0x0001,0x0001,0x0001,0x0001,
          0x0001,0x007f,0x0081,0x0101,0x0101,0x0101,0x0081,0x007f},
  /*Q*/  {000000,000000,0x0180,0x0040,0x007c,0x0092,0x0101,0x0101,0x0101,
          0x0101,0x0101,0x0101,0x0101,0x0101,0x0101,0x0082,0x007c},
  /*R*/  {000000,000000,000000,000000,0x0101,0x0081,0x0041,0x0021,0x0011,
          0x0009,0x007f,0x0081,0x0101,0x0101,0x0101,0x0081,0x007f},
  /*S*/  {000000,000000,000000,000000,0x007c,0x0082,0x0101,0x0100,0x0100,
          0x0080,0x007c,0x0002,0x0001,0x0001,0x0101,0x0082,0x007c},
  /*T*/  {000000,000000,000000,000000,0x0038,0x0010,0x0010,0x0010,0x0010,
          0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0111,0x01ff},
  /*U*/  {000000,000000,000000,000000,0x007c,0x0082,0x0101,0x0101,0x0101,
          0x0101,0x0101,0x0101,0x0101,0x0101,0x0101,0x0101,0x0101},
  /*V*/  {000000,000000,000000,000000,0x0010,0x0010,0x0028,0x0028,0x0044,
          0x0044,0x0082,0x0082,0x0101,0x0101,0x0101,0x0101,0x0101},
  /*W*/  {000000,000000,000000,000000,0x0101,0x0183,0x0145,0x0145,0x0129,
          0x0111,0x0111,0x0101,0x0101,0x0101,0x0101,0x0101,0x0101},
  /*X*/  {000000,000000,000000,000000,0x0101,0x0101,0x0082,0x0082,0x0044,
          0x0028,0x0010,0x0028,0x0044,0x0082,0x0082,0x0101,0x0101},
  /*Y*/  {000000,000000,000000,000000,0x0010,0x0010,0x0010,0x0010,0x0010,
          0x0010,0x0010,0x0028,0x0044,0x0082,0x0082,0x0101,0x0101},
  /*Z*/  {000000,000000,000000,000000,0x01ff,0x0001,0x0002,0x0002,0x0004,
          0x0008,0x0010,0x0020,0x0040,0x0080,0x0080,0x0100,0x01ff},
  /*[*/  {000000,000000,000000,000000,0x007c,0x0004,0x0004,0x0004,0x0004,
          0x0004,0x0004,0x0004,0x0004,0x0004,0x0004,0x0004,0x007c},
  /*\*/  {000000,000000,000000,000000,000000,000000,0x0100,0x0080,0x0040,
          0x0020,0x0010,0x0008,0x0004,0x0002,0x0001,000000,000000},
  /*]*/  {000000,000000,000000,000000,0x007c,0x0040,0x0040,0x0040,0x0040,
          0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x007c},
  /*^*/  {000000,000000,000000,000000,000000,000000,000000,000000,000000,
          000000,000000,000000,0x0101,0x0082,0x0044,0x0028,0x0010},
  /*_*/  {000000,000000,000000,000000,0x01ff,000000,000000,000000,000000,
          000000,000000,000000,000000,000000,000000,000000,000000},
  /*`*/  {000000,000000,000000,000000,000000,000000,000000,000000,000000,
          000000,000000,0x0020,0x0010,0x0008,0x000c,0x001c,0x0008},
  /*a*/  {000000,000000,000000,000000,0x03fc,0x0102,0x0101,0x0102,0x01fc,
          0x0100,0x0100,0x0080,0x007c,000000,000000,000000,000000},
  /*b*/  {000000,000000,000000,000000,0x007d,0x0083,0x0101,0x0101,0x0101,
          0x0101,0x0101,0x0083,0x007d,0x0001,0x0001,0x0001,0x0001},
  /*c*/  {000000,000000,000000,000000,0x007c,0x0082,0x0101,0x0001,0x0001,
          0x0001,0x0101,0x0082,0x007c,000000,000000,000000,000000},
  /*d*/  {000000,000000,000000,000000,0x017c,0x0182,0x0101,0x0101,0x0101,
          0x0101,0x0101,0x0182,0x017c,0x0100,0x0100,0x0100,0x0100},
  /*e*/  {000000,000000,000000,000000,0x007c,0x0002,0x0001,0x0001,0x01ff,
          0x0101,0x0101,0x0082,0x007c,000000,000000,000000,000000},
  /*f*/  {000000,000000,000000,000000,0x0010,0x0010,0x0010,0x0010,0x0010,
          0x0010,0x007c,0x0010,0x0010,0x0010,0x0110,0x00a0,0x0040},
  /*g*/  {0x007c,0x0082,0x0101,0x0100,0x017c,0x0182,0x0101,0x0101,0x0101,
          0x0101,0x0101,0x0182,0x017c,000000,000000,000000,000000},
  /*h*/  {000000,000000,000000,000000,0x0101,0x0101,0x0101,0x0101,0x0101,
          0x0103,0x0103,0x0085,0x0079,0x0001,0x0001,0x0001,0x0001},
  /*i*/  {000000,000000,000000,000000,0x007c,0x0010,0x0010,0x0010,0x0010,
          0x0010,0x0010,0x0018,000000,000000,0x0018,0x0018,000000},
  /*j*/  {0x003c,0x0042,0x0081,0x0080,0x0080,0x0080,0x0080,0x0080,0x0080,
          0x0080,0x0080,0x00c0,000000,000000,0x00c0,0x00c0,000000},
  /*k*/  {000000,000000,000000,000000,0x0082,0x0042,0x0022,0x0012,0x000a,
          0x0016,0x0022,0x0042,0x0002,0x0002,0x0002,0x0002,0x0002},
  /*l*/  {000000,000000,000000,000000,0x007c,0x0010,0x0010,0x0010,0x0010,
          0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x0010,0x001c},
  /*m*/  {000000,000000,000000,000000,0x0111,0x0111,0x0111,0x0111,0x0111,
          0x0111,0x0111,0x00ab,0x0045,000000,000000,000000,000000},
  /*n*/  {000000,000000,000000,000000,0x0101,0x0101,0x0101,0x0101,0x0101,
          0x0101,0x0101,0x0083,0x007d,000000,000000,000000,000000},
  /*o*/  {000000,000000,000000,000000,0x007c,0x0082,0x0101,0x0101,0x0101,
          0x0101,0x0101,0x0082,0x007c,000000,000000,000000,000000},
  /*p*/  {0x0001,0x0001,0x0001,0x0001,0x007d,0x0003,0x0081,0x0101,0x0101,
          0x0101,0x0101,0x0083,0x007d,000000,000000,000000,000000},
  /*q*/  {0x0100,0x0100,0x0100,0x0100,0x017c,0x0182,0x0101,0x0101,0x0101,
          0x0101,0x0101,0x0182,0x017c,000000,000000,000000,000000},
  /*r*/  {000000,000000,000000,000000,0x0001,0x0001,0x0001,0x0001,0x0001,
          0x0001,0x0103,0x0085,0x0079,000000,000000,000000,000000},
  /*s*/  {000000,000000,000000,000000,0x007e,0x0081,0x0100,0x0080,0x007c,
          0x0002,0x0001,0x0102,0x00fc,000000,000000,000000,000000},
  /*t*/  {000000,000000,000000,000000,0x0040,0x00a0,0x0110,0x0010,0x0010,
          0x0010,0x0010,0x0010,0x00fe,0x0010,0x0010,0x0010,0x0010},
  /*u*/  {000000,000000,000000,000000,0x013c,0x0142,0x0181,0x0101,0x0101,
          0x0101,0x0101,0x0101,0x0101,000000,000000,000000,000000},
  /*v*/  {000000,000000,000000,000000,0x0010,0x0028,0x0044,0x0082,0x0101,
          0x0101,0x0101,0x0101,0x0101,000000,000000,000000,000000},
  /*w*/  {000000,000000,000000,000000,0x0044,0x00aa,0x0111,0x0111,0x0101,
          0x0101,0x0101,0x0101,0x0101,000000,000000,000000,000000},
  /*x*/  {000000,000000,000000,000000,0x0101,0x0082,0x0044,0x0028,0x0010,
          0x0028,0x0044,0x0082,0x0101,000000,000000,000000,000000},
  /*y*/  {0x007c,0x0082,0x0101,0x0100,0x0100,0x01fc,0x0102,0x0101,0x0101,
          0x0101,0x0101,0x0101,0x0101,000000,000000,000000,000000},
  /*z*/  {000000,000000,000000,000000,0x01ff,0x0002,0x0004,0x0008,0x0010,
          0x0020,0x0040,0x0080,0x01ff,000000,000000,000000,000000},
  /*{*/  {000000,000000,000000,000000,0x00c0,0x0020,0x0010,0x0010,0x0010,
          0x0008,0x0004,0x0008,0x0010,0x0010,0x0010,0x0020,0x00c0},
  /*|*/  {000000,000000,000000,000000,0x0010,0x0010,0x0010,0x0010,0x0010,
          000000,000000,000000,0x0010,0x0010,0x0010,0x0010,0x0010},
  /*}*/  {000000,000000,000000,000000,0x0006,0x0008,0x0010,0x0010,0x0010,
          0x0020,0x0040,0x0020,0x0010,0x0010,0x0010,0x0008,0x0006},
  /*~*/  {000000,000000,000000,000000,000000,000000,000000,000000,000000,
          000000,000000,000000,0x0040,0x00a0,0x0111,0x000a,0x0004},
  /*DEL*/{000000,000000,000000,000000,0x0155,000000,0x0155,000000,0x0155,
          000000,0x0155,000000,0x0155,000000,0x0155,000000,0x0155},
};

/* 13x25 font, bottom row first, left pixel in lsb */
char_row GPFAR fnt13x25[FNT_CHARS][FNT13X25_VBITS] = {
  /* */  {000000,000000,000000,000000,000000,000000,000000,000000,000000,
          000000,000000,000000,000000,000000,000000,000000,000000,000000,
          000000,000000,000000,000000,000000,000000,000000},
  /*!*/  {000000,000000,000000,000000,000000,0x00e0,0x00e0,0x00e0,000000,
          000000,000000,0x0040,0x0040,0x0040,0x0040,0x0040,0x00e0,0x00e0,
          0x00e0,0x00e0,0x00e0,0x00e0,0x00e0,0x00e0,0x0040},
  /*"*/  {000000,000000,000000,000000,000000,000000,000000,000000,000000,
          000000,000000,000000,000000,000000,000000,000000,000000,000000,
          0x0208,0x0208,0x0208,0x0208,0x0208,0x0208,0x0208},
  /*#*/  {000000,000000,000000,000000,000000,000000,0x0208,0x0208,0x0208,
          0x0208,0x0208,0x0208,0x1fff,0x0208,0x0208,0x0208,0x0208,0x0208,
          0x1fff,0x0208,0x0208,0x0208,0x0208,0x0208,0x0208},
  /*$*/  {000000,000000,000000,000000,000000,000000,0x0040,0x0040,0x0040,
          0x03f8,0x0444,0x0842,0x0840,0x0840,0x0440,0x03f8,0x0044,0x0042,
          0x0042,0x0842,0x0444,0x03f8,0x0040,0x0040,0x0040},
  /*%*/  {000000,000000,000000,000000,000000,000000,0x0c00,0x1200,0x1201,
          0x0c01,0x0002,0x0004,0x0008,0x0010,0x0020,0x0040,0x0080,0x0100,
          0x0200,0x0400,0x0800,0x1006,0x1009,0x0009,0x0006},
  /*&*/  {000000,000000,000000,000000,000000,000000,0x1078,0x1084,0x0902,
          0x0601,0x0601,0x0901,0x1081,0x0042,0x0024,0x0018,0x0018,0x0024,
          0x0042,0x0042,0x0042,0x0042,0x0024,0x0018,000000},
  /*'*/  {000000,000000,000000,000000,000000,000000,000000,000000,000000,
          000000,000000,000000,000000,000000,0x0001,0x0002,0x0004,0x0008,
          0x0010,0x0030,0x0078,0x0078,0x0078,0x0030,000000},
  /*(*/  {000000,000000,000000,000000,000000,000000,0x0080,0x0040,0x0020,
          0x0020,0x0010,0x0008,0x0008,0x0004,0x0004,0x0004,0x0004,0x0004,
          0x0008,0x0008,0x0010,0x0020,0x0020,0x0040,0x0080},
  /*)*/  {000000,000000,000000,000000,000000,000000,0x0020,0x0040,0x0080,
          0x0080,0x0100,0x0200,0x0200,0x0400,0x0400,0x0400,0x0400,0x0400,
          0x0200,0x0200,0x0100,0x0080,0x0080,0x0040,0x0020},
  /***/  {000000,000000,000000,000000,000000,000000,0x0040,0x0040,0x0040,
          0x1041,0x0842,0x0444,0x0248,0x0150,0x00e0,0x1fff,0x00e0,0x0150,
          0x0248,0x0444,0x0842,0x1041,0x0040,0x0040,0x0040},
  /*+*/  {000000,000000,000000,000000,000000,000000,000000,000000,000000,
          0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x1fff,0x0040,0x0040,
          0x0040,0x0040,0x0040,0x0040,000000,000000,000000},
  /*,*/  {000000,000000,0x0001,0x0002,0x0004,0x0008,0x0010,0x0030,0x0078,
          0x0078,0x0078,0x0030,000000,000000,000000,000000,000000,000000,
          000000,000000,000000,000000,000000,000000,000000},
  /*-*/  {000000,000000,000000,000000,000000,000000,000000,000000,000000,
          000000,000000,000000,000000,000000,000000,0x1fff,000000,000000,
          000000,000000,000000,000000,000000,000000,000000},
  /*.*/  {000000,000000,000000,000000,000000,000000,000000,0x0038,0x007c,
          0x007c,0x007c,0x0038,000000,000000,000000,000000,000000,000000,
          000000,000000,000000,000000,000000,000000,000000},
  /*-/-*/{000000,000000,000000,000000,000000,000000,000000,000000,0x0001,
          0x0001,0x0002,0x0004,0x0008,0x0010,0x0020,0x0040,0x0080,0x0100,
          0x0200,0x0400,0x0800,0x1000,0x1000,000000,000000},
  /*0*/  {000000,000000,000000,000000,000000,000000,0x03f8,0x0404,0x0802,
          0x1001,0x1003,0x1005,0x1009,0x1011,0x1021,0x1041,0x1081,0x1101,
          0x1201,0x1401,0x1801,0x1001,0x0802,0x0404,0x03f8},
  /*1*/  {000000,000000,000000,000000,000000,000000,0x03f8,0x0040,0x0040,
          0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,
          0x0040,0x0040,0x0040,0x0048,0x0070,0x0060,0x0040},
  /*2*/  {000000,000000,000000,000000,000000,000000,0x1fff,0x0001,0x0001,
          0x0001,0x0001,0x0001,0x0001,0x0002,0x03fc,0x0400,0x0800,0x1000,
          0x1000,0x1000,0x1000,0x1001,0x0802,0x0404,0x03f8},
  /*3*/  {000000,000000,000000,000000,000000,000000,0x03f8,0x0404,0x0802,
          0x1001,0x1000,0x1000,0x1000,0x0800,0x0400,0x03e0,0x0400,0x0800,
          0x1000,0x1000,0x1000,0x1001,0x0802,0x0404,0x03f8},
  /*4*/  {000000,000000,000000,000000,000000,000000,0x0200,0x0200,0x0200,
          0x0200,0x0200,0x0200,0x0200,0x1fff,0x0201,0x0201,0x0202,0x0204,
          0x0208,0x0210,0x0220,0x0240,0x0280,0x0300,0x0200},
  /*5*/  {000000,000000,000000,000000,000000,000000,0x03f8,0x0404,0x0802,
          0x1001,0x1000,0x1000,0x1000,0x1000,0x1000,0x0800,0x0400,0x03ff,
          0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x1fff},
  /*6*/  {000000,000000,000000,000000,000000,000000,0x03f8,0x0404,0x0802,
          0x1001,0x1001,0x1001,0x1001,0x0801,0x0401,0x03ff,0x0001,0x0001,
          0x0001,0x0001,0x0002,0x0004,0x0808,0x0410,0x03e0},
  /*7*/  {000000,000000,000000,000000,000000,000000,0x0001,0x0001,0x0001,
          0x0002,0x0002,0x0004,0x0008,0x0010,0x0020,0x0040,0x0080,0x0100,
          0x0200,0x0400,0x0800,0x0800,0x1000,0x1000,0x1fff},
  /*8*/  {000000,000000,000000,000000,000000,000000,0x03f8,0x0404,0x0802,
          0x1001,0x1001,0x1001,0x1001,0x0802,0x0404,0x03f8,0x0404,0x0802,
          0x1001,0x1001,0x1001,0x1001,0x0802,0x0404,0x03f8},
  /*9*/  {000000,000000,000000,000000,000000,000000,0x00f8,0x0104,0x0202,
          0x0400,0x0800,0x1000,0x1000,0x1000,0x1000,0x1ff8,0x1004,0x1002,
          0x1001,0x1001,0x1001,0x1001,0x0802,0x0404,0x03f8},
  /*:*/  {000000,000000,000000,000000,000000,000000,000000,000000,0x0030,
          0x0078,0x0078,0x0030,000000,000000,000000,000000,000000,000000,
          0x0030,0x0078,0x0078,0x0030,000000,000000,000000},
  /*;*/  {000000,000000,0x0001,0x0002,0x0004,0x0008,0x0010,0x0030,0x0078,
          0x0078,0x0078,0x0030,000000,000000,000000,000000,000000,000000,
          0x0030,0x0078,0x0078,0x0030,000000,000000,000000},
  /*<*/  {000000,000000,000000,000000,000000,000000,0x0200,0x0100,0x0080,
          0x0040,0x0020,0x0010,0x0008,0x0004,0x0002,0x0001,0x0002,0x0004,
          0x0008,0x0010,0x0020,0x0040,0x0080,0x0100,0x0200},
  /*=*/  {000000,000000,000000,000000,000000,000000,000000,000000,000000,
          000000,000000,000000,0x1fff,000000,000000,000000,000000,000000,
          0x1fff,000000,000000,000000,000000,000000,000000},
  /*>*/  {000000,000000,000000,000000,000000,000000,0x0008,0x0010,0x0020,
          0x0040,0x0080,0x0100,0x0200,0x0400,0x0800,0x1000,0x0800,0x0400,
          0x0200,0x0100,0x0080,0x0040,0x0020,0x0010,0x0008},
  /*?*/  {000000,000000,000000,000000,000000,0x0040,0x00e0,0x0040,000000,
          000000,000000,0x0040,0x0040,0x0080,0x0100,0x0200,0x0400,0x0800,
          0x1000,0x1000,0x1001,0x1001,0x0802,0x0404,0x03f8},
  /*@*/  {000000,000000,000000,000000,000000,000000,0x03f8,0x0404,0x0002,
          0x0001,0x0001,0x0ee1,0x1111,0x1111,0x1111,0x1111,0x1111,0x12e1,
          0x1001,0x1001,0x1001,0x1001,0x0802,0x0404,0x03f8},
  /*A*/  {000000,000000,000000,000000,000000,000000,0x1001,0x1001,0x1001,
          0x1001,0x1001,0x1001,0x1fff,0x1001,0x1001,0x1001,0x1001,0x0802,
          0x0802,0x0404,0x0208,0x0110,0x00a0,0x00a0,0x0040},
  /*B*/  {000000,000000,000000,000000,000000,000000,0x03ff,0x0408,0x0808,
          0x1008,0x1008,0x1008,0x1008,0x0808,0x0408,0x03f8,0x0408,0x0808,
          0x1008,0x1008,0x1008,0x1008,0x0808,0x0408,0x03ff},
  /*C*/  {000000,000000,000000,000000,000000,000000,0x03f8,0x0404,0x0802,
          0x1001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,
          0x0001,0x0001,0x0001,0x1001,0x0802,0x0404,0x03f8},
  /*D*/  {000000,000000,000000,000000,000000,000000,0x03ff,0x0408,0x0808,
          0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,0x1008,
          0x1008,0x1008,0x1008,0x1008,0x0808,0x0408,0x03ff},
  /*E*/  {000000,000000,000000,000000,000000,000000,0x1fff,0x0001,0x0001,
          0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x007f,0x0001,0x0001,
          0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x1fff},
  /*F*/  {000000,000000,000000,000000,000000,000000,0x0001,0x0001,0x0001,
          0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x007f,0x0001,0x0001,
          0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x1fff},
  /*G*/  {000000,000000,000000,000000,000000,000000,0x0ff8,0x1004,0x1002,
          0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1f01,0x0001,0x0001,
          0x0001,0x0001,0x0001,0x0001,0x0002,0x1004,0x0ff8},
  /*H*/  {000000,000000,000000,000000,000000,000000,0x1001,0x1001,0x1001,
          0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1fff,0x1001,0x1001,
          0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001},
  /*I*/  {000000,000000,000000,000000,000000,000000,0x03f8,0x0040,0x0040,
          0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,
          0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x03f8},
  /*J*/  {000000,000000,000000,000000,000000,000000,0x03f8,0x0404,0x0802,
          0x1001,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,
          0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x1e00},
  /*K*/  {000000,000000,000000,000000,000000,000000,0x1001,0x0801,0x0401,
          0x0201,0x0101,0x0081,0x0041,0x0021,0x0011,0x000f,0x0009,0x0011,
          0x0021,0x0041,0x0081,0x0101,0x0201,0x0401,0x0801},
  /*L*/  {000000,000000,000000,000000,000000,000000,0x1fff,0x1001,0x1001,
          0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,
          0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001},
  /*M*/  {000000,000000,000000,000000,000000,000000,0x1001,0x1001,0x1001,
          0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1041,0x1041,0x10a1,
          0x10a1,0x1111,0x1209,0x1209,0x1405,0x1803,0x1001},
  /*N*/  {000000,000000,000000,000000,000000,000000,0x1001,0x1001,0x1001,
          0x1001,0x1801,0x1401,0x1201,0x1201,0x1101,0x1081,0x1041,0x1041,
          0x1021,0x1011,0x1009,0x1009,0x1005,0x1003,0x1001},
  /*O*/  {000000,000000,000000,000000,000000,000000,0x03f8,0x0404,0x0802,
          0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,
          0x1001,0x1001,0x1001,0x1001,0x0802,0x0404,0x03f8},
  /*P*/  {000000,000000,000000,000000,000000,000000,0x0001,0x0001,0x0001,
          0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x03ff,0x0401,0x0801,
          0x1001,0x1001,0x1001,0x1001,0x0801,0x0401,0x03ff},
  /*Q*/  {000000,000000,000000,000000,0x0c00,0x0200,0x03f8,0x0494,0x0862,
          0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,
          0x1001,0x1001,0x1001,0x1001,0x0802,0x0404,0x03f8},
  /*R*/  {000000,000000,000000,000000,000000,000000,0x1001,0x0801,0x0401,
          0x0201,0x0101,0x0081,0x0041,0x0021,0x0011,0x03ff,0x0401,0x0801,
          0x1001,0x1001,0x1001,0x1001,0x0801,0x0401,0x03ff},
  /*S*/  {000000,000000,000000,000000,000000,000000,0x03f8,0x0404,0x0802,
          0x1001,0x1000,0x1000,0x1000,0x0800,0x0400,0x03f8,0x0004,0x0002,
          0x0001,0x0001,0x0001,0x1001,0x0802,0x0404,0x03f8},
  /*T*/  {000000,000000,000000,000000,000000,000000,0x00e0,0x0040,0x0040,
          0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,
          0x0040,0x0040,0x0040,0x0040,0x0040,0x1041,0x1fff},
  /*U*/  {000000,000000,000000,000000,000000,000000,0x03f8,0x0404,0x0802,
          0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,
          0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001},
  /*V*/  {000000,000000,000000,000000,000000,000000,0x0040,0x0040,0x00a0,
          0x00a0,0x0110,0x0110,0x0208,0x0208,0x0404,0x0404,0x0802,0x0802,
          0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001},
  /*W*/  {000000,000000,000000,000000,000000,000000,0x1001,0x1001,0x1803,
          0x1405,0x1405,0x1209,0x1209,0x1111,0x1111,0x10a1,0x1041,0x1001,
          0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001},
  /*X*/  {000000,000000,000000,000000,000000,000000,0x1001,0x1001,0x1001,
          0x0802,0x0802,0x0404,0x0208,0x0110,0x00a0,0x0040,0x00a0,0x0110,
          0x0208,0x0404,0x0802,0x0802,0x1001,0x1001,0x1001},
  /*Y*/  {000000,000000,000000,000000,000000,000000,0x0040,0x0040,0x0040,
          0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x00a0,0x0110,0x0208,
          0x0404,0x0802,0x0802,0x1001,0x1001,0x1001,0x1001},
  /*Z*/  {000000,000000,000000,000000,000000,000000,0x1fff,0x0001,0x0001,
          0x0002,0x0004,0x0004,0x0008,0x0010,0x0020,0x0040,0x0080,0x0100,
          0x0200,0x0400,0x0400,0x0800,0x1000,0x1000,0x1fff},
  /*[*/  {000000,000000,000000,000000,000000,000000,0x03f8,0x0008,0x0008,
          0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,
          0x0008,0x0008,0x0008,0x0008,0x0008,0x0008,0x03f8},
  /*\*/  {000000,000000,000000,000000,000000,000000,000000,000000,0x1000,
          0x1000,0x0800,0x0400,0x0200,0x0100,0x0080,0x0040,0x0020,0x0010,
          0x0008,0x0004,0x0002,0x0001,0x0001,000000,000000},
  /*]*/  {000000,000000,000000,000000,000000,000000,0x03f8,0x0200,0x0200,
          0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,
          0x0200,0x0200,0x0200,0x0200,0x0200,0x0200,0x03f8},
  /*^*/  {000000,000000,000000,000000,000000,000000,000000,000000,000000,
          000000,000000,000000,000000,000000,000000,000000,000000,000000,
          0x1001,0x0802,0x0404,0x0208,0x0110,0x00a0,0x0040},
  /*_*/  {000000,000000,000000,000000,000000,000000,0x1fff,000000,000000,
          000000,000000,000000,000000,000000,000000,000000,000000,000000,
          000000,000000,000000,000000,000000,000000,000000},
  /*`*/  {000000,000000,000000,000000,000000,000000,000000,000000,000000,
          000000,000000,000000,000000,000000,0x0400,0x0200,0x0100,0x0080,
          0x0040,0x0060,0x00f0,0x00f0,0x00f0,0x0060,000000},
  /*a*/  {000000,000000,000000,000000,000000,000000,0x17f8,0x0804,0x0802,
          0x0802,0x0802,0x0804,0x0ff8,0x0800,0x0800,0x0800,0x0800,0x0404,
          0x03f8,000000,000000,000000,000000,000000,000000},
  /*b*/  {000000,000000,000000,000000,000000,000000,0x03f9,0x0405,0x0803,
          0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x0803,0x0405,
          0x03f9,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001},
  /*c*/  {000000,000000,000000,000000,000000,000000,0x03f8,0x0404,0x0802,
          0x1001,0x0001,0x0001,0x0001,0x0001,0x0001,0x1001,0x0802,0x0404,
          0x03f8,000000,000000,000000,000000,000000,000000},
  /*d*/  {000000,000000,000000,000000,000000,000000,0x13f8,0x1404,0x1802,
          0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1802,0x1404,
          0x13f8,0x1000,0x1000,0x1000,0x1000,0x1000,0x1000},
  /*e*/  {000000,000000,000000,000000,000000,000000,0x0ff8,0x0004,0x0002,
          0x0001,0x0001,0x0001,0x1fff,0x1001,0x1001,0x1001,0x0802,0x0404,
          0x03f8,000000,000000,000000,000000,000000,000000},
  /*f*/  {000000,000000,000000,000000,000000,000000,0x0040,0x0040,0x0040,
          0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x03f8,0x0040,0x0040,
          0x0040,0x0040,0x0040,0x1040,0x0880,0x0500,0x0200},
  /*g*/  {0x03f8,0x0404,0x0802,0x1001,0x1000,0x1000,0x13f8,0x1404,0x1802,
          0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1802,0x1404,
          0x13f8,000000,000000,000000,000000,000000,000000},
  /*h*/  {000000,000000,000000,000000,000000,000000,0x1001,0x1001,0x1001,
          0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x0803,0x0405,
          0x03f9,0x0001,0x0001,0x0001,0x0001,0x0001,0x0001},
  /*i*/  {000000,000000,000000,000000,000000,000000,0x03f8,0x0040,0x0040,
          0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0070,
          000000,000000,000000,0x00e0,0x00e0,0x00e0,000000},
  /*j*/  {0x00f0,0x0108,0x0204,0x0402,0x0400,0x0400,0x0400,0x0400,0x0400,
          0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0400,0x0700,
          000000,000000,000000,0x0700,0x0700,0x0700,000000},
  /*k*/  {000000,000000,000000,000000,000000,000000,0x0804,0x0404,0x0204,
          0x0104,0x0084,0x0044,0x0024,0x0014,0x002c,0x0044,0x0084,0x0104,
          0x0204,0x0004,0x0004,0x0004,0x0004,0x0004,0x0004},
  /*l*/  {000000,000000,000000,000000,000000,000000,0x03f8,0x0040,0x0040,
          0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,
          0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0070},
  /*m*/  {000000,000000,000000,000000,000000,000000,0x1041,0x1041,0x1041,
          0x1041,0x1041,0x1041,0x1041,0x1041,0x1041,0x1041,0x08a3,0x0515,
          0x0209,000000,000000,000000,000000,000000,000000},
  /*n*/  {000000,000000,000000,000000,000000,000000,0x1001,0x1001,0x1001,
          0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x0803,0x0405,
          0x03f9,000000,000000,000000,000000,000000,000000},
  /*o*/  {000000,000000,000000,000000,000000,000000,0x03f8,0x0404,0x0802,
          0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x0802,0x0404,
          0x03f8,000000,000000,000000,000000,000000,000000},
  /*p*/  {0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x03f9,0x0405,0x0803,
          0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x0803,0x0405,
          0x03f9,000000,000000,000000,000000,000000,000000},
  /*q*/  {0x1000,0x1000,0x1000,0x1000,0x1000,0x1000,0x13f8,0x1404,0x1802,
          0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1802,0x1404,
          0x13f8,000000,000000,000000,000000,000000,000000},
  /*r*/  {000000,000000,000000,000000,000000,000000,0x0001,0x0001,0x0001,
          0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x1001,0x0803,0x0405,
          0x03f9,000000,000000,000000,000000,000000,000000},
  /*s*/  {000000,000000,000000,000000,000000,000000,0x03fc,0x0402,0x0800,
          0x0800,0x0800,0x0400,0x03f8,0x0004,0x0002,0x0002,0x0002,0x0804,
          0x07f8,000000,000000,000000,000000,000000,000000},
  /*t*/  {000000,000000,000000,000000,000000,000000,0x0200,0x0500,0x0880,
          0x1040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,
          0x07fc,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040},
  /*u*/  {000000,000000,000000,000000,000000,000000,0x13f8,0x1404,0x1802,
          0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,
          0x1001,000000,000000,000000,000000,000000,000000},
  /*v*/  {000000,000000,000000,000000,000000,000000,0x0040,0x00a0,0x0110,
          0x0208,0x0404,0x0802,0x0802,0x1001,0x1001,0x1001,0x1001,0x1001,
          0x1001,000000,000000,000000,000000,000000,000000},
  /*w*/  {000000,000000,000000,000000,000000,000000,0x0208,0x0514,0x08a2,
          0x08a2,0x1041,0x1041,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,
          0x1001,000000,000000,000000,000000,000000,000000},
  /*x*/  {000000,000000,000000,000000,000000,000000,0x1001,0x0802,0x0404,
          0x0208,0x0110,0x00a0,0x0040,0x00a0,0x0110,0x0208,0x0404,0x0802,
          0x1001,000000,000000,000000,000000,000000,000000},
  /*y*/  {0x03f8,0x0404,0x0802,0x1001,0x1000,0x1000,0x1000,0x1000,0x1ff8,
          0x1004,0x1002,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,0x1001,
          0x1001,000000,000000,000000,000000,000000,000000},
  /*z*/  {000000,000000,000000,000000,000000,000000,0x1fff,0x0002,0x0004,
          0x0008,0x0010,0x0020,0x0040,0x0080,0x0100,0x0200,0x0400,0x0800,
          0x1fff,000000,000000,000000,000000,000000,000000},
  /*{*/  {000000,000000,000000,000000,000000,000000,0x0600,0x0100,0x0080,
          0x0040,0x0040,0x0040,0x0040,0x0040,0x0020,0x0010,0x0020,0x0040,
          0x0040,0x0040,0x0040,0x0040,0x0080,0x0100,0x0600},
  /*|*/  {000000,000000,000000,000000,000000,000000,0x0040,0x0040,0x0040,
          0x0040,0x0040,0x0040,0x0040,000000,000000,000000,000000,000000,
          0x0040,0x0040,0x0040,0x0040,0x0040,0x0040,0x0040},
  /*}*/  {000000,000000,000000,000000,000000,000000,0x000c,0x0010,0x0020,
          0x0040,0x0040,0x0040,0x0040,0x0040,0x0080,0x0100,0x0080,0x0040,
          0x0040,0x0040,0x0040,0x0040,0x0020,0x0010,0x000c},
  /*~*/  {000000,000000,000000,000000,000000,000000,000000,000000,000000,
          000000,000000,000000,000000,000000,000000,000000,000000,000000,
          0x0600,0x0900,0x1080,0x1041,0x0021,0x0012,0x000c},
  /*DEL*/{000000,000000,000000,000000,000000,000000,0x1249,000000,000000,
          0x1249,000000,000000,0x1249,000000,000000,0x1249,000000,000000,
          0x1249,000000,000000,0x1249,000000,000000,0x1249},
};

/*
** The plotting area is defined as a huge bitmap.
** The bitmap is stored in a dynamically allocated pixel array b_p
**
** The bitmap is allocated (and initialized to zero) with
** b_makebitmap(xsize, ysize, planes)
** and freed with b_freebitmap()
** xsize and ysize will be rounded up to a multiple of 8.
**
** Valid (int) coordinates range from zero to (xsize-1,ysize-1)
**
** Plotting is done via b_move(x, y) and b_vector(x, y) functions,
** where the point (x,y) is the target to go from the current point
** To set the color use b_setvalue(value) where value is the value 
** (0 or 1 or a color number) to be stored in every pixel.
** To get dotted line styles, use b_setlinetype(linetype).
**
** Internally all plotting goes through b_setpixel(x, y, value).
*/


/*
** set pixel (x, y, value) to value value (this can be 1/0 or a color number).
*/
void
b_setpixel(x, y, value)
unsigned int x, y, value;
{
  register unsigned int row;
  register unsigned char mask;
  int i;
  if (b_rastermode) {
	/* interchange so that new (x,y) is old (y,b_ysize-1-x) */
	row = x;  /* temp storage */
	x = y;
	y = b_ysize-1-row;
  }
  if (IN(x, b_xsize) && IN(y, b_ysize))
  {
    row = y/8;
    mask = 1<<(y%8);

	for (i=0; i<b_planes; i++) {
		if (value&1)
			*((*b_p)[row]+x) |= mask;
		else
			*((*b_p)[row]+x) &= ~mask;
		row += b_psize;
		value >>= 1;
	}
  }
#ifdef BITMAPDEBUG
  else
  {
    if (b_rastermode)
      fprintf(stderr, "Warning: setpixel(%d, %d, %d) out of bounds\n", 
		b_ysize-1-y, x, value);
    else
      fprintf(stderr, "Warning: setpixel(%d, %d, %d) out of bounds\n",
		x, y, value);
  }
#endif
}

/*
** get pixel (x,y) value----unused
*/
/****************************
unsigned int
b_getpixel(x, y)
unsigned int x, y;
{
  register unsigned int row;
  register unsigned char mask;
  register unsigned char value;
  int i;

  if (b_rastermode) {
	row = x;
	x = y;
	y = b_ysize-1-row;
  }
  if (IN(x, b_xsize) && IN(y, b_ysize))
  {
    row = y/8 + (b_planes-1)*b_psize;
    mask = 1<<(y%8);

	for (i=0; i<b_planes; i++) {
		if ( *((*b_p)[row]+x) & mask )
			value |= 1;
		row -= b_psize;
		value <<= 1;
	}
    return(value);
  }
  else
  {
#ifdef BITMAPDEBUG
    if (b_rastermode)
      fprintf(stderr, "Warning: getpixel(%d,%d) out of bounds\n",
		b_ysize-1-y, x);
    else
      fprintf(stderr, "Warning: getpixel(%d,%d) out of bounds\n", x, y);
#endif
    return(0);
  }
}
********************************/

/*
** allocate the bitmap
*/
void
b_makebitmap(x, y, planes)
unsigned int x, y, planes;
{
  register unsigned j;
  unsigned rows;

  x = 8 * (unsigned int)(x/8.0+0.9);	/* round up to multiple of 8 */
  y = 8 * (unsigned int)(y/8.0+0.9);	/* round up to multiple of 8 */
  b_psize = y/8;					/* size of each plane */
  rows = b_psize * planes;			/* total number of rows of 8 pixels high */
  b_xsize = x; b_ysize = y;
  b_currx = b_curry = 0;
  b_planes = planes;
  b_value = 1;
  b_angle = 0;
  b_rastermode = 0;
  /* allocate row pointers */
  b_p = (bitmap *)alloc( (unsigned long)rows * sizeof(pixels *), "bitmap row buffer");
  bzero(b_p, rows * sizeof(pixels *));
  for (j = 0; j < rows; j++) {
    /* allocate bitmap buffers */
    (*b_p)[j] = (pixels *)alloc((unsigned long)x * sizeof(pixels),(char *)NULL);
    if ((*b_p)[j] == (pixels *)NULL) {
		b_freebitmap();  /* free what we have already allocated */
		int_error("out of memory for bitmap buffer", NO_CARET);
	}
    bzero((*b_p)[j], x * sizeof(pixels));
  }
}
  
/*
** free the allocated bitmap
*/
void
b_freebitmap()
{
  int j;
  unsigned rows;

  rows = b_psize * b_planes;   /* total number of rows of 8 pixels high */
  for (j = 0; j < rows; j++)
  {
    (void) free((char *)(*b_p)[j]);
  }
  (void) free((char *)b_p);
  b_p = (bitmap *)(NULL);
}

/*
** set pixel at (x,y) with color b_value and dotted mask b_linemask.
*/
void
b_setmaskpixel(x,y,value)
unsigned int x,y,value;
{
	/* dotted line generator */
	if ((b_linemask>>b_maskcount)&(unsigned int)(1)) {
		b_setpixel(x,y,value);
	}
	b_maskcount= (b_maskcount+1) % 16;
	b_lastx= x;  /* last pixel set with mask */
	b_lasty= y;
}

/*
** draw a line from (x1,y1) to (x2,y2)
** with color b_value and dotted mask b_linemask.
*/
void
b_line(x1,y1,x2,y2)
unsigned int x1,y1,x2,y2;
{
int runcount;
int dx,dy;
int xinc,yinc;
unsigned int xplot,yplot;

	runcount=0;
	dx = abs((int)(x1)-(int)(x2));
	if (x2>x1)  xinc=  1;
	if (x2==x1) xinc=  0;
	if (x2<x1)  xinc= -1;
	dy = abs((int)(y1)-(int)(y2));
	if (y2>y1)  yinc=  1;
	if (y2==y1) yinc=  0;
	if (y2<y1)  yinc= -1;
	xplot=x1;
	yplot=y1;
	if (dx>dy) {
		/* iterate x */
		if ( (b_linemask==0xffff) ||
			((xplot!=b_lastx) && (yplot!=b_lasty)) )
			b_setmaskpixel(xplot,yplot,b_value);
		while (xplot!=x2) {
			xplot+=xinc;
			runcount+=dy;
			if (runcount>=(dx-runcount)) {
				yplot+=yinc;
				runcount-=dx;
			}
			b_setmaskpixel(xplot,yplot,b_value);
		}
	} else {
		/* iterate y */
		if ( (b_linemask==0xffff) ||
			((xplot!=b_lastx) && (yplot!=b_lasty)) )
			b_setmaskpixel(xplot,yplot,b_value);
		while (yplot!=y2) {
			yplot+=yinc;
			runcount+=dx;
			if (runcount>=(dy-runcount)) {
				xplot+=xinc;
				runcount-=dy;
			}
			b_setmaskpixel(xplot,yplot,b_value);
		}
	}
}

/*
** set character size
*/
void
b_charsize(size)
unsigned int size;
{
	int j;
	switch(size) {
		case FNT5X9:
			b_hchar = FNT5X9_HCHAR;
			b_hbits = FNT5X9_HBITS;
			b_vchar = FNT5X9_VCHAR;
			b_vbits = FNT5X9_VBITS;
			for (j = 0; j < FNT_CHARS; j++ )
				b_font[j] = &fnt5x9[j][0];
			break;
		case FNT9X17:
			b_hchar = FNT9X17_HCHAR;
			b_hbits = FNT9X17_HBITS;
			b_vchar = FNT9X17_VCHAR;
			b_vbits = FNT9X17_VBITS;
			for (j = 0; j < FNT_CHARS; j++ )
				b_font[j] = &fnt9x17[j][0];
			break;
		case FNT13X25:
			b_hchar = FNT13X25_HCHAR;
			b_hbits = FNT13X25_HBITS;
			b_vchar = FNT13X25_VCHAR;
			b_vbits = FNT13X25_VBITS;
			for (j = 0; j < FNT_CHARS; j++ )
				b_font[j] = &fnt13x25[j][0];
			break;
		default:
			int_error("Unknown character size",NO_CARET);
	}
}


/*
** put characater c at (x,y) rotated by angle with color b_value.
*/
void
b_putc(x,y,c,angle)
unsigned int x,y;
char c;
unsigned int angle;
{
	unsigned int i, j, k;
	char_row fc;

	j = c - ' ';
	for ( i = 0; i < b_vbits; i++ ) {
		fc = *( b_font[j] + i );
		if ( c == '_' ) {	/* treat underline specially */
			if ( fc  ) {	/* this this the underline row ? */
				/* draw the under line for the full h_char width */
				for ( k = ( b_hbits - b_hchar )/2;
					k < ( b_hbits + b_hchar )/2; k++ ) {
					switch(angle) {
						case 0 : b_setpixel(x+k+1,y+i,b_value);
							break;
						case 1 : b_setpixel(x-i,y+k+1,b_value);
							break;
					}
				}
			}
		}
		else {
			/* draw character */
			for ( k = 0; k < b_hbits; k++ ) {
				if ( ( fc >> k ) & 1 ) {
					switch(angle) {
						case 0 : b_setpixel(x+k+1,y+i,b_value);
							break;
						case 1 : b_setpixel(x-i,y+k+1,b_value);
							break;
					}
				}
			}
		}
	}
}


/*
** set b_linemask to b_pattern[linetype]
*/
int
b_setlinetype(linetype)
int linetype;
{
	if (linetype>=7)
		linetype %= 7;
	b_linemask = b_pattern[linetype+2];
	b_maskcount=0;
}

/*
** set b_value to value
*/
void
b_setvalue(value)
unsigned int value;
{
	b_value = value;
}

/*
** move to (x,y)
*/
int
b_move(x, y)
unsigned int x, y;
{
  b_currx = x;
  b_curry = y;
}

/*
** draw to (x,y) with color b_value
*/
int
b_vector(x, y)
unsigned int x, y;
{
  b_line(b_currx, b_curry, x, y);
  b_currx = x;
  b_curry = y;
}


/*
** put text str at (x,y) with color b_value and rotation b_angle
*/
int
b_put_text(x,y,str)
unsigned int x, y;
char *str;
{
	if (b_angle == 1)
		x += b_vchar/2;
	else
		y -= b_vchar/2;
   switch (b_angle) {
      case 0:
	 for (; *str; ++str, x += b_hchar)
	    b_putc (x, y, *str, b_angle);
					break;
      case 1:
	 for (; *str; ++str, y += b_hchar)
	    b_putc (x, y, *str, b_angle);
					break;
	}
}


int
b_text_angle(ang)
int ang;
{
	b_angle=(unsigned int)ang;
	return TRUE;
}
