CONST EndOfList = 5000
' $INCLUDE: 'QTIMER.BI'

DIM RandoList(EndOfList) AS INTEGER
DECLARE FUNCTION RanMan% (Range AS INTEGER)

RANDOMIZE TIMER

PRINT "Create the random list of numbers"

FOR I% = 0 TO EndOfList%
   RandoList(I%) = I%
NEXT I%

FOR I% = 0 TO EndOfList
   Idx% = RanMan%(EndOfList)
   Tmp% = RandoList(I%)
   RandoList(I%) = RandoList(Idx%)
   RandoList(Idx%) = Tmp%
NEXT I%

PRINT "Normal linear search"

Count& = 0
Misses% = 0
StartTime& = tStart&

FOR I% = 0 TO EndOfList + 5
   J% = 0
   DO WHILE ((RandoList(J%) <> I%) AND (J% < EndOfList))
     J% = J% + 1
   LOOP
   IF J% = EndOfList THEN
     Misses% = Misses% + 1
   ELSE
     Count& = Count& + J%
   END IF
NEXT I%

EndTime& = tGet&

fpCount& = Count&
fpExp! = (EndOfList + 5 - Misses%)

PRINT "Time: "; tFormat$(StartTime&, EndTime&);
PRINT USING " Average searches: #####.###"; fpCount& / fpExp!;
PRINT " Misses: "; Misses%

PRINT "Linear search using a sentinel value"

Count& = 0
Misses% = 0
StartTime& = tStart&

FOR I% = 0 TO EndOfList + 5
   RandoList(EndOfList) = I%
   J% = 0
   DO WHILE RandoList(J%) <> I%
     J% = J% + 1
   LOOP
   IF J% = EndOfList THEN
     Misses% = Misses% + 1
   ELSE
     Count& = Count& + J%
   END IF
NEXT I%

EndTime& = tGet&
fpCount& = Count&
fpExp! = (EndOfList + 5 - Misses%)

PRINT "Time: "; tFormat$(StartTime&, EndTime&);
PRINT USING " Average searches: #####.###"; fpCount& / fpExp!;
PRINT " Misses: "; Misses%

PRINT "End of execution"

FUNCTION RanMan% (Range AS INTEGER)
RanMan% = INT((Range - 1 + 1)*RND +1)
END FUNCTION
