' VIEWFILE.BAS  by Matt Hart
' View any size text file without any temporary files.
' Keeps the SEEK position of each line in a long integer array -
' which does limit this to 16,384 lines of text (and makes this
' program easy, small, and fast.)  Key controls are up, down,
' left, right, page up, page down, end, home, and escape.
'
    '$DYNAMIC
    DEFINT A-Z
'
    CONST false = 0
    CONST true = NOT false
    CLS
    LINE INPUT "File Name: "; File$
'   File$ = "VIEW.BAS"
'   File$ = "c:\binkley\nodelist\nodelist.235"
    Escape = false
'
    OPEN "I", 1, File$
    REDIM Seeks&(1 TO 16384)        ' Max number of lines if 16384
    CurSeek& = 1
    NumLines = 0
    DO UNTIL EOF(1)
        LINE INPUT #1, Text$
        NumLines = NumLines + 1
        Seeks&(NumLines) = CurSeek&          ' Save starting position
        CurSeek& = CurSeek& + LEN(Text$) + 2 ' Next position - 2 is
    LOOP                                     ' for C/R & LF
'
    CurCol = 1                               ' Current Column
    SeekEl = 1                               ' Current line
    Escape = false

    DO
       GOSUB LoadAndDisplay
       GOSUB KeyProcess
    LOOP UNTIL Escape

    CLOSE 1
    END

LoadAndDisplay:
    SEEK #1, Seeks&(SeekEl)
    FOR i = 1 TO 24
        IF NOT EOF(1) THEN LINE INPUT #1, Text$ ELSE Text$ = ""
        Strg$ = SPACE$(80)
        IF LEN(Text$) < CurCol THEN Text$ = Text$ + SPACE$(CurCol - LEN(Text$))
         LSET Strg$ = MID$(Text$, CurCol)
        LOCATE i, 1, 0: PRINT Strg$;
    NEXT i
RETURN

KeyProcess:
    A$ = INKEY$: IF A$ = "" THEN GOTO KeyProcess
    SELECT CASE A$
        CASE CHR$(27): Escape = true        ' ESC
        CASE CHR$(0) + CHR$(72)             ' Up Arrow
            SeekEl = SeekEl - 1
            IF SeekEl < 1 THEN SeekEl = 1: GOTO KeyProcess
        CASE CHR$(0) + CHR$(80)             ' Dn Arrow
            SeekEl = SeekEl + 1
            IF SeekEl + 23 > NumLines THEN SeekEl = SeekEl - 1: GOTO KeyProcess
         CASE CHR$(0) + CHR$(77)             ' Right Arrow
            CurCol = CurCol + 1
        CASE CHR$(0) + CHR$(75)             ' Left Arrow
            CurCol = CurCol - 1
            IF CurCol < 1 THEN CurCol = 1: GOTO KeyProcess
        CASE CHR$(0) + CHR$(73)             ' Page Up
            SeekEl = SeekEl - 24
            IF SeekEl < 1 THEN SeekEl = 1
        CASE CHR$(0) + CHR$(81)             ' Page Dn
            SeekEl = SeekEl + 24
            IF SeekEl > NumLines THEN
                SeekEl = NumLines - 23: GOTO KeyProcess
            END IF
        CASE CHR$(0) + CHR$(71)                       ' Home
            SeekEl = 1
        CASE CHR$(0) + CHR$(79)                       ' End
            SeekEl = NumLines - 23
            IF SeekEl < 1 THEN SeekEl = 1: GOTO KeyProcess
        CASE ELSE
            GOTO KeyProcess
    END SELECT
RETURN

