procedure EXTRUDE;
 { procedure will make a solid of extrusion }

var
   Firstnode, Lastnode:   integer;       { first, last node # in the solid }
   Node:                  integer;       { node # }
   Surf:                  integer;       { surface # }
   X, Y:                  array[1..MAXOUTLN] of real; { coords of surf outln }
   Noutln:                integer;       { number of outline nodes }
   Num:                   integer;       { #inputted vals on line }
   Comment:               text80;        { comment at end of line }
   Realvar:               vartype;       { genl. input array }
   Outln:                 integer;       { outline node number }
   Orient:                integer;       { orientation code (1 = X axis,
                                              2 = Y axis, 3 = Z axis) }
   d1, d2, d3:            integer;       { degree nos. for each axis }
   Nextrude:              integer;       { number of layers to generate }
   Iquad:                 integer;       { flag, (1) use quads only, or }
                                         {       (2) use any order polygons }
   Material:              integer;       { material number of solid }
   Nextnode:              integer;       { 1st node of next quad }
   i:                     integer;       { genl index }
   Zslice:                real;          { length of slice in Z direction }
   Firstnodelastrow:      integer;       { node # }
   Firstnodethisrow:      integer;       { node # }
   Scale:                 vector;        { scale factors }
   Shift:                 vector;        { shift distances }
   Rotate:                vector;        { rotation angles }
   Zbot, Ztop:            real;          { top and bottom specified by input }
   Islice:                integer;       { Z-slice number }
   Quad:                  integer;       { Quad number on top or bottom surf }
   Nquads:                integer;       { #quads on top or bottom surf }

begin
{$ifdef BIGMEM}
with ptra^ do with ptrb^ do with ptrc^ do
begin
{$endif}
  Line_num := Line_num + 1;
  Num := inreal (Infile, Realvar, Comment, Line_num, FALSE);
  if (Num <> 5) or (Realvar[1] < 1) or (Realvar[1] > MAXOUTLN) or
       (Realvar[2] < 1) or (Realvar[3] < 0) or (Realvar[3] > 1) or
       (Realvar[4] < 1) or (Realvar[4] > Nmatl) or (Realvar[5] < 1) or
       (Realvar[5] > 3) then begin
    writeln ('Bad input for solid of extrusion (line ', Line_num, ')');
    if (Num <> 5) then
      writeln ('Expecting 5 numeric entries');
    if (Realvar[1] < 1) or (Realvar[1] > MAXOUTLN) then
      writeln ('Number of outline nodes must be between 1 and ', MAXOUTLN);
    if (Realvar[2] < 1) then
      writeln ('Number of vertical slices must be positive');
    if (Realvar[3] < 0) or (Realvar[3] > 1) then
      writeln ('Subdivision flag must be either 0 or 1');
    if (Realvar[4] < 0) or (Realvar[4] > Nmatl) then
      writeln ('Matl. must be between 1 and ',Nmatl);
    if (Realvar[5] < 0) or (Realvar[5] > Nmatl) then

      writeln ('Orientation code must be 1, 2, or 3');
    close (Infile);
    halt;
  end;
  Noutln := round(Realvar[1]);
  Nextrude := round(Realvar[2]);
  Iquad := round(Realvar[3]);
  Material := round(Realvar[4]);
  Orient := round(Realvar[5]);

  Line_num := Line_num + 1;
  Num := inreal (Infile, Realvar, Comment, Line_num, FALSE);
  if (Num <> 6) then begin
    writeln ('Bad input for shifting or scaling (line ', Line_num, ')');
    writeln ('Expecting 6 numeric entries');
    close (Infile);
    halt;
  end;
  Scale[1] := Realvar[1];
  Scale[2] := Realvar[2];
  Scale[3] := Realvar[3];
  Shift[1] := Realvar[4];
  Shift[2] := Realvar[5];
  Shift[3] := Realvar[6];

  Line_num := Line_num + 1;
  Num := inreal (Infile, Realvar, Comment, Line_num, FALSE);
  if (Num <> 3) then begin
    writeln ('Bad input for rotations (line ', Line_num, ')');
    writeln ('Expecting 3 numeric entries');
    close (Infile);
    halt;
  end;
  Rotate[1] := Realvar[1];
  Rotate[2] := Realvar[2];
  Rotate[3] := Realvar[3];

  Line_num := Line_num + 1;
  Num := inreal (Infile, Realvar, Comment, Line_num, FALSE);
  if (Num <> 2) then begin
    writeln ('Bad input: expecting 2 numeric entries for top and bottom ',
        '(line ', Line_num, ')');
    close (Infile);
    halt;
  end; { if Num }
  Ztop := Realvar[1];
  Zbot := Realvar[2];

  for Outln := 1 to Noutln do begin
    Line_num := Line_num + 1;
    Num := inreal (Infile, Realvar, Comment, Line_num, FALSE);
    if (Num <> 2) then begin
      writeln ('Bad input: expecting 2 entries for node (Line ',Line_num, ')');
      close (Infile);
      halt;
    end;
    X[Outln] := Realvar[1];
    Y[Outln] := Realvar[2];
  end; { for Outln }

  case Orient of
    1: begin       { X major axis }
         d1 := 2;
         d2 := 3;
         d3 := 1;
       end;
    2: begin       { Y major axis }
         d1 := 3;
         d2 := 1;
         d3 := 2;
       end;
    3: begin       { Z major axis }
         d1 := 1;
         d2 := 2;
         d3 := 3;
       end;
  end;   { case }

  Firstnode := Nnodes + 1;
  Node := Nnodes;
  Surf := Nsurf;

  Zslice := (Ztop - Zbot) / Nextrude;

{ Do the top row of nodes first }
  for Outln := 1 to Noutln do begin
    Node := Node + 1;
    if (Node > MAXNODES) then begin
      writeln ('Exceeded MAXNODES=',MAXNODES,' in surface of extrusion ',
        '(line ',Line_num,' of input).');
      close (Infile);
      halt;
    end;
    World[Node][d1] := X[Outln];
    World[Node][d2] := Y[Outln];
    World[Node][d3] := Ztop;
  end;

{ Connect the top surface(s) }
  Firstnodethisrow := Firstnode;
  if (Iquad = 0) then begin

    { Don't break the top surface into quads; leave it as is }
    Surf := Surf + 1;
    if (Surf > Realmaxsurf) then begin
      writeln ('Exceeded MAXSURF=',Realmaxsurf,' in surface of extrusion ',
        '(line ',Line_num,' of input).');
      close (Infile);
      halt;
    end;
    Matl[Surf] := Material;
    if (Noutln > Maxvert) then begin
      writeln ('Bad input: Noutln cannot exceed Maxvert if Iquad=0');
      close (Infile);
      halt;
    end;
    for Outln := 1 to Noutln do
      Connect[(Surf-1)*Maxvert+Outln] := Firstnodethisrow + Outln - 1;
    if (Noutln < Maxvert) then
      Connect[(Surf-1)*Maxvert+Noutln+1] := 0;

  end else begin

    { Break the surface into quads, plus an extra triangle if req'd }
    Nquads := (Noutln-2) div 2;
    Nextnode := Firstnodethisrow;
    for Quad := 1 to Nquads do begin
      Surf := Surf + 1;
      if (Surf > Realmaxsurf) then begin
        writeln ('Exceeded MAXSURF=',Realmaxsurf,' in surface of extrusion ',
          '(line ',Line_num,' of input).');
        close (Infile);
        halt;
      end;
      Matl[Surf] := Material;
      Connect[(Surf-1)*Maxvert+1] := Firstnodethisrow;
      for i := 2 to 4 do
        Connect[(Surf-1)*Maxvert+i] := Nextnode + i - 1;
      if (Maxvert > 4) then
        Connect[(Surf-1)*Maxvert+5] := 0;
      Nextnode := Nextnode + 2;
    end; { for Quad }
    if ((Noutln div 2) * 2 <> Noutln) then begin
      { Noutln is odd, so need an extra triangle to complete the surface }
      Surf := Surf + 1;
      if (Surf > Realmaxsurf) then begin
        writeln ('Exceeded MAXSURF=',Realmaxsurf,' in surface of extrusion ',
          '(line ',Line_num,' of input).');
        close (Infile);
        halt;
      end;
      Matl[Surf] := Material;
      Connect[(Surf-1)*Maxvert+1] := Firstnodethisrow;
      for i := 2 to 3 do
        Connect[(Surf-1)*Maxvert+i] := Nextnode + i - 1;
      Connect[(Surf-1)*Maxvert+4] := 0;
    end; { if Noutln }
  end; { if Iquad }

  Firstnodelastrow := Firstnodethisrow;
  for Islice := 1 to Nextrude do begin
    Firstnodethisrow := Node + 1;
    for Outln := 1 to Noutln do begin
      Node := Node + 1;
      if (Node > MAXNODES) then begin
        writeln ('Exceeded MAXNODES=',MAXNODES,' in surface of extrusion ',
          '(line ',Line_num,' of input).');
        close (Infile);
        halt;
      end;
      World[Node][d1] := X[Outln];
      World[Node][d2] := Y[Outln];
      World[Node][d3] := Ztop - Zslice * Islice;

      Surf := Surf + 1;
      if (Surf > Realmaxsurf) then begin
        writeln ('Exceeded MAXSURF=',Realmaxsurf,' in surface of extrusion ',
          '(line ',Line_num,' of input).');
        close (Infile);
        halt;
      end;
      Matl[Surf] := Material;
      Connect[(Surf-1)*Maxvert+1] := Firstnodelastrow + Outln - 1;
      Connect[(Surf-1)*Maxvert+2] := Firstnodethisrow + Outln - 1;
      if (Outln = Noutln) then begin
        Connect[(Surf-1)*Maxvert+3] := Firstnodethisrow;
        Connect[(Surf-1)*Maxvert+4] := Firstnodelastrow;
      end else begin
        Connect[(Surf-1)*Maxvert+3] := Firstnodethisrow + Outln;
        Connect[(Surf-1)*Maxvert+4] := Firstnodelastrow + Outln;
      end;
      if (Maxvert > 4) then
        Connect[(Surf-1)*Maxvert+5] := 0;
    end; { for Outln }
    Firstnodelastrow := Firstnodethisrow;
  end; { for Islice }

  Lastnode := Node;
  Nnodes := Node;

{ Connect the bottom surface(s) in reverse order }
  Firstnodethisrow := Firstnodelastrow;
  if (Iquad = 0) then begin

    { Don't break the bottom surface into quads; leave it as is }
    Surf := Surf + 1;
    if (Surf > Realmaxsurf) then begin
      writeln ('Exceeded MAXSURF=',Realmaxsurf,' in surface of extrusion ',
        '(line ',Line_num,' of input).');
      close (Infile);
      halt;
    end;
    Matl[Surf] := Material;
    for Outln := 1 to Noutln do
      Connect[(Surf-1)*Maxvert+Outln] := Firstnodethisrow + Noutln - Outln;
    if (Noutln < Maxvert) then
      Connect[(Surf-1)*Maxvert+Noutln+1] := 0;

  end else begin

    { Break the surface into quads, plus an extra triangle if req'd }
    Nquads := (Noutln-2) div 2;
    Nextnode := Firstnodethisrow + Noutln;
    for Quad := 1 to Nquads do begin
      Surf := Surf + 1;
      if (Surf > Realmaxsurf) then begin
        writeln ('Exceeded MAXSURF=',Realmaxsurf,' in surface of extrusion ',
          '(line ',Line_num,' of input).');
        close (Infile);
        halt;
      end;
      Matl[Surf] := Material;
      Connect[(Surf-1)*Maxvert+1] := Firstnodethisrow;
      for i := 2 to 4 do
        Connect[(Surf-1)*Maxvert+i] := Nextnode - i + 1;
      if (Maxvert > 4) then
        Connect[(Surf-1)*Maxvert+5] := 0;
      Nextnode := Nextnode + 2;
    end; { for Quad }
    if ((Noutln div 2) * 2 <> Noutln) then begin
      { Noutln is odd, so need an extra triangle to complete the surface }
      Surf := Surf + 1;
      if (Surf > Realmaxsurf) then begin
        writeln ('Exceeded MAXSURF=',Realmaxsurf,' in surface of extrusion ',
          '(line ',Line_num,' of input).');
        close (Infile);
        halt;
      end;
      Matl[Surf] := Material;
      Connect[(Surf-1)*Maxvert+1] := Firstnodethisrow;
      for i := 2 to 3 do
        Connect[(Surf-1)*Maxvert+i] := Nextnode - i + 1;
      Connect[(Surf-1)*Maxvert+4] := 0;
    end; { if Noutln }
  end; { if Iquad }

  Nsurf := Surf;

  rotatenodes (Firstnode, Lastnode, Rotate);
  shiftnodes (Firstnode, Lastnode, Shift);
  scalenodes (Firstnode, Lastnode, Scale);
{$ifdef BIGMEM}
end; {with}
{$endif}
end; { procedure EXTRUDE }
