% Prolog for the itrans program...
% RCSID: $Header: e:/itrans/lib/rcs/itrans.pro 1.2 91/09/05 21:49:25 aginash Exp $
%
% ========================================================================== 
% Copyright 1991 Avinash Chopde, All Rights Reserved.
%
% Permission to use, copy, modify and distribute this software and its
% documentation for any purpose is hereby granted without fee, provided that
% the above copyright notice appear in all copies and that both that
% copyright notice and this permission notice appear in supporting
% documentation, and that the name of Avinash Chopde not be used in
% advertising or publicity pertaining to distribution of the software
% without specific, written prior permission.
% Avinash Chopde makes no representations about the suitability of this
% software for any purpose.
% It is provided "as is" without express or implied warranty.
%
% AVINASH CHOPDE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
% INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
% IN NO EVENT SHALL AVINASH CHOPDE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
% CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
% DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
% TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
% OF THIS SOFTWARE.
%
% Author:  Avinash Chopde, 1991
%	    C2 Colonial Drive #4, Andover, MA 01810, USA.
%

/endx 500 def
/endy 790 def
/EMSIZE 40 def
% program redefines EMSIZE value, otherwise use 40 point size

/checkline {  % -- checkline  -> -- (uses EMSIZE global variable)
    currentpoint
    % (in checkline) == pstack
    /y exch def
    EMSIZE add endx ge { % add EMSIZE to x on stack
    	    /y y EMSIZE sub def % go to next line
	    y 10 le { % check if overflow on next page
		/y endy def
		showpage
	    } if

	    50 y moveto
	}  if % x > endx, reached end of line
    % (end of checkline) == pstack
} def

/newline {
    currentpoint
    % (in checkline) == pstack
    /y exch def
    pop
    /y y EMSIZE sub def % go to next line
    y 10 le { % check if overflow on next page
	/y endy def
	showpage
    } if
    50 y moveto
} def

/EM { % expects a em-unit on stack, converts it to PostScript points
    EMSIZE mul
} def


/BASEFONTNAME /Devnac def % this should be redefined by the itrans program..
			  % so that it refers to the correct font name.

/basefont {
    BASEFONTNAME findfont
} def

/currentfontsize { % pushes the current font size on the stack
    EMSIZE
} def

% <fontsize in points> slantfont --
/normalfont {		% sets font to be the normal font of BASEFONTNAME
    /EMSIZE exch def
    basefont [EMSIZE 0 0 EMSIZE 0 0] makefont setfont
} def

% <fontsize in points> slantfont --
/slantfont {		% sets up a slanted version of font BASEFONTNAME
    /EMSIZE exch def
    basefont [EMSIZE 0  0.167 EMSIZE mul  EMSIZE 0 0] makefont setfont
} def

% <fontsize in points> expandedfont --
/expandedfont { 	% expanded version of BASEFONTNAME
    /EMSIZE exch def
    basefont [EMSIZE 1.2 mul  0 0 EMSIZE 0 0] makefont setfont
} def

% <fontsize in points> compressedfont --
/compressedfont { 	% compressed (x-axis) version of BASEFONTNAME
    /EMSIZE exch def
    basefont [EMSIZE 0.82 mul  0 0 EMSIZE 0 0] makefont setfont
} def

% <fontsize in points> englishfont --
/englishfont {
    /Times-Roman findfont exch scalefont setfont
} def
