#ifndef IFM_H
#define IFM_H

/*
 *========================================================================== 
 * Copyright 1991 Avinash Chopde, All Rights Reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Avinash Chopde not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * Avinash Chopde makes no representations about the suitability of this
 * software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * AVINASH CHOPDE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL AVINASH CHOPDE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * Author:  Avinash Chopde, 1991
 *	    C2 Colonial Drive #4, Andover, MA 01810, USA.
 *
 */

/* static char S_RCSID[] = "$Header: e:/itrans/src/rcs/ifm.h 1.3 91/10/07 23:27:45 avinash Exp $"; */

#include <stdio.h>

#if defined(__STDC__) || (PROTO_C)
#   define P(s)	s
#else
#   define P(s) ()
#endif

/* Lines from the IFM file may contain these tokens: CC, CCS, CCADD,
 * word, number, etc
 * Examples:
(start of indian script composite char metrics:)
Comment -I- StartINDIAN
(indian script font name and number (number is from y.tab.h - yacc generated:)
Comment -I- FONT 224 devnac.afm marathi
(indian script composite char metrics:)
Comment -I- CC a 2 ; PCC 97 0 0 ; PCC 129 -70 0 ;
(special composite char metrics added:)
Comment -I- CCADD normA ;
(define equivalence bewteen khadi's:)
Comment -I- CCS normAkp normA ;
(end of indian script composite char metrics:)
Comment -I- EndINDIAN
 *
 */

/* tokens returned by yylex(), values must be > 0 and distinct */
#define COMMENT_IFMTAG		1
#define IFM_IFMTAG		2
#define ENDIFM_IFMTAG		3
#define CC_IFMTAG		4
#define CCS_IFMTAG		5
#define CCADD_IFMTAG		6
#define PCC_IFMTAG		7
#define DNAME_IFMTAG		8
#define NUMBER_IFMTAG		9
#define IMPLICIT_IFMTAG		10
#define NONE_IFMTAG		11
#define DELTAS_IFMTAG		12
#define FONT_IFMTAG		13
#define PROP_IFMTAG		14

/* the lexer is switched between many states depending on which
 * file it is reading, these macros are used to guide the lexer
 * to the correct patterns.
 * (see set_lex_input_fp().)
 */
#define BEGIN_IFM		1
#define BEGIN_INPUT		2

extern set_lex_input_fp	P((FILE* fp, int begin));

extern int G_ifm_lineno; /* current line number, IFM file */

/** extern functions */
extern int get_ifm_token	P((FILE* fp, char* word));
extern void reset_pifm		P(());

/* ===========================^ ifm.h ^============================== */
#undef P
#endif /* IFM_H */
