;=======================================================================
; MODULE NAME:  NumBits.ASM
; DEPENDENCIES: (None)
; LAST MOD ON:  9005.08
; PROGRAMMER:   Naoto Kimura
;
;     This is the assembly code for the routine NumBits.  This routine
; returns the number of bits required for representing a value.
;
;     This file should be assembled with Turbo Assembler.  If you need
; to use another assembler, then you should keep some things in mind.
;
; The TPASCAL memory model sets up automatically:
; * the standard Turbo Pascal entry code
;      push bp
;      mov bp,sp
; * the standard Turbo Pascal exit code
;      pop bp
;      ret n
; * the order of the arguments don't need to be reversed in the
;   assembly code.
;-----------------------------------------------------------------------
; 9004.22     Naoto Kimura
;             * Initial version created
;
; Modification history:
;
;=======================================================================
.MODEL   TPASCAL
LOCALS

.CODE

;-----------------------------------------------------------------------
;FUNCTION NumBits ( L : LongInt ) : Integer
;
; This funciton returns the number of bits required for representing a 
; value.
;
; REGISTER USAGE:  AX -- Return value
;                  BX -- Zeroed
;-----------------------------------------------------------------------
NumBits		PROC FAR L:DWORD
		PUBLIC	NumBits
		les	bx,[L]		; es:bx <-- L
		mov	ax,es		; ax <-- HiWord(L)
		or	ax,ax
		jz	@@ShiftIt
		xchg	ax,bx		; bx <--> ax
		mov	ax,16
@@ShiftIt:	shr	bx,1
		inc	ax
		or	bx,bx
		jnz	@@ShiftIt
		ret
NumBits		ENDP

END
