{

                                                      ͻ
                                                            PGUI        
                                                           Example      
                                                          Rev. 1.01     
                                                      ͼ

}

Program EG;

{$F-} {$O-} {$A+} {$G-}
{$V-} {$B-} {$X-} {$N+} {$E+}

{$I FINAL.PAS}

{$IFDEF FINAL}
  {$I-} {$R-}
  {$D-} {$L-} {$S-}
  {$M 8192,262144,655360}
{$ELSE}
  {$M 8192,0,655360}
{$ENDIF}

{$M 20000,120000,300000}

Uses CRT,Dos,Graph,PGUI,Strings,Dirs;

{ ͻ }
{                                                                          }
{   This program is an example for the Pure Power GUI.                     }
{                                                                          }
{   Program Author : Michael Gallias                                       }
{   Date           : 31 January  1992                                      }
{   Last Updated   : 31 December 1992                                      }
{                                                                          }
{ ͼ }

Var
  Ver  :String[10];
  FName:PathStr;

Procedure QuitProg;

{ ͻ }
{                  Quit Program                                            }
{ ͼ }

Begin
  CloseGraph;
  WriteLn('Thank you,');
  WriteLn('  for using the Pure Power GUI Unit by Michael Gallias.');
  Halt(0);
End;

Function SureQuit:Boolean;

{ ͻ }
{                Prompt Before Quit                                        }
{ ͼ }

Var
  PWin     :GraphicWindow;
  X,Y      :Word;
  MB       :Byte;
  Held,
  Doubled,
  Special  :Boolean;
  Key      :Char;

Begin
  PWin.Open(100,100,280,200,Red,Black,2,SolidFill,Black,True);
  PWin.NewHeading('Quit',CentreText,Yellow,CloseDotFill,Blue);
  Mouse.Hide;
  PWin.Lock;
  SetColor(White);
  OutTextXY(40,30,'Are you sure?');
  PWin.UnLock;
  PWin.Buttons.Create(145,150,180,180,2,Black,NIL,'Yes',False,'Y');
  PWin.Buttons.Create(195,150,230,180,2,Black,NIL,'No',False,'N');
  Mouse.Show;
  PWin.Buttons.WaitForClick(X,Y,MB,Held,Doubled,Special,Key);
  If (Key='Y') And (Not Special) Then SureQuit:=True Else SureQuit:=False;
  PWin.Close;
End;

Procedure NewName(Var FName:String);

{ ͻ }
{     Gets a New File Name when a directory is being displayed             }
{ ͼ }

Var
   Temp   :String;

   PWin   :GraphicWindow;
   X,Y    :Word;
   MB     :Byte;
   Held,
   Doubled,
   Special:Boolean;
   Key    :Char;

Begin
  PWin.Open(75,200,575,320,Red,Black,2,SolidFill,Black,True);
  PWin.NewHeading('New File Name',CentreText,Yellow,CloseDotFill,Blue);
  Mouse.Hide;
  SetColor(White);
  PWin.Lock;
  OutTextXY(30,30,'Specify the file name, including path if needed.');
  OutTextXY(30,90,'Press [Esc] to Abort');
  Temp:='';
  EditString(30,60,40,True,Temp);
  PWin.UnLock;
  Mouse.Show;
  If Temp<>'' Then FName:=Temp;
  PWin.Close;
End;

Procedure NewPath;

{ ͻ }
{    Lets the user specify a new directory to search.                      }
{ ͼ }

Var
   Temp:String;

   PWin   :GraphicWindow;
   X,Y    :Word;
   MB     :Byte;
   Held,
   Doubled,
   Special:Boolean;
   Key    :Char;

Begin
  PWin.Open(75,200,575,320,Red,Black,2,SolidFill,Black,True);
  PWin.NewHeading('New Path',CentreText,Green,CloseDotFill,Blue);
  Mouse.Hide;
  PWin.Lock;
  SetColor(White);
  OutTextXY(30,30,'Specify the path name, drive letter included if needed.');
  OutTextXY(30,90,'Press [Esc] to Abort');
  Temp:='';
  EditString(30,60,40,True,Temp);
  PWin.UnLock;
  Mouse.Show;
  If Temp<>'' Then GoDir(Temp);
  PWin.Close;
End;

Procedure OneFile(Var FName:String);

{ ͻ }
{   Lets the user pick one file from the files on the disk.                }
{ ͼ }

Const
   X = 200;    {Area to display the}
   Y = 120;    {list of files}

Var
   PWin   :GraphicWindow;
   MX,MY  :Word;
   MB     :Byte;
   PgUp,
   PgDn,
   Held,
   Doubled,
   Special:Boolean;
   Key    :Char;

   Dir     :DirList;
   NewDir,
   Okay    :Boolean;
   EndF,
   I,J,
   Current,
   Start   :Word;
   Mask    :String[64];

   MouseDef:BGIMouseShapePtr;

Begin
  Dir.Root:=NIL;
  Dir.Info:=NIL;
  Dir.Total:=0;
  StandardScreen('PGUI Unit Example Program   (c)  Michael Gallias  1993   '+Ver);
  PWin.Open(50,50,590,440,Blue,Black,4,SolidFill,Black,False);
  PWin.NewHeading('Select A File',CentreText,Yellow,CloseDotFill,LightGray);

  New(MouseDef);

  NewDir:=False;
  Repeat {Not NewDir}
    MouseDef^.Picture:=IconBGIMouseCursorA;
    MouseDef^.Mask   :=IconBGIMouseMaskA;
    MouseDef^.XHot   :=0;
    MouseDef^.YHot   :=0;
    Mouse.SetShape(MouseDef);

    Okay:=False;
    Mask:='*.*';
    LoadDirList(Dir,Mask,StdFile,Directories + Files);
    Start:=1;
    Current:=1;

    MouseDef^.Picture:=IconBGIMouseCursorC;
    MouseDef^.Mask   :=IconBGIMouseMaskC;
    MouseDef^.XHot   :=0;
    MouseDef^.YHot   :=0;
    Mouse.SetShape(MouseDef);

    Repeat    {Okay}
      Mouse.Hide;
      SetFillStyle(SolidFill,Black);
      Bar(X,Y-40,X+200,Y+295);
      Mouse.Show;
      ShowDirList(Dir,Files + Directories + Size, X, Y,
                  Current, Start, 21, Green, Blue, White, PgUp, PgDn);

      PWin.Buttons.Add(9999,9999,9999,9999,0,0,NIL,'',True,'H');
      {Up Key, Keyboard Only}
      PWin.Buttons.Add(9999,9999,9999,9999,0,0,NIL,'',True,'P');
      {Down Key, Keyboard Only}

      If PgUp Then
        PWin.Buttons.Create(X+60,Y-40,X+100,Y-15,2,Black,NIL,'PgUp',True,'I');

      If PgDn Then
        PWin.Buttons.Create(X+60,Y+270,X+100,Y+295,2,Black,NIL,'PgDn',True,'Q');

      I:=0;
      J:=1;
      If Dir.Total>0 Then
        Repeat
          PWin.Buttons.Add(X-5,Y+I,X+100,Y+I+8,0,0,NIL,'',False,Chr(J));
          Inc(I,12);
          Inc(J);
        Until J=Dir.Total+1                            {Up to 21 Files}
      Else
        OutTextXY(X+16,Y+30,'No Files');

      PWin.Buttons.Create(80,210,140,255,2,Black,NIL,'Okay',False,'O');
      PWin.Buttons.Create(440,210,500,255,2,Black,NIL,'Path',False,'P');
      PWin.Buttons.Create(440,270,500,315,2,Black,NIL,'Name',False,'N');
      PWin.Buttons.Create(576,1,634,15,2,Black,NIL,'Quit',False,#27);

      PWin.Buttons.WaitForClick(MX,MY,MB,Held,Doubled,Special,Key);
      SetColor(White);
      If Special Then
      Begin
        Case Key Of
          'I':Begin
                If Start>20 Then Dec(Start,20) Else Start:=1;
                Current:=Start;
              End;
          'Q':Begin
                Inc(Start,20);
                If Dir.Total-Start<21 Then Start:=Dir.Total-20;
                Current:=Start;
              End;
          'H':Begin
                If Current>1 Then Dec(Current);
                If Current<Start Then Dec(Start);
              End;
          'P':Begin
                If Current<Dir.Total Then Inc(Current);
                If (Current>Start+20) And (Start+20<Dir.Total) Then Inc(Start);
              End;
        End;
      End
      Else
        Case Key Of
          'O':Begin
                Okay:=True;
                GotoDirList(Dir,Current);
                If IsDir(Dir.Info^.Name) Then
                Begin
                  GoDir(Dir.Info^.Name);
                  Okay:=True;
                  NewDir:=True;
                End
                Else
                  NewDir:=False;
              End;
          'N':Begin
                NewName(Mask);
                If Mask='' Then
                  Mask:='*.*'
                Else
                Begin
                  Okay:=True;
                  GotoDirList(Dir,Current);
                  Dir.Info^.Name:=Mask;
                  If IsDir(Dir.Info^.Name) Then
                  Begin
                    GoDir(Dir.Info^.Name);
                    NewDir:=True;
                  End
                  Else
                    NewDir:=False;
                End;
              End;
          'P':Begin
                NewPath;
                Okay:=True;
                NewDir:=True;
              End;
          #27:If SureQuit Then QuitProg;
          #1..#21:Current:=Ord(Key)+Start-1;
        End;
      Begin
      End;
      PWin.Buttons.KillAll;
    Until Okay;
    GotoDirList(Dir,Current);
    FName:=Dir.Info^.Name;
    KillDirList(Dir);
  Until Not NewDir;
  Dispose(MouseDef);
  PWin.Close;
End;

Begin
  Ver:='Ver. 1.01';
  InitVGA('D:\TP\BGI');      (* ****** Put your BGI Path Here ****** *)
  Mouse.Init(True);
  InstallBGIMouse(NIL);
  Mouse.Show;
  OneFile(FName);
  CloseGraph;
  WriteLn('File Selected: ',FName);
  WriteLn;
End.
