;   _______________________________________________________________
;  |                                                               |
;  |            Copyright (C) 1989,1990  Steven Lutrov             |
;  |_______________________________________________________________|____
;  |                                                               |    |
;  |  Program Title : FastBit.Asm                                  |    | ___
;  |  Author        : Steven Lutrov                                |    |    |
;  |  Revision      : 2.01                                         |    |    |
;  |  Date          : 1990-03-16                                   |    |    |
;  |  Language      : Turbo  Assembler                             |    |    |
;  |                                                               |    |    |
;  |  Description   : Assembly Functions For Bit Mannipulation.    |    |    |
;  |                : Tested with Turbo Pascal Ver 5.0 5.5         |    |    |
;  |                                                               |    |    |
;  |_______________________________________________________________|    |    |
;      |                                                                |    |
;      |________________________________________________________________|    |
;          |                                                                 |
;          |_________________________________________________________________|
;


Code    Segment Word  Public

Assume  Cs:Code


Public  Bytetohex,Rotatebyteleft,Rotatewordleft,Rotatebyteright
Public  Rotatewordright,Wordtohex


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Bytetohex(Work_: Byte): Stype;
;
;
Bytetohex Proc Far
                Push Bp                         ;Save Bp
                Mov  Bp,Sp                      ;Set Stack Frame
                Les  Di,Dword Ptr[Bp+8]         ;Es:Di Pts To Return String
                Sub  Si,Si                      ;Si Counts Chars
                Mov  Bl,[Bp+6]                  ;Get The Value To Convert
                Mov  Cl,2                       ;String Length
                Mov  Es:[Di],Cl                 ;Set String Descriptor
                Shl  Cl,1                       ;Cl=4 Bits=One-Half Byte
Bytetohex1:     Sub  Bh,Bh                      ;Clear Bh
                Shl  Bx,Cl                      ;Shift In One-Half Byte
                Cmp  Bh,10                      ;Is It '0' - '9'?
                Jl   Bytetohex2                 ;If Not, Jump Ahead
                Add  Bh,55                      ;10+55 = 'A', Etc...
                Jmp  Short Bytetohex3           ;Jmp Ahead
Bytetohex2:     Add  Bh,48                      ;0+48 = '0', Etc...
Bytetohex3:     Inc  Di                         ;Pt To Next Byte Of Strx
                Mov  Es:[Di],Bh                 ;Place Char In The Strx
                Inc  Si                         ;Test Char Counter
                Cmp  Si,2                       ;End Of String?
                Jne  Bytetohex1                 ;Jump If Not
                Pop  Bp                         ;Restore Bp
                Ret  2
Bytetohex Endp



;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Rotatewordleft(Work_: Word; Bits_: Byte): Word;
;
;
Rotatewordleft Proc Far
                Mov  Bx,Sp                      ;Set Stack Frame
                Mov  Cl,Ss:[Bx+4]               ;Number Of Bits To Rotate
                Mov  Ax,Ss:[Bx+6]               ;Get The Integer
                Rol  Ax,Cl                      ;Make The Rotation
                Ret  4
Rotatewordleft Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Rotatebyteright(Work_,Bits_: Byte): Byte;
;
;
Rotatebyteright Proc Far
                Mov  Bx,Sp                      ;Set Stack Frame
                Mov  Cl,Ss:[Bx+4]               ;Number Of Bits To Rotate
                Mov  Al,Ss:[Bx+6]               ;Get The Byte
                Ror  Al,Cl                      ;Make The Rotation
                Ret  4
Rotatebyteright Endp

;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Rotatebyteleft(Work_,Bits_:Byte): Byte;
;
;
Rotatebyteleft Proc Far
                Mov  Bx,Sp                      ;Set Stack Frame
                Mov  Cx,Ss:[Bx+4]               ;Number Of Bits To Rotate
                Mov  Al,Ss:[Bx+6]               ;Get The Byte
                Rol  Al,Cl                      ;Make The Rotation
                Ret  4
Rotatebyteleft Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Rotatewordright(Work_: Word; Bits_: Byte): Word;
;
;
Rotatewordright Proc Far
                Mov  Bx,Sp                      ;Set Stack Frame
                Mov  Cl,Ss:[Bx+4]               ;Number Of Bits To Rotate
                Mov  Ax,Ss:[Bx+6]               ;Get The Integer
                Ror  Ax,Cl                      ;Make The Rotation
                Ret  4
Rotatewordright Endp



;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Wordtohex(Work_: Word): Stype;
;
;
Wordtohex Proc Far
                Push Bp                         ;Save Bp
                Mov  Bp,Sp                      ;Set Stack Frame
                Les  Di,Dword Ptr[Bp+8]         ;Es:Di Pts To Return String
                Sub  Si,Si                      ;Si Counts Chars
                Mov  Ax,[Bp+6]                  ;Get The Value To Convert
                Mov  Cl,4                       ;Shifts One-Half Byte
                Mov  Es:[Di],Cl                 ;Set String Descriptor
                Mov  Bl,Ah                      ;Start With High Byte
Wordtohex1:     Sub  Bh,Bh                      ;Clear Bh
                Shl  Bx,Cl                      ;Shift In One-Half Byte
                Cmp  Bh,10                      ;Is It '0' - '9'?
                Jl   Wordtohex2                 ;If Not, Jump Ahead
                Add  Bh,55                      ;10+55 = 'A', Etc...
                Jmp  Short Wordtohex3           ;Jmp Ahead
Wordtohex2:     Add  Bh,48                      ;0+48 = '0', Etc...
Wordtohex3:     Inc  Di                         ;Pt To Next Byte Of Strx
                Mov  Es:[Di],Bh                 ;Place Char In The Strx

                Inc  Si                         ;Test Char Counter
                Test Si,1                       ;Is Strx Ctr Odd Or Even?
                Jnz  Wordtohex1                 ;Do 2Nd Half Char If Odd
                Cmp  Si,2                       ;Another Byte To Do?
                Jne  Wordtohex4                 ;Jump If Not
                Mov  Bl,Al                      ;Fetch Low Byte
                Jmp  Short Wordtohex1           ;Start Over On 2Nd Byte
Wordtohex4:     Pop  Bp                         ;Restore Bp
                Ret  2
Wordtohex Endp


Code    Ends
        End

