program testbios;
{----------------------------------------------------------------------------
 |  Program TESTBIOS.PAS                                                    |
 |                                                                          |
 |  This program demonstrates the BIOS timing capability of the TPHRT       |
 |  t_bios timer functions in a Turbo Pascal environment.  The user may     |
 |  select from several BIOS interrupts to "exercise", and appropriate      |
 |  activity is generated, along with a BIOS timer summary.  MSDOS          |
 |  interrupt 21h is timed in all cases, showing the user the               |
 |  relationship between hardware and operating system overhead.            |
 |                                                                          |
 |  (c)1989 Ryle Design, P.O. Box 22, Mt. Pleasant, Michigan 48804          |
 |                                                                          |
 |  V3.00 Shareware Evaluation Version                                      |
 ----------------------------------------------------------------------------}
uses
    crt, printer, tphrt;

var
    atom : byte;
    hits : longint;
    rt   : longint;
    ts   : string;


procedure do_crt;
{----------------------------------------------------------------------------
 |  This procedure enables CRT & MSDOS timing, generates some CRT           |
 |  activity, and displays a BIOS timer summary.                            |
 |                                                                          |
 |  Globals referenced: none                                                |
 |                                                                          |
 |  Arguments: void                                                         |
 |                                                                          |
 |  Returns  : void                                                         |
 ----------------------------------------------------------------------------}
var
    indx : integer;

begin

    t_bios_start(CRT10 + DOS21);

    for indx := 1 to 20 do writeln('Ryle Design ... Purveyors of Big Science');

    t_bios_report(0);

    t_bios_stop;

end; { do_crt }


procedure do_disk;
{----------------------------------------------------------------------------
 |  This procedure enables DISK & MSDOS timing, generates some disk         |
 |  activity, and displays a BIOS timer summary.                            |
 |                                                                          |
 |  Globals referenced: none                                                |
 |                                                                          |
 |  Arguments: void                                                         |
 |                                                                          |
 |  Returns  : void                                                         |
 ----------------------------------------------------------------------------}
var
    indx : integer;
    df   : file of integer;
begin

    t_bios_start(DISK+DOS21);

    write('Creating data file ... ');
    assign(df,'TEST.DAT');
    rewrite(df);
    writeln('complete.');

    write('Writing 32k bytes two bytes at a time ... ');
    for indx := 1 to 16384 do write(df,indx);
    writeln('complete.');

    write('Closing and erasing file ... ');
    close(df);
    erase(df);
    writeln('complete.');

    t_bios_report(0);

    t_bios_stop;

end; { do_disk }


procedure do_printer;
{----------------------------------------------------------------------------
 |  This procedure enables PRT & MSDOS timing, generates some printer       |
 |  activity, and displays a BIOS timer summary.                            |
 |                                                                          |
 |  Globals referenced: none                                                |
 |                                                                          |
 |  Arguments: void                                                         |
 |                                                                          |
 |  Returns  : void                                                         |
 ----------------------------------------------------------------------------}
var
    indx : integer;
    atom : char;

begin

    write('Make sure printer is online and ready.  Press any key to continue >> ');
    atom := readkey;

    t_bios_start(PRT+DOS21);

    for indx := 1 to 10 do writeln(lst,'Ryle Design ... Purveyors of Big Science');

    t_bios_report(0);

    t_bios_stop;

end; { do_printer }


begin

    directvideo := FALSE;      { force this so video goes through the BIOS }

    t_start;
    t_entry(1);

    writeln('TestBios   TPHRT V3 Demonstration Series');
    writeln;
    writeln('Make sure the files 10.INT, 13.INT, 17.INT, and 21.INT are in this directory.');
    writeln;

    repeat

        writeln('0 ... Profile BIOS interrupt 10h (CRT) ');
        writeln('1 ... Profile BIOS interrupt 13h (Disk)');
        writeln('2 ... Profile BIOS interrupt 17h (Printer)');
        writeln('3 ... Exit');
        write('Select 0-3 >> ');
        readln(atom);

        case atom of
          0 : do_crt;
          1 : do_disk;
          2 : do_printer;
        end;

    until (atom = 3);

    t_exit(1);
    t_ask_timer(1,hits,rt);
    t_stop;

    writeln('TestBios complete.  Elapsed time: ',t_cvt_time(rt,ts));

end. { testbios }
