
; *******************************************************
; *                                                     *
; *     Turbo Pascal Runtime Library Version 6.0        *
; *     Real Frac Function                              *
; *                                                     *
; *     Copyright (C) 1989-1992 Norbert Juffa           *
; *                                                     *
; *******************************************************

             TITLE   F48FFRC


CODE         SEGMENT BYTE PUBLIC

             ASSUME  CS:CODE

; Publics

             PUBLIC  RFrac,RealFrac

;-------------------------------------------------------------------------------
; RFrac represents the standard function Frac. It computes the fractional part
; of a TURBO Pascal six byte floating point number. This routine is realized as
; a selfcontained routine rather than as a combination of the RInt and RealSub
; routines.
;
; INPUT:     DX:BX:AX  floating point number
;
; OUTPUT:    DX:BX:AX  fractional part of floating point number
;
; DESTROYS:  AX,BX,CX,DX,Flags
;-------------------------------------------------------------------------------

RFrac        PROC    FAR
RealFrac:    CMP     AL, 80h           ; is number < 1 ?
             JBE     $unchanged        ; yes, that is the result
             CMP     AL, 0A8h          ; is number > 2^39 ?
             JA      $frac_zero        ; yes, no fractional part
             MOV     CH, 7Fh           ; generate mask for sign bit
             OR      CH, DH            ; get sign bit
             PUSH    CX                ; save sign mask
             JMP     $shift_start      ; start left shift
             NOP                       ; filler
$frac_shift8:SUB     AL, 8             ; adjust exponent
             MOV     DH, DL            ; shift
             MOV     DL, BH            ;  mantissa
             MOV     BH, BL            ;   8 bits
             MOV     BL, AH            ;    to the
             XOR     AH, AH            ;     left
$shift_start:CMP     AL, 88h           ; another byte shift possible ?
             JA      $frac_shift8      ; yes, do it

             ALIGN   4

$frac_shift1:DEC     AX                ; adjust exponent
             ADD     AH, AH            ; shift
             ADC     BX, BX            ;  mantissa
             ADC     DX, DX            ;   1 bit to the left
             CMP     AL, 80h           ; another bit shift necessary ?
             JA      $frac_shift1      ; yes, do it
             MOV     CX, DX            ; test if
             OR      CH, AH            ;   resulting
             OR      CX, BX            ;    mantissa is zero
             POP     CX                ; get back sign mask
             JZ      $frac_zero        ; yes, return zero
$frac_norm:  OR      DH, DH            ; mantissa normalized ?
             JS      $frac_exit        ; yes
             ADD     AH, AH            ; shift
             ADC     BX, BX            ;  mantissa
             ADC     DX, DX            ;   1 bit to the left
             DEC     AL                ; adjust exponent
             JNZ     $frac_norm        ; if no underflow, cont. normalization
$frac_zero:  XOR     AX, AX            ; load
             MOV     BX, AX            ;  a
             CWD                       ;   zero
$frac_exit:  AND     DH, CH            ; mask out sign bit if necessary
$unchanged:  RET                       ; done
RFrac        ENDP

             ALIGN   4

CODE         ENDS

             END
