Unit RepPrn;
Interface
Uses Printer,WinTypes,wObjects,winDos;
Type
  hStr = array[0..79] of Char;

  pReportPrinter = ^tReportPrinter;
  tReportPrinter = object(tPrinter)
    Heading1: hStr;
    Heading2: hStr;
    lineCount: Integer;
    maxLines: Integer;
    pageCount: Integer;
    rDateTime: hStr;

    Function setRunTime: Boolean;
    Function setPageNum: Boolean;
    Function setHeading2: Boolean;
    Function printMainHeadings: Boolean;
    Function setDefaults(hText: string): Boolean;
    Function printHeadings: Boolean;
    Function startNewPage: Boolean;
    Function outText(tLine: pChar): Boolean;
    Constructor Init(inst: tHandle;
                     par: pWindowsObject;
                     ml: Integer);
  End;

Implementation
Uses Strings;

CONSTRUCTOR tReportPrinter.Init;
Begin
  tPrinter.Init(inst,par);
  lineCount := 99;
  pageCount := 0;
  maxLines := ml;
  FillChar(heading1, SizeOF(heading1),#32);
  FillChar(heading2, SizeOF(heading2),#32);
  SetRunTime;
End;

Function tReportPrinter.setDefaults(hText: string): Boolean;
Begin
  strPCopy(heading1,hText);
  setHeading2;
End;

Function tReportPrinter.setHeading2: Boolean;
Begin
  strMove(Heading2,rDateTime,strLen(rDateTime));
  strMove(@heading2[68],'PAGE',4);
  setPageNum;
End;

Function tReportPrinter.SetPageNum: Boolean;
var
  pCount: array[0..3] of Char;

Begin
  str(pageCount,pCount);
  strCopy(@heading2[73],pCount);
End;

Function tReportPrinter.printMainHeadings: Boolean;
Begin
  setPageNum;
  printLine(heading1);
  printLine(heading2);
End;

Function tReportPrinter.printHeadings: Boolean;
Begin
  newLine;
  inc(pageCount);
  printMainHeadings;
  newLine;
  newLine;
  lineCount := 5;
End;

Function tReportPrinter.StartNewPage: Boolean;
Begin
  if (pageCount > 0) then begin
    newPage;
    printHeadings;
  End;
End;

Function tReportPrinter.outText(tLine: pChar): Boolean;
Begin
  if (lineCount > maxLines) then
    startNewPage;
  printLine(tLine);
  inc(lineCount);
End;

Function tReportPrinter.SetRunTime: Boolean;
var
  m,d,y,dw: Word;
  temp,tag: string[4];
  tStr: String;

Begin
  tStr := '';
  GetTime(y,m,d,dw);
  if (y > 12) then begin
    y := (y - 12);
    tag := 'pm';
  End else
    tag := 'am';
  str(y,temp);
  if (y < 10) then
    temp := '0' + Temp;
  tStr := tStr + temp + ':';
  str(m,Temp);
  tStr := tStr + temp + ':';
  str(d,temp);
  tStr := tStr + temp + tag + '     ';
  GetDate(y,m,d,dw);
  str(m,Temp);
  if (m < 10) then
    temp := '0' + temp;
  tStr := tStr + temp + '/';
  str(d,Temp);
  if (d < 10) then
    Temp := '0' + temp;
  tStr := tStr + Temp + '/';
  str(y,temp);
  tStr := tStr + temp;
  strPcopy(rDateTime,tStr);
End;
End.