/* -*- Mode: C -*- */
/* ListRecord.cc - ListRecord implementation
 * Created by Robert Heller on Sat Dec  7 00:13:55 1991
 *
 * ------------------------------------------------------------------
 * Home Libarian by Deepwoods Software
 * Common Class library implementation code
 * ------------------------------------------------------------------
 * Modification History:
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 * 
 * 
 * Copyright (c) 1991,1992 by Robert heller (D/B/A Deepwoods Software)
 *        All Rights Reserved
 * 
 */
#ifdef MESSYDOS
#include <listrec.h>
#else
#include <ListRecord.h>
#endif
#include <string.h>

// ListRecord constructor, given a Record
ListRecord::ListRecord(const Record* record)
{
	RawData = *record;		// copy data
	char* str = RawData.buffer;	// get data pointer
	int bytesleft = RawData.size;	// and size
	char* p = str;			// temp pointe
	int bl = bytesleft;		// temp counter

	// find element count
	for (numelts = 0;
		bl > 0 && *p != '\n'; numelts++) {
		int slen = strlen(p)+1;
		p += slen; bl -= slen;
	}
	// allocate vector
	elems = new char* [numelts];
	// fill in pointers
	for (int i = 0; i < numelts; i++) {
		elems[i] = str;
		str += strlen(str)+1;
	}
}

// ListRecord constructor, given a CoreItem
ListRecord::ListRecord(const CoreItem* coreitem)
{
	RawData = coreitem->data;	// copy data
	char* str = RawData.buffer;	// get data pointer
	int bytesleft = RawData.size;	// and size
	char* p = str;			// temp pointe
	int bl = bytesleft;		// temp counter

	// find element count
	for (numelts = 0;
		bl > 0 && *p != '\n'; numelts++) {
		int slen = strlen(p)+1;
		p += slen; bl -= slen;
	}
	// allocate vector
	elems = new char* [numelts];
	// fill in pointers
	for (int i = 0; i < numelts; i++) {
		elems[i] = str;
		str += strlen(str)+1;
	}
}

// ListRecord constructor, given a string vector
ListRecord::ListRecord (int numitems,const char* const inelems[])
{
	CreateRecord(numitems,inelems);
	char* str = RawData.buffer;
	numelts = numitems;			// number of elements
	elems = new char* [numelts];		// allocate a vector
	for (int i = 0; i < numelts; i++) {	// copy vector
		elems[i] = str;
		str += strlen(str)+1;
	}
}

// ListRecord constructor, given a string
ListRecord::ListRecord (const char* element)
{
	const char *lst[1];
	lst[0] = element;
	CreateRecord(1,lst);
	char* str = RawData.buffer;
	numelts = 1;			// number of elements
	elems = new char* [1];		// allocate a vector
	elems[0] = str;
}

ListRecord::ListRecord(const ListRecord& oldrec)
{
	CreateRecord(oldrec.numelts,oldrec.elems);
	char* str = RawData.buffer;
	numelts = oldrec.numelts;
	elems = new char* [numelts];
	for (int i = 0; i < numelts; i++) {	// copy vector
		elems[i] = str;
		str += strlen(str)+1;
	}
}

ListRecord& ListRecord::operator = (const ListRecord& oldrec)
{
	CreateRecord(oldrec.numelts,oldrec.elems);
	char* str = RawData.buffer;
	numelts = oldrec.numelts;
	elems = new char* [numelts];
	for (int i = 0; i < numelts; i++) {	// copy vector
		elems[i] = str;
		str += strlen(str)+1;
	}
	return *this;
}


// create a fresh record, given the string vector
void ListRecord::CreateRecord(int numitems,const char* const inelems[])
{
	int rsize = 2;		// "\n\0"	// size

	int i;
	for (i = 0; i < numitems; i++) {	// compute buffer size
		rsize += strlen(inelems[i])+1;
	}
	char* str = new char[rsize]; char *p = str;	// allocate buffer
	// copy strings into the buffer
	for (i = 0; i < numitems; i++) {
		strcpy(p,inelems[i]);
		p += strlen(p)+1;
	}
	// add terminator
	*p++ = '\n'; *p++ = 0;
	// free up old buffer
	RawData.NewBuffer(0);
	// paste in new buffer
	RawData.size = rsize;
	RawData.buffer = str;
}


void ListRecord::UpdateRecord ()
{
	CreateRecord(numelts,elems);
	char* str = RawData.buffer;
	for (int i = 0; i < numelts; i++) {	// copy vector
		elems[i] = str;
		str += strlen(str)+1;
	}
}

int ListRecord::AddElement(const char* element)
{
	int i;
	for (i = 0; i < numelts; i++)
	{
		if (strcasecmp(element,elems[i]) == 0) return numelts;
	}
	char **newelems = new char *[numelts+1];
	for (i = 0; i < numelts; i++)
	{
		newelems[i] = elems[i];
	}
	newelems[i] = (char*) element;
	CreateRecord(numelts+1,newelems);
	delete newelems;
	char* str = RawData.buffer;
	numelts++;				// number of elements
	elems = new char* [numelts];		// allocate a vector
	for (i = 0; i < numelts; i++) {	// copy vector
		elems[i] = str;
		str += strlen(str)+1;
	}
	return numelts;
}

int ListRecord::RemoveElement(const char* element)
{
	int i;
	for (i = 0; i < numelts; i++)
	{
		if (strcasecmp(element,elems[i]) == 0) break;
	}
	if (i == numelts) return numelts;
	for (;i < (numelts-1); i++)
	{
		elems[i] = elems[i+1];
	}
	elems[numelts-1] = NULL;
	numelts--;
	UpdateRecord();
	return numelts;
}

int ListRecord::RemoveElement(int index)
{
	if (index < 0 || index >= numelts) return numelts;
	int i;
	for (i = index;i < (numelts-1); i++)
	{
		elems[i] = elems[i+1];
	}
	elems[numelts-1] = NULL;
	numelts--;
	UpdateRecord();
	return numelts;
}


