/* Rexx program to install a Puzzler Object on the desktop         */
/* USEAGE:  OS2SETUP      //Reads data directory from pzl.bat      */
/*                        //must be run from destination directory */
/*                                                                 */
/*          OS2SETUP DESTINATION_PATH DATA_PATH                    */

PARSE ARG DESTINATION DATA

/* The print timeout of the object will be set to this value */
printTimeout=20

Call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
Call sysloadfuncs

IF DESTINATION = "" | DATA="" THEN DO
	/* Read in PZL.BAT to find the destination and data directories */
	IF STREAM('pzl.bat','c','open read')<>"READY:" THEN DO
		SAY "Can't open the file pzl.bat"
		say "Run OS2SETUP from the destination directory you specified in install"
		say "Or specify the directories you chose in install:"
		say "   OS2SETUP DESTINATION_DIR DATA_DIR"
		say "Install must be run before running OS2SETUP"
		exit
	END

	DESTINATION=DIRECTORY()

	TEMP=LINEIN('pzl.bat')
	TEMP=LINEIN('pzl.bat')
	TEMP=LINEIN('pzl.bat')
	TEMP=LINEIN('pzl.bat')
	TEMP=LINEIN('pzl.bat')

	DATA=TEMP /* DRIVE */

	TEMP=LINEIN('pzl.bat')
	TEMP=LINEIN('pzl.bat')

	RC=STREAM("PZL.BAT","C","CLOSE")

	PARSE VAR TEMP . PATH
	DATA=DATA || PATH

	IF SUBSTR(DATA,2,1)<> ":" | SUBSTR(DATA,3,1) <> '\' THEN DO
		SAY "The pzl.bat file appears to have been modified."
		say "Unable to determine data directory."
		say "Please run OS2SETUP again and supply the directories"
		say "   OS2SETUP  DESTINATION_DIR  DATA_DIR"
		exit
	END

	IF STREAM(DESTINATION || "\PUZZLER.EXE","C","QUERY EXISTS")="" THEN DO
		SAY "'"DESTINATION || "\PUZZLER.EXE' Does not exist."
		SAY "Run OS2SETUP from the directory you specified as"
		SAY "the destination directory, or specify the directories"
		SAY "on the command line."
		SAY "   OS2SETUP  DESTINATION_DIR  DATA_DIR"
		EXIT
	END
END
ELSE DO
	IF SUBSTR(DATA,2,2) <> ":\" THEN DO
		SAY "Invalid data directory. You must specify a full path."
		EXIT
	END

	IF STREAM(DESTINATION || "\PUZZLER.EXE","C","QUERY EXISTS")="" THEN DO
		SAY "'"DESTINATION || "\PUZZLER.EXE' Does not exist."
		SAY "The destination directory you specified may be incorrect."
		SAY "Or you may not have run install first."
		SAY "USEAGE:   OS2SETUP  DESTINATION_DIR  DATA_DIR"
		EXIT
	END
END

Say "Object will have the following settings:"
SAY "   Path to program  : " DESTINATION || "\PUZZLER.EXE"
SAY "   Working directory: " DATA
SAY "   Print Timeout    : " printTimeout
SAY " "
SAY " "

/* Create the object on the desktop */
Call SysCreateObject 'WPProgram','Puzzler','<WP_DESKTOP>','ICONFILE='||destination||'\puzzler.ico;EXENAME='||destination||'\PUZZLER.EXE;PROGTYPE=VDM;STARTUPDIR='||data||';SET DPMI_MEMORY_LIMIT=0;SET EMS_MEMORY_LIMIT=0;SET XMS_MEMORY_LIMIT=0;SET PRINT_TIMEOUT='printTimeout';SET IDLE_SENSITIVITY=50;','F'

IF RESULT=1 THEN
	SAY "The Puzzler object was successfully created."
ELSE
	SAY "The Puzzler object was not created. Perhaps it already exists."
