'File: STANDARD.MCR

'This is a sample WaverlyStreet Easy Money 1.2 macro file.
'These files are plain ASCII text files which can be created with the DOS
'EDIT program, or other text editors.

'Macro files are used to automate the input of recurring transactions - all
'those various deductions from your payroll check being a fine example.
'Instead of having to input single entries for federal tax, state tax,
'social security, etc. every payday, create a macro file that does it for
'you.

'The following rules apply to EZM .MCR files:

'Blank lines, and lines which begin with " ' " are ignored.

'Macro files must be pure ASCII text files - formatted files from word
'processors won't work (although most word processors have an option to
'save a file as "DOS text" or "ASCII text", either of which WILL work).

'Macro format:

'Since we are dealing with recurring transactions, the only unknown is the
'date. When you run a macro file, the only information you must supply is
'the macro file name and the date. The remainder of the information is
'written into the macro file, and used over and over.

'A single macro file may contain as many entries as you wish. There are
'three items that you must include in the macro file for each entry:

'1) the two-character category code
'2) the amount of the transaction
'3) the note

'These items must be specified one after the other, each on a single line.

'In the example immediately below, pretend that the beginning " ' " and
'everything after and including " <- " does not exist.


'tx <- category code being used for tax
'-100.00 <- the usual dollar amount for this (note minus sign)
'payroll deduction - federal IC tax <- a note about it


'Note: unlike making single entries in the program, in a macro file the
'amount, if negative (an expense) must have a preceeding "-" (minus sign).
'Positive amounts (money in) do not require anything special.

'Each set of three sequential lines in the macro file which are not either
'blank or begining with " ' " will be read into the current data file as
'an entry.

'Errors will happen if the macro file is not properly written.

'The following 12 lines comprise a "real" sample macro which will write
'four separate entries to the current data file (blanks don't count):

wa
1000
regular paycheck

tx
-100.00
payroll deduction - federal IC tax

tx
-30.00
payroll deduction - state IC tax

tx
-25.00
payroll deduction - city IC tax

'(Note: the records above will be "orphans" unless you happen to have
'categories with codes "wa" & "tx")

'You may create as many macro files as you wish, and each one may contain
'as many entries as you wish. Macro filenames must end in the extention .mcr

'The filename "standard.mcr" is hard-wired into the program as the default
'macro name. To avoid having to type a filename, edit this particular file
'to be your standard macro (change/add to those 12 lines above).
