{
NNRNEWS.PAS ver. 2.00 - July 7, 1994. Programmed in Turbo Pascal 6.0 by

  Henrik Rosen  (*)
--
| Henrik Rosen, MSc.         |    Tel: + 45 35 36 52 76    | East or West, |
| Nrrebrogade 49C, 1.tv.     |    FAX: + 45 35 26 25 93    | Cyberspace is |
| 2200 Copenhagen N - DENMARK | e-mail: hero@login.dkuug.dk | best   - HeRo |

NNRNEWS.PAS Copyright (c) 1994 Henrik Rosen.

License conditions:
This program is freeware and distributed as a TP 6.0 source file.
I do not take any responsibility for the consequences of compiling or
running the program. Alteration and redistribution is allowed, as long
as the file is only altered below the following line.
--------------------------------------------------------------------------

  NNRNEWS converts files saved by nn into rnews-batches (according
  to RFC-1036 section 4.3), by inserting the '#! rnews <x>'-line before
  the headers of all the postings in the file. When saved by nn, the
  messages are simply separated by an empty line. It has been tested,
  that Yarn v0.65 can import these rnews-batches. NNRNEWS can also
  create a list of newsgroups necessary so that no article in the rnews-
  batches go to 'junk'. In this situation the program can use the active
  file for the news system, to check if the articles are posted to an
  existing newsgroup.

  The program requires access to FLIP.EXE, to work!
  (FTP or download FLIP from somewhere, for instance as
   textutil/flip1exe.zip at SimTel mirrors.)

  The nnrnews command:

      nnrnews [-s<search string>] [-d<directory>] [-nl[<newsgroup-list>]]
              [-a<active-file>] [-nc]

        []             Parameters in [] are optional.

        search string  The files to be processed ex. *.doc.
                       Default is *.*
                       (At least on DR DOS 6.0 *.* does not work!)

        directory      The directory to be searched for files to convert.
                       Default is current directory on default drive.

        -nl            Create a text file with the names of all the
                       newsgroups that need to be created in order to
                       insure that all acticles in the rnews-batches fall
                       into at least one newsgroup (so that no article
                       goes to 'junk'). Each line contains one newsgroup
                       name, with one <space> character in front of it.
                       (The lines are terminated by <cr><lf>.)
                       Nnrnews can even process files already containing
                       rnews-batches, to create the list of unknown
                       newsgroups, if this option is applied.            

        newsgroup-list Name (and path) of the text file for new newsgroups.
                       Default is 'newgroup.uvy' in current directory.

        active-file    Only applied i conjunction with '-nl' option.
                       The name (and path) of the active file for the news
                       system into which the rnews-batches will be injected.
                       If this option is applied, the program checks if at
                       least one of the newsgroups to which an article is
                       posted, is in the active-file.

        '-nc'          No confirm. Eliminates the question:
                       'The file(s) <search string> in directory <directory>
                       will be converted into rnews-batches. Is this okay ?
                       (y/n) ' Especially for use in batch processes.

When compiled in TP 6.0, this program cuts down lines to 255 characters.
Some header lines (especially Path: and Xref:, but also Newsgroups:) are
longer than 255 characters, and are damaged.
Lines that where cut, are copied to the file 'cutlines.uvy', for manual
evaluation of the damage.
Anybody with TP 7.0 are encouraged to compile a version of the program,
that does not cut any lines.

  All <space>-characters in the end of any line is removed in the process
  of creating rnews-batches.
  This feature is an integrated part of the whole algorithm.
  The program allows the file to start with whatever before the first
  news-message, and moves that to 'crapfile.uvy'.

  The program detects the starting of a new message by the following
  criteria:
  After an empty line, all the required headers (according to RFC-1036)
  are found among the headers before the next empty line (or max. 50 lines).
  The required headers are:
  "From:", "Date:", "Newsgroups:", "Subject:", "Message-ID:" and "Path:".

  This algorithm is nearly 100% sure of detecting the start of a message,
  but:
  1. If a message contains a forwarded message, the forwarded message will
     be regarded as a new message, if the 6 required headers are unchanged
     and there is an empty line just before these headers.
  2. If the first header is very wierd and therefore unknown (see the
     is_header-function), the program will not regard it as the start of
     a new message.
  3. If the block of headers contains an empty line before the 6 required
     headers have been found, the program will not regard it as the start
     of a new message.

  The program assumes that the active file is a textfile with the newsgroup
  names in the start of each line.

  The program can _probably_ handle up to 8000 messages in one file,
  depending on allocated heap and the number of newsgroups in the active
  file and the list of new newsgroups (if '-nl' option used).
  The size of files only depend on the diskspace for the temporary copy.
  The program uses 3 passes:
  1. It finds the starting points of messages, places '#! rnews' and
     counts the size of the messages in bytes. These numbers are placed
     in a list chained with pointers.
  2. The numbers in the list are placed in the '#! rnews'-lines.
  3. If the '-nl' option is applied: For every article the program checks
     if any of the newsgroups in the Newsgroups:-header is in the active
     file (if active file specified). If not, the first newsgroup in the
     Newsgroups:-header is appended to the list of new newsgroups.
  Well, there are actually 2 more passes (calling FLIP.EXE):
  Before, all the files are converted to DOS-ASCII, by inserting <Carriage
  Return> at newline (for Turbo Pascal to be able to handle them as text
  files), and in the end they are converted (back) to UNIX-text-format,
  by removing the <Carriage Return>s at all newlines, to create a real
  rnews-batch.

(*) (The reason why Danish letters can be used in Turbo Pascal source code,
     is that from the begining as COMPAS Pascal in 1982 (or earlier?), and
     until now, TP has been developed by a Dane, Anders Hejlsberg.
     He programmed the Pascal-compiler in Z80-assembler in his spare time
     while studying Bachelor in Computer Science. I believe that he invented
     the idea of an integrated, interactive program-development environment,
     know called IDE, thereby making the big, clumsy, and time-consuming
     error-recovery procedures obsulete in the compiler.)
}

program nnrnews;
{$I-}
{$M 16384,0,65535 }

uses    dos,crt;

const
  max_headers=50;

type
  int_point   = ^longint_rec;
  longint_rec = record
                  count: longint;
                  next: int_point;
                end;
  group_point = ^group_rec;
  group_rec   = record
                  group: string;
                  next: group_point;
                end;

var
  newsgroup_set               : set of char;
  first_pointer, last_pointer, temp_pointer
                              : int_point;
  fpoint_nye, lpoint_nye, fpoint_active, lpoint_active, temp_point
                              : group_point;
  empty_line, empty_oldline, is_from, is_date, is_newsg, is_subj, is_mess,
    is_path, all_headers, is_a_header, is_newsfile, confirm, nl_option
                              : boolean;
  infil, udfil, crapfile, cutlinefile
                              : text;
  l, i, str_count             : integer;
  message_counter             : longint;
  streng, streng2, streng3, err_str, active_file, newgroups_file
                              : string;
  str_arr                     : array[1..max_headers] of string;
  dirinfo                     : searchrec;
  ch                          : char;

procedure required_heads(streng:string);
begin
  { The required headers:  "From:", "Date:", "Newsgroups:", "Subject:",
                           "Message-ID:" and "Path:" }
  if copy(streng,1,5)='Path:'        then is_path:=true else
    if copy(streng,1,11)='Newsgroups:' then is_newsg:=true else
      if copy(streng,1,5)='From:'        then is_from:=true else
        if copy(streng,1,5)='Date:'        then is_date:=true else
          if copy(streng,1,8)='Subject:'     then is_subj:=true else
            if copy(streng,1,10)='Message-ID'  then is_mess:=true else
              if copy(streng,1,10)='Message-id'  then is_mess:=true;
end;

function is_header(streng:string): boolean;
var is_head : boolean;
{ I believe this function is quite time-optimal! }
begin
  if streng='' then  is_head:=false  else
    if copy(streng,1,1)='-' then  is_head:=false  else
      if copy(streng,1,1)=' ' then  is_head:=false  else
        { The required headers:  "From:", "Date:", "Newsgroups:",
          "Subject:", "Message-ID:" and "Path:" }
        if copy(streng,1,5)='Path:' then
          begin is_head:=true; is_path:=true end else
          if copy(streng,1,11)='Newsgroups:' then
            begin is_head:=true; is_newsg:=true end else
            begin
            is_head:=false;
            if copy(streng,1,5)  = 'From:'       then
              begin is_head:=true; is_from:=true end;
            if copy(streng,1,5)  = 'Date:'       then
              begin is_head:=true; is_date:=true end;
            if copy(streng,1,8)  = 'Subject:'    then
              begin is_head:=true; is_subj:=true end;
            if copy(streng,1,10) = 'Message-ID'  then
              begin is_head:=true; is_mess:=true end;
            if copy(streng,1,10) = 'Message-id'  then
              begin is_head:=true; is_mess:=true end;
            if copy(streng,1,5)  = 'Xref:'          then is_head:=true;
            if copy(streng,1,8)  = 'Expires:'       then is_head:=true;
            if copy(streng,1,8)  = 'Control:'       then is_head:=true;
            if copy(streng,1,13) = 'Distribution:'  then is_head:=true;
            if copy(streng,1,9)  = 'Keywords:'      then is_head:=true;
            if copy(streng,1,8)  = 'Summary:'       then is_head:=true;
            if copy(streng,1,9)  = 'Approved:'      then is_head:=true;
            if copy(streng,1,9)  = 'Comments:'      then is_head:=true;
            if copy(streng,1,6)  = 'Lines:'         then is_head:=true;
            if copy(streng,1,13) = 'MIME-Version:'  then is_head:=true;
            if copy(streng,1,13) = 'MIME-version:'  then is_head:=true;
            if copy(streng,1,13) = 'Mime-Version:'  then is_head:=true;
            if copy(streng,1,13) = 'Mime-version:'  then is_head:=true;
            if copy(streng,1,5)  = 'NNTP-'          then is_head:=true;
            if copy(streng,1,5)  = 'Nntp-'          then is_head:=true;
            if copy(streng,1,8)  = 'Content-'       then is_head:=true;
            if copy(streng,1,2)  = 'X-'             then is_head:=true;
            if copy(streng,1,12) = 'In-reply-to:'   then is_head:=true;
            if copy(streng,1,12) = 'In-Reply-To:'   then is_head:=true;
            if copy(streng,1,13) = 'Organization:'  then is_head:=true;
            if copy(streng,1,11) = 'References:'    then is_head:=true;
            if copy(streng,1,9)  = 'Followup-'      then is_head:=true;
            if copy(streng,1,6)  = 'Reply-'         then is_head:=true;
            if copy(streng,1,7)  = 'Return-'        then is_head:=true;
            if copy(streng,1,7)  = 'Errors-'        then is_head:=true;
            if copy(streng,1,7)  = 'Sender:'        then is_head:=true;
            end;
  is_header:=is_head
end;

procedure err_stop(text: string);
begin
  writeln(text);
  Write('Press any key');
  Ch:=ReadKey;
  halt
end;

procedure process_possible_newsfile;
begin
          is_newsfile:=false;
          while not eof(infil) do begin
            { The possible start of a new message has been detected: }
            is_from:=false; is_date:=false; is_newsg:=false;
            is_subj:=false; is_mess:=false; is_path:=false;
            all_headers:=false;
            l:=length(streng);
            while (streng[l]=' ') and (l>0) do begin
              delete(streng,l,1);
              dec(l); { l:=l-1; }
            end;
            str_count:=1; str_arr[1]:=streng;
            required_heads(streng);
            while not eof(infil) and (str_count<50) and not all_headers
              and (streng<>'') do
            begin
              readln(infil,streng);
              l:=length(streng);
              if l=255 then writeln(cutlinefile,streng);
              while (streng[l]=' ') and (l>0) do begin
                delete(streng,l,1);
                dec(l); { l:=l-1; }
              end;
              inc(str_count);
              str_arr[str_count]:=streng;
              required_heads(streng);
              all_headers:=(is_from and is_date and is_newsg and
                            is_subj and is_mess and is_path)
            end;
            if streng='' then empty_line:=true else empty_line:=false;
            if all_headers then begin
              is_newsfile:=true;
              writeln(udfil,'#! rnews');
              if message_counter>0 then begin
                last_pointer^.count:=message_counter;
                new(last_pointer^.next);
                last_pointer:=last_pointer^.next;
                last_pointer^.next:=nil;
                message_counter:=0;
              end;
            end;
            for i:=1 to str_count do begin
              writeln(udfil,str_arr[i]);
              message_counter:=message_counter+length(str_arr[i])+1;
            end;
            { No matter whether a new message started or not, we can now copy
              from infil to udfil, counting bytes, until detecting an empty
              line followed by a header line. }
            empty_oldline:=false; is_a_header:=false;
            while not eof(infil) and not (empty_oldline and is_a_header) do
            begin
              readln(infil,streng);
              l:=length(streng);
              if l=255 then writeln(cutlinefile,streng);
              while (streng[l]=' ') and (l>0) do begin
                delete(streng,l,1);
                dec(l); { l:=l-1; }
              end;
              empty_oldline:=empty_line;
              if streng='' then empty_line:=true else empty_line:=false;
              { There is no reason for searching for headers inside a
                paragraph, neither when we are still in the header-block
                of current message: }
              if empty_oldline<>empty_line then
                is_a_header:=is_header(streng)
              else
                is_a_header:=false;
              if not is_a_header then begin
                writeln(udfil,streng);
                message_counter:=message_counter+length(streng)+1
              end;
            end;
          end; { end-while not eof(infil) }
          close(infil);
          close(udfil);
          if is_newsfile then
          begin
            last_pointer^.count:=message_counter;
            reset(udfil);
            rewrite(infil);
            while not eof(udfil) do begin
              readln(udfil,streng);
              if streng='#! rnews' then begin
                if first_pointer=nil then
                  err_stop('Program error: Unexpected end of integer pointer-list!');
                str(first_pointer^.count,streng2);
                streng:=streng+' '+streng2;
                temp_pointer:=first_pointer^.next;
                dispose(first_pointer);
                first_pointer:=temp_pointer;
              end;
              writeln(infil,streng);
            end;
            if first_pointer<>nil then
              err_stop('Program error: Too many integers in pointer-list!');
          end; { end_if: testing is_newsfile }
end;

procedure load_str_arr(var str_count: integer);
var empty  : boolean;
    len, i : integer;
    streng : string;
begin
  str_count:=0;
  repeat
    readln(infil,streng);
    inc(str_count);
    str_arr[str_count]:=streng;
    empty:=true;
    if streng<>'' then begin
      len:=length(streng);
      for i:=1 to len do
        if (streng[i]<>' ') and (streng[i]<>chr(9)) then
          begin empty:=false; i:=len end;
    end;
  until empty or eof(infil) or (str_count=max_headers);
  if empty then
    dec(str_count)
  else
  begin
    if str_count=max_headers then begin
      writeln('Warning: Not enough space in str_arr[] for the whole message-header');
      writeln('         in ',dirinfo.name,'. Newsgroups:-line or Followup-To:-line');
      writeln('         maybe lost.');
    end;
    if eof(infil) then begin
      err_str:=concat('Unexpected End-Of-File in ',dirinfo.name,'. Program aborts!');
      err_stop(err_str);
    end;
  end;
end;

procedure pass_line(newsstr: string; var ant_grops: integer;
                    var found_grp: boolean; var fst_grop: string);
var  i, len  : integer;
     cur_grp : string;
begin
  ant_grops:=0;
  found_grp:=false;
  fst_grop:='';
  i:=0;
  len:=length(newsstr);
  while not found_grp and (i<len) do begin
    repeat
      inc(i);
    until (newsstr[i] in newsgroup_set) or (i=len);
    cur_grp:='';
    while (i<=len) and (newsstr[i] in newsgroup_set) do begin
      cur_grp:=concat(cur_grp,newsstr[i]);
      inc(i);
    end;
    if fst_grop='' then fst_grop:=cur_grp;
    inc(ant_grops);
    temp_point:=fpoint_nye;
    while not found_grp and (temp_point^.next<>nil) do begin
      if temp_point^.group=cur_grp then found_grp:=true;
      temp_point:=temp_point^.next;
    end;
    temp_point:=fpoint_active;
    while not found_grp and (temp_point^.next<>nil) do begin
      if temp_point^.group=cur_grp then found_grp:=true;
      temp_point:=temp_point^.next;
    end;
  end;
end;

procedure pass_article;
var
  len, str_count, i, ant_groups, count_groups  : integer;
  streng, streng2, fst_group : string;
  found_gr : boolean;
begin
  load_str_arr(str_count);
{  load_followups; }

  i:=0;
  repeat
    inc(i);
  until (copy(str_arr[i],1,11)='Newsgroups:') or (i=str_count);
  if not (copy(str_arr[i],1,11)='Newsgroups:') then begin
    err_str:=concat('Newsgroups:-line not found in message-header in ',
                    dirinfo.name,'. Program aborts.');
    err_stop(err_str);
  end;
  streng:=copy(str_arr[i],13,length(str_arr[i])-12);
  pass_line(streng,ant_groups,found_gr,fst_group);
  count_groups:=ant_groups;
  if not found_gr then begin
    { Search in additional lines (starting with <space> or <tab>) }
    repeat
      inc(i);
      streng:=str_arr[i];
      l:=0;
      len:=length(streng);
      repeat
        inc(l);
      until (l>len) or ((streng[l]<>' ') and (streng[l]<>chr(9)));
      if (l>1) and ((streng[l]<>' ') and (streng[l]<>chr(9))) then begin
        pass_line(copy(streng,l,len-l+1),ant_groups,found_gr,err_str);
        count_groups:=count_groups+ant_groups;
      end;
    until found_gr or ((streng[1]<>' ') and (streng[1]<>chr(9)));
  end;

{ Alternative <space>|<tab> search (which works):
  repeat
    readln(infil,streng);
    inc(str_count);
    str_arr[str_count]:=streng;
    empty:=true;
    if streng<>'' then begin
      len:=length(streng);
      for i:=1 to len do
        if (streng[i]<>' ') and (streng[i]<>chr(9)) then
          begin empty:=false; i:=len end;
    end;
  until empty or eof(infil) or (str_count=max_headers);
}

{ if not found_gr and count_groups>1 and lpoint_temp<>fpoint_temp then begin
    search_followups(fst_group); }
{ If any of the Followup-To:-newsgroups are in the Newsgroups:-line,
  put it in the fst_group-string, and found_gr:=true. This (big) part is
  less important, and therefore not finished. }

  if not found_gr then begin
    { Append fst_group to lpoint_nye^ }
    lpoint_nye^.group:=fst_group;
    new(lpoint_nye^.next);
    lpoint_nye:=lpoint_nye^.next;
    lpoint_nye^.next:=nil;
  end;
end;

{ main program }
begin
{ These are the legal characters of newsgroup names, according to a draft
  of the new NetNews RFC (son-of-RFC1036), written by Henry Spencer and
  received by me July 4, 1994: }
  newsgroup_set:=['a'..'z','A'..'Z','0'..'9','+','-','_','/','=','?','.'];

  writeln;
  writeln('The program can be terminated by Ctrl-Break.');
  writeln;
  streng3:='';        { Used by -s  }
  streng:='';         { Used by -d  }
  active_file:='';    { Used by -a  }
  newgroups_file:=''; { Used by -nl }
  nl_option:=false;   {  -   -   -  }
  confirm:=true;      { Used by -nc }
  if paramcount>5 then err_stop('Too many parameters. Program aborts.');
  for i:=1 to paramcount do
    if copy(paramstr(i),1,2)='-s' then
      streng3:=copy(paramstr(i),3,length(paramstr(i))-2)
    else
      if copy(paramstr(i),1,2)='-d' then begin
        chdir(copy(paramstr(i),3,length(paramstr(i))-2));
        getdir(0,streng) end
      else
        if copy(paramstr(i),1,2)='-a' then
          active_file:=copy(paramstr(i),3,length(paramstr(i))-2)
        else
          if paramstr(i)='-nc' then
            confirm:=false
          else
            if copy(paramstr(i),1,3)='-nl' then begin
              newgroups_file:=copy(paramstr(i),4,length(paramstr(i))-3);
              nl_option:=true end
            else
              err_stop('Unrecognized parameter. Program aborts.');

  if streng3='' then streng3:='*.*';
  if streng='' then getdir(0,streng);
  if (not (active_file='')) and (not nl_option) then
    err_stop('<active-file> given without giving <newsgroups-list>. Program aborts.');
  if nl_option then begin
    new(fpoint_nye);
    lpoint_nye:=fpoint_nye;
    fpoint_nye^.group:='';
    fpoint_nye^.next:=nil;
    if newgroups_file='' then newgroups_file:='newgroup.uvy';
    new(fpoint_active);
    lpoint_active:=fpoint_active;
    fpoint_active^.group:='';
    fpoint_active^.next:=nil;
    if not(active_file='') then begin
      streng2 := Fsearch(active_file,getenv('PATH'));
      if streng2='' then begin
        err_str:=concat(active_file,' can not be found. Program aborts.');
        err_stop(err_str);
      end;
      active_file:=Fexpand(streng2);
      assign(infil,active_file);
      reset(infil);
      while not eof(infil) do begin
        read(infil,ch);
        streng2:='';
        while not (ch in newsgroup_set) do read(infil,ch);
        while (ch in newsgroup_set) do begin
          streng2:=concat(streng2,ch);
          read(infil,ch)
        end;
        if streng2<>'' then begin
          lpoint_active^.group:=streng2;
          new(lpoint_active^.next);
          lpoint_active:=lpoint_active^.next;
          lpoint_active^.next:=nil;
        end;
        while (ch<>chr(10)) and not eof(infil) do read(infil,ch);
      end;
      close(infil)
    end;
  end;

  if confirm then begin
    writeln('The file(s) ',streng3,' in directory ',streng);
    write('will be converted into rnews-batches. Is this okay ? (y/n) ');
    readln(streng2);
    if (copy(streng2,1,1)<>'y') and (copy(streng2,1,1)<>'Y') then halt;
  end;

  FindFirst(streng3, $3F, DirInfo);
  if (Doserror=0) and (dirinfo.name<>'.') then
    begin
      WriteLn('Temporary insertion of <Carriage Return>s at newline in all file(s).');
      streng := Fexpand(Fsearch('FLIP.EXE',getenv('PATH')));
      streng2:=' -mb '+streng3;
      swapvectors;
      exec(streng,streng2);
      swapvectors;
      if doserror<>0 then err_stop('FLIP.EXE could not be executed. Program aborts.');
    end
  else
    begin
      err_str:=concat('The directory does not contain any files matching ',streng3);
      err_stop(err_str);
    end;
  assign(crapfile,'crapfile.uvy');
  rewrite(crapfile);
  assign(cutlinefile,'cutlines.uvy');
  rewrite(cutlinefile);
  assign(udfil,'temp.fil');
  rewrite(udfil);
  close(udfil);
  FindFirst(streng3, $3F, DirInfo);
  { Processing one file at a time: }
  while (Doserror=0) and (dirinfo.name<>'.') do begin
    Write('Processing ',DirInfo.Name,'. ');
    if dirinfo.size+6000>diskfree(0) then
      writeln('There is probably not enough diskspace. The file will not be processed.')
    else begin
      assign(infil,dirinfo.name);
      reset(infil);
      readln(infil,streng);
      if copy(streng,1,9)='#! rnews ' then
        write('Is rnews-batch, no convert. ')
      else
        begin
        assign(udfil,'temp.fil');
        rewrite(udfil);
        new(first_pointer);
        last_pointer:=first_pointer;
        first_pointer^.count:=0;
        first_pointer^.next:=nil;
        writeln(crapfile,'');
        writeln(crapfile,'------------------- start of crap from ',dirinfo.name,' ------------------');
        writeln(crapfile,'');
        writeln(cutlinefile,'');
        writeln(cutlinefile,'----------- start of lines cut to 255 characters from ',dirinfo.name,' ----------');
        writeln(cutlinefile,'');
        while not eof(infil) and not is_header(streng) do
          begin writeln(crapfile,streng); readln(infil,streng) end;
        message_counter:=0;
        if eof(infil) then
          begin
            writeln(crapfile,streng);
            writeln('The file does not seem to contain any USENET-news messages.')
          end
        else

          process_possible_newsfile;

        close(udfil)
      end; { end-if: testing if first line in file is '#! rnews ' }
      close(infil);
      if nl_option then begin
        write('Processing newsgroup list.');
        reset(infil);
        while not eof(infil) do begin
          repeat
            readln(infil,streng);
          until (copy(streng,1,8)='#! rnews') or eof(infil);

          if copy(streng,1,8)='#! rnews' then pass_article

        end;
        close(infil);
      end;
    end; { end-if: testing necessary free disk space }
    writeln;
    findnext(dirinfo);
  end; { end-while: doserror = 0 }
  close(crapfile);
  close(cutlinefile);
  WriteLn('Deleting <Carriage Return>s at newline in all file(s).');
  streng := Fexpand(Fsearch('FLIP.EXE',getenv('PATH')));
  streng2:=' -ub '+streng3;
  swapvectors;
  exec(streng,streng2);
  swapvectors;
  streng2:='/C del temp.fil';
  SwapVectors;
  Exec(GetEnv('COMSPEC'), streng2);
  SwapVectors;
  if DosError <> 0 then
    WriteLn('Could not execute COMMAND.COM - temp.fil not deleted.');
  if nl_option then begin
    assign(udfil,newgroups_file);
    rewrite(udfil);
    temp_point:=fpoint_nye;
    while temp_point^.next<>nil do begin
      streng:=concat(' ',temp_point^.group);
      temp_point:=temp_point^.next;
      writeln(udfil,streng);
    end;
    close(udfil);
  end;
end.

{
procedure load_followups;
begin
  i:=0
  repeat
    inc(i);
  until copy(str_arr[i],1,9)='Followup-' or i=str_count;
  new(fpoint_temp);
  lpoint_temp:=fpoint_temp;
  fpoint_temp^.group:='';
  fpoint_temp^.next:=nil;
  if copy(str_arr[i],1,12)='Followup-To:' or
     copy(str_arr[i],1,12)='Followup-to:' then
    begin
    streng:=copy(str_arr[i],14,length(str_arr[i])-13);
    len:=length(streng);  i:=1;
    while i=<len do begin
      streng2:='';
      while (streng[i] in newsgroup_set) do begin
        streng2:=concat(streng2,streng[i]); inc(i);
      end;
      lpoint_temp^.group:=streng2;
      new(lpoint_temp^.next);
      lpoint_temp:=lpoint_temp^.next;
      lpoint_temp^.next:=nil;
      while not ((streng[i] in newsgroup_set) or (i>len)) do inc(i);
    end;
  end;
end;

procedure dispose_followups;
begin
  while fpoint_temp<>nil do begin
    temp_point:=fpoint_temp^.next;
    dispose(fpoint_temp);
    fpoint_temp:=temp_point
  end;
end;

procedure  search_followups(fst_group);

var streng, streng2, streng3

    i:=0
    repeat
      inc(i);
    until copy(str_arr[i],1,11)='Newsgroups:';
    streng:=copy(str_arr[i],13,length(str_arr[i])-12);
    len:=length(streng);
    l:=1;
    while l=<len and not found_gr do begin
      streng2:='';
      while (l=<len) and (streng[l] in newsgroup_set) do begin
        streng2:=concat(streng2,streng[l]); inc(l);
      end;
      temp_point:=fpoint_temp;
      repeat
        streng3:=temp_point^.group;
        temp_point:=temp_point^.next;
      until streng2=streng3 or temp_point^.next=nil;
      if streng2=streng3 then found_gr:=true;
      while (l=<len) and not (streng[l] in newsgroup_set) do inc(l);
    end;
    if not found_gr then begin
      repeat
        inc(i);
        streng:=str_arr[i];
        l:=0;
        len:=length(streng);
        repeat
          inc(l);
        until l>len or (streng[l]<>' ' and streng[l]<>chr(9));
        if l>1 and streng[l]<>' ' and streng[l]<>chr(9) then begin
          streng1:=copy(streng,l,len-l+1);
          len:=length(streng1);
          l:=1;
          while l=<len and not found_gr do begin
            streng2:='';
            while (l=<len) and (streng1[l] in newsgroup_set) do begin
              streng2:=concat(streng2,streng1[l]); inc(l);
            end;
            temp_point:=fpoint_temp;
            repeat
              streng3:=temp_point^.group;
              temp_point:=temp_point^.next;
            until streng2=streng3 or temp_point^.next=nil;
            if streng2=streng3 then begin
              found_gr:=true;
              fst_group:=streng2
            end;
            while (l=<len) and not (streng1[l] in newsgroup_set) do inc(l);
          end;
        end;
      until found_gr or not ((l>1) and (streng[l]<>' ') and (streng[l]<>chr(9)));
    end;
  end;

}
