// Stuff relating to the instrument class

union am_vib_union {
  unsigned char byte;
  struct {
    unsigned frequency_multiple: 4;
    unsigned keyboard_scaling_rate: 1;
    unsigned hold_at_sustain: 1;
    unsigned apply_vibrato: 1;
    unsigned apply_amplitude_modulation: 1;
  } bitmap;
};

union scaling_volume_union {
  unsigned char byte;
  struct {
    unsigned volume: 6;
    unsigned scaling_level: 2;
  } bitmap;
};

union a_d_union {
  unsigned char byte;
  struct {
    unsigned decay: 4;
    unsigned attack: 4;
  } bitmap;
};

union s_r_union {
  unsigned char byte;
  struct {
    unsigned release: 4;
    unsigned sustain: 4;
  } bitmap;
};

union op1mod_feedback_union {
  unsigned char byte;
  struct {
    unsigned additive_synthesis: 1;
    unsigned feedback_strength: 3;
  } bitmap;
};

union wave_union {
  unsigned char byte;
  struct {
    unsigned waveform: 3;
  } bitmap;
};

class instrument {
public:
  enum inst_types {type_synth, type_sample} type;
  unsigned int *sampledata;
  am_vib_union am_vib1, am_vib2;
  scaling_volume_union scaling_volume1, scaling_volume2;
  a_d_union a_d1, a_d2;
  s_r_union s_r1, s_r2;
  op1mod_feedback_union op1mod_feedback;
  wave_union wave1, wave2;
  char *name;

  instrument();
  ~instrument();
};
