
************************* Collect.PRG *******************************
*																	*
* A menu driven general purpose Collection Program written by:		*
* Jim Hoyt 															*
* 345 W Central														*
* Missoula, Mt  59801												*
* (406)549-3847														*
*********************************************************************

* Note: I wrote this program in a very simple "Flat File" format.
* I wrote it this way in order to keep it simple enough that anybody with
* a little experience (or help from a pal with experience) can edit or
* alter it to their satisfaction. 

* SO PLEASE... will any of you EGOMANIAC, GREEDY, HATEFUL
* programmers out there who get their hands on MY creation
* give the owner of it a break - & don't conBOOBrate it so they can't
* work on it themselves - or get some help with it that won't cost em much -
* as much as you are probably over-charging them alredy - ya crook! 
* If ya do - & I catch you - I'm gonna get ya!

* so, with that warning: here we go!

**********************************************************************
**********************************************************************

** PROGRAMS called in Collect.prg:

* Path.prg		&& Called from Collect.prg to set the path for you
				*  Make sure you alter this to fit the location of
				*  the files for this application on your machine!
*****************

** SCREENS called in Collect.prg

* Editscrn.scx
* Getname.scx
* Notfound.scx
*****************

** DATA BASES used in Collect.prg

* Debtor.dbf
* Client.dbf
* Tank.dbf
* Nonpost.dbf
*****************

** Index tags called in Collect.prg

* NAMES     : DB_LAST+DB_FIRST+DB_MI
* TOTALDEBT : DB_LAST+DB_FIRST+DB_MI+CL_TITLE1+DTOC(AC_ACTDATE)
* CLIENT    : CL_TITLE1
* ALLDEBT   : CL_TITLE1+DB_LAST+DB_FIRST+DTOC(AC_ACTDATE)
* DATENAME  : DTOC(DT_PMTDATE)+DB_LAST+DB_FIRST+DB_MI
* DEBTORNUM : DB_DBID
* CLIENTNUM : CL_CLID
* NAMEDBID  : DB_LAST+STR(DB_DBID)
* NOTICE    : DB_LAST+DB_FIRST+DB_MI+STR(CL_CLID)+STR(AC_ACCTNUM)
*****************

** REPORTS called in Collect.prg

* Allclnt.frx		Print list of clients and client info
* Alldebt.frx		Print Debtor list for each client - Called by ALLDEBT.prg
* Checks			Print checks for clients
* Clntdate			Print dbtr list for certain client for certain period
* Stmt.frx			Print Statements for Clients before running checks - Called by Collect.prg
* Totaldbt.frx		Print List of all Debtors - Called by DEBTOR.prg
* Transnon.frx		Print list of NON posted pmts - Called by Collect.prg
* Trans_dn.frx		Print List of posted pmts, index by Date and Name - Called by Collect.prg
* Trans_n.frx		Print List of posted pmts, index by Name - Called by Collect.prg
*****************


** PROCEDURES Called in Collect.prg:


** Main Menu Procedures:

* DEBTOR_MENU			
* CLIENT_MENU
* REPORT_MENU
* PAYMENT_MENU
****************

** Sub Menu Procedures

* PRNT_NON
* POST
* PRNT_POST
* CLOSE_MONTH
* PRINT_CHECK
* CHK_STMT		&& Called from Stmt.frx (UDF)

*****************

** Utility Procedures

* HEADING
* FIND_DEBTOR
* FIND_CLIENT
* DELETE_DEBTOR
* DELETE_CLIENT
* CLNT_FIELDS
* NUMBER_CHECK
******************
 

** PRINTER DRIVERS called in Collect.prg

* _pdsetup = 'pana17'		&& Use 17 cpi printer driver
* _pdsetup = 'pana10'		&& Return to 10 cpi printer driver

*  Be sure to set the printer drivers for your particular Printer.
*  This program is set up for the PANASONIC KX-P2124 Dot Matrix Printer.
*  using both 10 cpi and 17 cpi

** PAPER AND CARD STOCK used in Collect.prg

*  Card stock: Use 8 1/2 X 5 1/2 card stock.  It is 1/2 the length of
*  normal paper & will work well for stapling info papers to & so avoid
*  the need for those crummy manilla file folders.

*  Paper:  Use 8 1/2 X 3 1/2 continuous form for all notices - 
*  except for Legal notices use regular 8 1/2 X 11" paper


*********************************************************************
*********************************************************************
**********************  BEGIN MAIN PROGRAM  *************************

* -----  SET UP ENVIRONMENT 

CLOSE ALL
CLEAR ALL



 DO C:\COLLECT\PROGRAMS\PATH
	


	* This is the only program outside of the collect.prg that is called.
	* Make sure that you have the same directory structure as the path:
	* or else it won't go!
	
	* This is how it is set up:
	
	* c:\collect\database
	*			\programs
	*			\reports
	*			\screens
	*			\text
	

SET SAFETY ON
SET CLOCK ON	    &&  put clock in header
SET TALK OFF		&&  don't echo results of activities to screen
SET BELL OFF
SET SYSMENU OFF

Clear

******************************  MAIN MENU  *******************************

USE debtor  ORDER names

DO WHILE .T.

	choice = " "

	Do HEADING with "Main Menu"		&& Display main menu & get users choice

		@  6,25 SAY "D - Debtors"
		@ 08,25 SAY "C - Clients"
		@ 10,25 SAY "R - Reports"
		@ 12,25 SAY "P - Payments and Checks"
		@ 15,25 SAY "Q - Quit collect"

		@ 20,25 SAY "What is your choice > " GET choice PICT"!"
		
		READ

		DO CASE					

			CASE choice = "D"
				DO Debtor_menu

			CASE choice = "C"
				DO Client_menu
	
			CASE choice = "R"
				DO Report_menu
		
			CASE choice = "P"
				DO Payment_menu

			CASE choice = "Q"
				EXIT
		
			OTHERWISE
				?CHR(7)			&&	Beep!
		ENDCASE
ENDDO

* Close databases and return environment to default settings before exiting.

CLOSE ALL
CLEAR ALL

SET CLOCK OFF      &&  kill clock in header
SET SAFETY ON	   &&  ask b4 overwriting files
SET TALK ON		   &&  echo results of activities to screen
SET DELETED OFF	   &&  don't ignore deleted records
SET BELL ON
SET SYSMENU ON
SET STATUS ON

CLEAR

* QUIT

* Program ends here - rest of file is Procedures & other screens

***********************************************************************
***********************************************************************


Procedure HEADING

* Screen header used by the collect program and by the
* Debtmenu, Clntmenu, Reptmenu, & Pmtmenu Procedures

Parameter MENUNAME

CLEAR

 @ 1,25 SAY "COLLECT !"						&& For finished product

@ 3,25 SAY  menuname
@ 0,0 SAY DATE()

***********************************************************************

Procedure DEBTOR_MENU

* Debtor Submenu for collect -  called by the main menu

DO WHILE .T.

	choice = " "
	
	DO HEADING WITH "Debtor Submenu"

	@  6,25 SAY "A - Add a New Debtor"
	@ 08,25 SAY "E - Edit an Entry"
	@ 10,25 SAY "D - Delete Accounts Marked For Deletion"
	@ 13,25 SAY "R - Return to the Main Menu"

	@ 20,25 SAY "What is your choice > " GET choice PICT"!"
	READ
	
	
	DO CASE		&& 	perform option - or beep if choice was invalid

		CASE choice = "A"

			**** Debtor numbering routine: Gives debtor a new number

			m.number = ""					&& Reset db_dbid variable

			USE DEBTOR  order DEBTORNUM

			go bottom
			m.number = db_dbid +1			&& add new db_dbid to variable
			append blank					&& Append using custom screen
			replace db_dbid with m.number	&& Give new record new db_dbid
			m.number = ""					&& Reset db_dbid variable

			**** End Numbering routine ****			


			**** Begin Append debtor Routine ****

			USE DEBTOR  order NAMES

			SET bell on
			DO editscrn.spr
			DO Client_fields	
 			SET Bell off

		CASE choice = "E"		&& Debtor edit routine

			USE debtor ORDER names

			DO Find_debtor		&& Use Find_debtor to find and edit entry
			IF .NOT. EOF()
				SET BELL ON
				DO editscrn.spr
				DO Client_fields	
				SET BELL OFF
			ENDIF

		CASE choice = "D"		&& Debtor deletion routine
			DO DELETE_DEBTOR

		CASE choice = "R"
			EXIT

		OTHERWISE
			?CHR(7)		&& Beep!

	ENDCASE
ENDDO
RETURN

************************************************************************

Procedure CLIENT_MENU

* Client submenu for Collect - called my main menu

DO WHILE .T.

	choice = " "
	
	DO HEADING WITH "Client Submenu"

	@  6,25 SAY "A - Add a New Client"
	@  8,25 SAY "E - Edit a Client Record"
	@ 10,25 SAY "D - Delete a client"
	@ 13,25 SAY "R - Return to the Main Menu"
	@ 20,25 SAY "What is your choice > " GET choice PICT"!"
	READ
	
	
	DO CASE			&& 	perform option - or beep if choice was invalid

		CASE choice = "A"		&& ADD A NEW CLIENT ROUTINE
			**** Client numbering routine: Gives Client a new number

			m.number = ""					&& Reset cl_clid variable

			USE CLIENT  order CLIENTNUM

			go bottom
			m.number = cl_clid +1			&& add new cl_clid to variable
			append blank					&& Append using custom screen
			replace cl_clid with m.number	&& Give new record new cl_clid
			
			m.number = ""					&& Reset cl_clid variable

			**** End Numbering routine ****			

			**** Begin Append client Routine ****

			USE CLIENT  order CLIENT

			SET bell on
			DO editscrn.spr
			DO Client_fields
 			SET Bell off

		CASE choice = "E"		&& EDIT A CLIENT RECORD

			USE CLIENT  order CLIENT

			DO Find_client		&& Use Find_client to find and edit entry.

			 IF .NOT. EOF()
			 	SET bell on
			 	DO editscrn.spr
			 	DO Client_fields
				SET Bell off
			 ENDIF

		CASE choice = "D"
			DO Delete_client

		CASE choice = "R"
			EXIT

		OTHERWISE
			?CHR(7)
	ENDCASE
ENDDO
RETURN
**********************************************************************

Procedure CLIENT_FIELDS

* This will add the pertainant data to the respective client fields of each
* debtor record.  So, the only entry necessary in clients fields in the 
* debtor database will be the CLIENT # (CL_CLID).

* Set up variables
m.cl_clid = ""
m.cl_title1 = ""
m.cl_add1 = ""
m.cl_city = ""
m.cl_state = ""
m.cl_zip = ""
m.cl_phone = ""
m.cl_contact = ""
m.db_first = ""	

USE Client ORDER Clientnum
go top

	do while .not. EOF()
		store cl_clid to m.cl_clid
		store cl_title1 to m.cl_title1
		store cl_add1 to m.cl_add1
		store cl_city to m.cl_city
		store cl_state to m.cl_state
		store cl_zip to m.cl_zip
		store cl_phone to m.cl_phone
		store cl_contact to m.cl_contact
		replace db_last with '** Acct Info'
		replace db_first with m.cl_title1
		replace dt_code with 'C'	&& This will ensure dt_code always = 'C'
									*  for client dbf

		USE Debtor	ORDER Clientnum

		Go top
			replace all cl_title1 with m.cl_title1 for cl_clid = m.cl_clid
			replace all cl_add1 with m.cl_add1 for cl_clid = m.cl_clid
			replace all cl_city with m.cl_city for cl_clid = m.cl_clid
			replace all cl_state with m.cl_state for cl_clid = m.cl_clid
			replace all cl_zip with m.cl_zip for cl_clid = m.cl_clid
			replace all cl_phone with m.cl_phone for cl_clid = m.cl_clid
			replace all cl_contact with m.cl_contact for cl_clid = m.cl_clid
	
	USE Client ORDER Clientnum

	locate for cl_clid = m.cl_clid
	skip
enddo
return

**********************************************************************

Procedure REPORT_MENU

* Report submenu called by Main Menu

DO WHILE .T.

	choice = " "
	
	DO HEADING WITH "Report Submenu"

	@  5,25 SAY "C - Cards"
	@ 06,25 SAY "1 - First Notice"
	@ 07,25 SAY "2 - Second Notice"
	@ 08,25 SAY "L - Legal letter from Atty"
	@ 09,25 SAY "D - Total Debtors Print out"
    @ 10,25 SAY "I - Debtors for Individual Client and date"
    @ 11,25 SAY "A - Debtor Report for All Clients"
    @ 12,25 SAY "T - Total list of Clients & Client Numbers Print out"
	@ 15,25 SAY "R - Return to Main Menu"
	@ 20,25 SAY "What is your choice > " GET choice PICT"!"

	READ
	
		DO CASE			&& 	perform option - or beep if choice was invalid

		CASE choice = "C"		&& Print 'Cards' for selected records

			CLEAR

			m.num_cards = 0		&& Reset counter for number of cards

			USE debtor	ORDER notice

			COUNT for ac_card to m.num_cards

				IF m.num_cards = 0
					@ 5,5 SAY 'There are none to print'
					WAIT '     Press any key to return to menu'
					RETURN
				ENDIF

			@ 16,5 SAY 'Number of Cards to print.  'GET m.num_cards PICT"99"
			@ 19,5 SAY 'Load Card stock and turn on printer.'

			WAIT '      Press any key To begin printing'

			REPORT FORM card to print for ac_card
			Replace all ac_card with .F.
								
			CLEAR

			@ 5,5 SAY 'Card printing is done.'

			WAIT '     Press any Key To Return To Menu'

			USE debtor ORDER names

			return

		CASE choice = "1"		&& Print #1 Notices for selected records

			CLEAR

			m.countcheck=0	&& Counter for number of 'check' notices to print
			m.countdebt=0	&& Counter for number of 'debt' notices to print

			USE debtor	ORDER names

			COUNT for ac_first .AND. ac_type ='C'  to m.countcheck
			COUNT for ac_first .AND. ac_type ='D'  TO m.countdebt

				IF m.countcheck = 0 .AND. m.countdebt = 0
					@15,5 SAY 'There are none to print'
					WAIT '     Press any key to return to menu'
					RETURN
				ENDIF

			@ 14,5 SAY 'Number of First Notices for Checks to print today. 'GET m.countcheck PICT"99"
			@ 16,5 SAY 'Number of First Notices for Debts to print today.  'GET m.countdebt PICT"99"

			@ 19,5 SAY 'Load First notice paper, align, and turn on printer.'

			WAIT '      Press any key To begin printing'
			
			
				IF m.countcheck > 0
					_pdsetup = 'pana17'		&& Use 17 cpi printer driver
					REPORT FORM #1check to print for ac_first .AND. ac_type = 'C'
					Replace all ac_clstat with 'First notice' for ac_first .AND. ac_type = 'C'
					Replace all ac_first with .F. for ac_first .AND. ac_type = 'C'
					_pdsetup = 'pana10'		&& Return to 10 cpi printer driver
				ENDIF
				
				IF m.countdebt > 0				
					_pdsetup = 'pana17'		&& Use 17 cpi printer driver
					REPORT FORM #1debt to print for ac_first .AND. ac_type = 'D'
					Replace all ac_clstat with 'First notice' for ac_first .AND. ac_type = 'D'
					Replace all ac_first with .F. for ac_first .AND. ac_type = 'D'
					_pdsetup = 'pana10'		&& Return to 10 cpi printer driver	
				ENDIF

			CLEAR

			@ 5,5 SAY '#1 Notices for Checks and Debts are done.'

			WAIT '     Press any Key To Return To Menu'

			USE debtor ORDER names

			return

		CASE choice = "2"		&& Print Second Notice for selected records

			CLEAR

			m.countcheck=0	&& Counter for number of 'check' notices to print
			m.countdebt=0	&& Counter for number of 'debt' notices to print

			USE debtor	ORDER names

			COUNT for ac_second .AND. ac_type ='C'  to m.countcheck
			COUNT for ac_second .AND. ac_type ='D'  TO m.countdebt

				IF m.countcheck = 0 .AND. m.countdebt = 0
					@15,5 SAY 'There are none to print'
					WAIT '     Press any key to return to menu'
					RETURN
				ENDIF

			@ 14,5 SAY 'Number of Second Notices for Checks to print today. 'GET m.countcheck PICT"99"
			@ 16,5 SAY 'Number of Second Notices for Debts to print today.  'GET m.countdebt PICT"99"

			@ 19,5 SAY 'Load Second Notice paper, align, and turn on printer.'

			WAIT '      Press any key To begin printing'
			
			
				IF m.countcheck > 0
					_pdsetup = 'pana17'		&& Use 17 cpi printer driver
					REPORT FORM #2check to print for ac_second .AND. ac_type = 'C'
					Replace all ac_clstat with 'Second notice' for ac_second .AND. ac_type = 'C'
					Replace all ac_second with .F. for ac_second .AND. ac_type = 'C'
					_pdsetup = 'pana10'		&& Return to 10 cpi printer driver
				ENDIF
				
				IF m.countdebt > 0				
					_pdsetup = 'pana17'		&& Use 17 cpi printer driver
					REPORT FORM #2debt to print for ac_second .AND. ac_type = 'D'
					Replace all ac_clstat with 'Second notice' for ac_second .AND. ac_type = 'D'
					Replace all ac_second with .F. for ac_second .AND. ac_type = 'D'
					_pdsetup = 'pana10'		&& Return to 10 cpi printer driver	
				ENDIF

			CLEAR

			@ 5,5 SAY '#2 Notices for Checks and Debts are done.'

			WAIT '     Press any Key To Return To Menu'

			USE debtor ORDER names

			RETURN

		CASE choice = "L"		&& Print Legal Letter for Atty for selected records

			CLEAR

			m.countcheck=0	&& Counter for number of 'check' Atty Letters to print
			m.countdebt=0	&& Counter for number of 'debt' Atty Letters to print

			USE debtor	ORDER namedbid

			COUNT for ac_atty .AND. ac_type ='C'  to m.countcheck
			COUNT for ac_atty .AND. ac_type ='D'  TO m.countdebt

				IF m.countcheck = 0 .AND. m.countdebt = 0
					@15,5 SAY 'There are none to print'
					WAIT '     Press any key to return to menu'
					RETURN
				ENDIF

			@ 14,5 SAY 'Number of Atty Letters for Checks to print today. 'GET m.countcheck PICT"99"
			@ 16,5 SAY 'Number of Atty Letters for Debts to print today.  'GET m.countdebt PICT"99"

			@ 19,5 SAY 'Load Legal paper, align, and turn on printer.'

			WAIT '      Press any key To begin printing'

				IF m.countcheck > 0
					REPORT FORM attychek to print for ac_atty .AND. ac_type = 'C'
					Replace all ac_clstat with 'Sent to Attorney' for ac_atty .AND. ac_type = 'C'
					Replace all ac_atty with .F. for ac_atty .AND. ac_type = 'C'
				ENDIF
				
				IF m.countdebt > 0				
					REPORT FORM attydebt to print for ac_atty .AND. ac_type = 'D'
					Replace all ac_clstat with 'Sent to Attorney' for ac_atty .AND. ac_type = 'D'
					Replace all ac_atty with .F. for ac_atty .AND. ac_type = 'D'
				ENDIF

			CLEAR

			@ 5,5 SAY 'Legal Notices for Checks and Debts are done.'

			WAIT '     Press any Key To Return To Menu'

			USE debtor ORDER names

			return

		CASE choice = "D"		&& Total Debtor print out - index by name
				
				USE debtor	Order totaldebt
				
				report form TOTALDBT all to print
				
				USE debtor  ORDER names
				
				clear
				return

		CASE choice = "I"		&& print debtors for individual Client/date
			clear

			USE debtor ORDER alldebt

			m.client1 = ''		&& Name and reset variables
			m.client2 = ''
			m.date1 = ''
			m.date2 = ''

			Accept 'Enter Client Number  =  ' TO m.client1
			STORE val(m.client1) TO m.client2
			Accept 'Enter beginning date of period (??/??/??) ' TO m.date1
			STORE CTOD(m.date1) TO m.date2

			report form CLNTDATE to print for cl_clid = m.client2 .AND. ac_actdate >= m.date2

			clear memory
			m.client1 = ''		&& Reset variables
			m.client2 = ''
			m.date1 = ''
			m.date2 = ''

			USE debtor 	ORDER names	

		CASE choice = "A"		&& Debtor printout for all clients 

			USE debtor ORDER alldebt

			report form ALLDEBT all to print

			USE debtor ORDER names

		CASE choice = "T"		&& Print list of all clients & client number

			USE client  ORDER client

			Report form ALLCLNT to print

			USE debtor  order NAMES
		
		CASE choice = "R"
			EXIT

		OTHERWISE
			?CHR(7)

	ENDCASE
ENDDO
RETURN
******************************************************************

Procedure PAYMENT_MENU

* Payment & Check Submenu for collect -  called by main menu

DO WHILE .T.

	choice = " "
	
	DO HEADING WITH "Payment and Check Submenu"
		
	@  6,25 SAY "N - Print out Non-Posted payments"
	@  8,25 SAY "P - Post payments"
	@ 10,25 SAY "O - Print out Posted payments"
	@ 12,25 SAY "M - Close Month"
	@ 14,25 SAY "C - Print Client checks"
	@ 17,25 SAY "R - Return to the Main Menu"

	@ 20,25 SAY "What is your choice > " GET choice PICT"!"
	READ
	
	DO CASE				&& 	perform option - or beep if choice was invalid

		CASE choice = "N"
			DO PRINT_NON

		CASE choice = "P"
			DO POST

		CASE choice = "O"
			DO PRINT_POST

		CASE choice = "M"
			DO CLOSE_MONTH

		CASE choice = "C"
			DO PRINT_CHECK

		CASE choice = "R"
			EXIT

		OTHERWISE
			?CHR(7)

	ENDCASE
ENDDO
RETURN

******************************************************************

Procedure PRINT_NON

* Called by Payment_menu Procedure
* Prints out Non_Posted Payments

DO WHILE .T.

	choice = " "
	
	DO HEADING WITH "Print out non posted payments"
	
	@ 7,25 SAY "P - Print"
	@ 9,25 SAY "R - Return to the Main Menu"
	@ 20,25 SAY "What is your choice > " GET choice PICT"!"

	READ
	
	DO CASE		&& 	perform option - or beep if choice was invalid

		CASE choice = "P"

			
			USE nonpost ORDER names	   && Temporary DBF for non-posted accts

			SET safety OFF
			ZAP		&& Kill records in nonpost.dbf B4 appending
			SET safety ON

			Append from debtor for dt_pmtamt > 0.00
			Append from client for dt_dueagcy <> 0.00 .or. dt_dueclnt <> 0.00


			Replace all dt_code with 'B' for dt_code = 'C' .and. dt_dueagcy > 0.00	&& need B's for bal fwd's
			Replace all db_last with '** Balance Fwd' for dt_code = 'B'
			
			Replace all dt_code with 'P' for dt_code = 'C' .and. dt_dueagcy < 0.00	&& need P's for client pmts to agcy
			Replace all db_last with '** Client Pmt' for dt_code = 'P'
			
			Replace all db_last with '** Pmt to Clnt' for dt_code = 'C'
			

			_pdsetup = 'pana17'		&& Use 17 cpi printer driver
			Report form TRANSNON  all to print 
			_pdsetup = 'pana10'		&& Use 10 cpi printer driver

			SET safety ON
			Return
						
		CASE choice = "R"
			EXIT

		OTHERWISE
			?CHR(7)

	ENDCASE
ENDDO
RETURN
*****************************************************************

Procedure POST

* POST Procedure - posts Payments that haven't been posted yet.

DO WHILE .T.

	choice = " "
	
	DO HEADING WITH "Post Payments"
	
	@  7,25 SAY "P - Post payments"		
	@  9,25 SAY "R - Return to the Main Menu"
	@ 20,25 SAY "What is your choice > " GET choice PICT"!"

	READ
	
	DO CASE

		CASE choice = "P"		&& Append from debtor and client to tank & replace info in debtor with "0's"

			USE TANK

			* This will post all payments from debtors, clients, agcy, and all client bal fwd's.

			Append from DEBTOR for dt_pmtamt > 0.00
			Append from CLIENT for dt_dueagcy <> 0.00 .or. dt_dueclnt <> 0.00	&& picks up all balances

			Replace all dt_code with 'B' for dt_code = 'C' .and. dt_dueagcy > 0.00	&& need B's for bal fwd's
			Replace all db_last with '** Balance Fwd' for dt_code = 'B'
			
			Replace all dt_code with 'P' for dt_code = 'C' .and. dt_dueagcy < 0.00	&& need P's for client pmts to agcy
			Replace all db_last with '** Client Pmt' for dt_code = 'P'
			
			Replace all db_last with '** Pmt to Clnt' for dt_code = 'C'


			USE debtor  ORDER names
 			
 			replace all dt_pmtamt  with 0.00
  			replace all dt_pmtdate with ctod('  /  /  ')
 			replace all dt_crface  with 0.00
 			replace all dt_crfees  with 0.00
  			replace all dt_agcchgp with 0.00
  			replace all dt_agcchgd with 0.00
  			replace all dt_dueclnt with 0.00
  			replace all dt_dueagcy with 0.00
  			replace all dt_fwdchgp with 0.00
  			replace all dt_fwdchgd with 0.00
  			replace all dt_netagcy with 0.00
			
			USE client  ORDER client
 			
 			replace all dt_pmtamt  with 0.00
  			replace all dt_pmtdate with ctod('  /  /  ')
 			replace all dt_crface  with 0.00
 			replace all dt_crfees  with 0.00
  			replace all dt_agcchgp with 0.00
  			replace all dt_agcchgd with 0.00
  			replace all dt_dueclnt with 0.00
  			replace all dt_dueagcy with 0.00
  			replace all dt_fwdchgp with 0.00
  			replace all dt_fwdchgd with 0.00
  			replace all dt_netagcy with 0.00
			replace all dt_code with 'C'
			
			USE debtor  ORDER names
			Return
			
		CASE choice = "R"
			EXIT

		OTHERWISE
			?CHR(7)

	ENDCASE
ENDDO
RETURN
********************************************************************

Procedure PRINT_POST

* PRNT_POST Procedure

* Called by Pmtmenu Procedure
* Prints out Posted Payments

DO WHILE .T.

	choice = " "
	
	DO HEADING WITH "Print out Posted Payments"
	
	@ 10,25 SAY "N = Print - indexed by NAME"	
	@ 12,25 SAY "D = Print - indexed by DATE, and NAME within DATE" 
	@ 15,25 SAY "R - Return to the Main Menu"
	@ 20,25 SAY "What is your choice > " GET choice PICT"!"

	READ
	
	DO CASE

		CASE choice = "N"

			USE tank  ORDER names

			_pdsetup = 'pana17'		&& Use 17 cpi printer driver
			report form trans_n all to print
			_pdsetup = 'pana10'		&& Return to 10 cpi printer driver

			USE debtor	ORDER names
			Return
			
		CASE choice = "D"

			USE tank	ORDER datename

			_pdsetup = 'pana17'		&& Use 17 cpi printer driver
			report form trans_dn all to print
			_pdsetup = 'pana10'		&& Return to 10 cpi printer driver

			USE debtor	ORDER names
			Return
			
		CASE choice = "R"
			EXIT

		OTHERWISE
			?CHR(7)

	ENDCASE
ENDDO
RETURN
*****************************************************************

Procedure CLOSE_MONTH

* Month closing routine

DO WHILE .T.

	choice = " "
	
	DO HEADING WITH "Month Closing Routine"

    @ 10,25 SAY "A - Close month for All Clients"	
	@ 12,25 SAY "I - Close month for Individual Client"
	@ 15,25 SAY "R - Return to the Main Menu"
	@ 20,25 SAY "What is your choice > " GET choice PICT"!"

	READ

	***** First kill all CHECK info in CLIENT file *****

 	USE client  ORDER client

 	replace all cl_check with 0.00
 	replace all cl_chkdate with {  /  /  }	
 	replace all checknum with 0	
	replace all dt_dueagcy with 0.00

	DO CASE
		
		CASE choice = "A"	&& Close Month for ALL Clients
			clear			&& Clear screen
			
			date1 = ''	&& reset variables
			date2 = ''

			Accept 'Enter ending date of period (??/??/??) ' TO date1

				STORE CTOD(date1) TO date2

				***** Now - print client statements *****

			USE tank  ORDER alldebt

			_pdsetup = 'pana10'		&& Use to 10 cpi printer driver

			report form stmt to print for dt_pmtdate <= date2  .or. dt_code = 'B' .or. dt_code = 'P' .or. dt_code = 'C'
			*                             [all debtors]             [bal fwds]         [clients to agcy]  [agcy to client]



			****** Safety - repeat routine for statements ******

			clear

			DO WHILE .T.

				choice = " "	&& Variable for users choice
	
				DO HEADING WITH "Repeat Statement option Routine"

			    @ 14,14 SAY "R - Return to Month closing to repeat statement setup and printing"	
				@ 16,14 SAY "C - Continue data processing - don't repeat statements"

				@ 20,14 SAY "What is your choice > " GET choice PICT"!"
				
				READ
	
				DO CASE		&& 	perform option - beep if choice was invalid
		
					CASE choice = "R"	&& Return to Month closing routine
						
						USE client  ORDER client
												
						replace all cl_check with 0.00
 						replace all cl_chkdate with {  /  /  }	
 						replace all checknum with 0	
						replace all dt_dueagcy with 0.00
						
						USE debtor  ORDER names		&& return to normal

						exit			

					CASE choice = "C"	&& Continue on with data processing
						* delete all transactions that just got stmts printed from tank

						Go top

						delete for dt_pmtdate <= date2  .or. dt_code = 'B' .or. dt_code = 'P' .or. dt_code = 'C'
						*          [pmts from debtors]       [bal fwds]         [pmts - clients]   [pmts - agcy to client]

						pack		

						* Reset variables
						date1 = ''	
						date2 = ''

						return

						USE debtor  ORDER names

					OTHERWISE
					?CHR(7)

				ENDCASE
			ENDDO			
		RETURN		&& Return to CLOSE MONTH Screen
					*********************


		CASE choice = "I"	&& Close for Individual Client
		
			clear			&& Clear screen
			
			client1 = ''	&&	Name and reset variables
			client2 = ''
			date1 = ''
			date2 = ''

			Accept 'Enter Client Number to close month for: ' to client1	&& client1 is chr
				STORE val(client1) to client2	&& val converts chr to num

			Accept 'Enter ending date of period (??/??/??) ' TO date1
				STORE CTOD(date1) TO date2	&& ctod = Character to date

			
			****** Print stmt for SELECTED CLIENT

			USE tank  ORDER alldebt
			
			_pdsetup = 'pana10'		&& Use to 10 cpi printer driver

			report form stmt to print for dt_pmtdate <= date2 .and. cl_clid = client2 .or. dt_code = 'B' .and. cl_clid = client2 .or. dt_code = 'P' .and. cl_clid = client2 .or. dt_code = 'C' .and. cl_clid = client2
			*                             [pmts from debtors]                              [bal fwds from client]                     [pmts from client to agcy]                 [pmts from agcy to client]



		****** Safety - repeat routine for statements ******

		clear

		DO WHILE .T.

			choice = " "	

			DO HEADING WITH "Repeat Statement option Routine"

		    @ 14,14 SAY "R - Return to Month closing to repeat statement setup and printing"	
			@ 16,14 SAY "C - Continue data processing - don't repeat statements"

			@ 20,14 SAY "What is your choice > " GET choice PICT"!"

			READ
	
				DO CASE
		
					CASE choice = "R"	&& Return to Month closing routine
						
						USE client  ORDER client
												
						replace all cl_check with 0.00
 						replace all cl_chkdate with {  /  /  }	
 						replace all checknum with 0	
						replace all dt_dueagcy with 0.00
						
						USE client  ORDER client
												
						replace all cl_check with 0.00
 						replace all cl_chkdate with {  /  /  }	
 						replace all checknum with 0	
						replace all dt_dueagcy with 0.00
						
						USE debtor  ORDER names		&& return to normal

						EXIT			

					CASE choice = "C"	&& Continue on with data processing
						Go top

						delete for dt_pmtdate <= date2 .and. cl_clid = client2 .or. dt_code = 'B' .and. cl_clid = client2 .or. dt_code = 'P' .and. cl_clid = client2 .or. dt_code = 'C' .and. cl_clid = client2
*                                  [pmts from debtors]                              [bal fwds from client]                     [pmts from client to agcy]                 [pmts from agcy to client]

						PACK		

						client1 = ''	&& Reset variables
						client2 = ''
						date1 = ''
						date2 = ''

						USE debtor  ORDER names

						RETURN

					OTHERWISE
					?CHR(7)

				ENDCASE
		ENDDO			
		RETURN		&& Return to CLOSE MONTH Screen

			********************************* Back to Close Month loop						

	CASE choice = "R"
		EXIT
		
	OTHERWISE
		?CHR(7)

ENDCASE
ENDDO
RETURN
*****************************************************************

Procedure PRINT_CHECK		&& called by 'C' in payment menu

* Called by Pmtmenu Procedure
* Prints out checks for Clients 

DO WHILE .T.

	choice = " "
	
	DO HEADING WITH "Print out Checks"

	@ 12,25 SAY "P - Print checks"
	@ 14,25 SAY "R - Return to the Main Menu"

	@ 20,25 SAY "What is your choice > " GET choice PICT"!"
	READ
	
	DO CASE
		
		CASE choice = "P"

			DO NUMBER_CHECK		&& Stuff Numbers for checks in client.dbf

			USE client  ORDER client

			Report form CHECKS to print for cl_check > 0.00
	
			USE debtor  ORDER names		&& return to normal
			
			EXIT
				
		CASE choice = "R"
			EXIT

		OTHERWISE
			?CHR(7)

		ENDCASE
ENDDO
RETURN

**************************************************************************

Procedure NUMBER_CHECK

* Numberer - Adds numbers to client.dbf; 	requests beginning number

USE client  ORDER client

clear		&& watch this one!!! - may cause problems

go top

number = ""	&& Reset number

accept 'What is the number of first check? > ##### ' to number

store val(number) to number

	DO WHILE NOT eof()

		IF cl_check > 0.00
			replace checknum with number
			number = number +1
		ENDIF
	skip

	ENDDO
RETURN
**************************************************************************

Procedure FIND_DEBTOR

* a general purpose procedure to look up a record
* leaves pointer on record if found or on EOF() if not found
* called by the Debtor Procedure
* Uses GETNAME.SPR to get name
* Uses NOTFOUND.SPR for 'not found' message

mname = SPACE(20)
mfound = 0

DO getname.spr

mname = TRIM(mname)
LOCATE FOR db_last+db_first = mname

IF EOF()
	DO notfound.spr
ENDIF
*****************************************************************

Procedure FIND_CLIENT

* a general purpose procedure to look up a record
* leaves pointer on record if found or on EOF() if not found
* called by the Client Procedure
* Uses GETNAME.SPR to get name
* Uses NOTFOUND.SPR for 'not found' message

USE client ORDER client

mname = SPACE(20)
mfound = 0

DO getname.spr

mname = TRIM(mname)
LOCATE FOR cl_title1 = mname

IF EOF()
	DO notfound.spr
ENDIF
return
*****************************************************************

Procedure DELETE_DEBTOR

clear
set talk off

m.delete = 0		&& Reset variable to hold number of accts to delete
	
USE Debtor ORDER Names

	DO WHILE .T.

	DO HEADING with "Delete Debtor Menu"

	?
	?
	?
	?
	?
	? '         These are the accounts to be deleted'
	?
	? '         Last Name      First Name'
	
	COUNT for ac_delete to m.delete
	
	set talk off

	list db_last+db_first for ac_delete

	choice = " "		&& Reset variable to hold users choice

	@ 18,5 SAY "There are " GET m.delete PICT "99" +" accounts to delete today."

	@ 19,5 SAY "Do you wish to continue? > Y/N" GET choice PICT "!"

	READ

	* Perform the choice

		DO CASE

			CASE choice = "Y"
				delete for ac_delete
				pack
				exit

			CASE choice = "N"
				exit

			OTHERWISE
				?chr(7)		&& BEEP
		ENDCASE
	
	ENDDO

RETURN
*****************************************************************

Procedure DELETE_CLIENT

* This hairy-assed little bugger will look in the DEBTOR.DBF and then
* in the TANK.DBF to see if the clients 'to be deleted' have any accounts
* left in those dbf's that should first be deleted b4 the clients are killed.

clear
set talk off

m.delete = 0		&& Reset variable to hold number of accts to delete
m.cl_clid = ""		&& Reset variable to hold Client Number to delete
m.counter = 0		&& Reset variable to hold counted # of records

USE Client ORDER Names

DO WHILE .T.
	DO HEADING with "Delete Client Menu"

	?
	?
	?
	?
	?
	? '         These are the accounts to be deleted'
	?
	? '         Last Name      First Name'

	count for ac_delete to m.delete
	list trim(cl_title1) + ' '+ str(cl_clid) for ac_delete
	choice = " "
	@ 18,5 SAY "There are " GET m.delete PICT "99" +" accounts to delete."
	@ 19,5 SAY "Do you wish to continue? > Y/N" GET choice PICT "!"
	READ

	DO CASE
			CASE choice = "Y"		&& Loop through Client dbf

					USE client ORDER clientnum

					Go top
 					DO while .NOT. EOF()	&& 1st DO

						IF ac_delete
							store cl_clid to m.cl_clid

							USE debtor ORDER clientnum
							
							go top	
							COUNT for cl_clid = m.cl_clid to m.counter

								IF m.counter > 0
	
									USE client ORDER clientnum
										
									go top
									LOCATE for cl_clid = m.cl_clid
									clear
									@ 10,5 SAY "Sorry,  " + trim(cl_title1) + " has accts still in debtor dbf."
									@ 12,5 SAY "Please delete them and re_run Client deletion."
									?
									?
									wait
									return		&& Blow out of routine
								ENDIF
							
									USE tank ORDER clientnum
		
									go top
									COUNT for cl_clid = m.cl_clid to m.counter

								IF m.counter > 0
	
									USE client ORDER clientnum
	
									go top
									LOCATE for cl_clid = m.cl_clid
									clear	
									@ 10,5 SAY "Sorry,  " + trim(cl_title1) + " has Debtor Pmts that haven't been processed."
									@ 12,5 SAY "Please close month for this client re_run Client deletion."
									?
									?
									wait
									return		&& Blow out or routine
								ENDIF

							USE client ORDER clientnum

							LOCATE for cl_clid = m.cl_clid

						ENDIF
						SKIP
					ENDDO		&& For do while .not. EOF() loop

				delete for ac_delete	&& Now kill records in client.dbf
				pack
				exit

			CASE choice = "N"
			exit

			OTHERWISE
			?chr(7)		&& BEEP
	ENDCASE
ENDDO
RETURN
*****************************************************************

PROCEDURE CHK_STMT

* 		UDF		**************** 	chk_stmt.prg	******************

* Called by STMT.FRX

*					**** DISPLAYS CORRECT INFO IN STMT ****

* 1)	gathers sum of variables from tank.dbf and gives proper message
* 		whether to 'find check enclosed' - if variable is positive,
* 		or to 'Please remit' - if variable is negative - or "we pushed
*		if Agcy & Client came out even.

* 2)	If 'check' - replaces cl_check with check amount and fixes cl_chkdate

* 3)	If 'Bill" -  replaces dt_dueagcy with amount of bill

parameters mcheckamt
m.clientid = cl_clid	&& copy client # to variable

						***************

if checkamt > 0
	
	replace ac_clstat with 'MARKER'

	USE client  ORDER client
	
 	replace cl_check with checkamt for cl_clid = m.clientid
	replace cl_chkdate with date() for cl_clid = m.clientid

 	USE tank  ORDER alldebt		&& back to stmt order

	locate for ac_clstat = 'MARKER'
	replace ac_clstat with ''		

	Return 'Enclosed is check in amount of $ ' +ltrim(str(checkamt,8,2))

endif
						**********

if checkamt = 0
	
	Return 'We broke even - see ya next Month'

endif

						*******************

if checkamt < 0

STORE abs(checkamt) to abscheckamt		&& always return positive number

	replace ac_clstat with 'MARKER'

 	USE client ORDER client		&& order was blanked for last version....?

 	replace dt_dueagcy with ABScheckamt for cl_clid = m.clientid
	replace dt_pmtdate with date() for cl_clid = m.clientid

	USE tank  ORDER alldebt	&& back to stmt order

	locate for ac_clstat = 'MARKER'
	replace ac_clstat with ''		

Return '     Please remit to Agency: $ '+ ltrim(str(abscheckamt,8,2))

endif

						****************


abscheckamt=""	&& return variable to nix

Return

*EOF chk_stmt.prg

************************************************

* EOP Collect.prg