/* TGA routines */

#include "ldpcxtga.h"       // header file for this program
#include <sys/farptr.h>     // _farpokeb()
#include <go32.h>           // _dos_ds
#include <iostream.h>       // cout
#include <pc.h>             // outportb() 
#include <stdio.h>          // FILE, fopen(), fclose, fread(), fseek() etc.
#include <stdlib.h>         // malloc()

#define putpixel(x,y,c) _farpokeb(_dos_ds, 0xA0000 + (y << 8) + (y << 6) + x, c)
#define set_v_mode()  asm(" movw $0x13, %ax; int $0x10 ")  // 320x200x256 mode
#define set_t_mode()  asm(" movw $0x03, %ax; int $0x10 ")  // back to text mode

TGALoad::TGALoad(char *fname)
{
  inf = fopen(fname, "rb");

  if(inf == NULL)
  {
    cout << "Could not open the file: " << fname << ".\n";
    exit(0);
  }

  fseek(inf, 12, SEEK_SET);  // Get the Width and the Height of the image.

  Width = fgetc(inf);
  Width = (fgetc(inf) << 8) | Width;
  Height = fgetc(inf);
  Height = (fgetc(inf) << 8) | Height;

  Image = (char *)malloc(Width * Height);  // malloc the memory needed to hold
                                           // the entire image.
}

TGALoad::~TGALoad()
{
  free(Image);  // Free the memory which was preserved for the Image.
  set_t_mode(); // Get back to the text mode.
  fclose(inf);  // Close the file we were working with.
}

void TGALoad::SetPal()
{
  char tmp;

  fseek(inf, 18, SEEK_SET);
  fread(Pal, 1, 768, inf);

  for(int i = 0; i < 768; i+=3)  // This loop reverses the pallete
  {                              // because the pallete in a TGA file is
    tmp = Pal[i];                // not in RGB format as we are used to
    Pal[i] = Pal[i+2];           // but in BGR.
    Pal[i+2] = tmp;
  }

  outportb(0x3c8, 0);
  for(int i = 0; i < 768; i++)  outportb(0x3c9, Pal[i] >> 2);

}

void TGALoad::Load()
{
  char c;
  int X = 0, Y = 0;

  set_v_mode();  // Get into the 320x200x256 mode.
  SetPal();      // Set the Pallete.

  fread(Image, 1, Width * Height, inf);  // Read the image data from the file.

  while( (Y < Height) && ( (X * Y) < (Width * Height) ) )
  {
    c = *Image;
    Image++;
    putpixel(X, Y, c);
    X++;
    if(X == Width)  {Y++; X = 0; }
  }
}
