unit rnrconf;

{

rnrconf.pas - configuration stuff - mostly removed from rnrglob.pas

}

{$I rnr-def.pas}

interface

uses rnrglob;

const
  maxconfigelementnamelen=30;  {max 27 as of 1995-11-11}
  configmemoryreserved=4096;  {for savedconfighead*}

type
  configelementname=string[maxconfigelementnamelen];

{
  configelementptrTYPE=^configelementTYPE;
  configelementTYPE=
    record
      name: configelementname;
      value: FULLTYPE;
      changed: boolean;
      next: configelementptrTYPE;
    end;
}

  configelementptrpathstring=^configelementpathstring;
  configelementpathstring=
    record
      name: configelementname;
      value: pathstring;
      changed: boolean;
      next: configelementptrpathstring;
    end;

  configelementptrshortstring=^configelementshortstring;
  configelementshortstring=
    record
      name: configelementname;
      value: shortstring;
      changed: boolean;
      next: configelementptrshortstring;
    end;

  configelementptrinteger=^configelementinteger;
  configelementinteger=
    record
      name: configelementname;
      value: integer;
      changed: boolean;
      next: configelementptrinteger;
    end;

  configelementptrboolean=^configelementboolean;
  configelementboolean=
    record
      name: configelementname;
      value: boolean;
      changed: boolean;
      next: configelementptrboolean;
    end;

var
  configheadpathstring: configelementptrpathstring;
  savedconfigheadpathstring: configelementptrpathstring;

  configheadshortstring: configelementptrshortstring;
  savedconfigheadshortstring: configelementptrshortstring;

  configheadinteger: configelementptrinteger;
  savedconfigheadinteger: configelementptrinteger;

  configheadboolean: configelementptrboolean;
  savedconfigheadboolean: configelementptrboolean;

{ from here are are rc-file/command-line configuration variables }



  subjectscaseinsensitive: boolean;
  subjectlength: byte;
  squashspaces: boolean;
  equatetruncated: integer;
  makespacelikex: boolean;
  hideheaders: string;
  showheaders: string;
  highlightheaders: string;
  nomailfrom: boolean;
  nomailheaders: string;
  nonewsheaders: string;
  wanderingnumbers: boolean;

  antikillreferences: boolean;

  showsubjectkills: boolean;
  showfromkills: boolean;
  showsubjectantikills: boolean;
  showfromantikills: boolean;
  showkills: boolean;
  showantikills: boolean;

  autoantikill: boolean;
  warnautoantikill: boolean;

  editaftervspell: boolean;
  caseinsensitivekill: boolean;
  caseinsensitiveantikill: boolean;
  substringsubjectkill: boolean;
  substringfromkill: boolean;
  substringsubjectantikill: boolean;
  substringfromantikill: boolean;
  quiet: boolean;
  ignoreenvironment: boolean;
  confirmquit: boolean;
  confirmnextgroup: boolean;
  confirmnextarticle: boolean;
  missingsubjectisok: boolean;
  tildehome: boolean;
  antikillthisnewsreader: boolean;  {not of great use to many, I'm sure}
  clearscreenbetweengroups: boolean;
  detectvideo: boolean;
  antikillevenkilled: boolean;
  mailprefix: pathstring;  {no longer groupstringt, to make maybeoptset* easy}
  ignoremouse: boolean;
  usebiosforscreen: boolean;
  hideformfeeds: boolean;
  pathuserid: shortstring;
  fromuserid: shortstring;
  customstatic: pathstring;
  haltonunknowngroups: boolean;
  mousecharsheader: string;
  justdots: boolean;
  nofilemode: boolean;
  quitmessage: string;
  outputseparator: string;
  newscmdline: pathstring;
  mailcmdline: pathstring;
  mailagent: boolean;
  outgoingmail: string;  {not pathstring since it's passed var foo: string}
  outgoingnews: string;  {not pathstring since it's passed var foo: string}
  highlightsearchhits: boolean;
  colors: shortstring;
  quotecolor: byte;

{$ifdef charset}
  uselocalcharset: boolean;
  localcharsetfn: pathstring;
{$endif}

  rmailsingle: boolean;
  idleminutes: integer;
  swap: shortstring;
  articlefilenamepattern: pathstring;
  overviewbasename: pathstring;
  fromwidth: integer;
  sizewidth: integer;
  crosspostwidth: integer;
  showcrosspostsabove: integer;
  entergroupcommand: pathstring;
  dotsonreset: boolean;
  requireexplicitquit: boolean;
  crlf: boolean;
  viewcommand: cmdstring;
  extractcommand: cmdstring;
  encodecommand: cmdstring;
  manualcommand: cmdstring;
  printcommand: cmdstring;  {ugh}
  findquotechar: boolean;
  netware: boolean;
  layout: layoutt;
  alternatecolor: byte;
  datecolor: byte;
  mailmarkerline: string;
  newsmarkerline: string;
  truncateidlength: integer;
  debuglist: string;
  dateformat: string;
  maildateformat: string;
  newsdateformat: string;
  useregex: boolean;
  quotewithspace: boolean;
  findfilecommand: pathstring;
  findexistingfilecommand: pathstring;
  helpful: boolean;
  indicatepostedmailinbody: boolean;
  donemailmessage: string;
  donenewsmessage: string;
  showmonitorfilename: boolean;
  allowemptymessage: boolean;

implementation

end.
