unit rnrmous;

{

rnrmous.pas - rnr mouse handling things

with any screen output call mousehide() before and
mouseshow() after

with any exec...() call mouseshutdown() before and mouseinit() after
  (use execresult, which won't get globbered by mouseinit)

if there is no mouse driver loaded, or it was compiled
without $define mouse these will have no effect, but will
make the same code work with and without a mouse.

}

{
the mouse unit I have is from Turbo Technix v1n4, p52

see the file `technixm.zip' in ths source distribution.  note that
various fixes have been applied, especially in the light-pen and
ratio functions (in mouse.pas).
}

{$I rnr-def.pas}

interface

{$ifdef mouse}

uses mouse,rnrglob,rnrconf;

{$endif}

procedure mouseinit;
procedure mouseshutdown;

procedure mousehide;
procedure mouseshow;

implementation

{$ifdef mouse}

procedure mousehandler     { Mouse event handler called by device driver }
   (flags, cs, ip, ax, bx, cx, dx, si, di, ds, es, bp: word);
interrupt;

begin
  mousevent.event     := ax;
  mousevent.btnstatus := bx;
  mousevent.horiz     := cx;
  mousevent.vert      := dx;
  inline (        { Exit processing for far return to device driver }
       $8B/$E5/            { MOV  SP, BP }
       $5D/                { POP  BP }
       $07/                { POP  ES }
       $1F/                { POP  DS }
       $5F/                { POP  DI }
       $5E/                { POP  SI }
       $5A/                { POP  DX }
       $59/                { POP  CX }
       $5B/                { POP  BX }
       $58/                { POP  AX }
       $CB );              { RETF    }
end;

{$endif}

procedure mouseinit;

begin

{$ifdef mouse}

  if not ignoremouse then
    begin
      mreset(themouse);
      hasmouse := themouse.exists;
    end;

  if hasmouse then
    begin
      minsttask($14,seg(mousehandler),ofs(mousehandler));
      mousevent.event := 0;
      mouseshow;
    end;

{$endif}

end;

procedure mouseshutdown;

begin

{$ifdef mouse}

  if hasmouse then
    begin
      mouseshow;
      mreset(themouse);
    end;

{$endif}

end;





procedure mousehide;

begin

{$ifdef mouse}
  if hasmouse then
    mhide;
{$endif}

end;

procedure mouseshow;

begin

{$ifdef mouse}
  if hasmouse then
    mshow;
{$endif}

end;

procedure mousereset;

begin

{$ifdef mouse}
  if hasmouse then
    mreset(themouse);
{$endif}

end;

end.
