pstart();

# Make 3D data

# Sombrero

NX = 20;
NY = 20;
xx = zeros (1, NX);
yy = zeros (1, NY);
for (i in 1:NX) { xx[i] = (i - NX/2)/(NX/2); }
for (i in 1:NY) { yy[i] = (i - NY/2)/(NY/2); }

zz = zeros (NX, NY);

for (i in 1:NX)
{
  for (j in 1:NY)
  {
    r = sqrt (xx[i]^2 + yy[j]^2);
    zz[i;j] = exp (-r * r) * cos (2*pi*r);
  }
}

# Sin - Cos surface

x1 = -3:3:.2;
y1 = -3:3:.2;
z1 = zeros (x1.n, y1.n);

for (i in 1:x1.n)
{
  for(j in 1:y1.n)
  {
    z1[i;j] = sin(y1[j]) * cos(x1[i]);
  }
}

# Slanted plane

x2 = 1:10;
y2 = 1:10;
z2 = zeros (x2.n, y2.n);
for (i in 1:x2.n) { z2[i;] = i*ones(1,y2.n); }
 
# Now create some plots

ptitle("PLOT3");
plot3 (<< x = xx; y = yy; z = zz>>);
pause();
ptitle("PLMESH");
plmesh (<< x = xx; y = yy; z = zz>>);
pause();

ptitle("PLOT3");
plot3 (<< x = x1; y = y1; z = z1>>);
pause();
ptitle("PLMESH");
plmesh (<< x = x1; y = y1; z = z1>>);
pause();

ptitle("PLOT3");
plot3 (<< x = x2; y = y2; z = z2>>);
pause();
ptitle("PLMESH");
plmesh (<< x = x2; y = y2; z = z2>>);
pause();

