//-------------------------------------------------------------------//

// Synopsis:	Clear all the variables from the workspace.

//  Syntax:	clearall ( )

//  Description:

//  The function clearall, clears all data objects from the workspace.
//  Scalars, strings, matrices, and lists are cleared with the clear
//  function. User function are not affected by clearall. If you wish
//  to remove user functions you must do so explicitly with clear.
//

//  See Also: clear
//-------------------------------------------------------------------//


clearall = function ( )
{
  for (i in members ($$))
  {
    if (class ($$.[i]) != "function")
    {
      if (i != "pi" && i != "eps" && i != "_rlab_search_path") 
      {
        clear ($$.[i]);
      }
    }
  }
};
