//-------------------------------------------------------------------//

//  Synopsis:	Convert a number object into a string-object.

//  Syntax:	num2str ( N )

//  Description:

//  Num2str converts the real-numeric argument into a string, which
//  is the return value. 
//-------------------------------------------------------------------//

num2str = function ( N )
{
  local (i, j, s, stmp)

  if (class (N) == "num" && type (N) == "real")
  {
    s = [];
    for (i in 1:N.nr)
    {
      for (j in 1:N.nc)
      {
        sprintf (stmp, "%.4g", N[i;j]);
        s[i;j] = stmp;
      }
    }
    return s;
  else
    error ("num2str: argument must be numeric-real");
  }
};
