// Instrument code file (INST.CPP)
//
// Written 1996, 1997 by Roland Acton - public domain.
//
// This file is part of the Game Music System 1.1 distribution.

#define COMPILING_INST

#include "globals.h"
#include <stdlib.h>
#ifdef TARGET_MSDOS
  #ifdef USING_BORLAND
    #include <alloc.h>
  #endif
  #ifdef USING_GCC
    #include <sys/movedata.h>
  #endif
#endif
#include "inst.h"



instrument::instrument() {

  has_synth_component = NO;
  has_sample_component = NO;
  name[0] = 0;
  sample_linear_address = 0;
}



instrument::~instrument() {

  delete_synth_component();
  delete_sample_component();
}



void instrument::delete_synth_component() {

  has_synth_component = NO;
}



void instrument::delete_sample_component() {

  if (has_sample_component) {
    unprepare_sample();
#ifdef USING_BORLAND
    farfree(sample_address_RM);
#else
    free(sample_address_PM);
#endif
    has_sample_component = NO;
  }
}



// Moves the sample to conventional memory and converts it to unsigned.
gms_function_return_codes instrument::prepare_sample() {

#ifdef TARGET_WIN95
// Does nothing under Win95.
#else
  if (has_sample_component && !sample_linear_address) {
    convert_to_unsigned();
/* Borland 3.1 only works in real mode, so the sample is already where it
   needs to be. */
  #ifdef USING_GCC
    dos_buffer_info.size = (sample_length >> 4) + 1;
    if (_go32_dpmi_allocate_dos_memory(&dos_buffer_info))
      return gms_function_failure;
    sample_address_RM = (signed char *) (dos_buffer_info.rm_segment << 16);
    dosmemput(sample_address_PM, sample_length,
      dos_buffer_info.rm_segment << 4);
  #endif
  #ifdef USING_WATCOM
*** Needs to allocate conventional memory and copy the sample into it.
  #endif
    sample_linear_address =
      (((unsigned long int) sample_address_RM & 0xFFFF0000) >> 12)
      + ((unsigned long int) sample_address_RM & 0x0000FFFF);
  }
#endif
  return gms_function_success;
}



// Deletes the conventional memory copy of the sample.
void instrument::unprepare_sample() {

#ifdef TARGET_WIN95
// Does nothing under Win95.
#else
  if (has_sample_component && sample_linear_address) {
  #ifdef USING_GCC
    _go32_dpmi_free_dos_memory(&dos_buffer_info);
  #endif
  #ifdef USING_WATCOM
*** Needs to free the conventional memory used by the sample.
  #endif
    sample_linear_address = 0;
  }
#endif
}



// Converts the instrument to signed data format.
void instrument::convert_to_signed() {

  if (!in_signed_form) {
#ifdef USING_BORLAND
    unprepare_sample();
#endif
    invert_samples();
    in_signed_form = YES;
  }
}



// Converts the instrument to unsigned data format.
void instrument::convert_to_unsigned() {

  if (in_signed_form) {
    invert_samples();
    in_signed_form = NO;
  }
}



// Converts the instrument between signed and unsigned data format.
void instrument::invert_samples() {
  unsigned long int stepper;

  for (stepper = 0;stepper < sample_length;stepper++)
#ifdef USING_BORLAND
    *(sample_address_RM + stepper) ^= 128;
#else
    *(sample_address_PM + stepper) ^= 128;
#endif
}
