// Windows 95 player program code file (PLAYER95.CPP)
//
// Written 1997 by Roland Acton - public domain.
//
// This file is part of the Game Music System 1.1 distribution.

// A fairly simple GUI to play GMS modules.

// *** Soundsystems higher than Adlib aren't working

#define COMPILING_PLAYER95

#define STRICT

#include "globals.h"
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <assert.h>
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <commdlg.h>
#include "inst.h"
#include "block.h"
#include "song.h"
#include "musdrv.h"
#include "player95.h"



int WINAPI WinMain(HINSTANCE hThisInst, HINSTANCE /*hPrevInst*/, LPSTR /*lpszArgs*/,
    int nWinMode) {
  HWND hwnd;
  MSG msg;
  WNDCLASSEX wcl;

// Initialization.
  is_module_loaded = NO;
  is_song_paused = NO;
  player_instance_handle = hThisInst;
  InitCommonControls();
  song::set_up_class();
  music_driver::reset_card();
// Define window class.
  wcl.hInstance = hThisInst;
  wcl.lpszClassName = WinName;
  wcl.lpfnWndProc = WindowFunc;
  wcl.style = 0;
  wcl.cbSize = sizeof(WNDCLASSEX);
  wcl.hIcon = LoadIcon(0, IDI_APPLICATION);
  wcl.hIconSm = LoadIcon(0, IDI_WINLOGO);
  wcl.hCursor = LoadCursor(0, IDC_ARROW);
  wcl.lpszMenuName = "MAIN_MENU";
  wcl.cbClsExtra = 0;
  wcl.cbWndExtra = 0;
  wcl.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
// Register window class.
  if (!RegisterClassEx(&wcl))
    exit(EXIT_FAILURE);
// Create window.
  hwnd = CreateWindow(WinName, "Game Music System 1.1 player",
    WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
    CW_USEDEFAULT, 0, 0, hThisInst, 0);
  if (!hwnd)
    exit(EXIT_FAILURE);
// Display window.
  ShowWindow(hwnd, nWinMode);
  UpdateWindow(hwnd);
// Make dialog and controls.
  player_toolbar = CreateToolbarEx(hwnd, WS_VISIBLE | WS_CHILD, //| TBSTYLE_TOOLTIPS,
    ID_TOOLBAR, 3, player_instance_handle, ID_TOOLBAR_BITMAP,
    play_buttons, 3, 0, 0, 16, 16, sizeof(TBBUTTON));
  CreateDialog(hThisInst, "MAIN_DIALOG", hwnd, DialogFunc);
// Set up timer function.
  if (!SetTimer(hwnd, 1, 10, TimerFunc))
    MessageBox(hwnd, "Couldn't allocate a timer.",
      "Error Allocating Timer", MB_ICONEXCLAMATION | MB_OK);
  MessageBox(hwnd, "This Win95 player is experimental and does NOT work very well. Proceed at your own risk.",
    "Warning: Buggy Code Ahead", MB_ICONEXCLAMATION | MB_OK);
// Enter message loop.
  while (GetMessage(&msg, 0, 0, 0)) {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
// Clean up.
  KillTimer(hwnd, 1);
  music_driver::reset_card();
  song::shut_down_class();
  return msg.wParam;
}



LRESULT CALLBACK WindowFunc(HWND hwnd, UINT message, WPARAM wParam,
    LPARAM lParam) {
  OPENFILENAME fname;
  char fullfilename[255], shortfilename[255];
  FILE *module;
  unsigned int sb_base;

  switch (message) {
    case WM_DESTROY:
      PostQuitMessage(0);
      break;
    case WM_COMMAND:
      switch (LOWORD(wParam)) {
        case IDM_LOAD:
          fullfilename[0] = 0;
          fname.lStructSize = sizeof(OPENFILENAME);
          fname.hwndOwner = hwnd;
          fname.lpstrFilter = "GMS Modules\0*.GMS\0All Files\0*.*\0\0\0";
          fname.lpstrCustomFilter = 0;
          fname.nFilterIndex = 1;
          fname.lpstrFile = fullfilename;
          fname.nMaxFile = 255;
          fname.lpstrFileTitle = shortfilename;
          fname.nMaxFileTitle = 255;
          fname.lpstrInitialDir = 0;
          fname.lpstrTitle = 0;
          fname.Flags = OFN_FILEMUSTEXIST;
          if (GetOpenFileName(&fname)) {
            module = fopen(fullfilename, "rb");
            if (module) {
              if (song::load_gms(module) == gms_function_success) {
                is_module_loaded = YES;
                strcpy(open_file_name, shortfilename);
              }
              else
                MessageBox(hwnd, "Not a GMS 1.0/1.1 module.",
                  "Error While Reading Module", MB_ICONEXCLAMATION | MB_OK);
              fclose(module);
            }
            else
              MessageBox(hwnd, "Couldn't open that file.",
                "Error Opening File", MB_ICONEXCLAMATION | MB_OK);
          }
          break;
        case IDM_PLAY:
          if (is_module_loaded) {
            switch (SendDlgItemMessage(hwnd, IDD_SB_BASE, LB_GETCURSEL, 0, 0)) {
              case 0:
              sb_base = 0x210;
              break;
              case 1:
              sb_base = 0x220;
              break;
              case 2:
              sb_base = 0x240;
              break;
              case 3:
              sb_base = 0x260;
              break;
              default:
// Should be impossible.
              assert(0);
              break;
            }
            music_driver::set_up_driver(song::soundsystem, sb_base, 5, 1);
            music_driver::reset_card();
            music_driver::set_up_card();
            song::position_jump(0);
            music_driver::start_playing();
//            SendMessage(player_toolbar, TB_ENABLEBUTTON, IDM_PAUSE, 1);
          }
          else
            MessageBox(hwnd, "You need to load a GMS module first.",
              "No Module Loaded", MB_ICONSTOP | MB_OK);
          break;
        case IDM_STOP:
          music_driver::stop_playing();
          music_driver::reset_card();
//          SendMessage(player_toolbar, TB_ENABLEBUTTON, IDM_PAUSE, 0);
          break;
        case IDM_PAUSE:
          if (is_song_paused) {
            is_song_paused = NO;
            music_driver::start_playing();
//          SendMessage(player_toolbar, TB_ENABLEBUTTON, IDM_PLAY, 0);
//          SendMessage(player_toolbar, TB_ENABLEBUTTON, IDM_STOP, 0);
          }
          else {
            is_song_paused = YES;
            music_driver::stop_playing();
//          SendMessage(player_toolbar, TB_ENABLEBUTTON, IDM_PLAY, 1);
//          SendMessage(player_toolbar, TB_ENABLEBUTTON, IDM_STOP, 1);
          }
          break;
        case IDM_ABOUT:
          MessageBox(hwnd, "Game Music System player program for Windows 95.\n\nWritten 1997 by Roland Acton.\n\nThis program is public domain.",
            "About", MB_ICONINFORMATION | MB_OK);
          break;
        case IDM_EXIT:
          PostQuitMessage(0);
          break;
      }
      break;
    default:
      return DefWindowProc(hwnd, message, wParam, lParam);
  }
  return 0;
}



BOOL CALLBACK DialogFunc(HWND hwnd, UINT message, WPARAM wParam,
    LPARAM lParam) {
  static HWND volume_trackbar;

  switch (message) {
    case WM_INITDIALOG:
      SendDlgItemMessage(hwnd, IDD_SB_BASE, LB_ADDSTRING, 0,
        (LPARAM) "210");
      SendDlgItemMessage(hwnd, IDD_SB_BASE, LB_ADDSTRING, 0,
        (LPARAM) "220");
      SendDlgItemMessage(hwnd, IDD_SB_BASE, LB_ADDSTRING, 0,
        (LPARAM) "240");
      SendDlgItemMessage(hwnd, IDD_SB_BASE, LB_ADDSTRING, 0,
        (LPARAM) "260");
      SendDlgItemMessage(hwnd, IDD_SB_BASE, LB_SETCURSEL, 1, 0);
      SendDlgItemMessage(hwnd, IDD_SOUNDSYSTEM_ADLIB, BM_SETCHECK, 1, 0);
/*
      volume_trackbar = CreateWindow(TRACKBAR_CLASS, "Volume",
        WS_CHILD | WS_VISIBLE | WS_TABSTOP | TBS_AUTOTICKS, 0, 100,
        50, 20, hwnd, 0, player_instance_handle, 0);
      if (volume_trackbar) {
        SendMessage(volume_trackbar, TBM_SETRANGE, 1, (63 << 16) | 0;
           // Min volume 0, max 63.
         SendMessage(volume_trackbar, TBM_SETPOS, 1, 63);
      }
      else
              MessageBox(hwnd, "....",
                "Error Opening File", MB_ICONEXCLAMATION | MB_OK);
*/
      return 1;
    case WM_COMMAND:
      switch (wParam) {
        case IDD_SOUNDSYSTEM_ADLIB:
        case IDD_SOUNDSYSTEM_SB:
        case IDD_SOUNDSYSTEM_SBPRO1:
        case IDD_SOUNDSYSTEM_SBPRO2:
          music_driver::forbid_playing();
          music_driver::reset_card();
          switch (wParam) {
            case IDD_SOUNDSYSTEM_ADLIB:
              song::soundsystem = song::adlib;
              break;
            case IDD_SOUNDSYSTEM_SB:
              song::soundsystem = song::sb;
              break;
            case IDD_SOUNDSYSTEM_SBPRO1:
              song::soundsystem = song::sbpro1;
              break;
            case IDD_SOUNDSYSTEM_SBPRO2:
              song::soundsystem = song::sbpro2;
              break;
            default:
// Should be impossible.
              assert(0);
              break;
          }
          music_driver::reset_card();
          music_driver::set_up_card();
          music_driver::permit_playing();
          return 1;
      }
      break;
//    case WM_HSCROLL:
//      if ((HWND) lParam == volume_trackbar)
//        music_driver::set_global_volume(SendMessage(volume_trackbar,
//          TBM_GETPOS, 0, 0));
//      break;
  }
  return 0;
}



VOID CALLBACK TimerFunc(HWND hwnd, UINT msg, UINT TimerID,
    DWORD SysTime) {
//  static unsigned int old_tempo = 9999;
  static unsigned int systime_memory = 0;
  unsigned int update_milliseconds;

// *** Find out how to wedge an interrupt under Win95.
  if (systime_memory) {
    update_milliseconds = music_driver::compute_tempo_milliseconds(song::tempo);
    while (SysTime - systime_memory > update_milliseconds) {
      music_driver::update();
      systime_memory += update_milliseconds;
    }
  }
  else
    systime_memory = SysTime;   // Happens on first call.
/*
  music_driver::update();
  if (old_tempo != song::tempo) {
    KillTimer(hwnd, 1);
    SetTimer(hwnd, 1,
      music_driver::compute_tempo_milliseconds(song::tempo), TimerFunc);
    old_tempo = song::tempo;
  }
*/
}
