#ifndef __XSND_H
#define __XSND_H

/**********************************************************/
/*/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/
/*
Copyright: 1995 - Borja Etxebarria
*/
/*/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/
/**********************************************************/

#include "tdef.h"

/**********************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/**********************************************************/

#define XSND_RECORD TRUE
#define XSND_PLAY FALSE
#define XSND_MONO FALSE
#define XSND_STEREO TRUE

/**********************************************************/

#define xsnd_open  xsnd16_open
#define xsnd_close  xsnd16_close
#define xsnd_getblk  xsnd16_getblk
#define xsnd_addblk  xsnd16_addblk
#define xsnd_addlastblk  xsnd16_addlastblk
#define xsnd_stopped  xsnd16_stopped
#define xsnd_blocked  xsnd16_blocked
#define xsnd_reset  xsnd16_reset
#define xsnd_start  xsnd16_start
#define xsnd_stop  xsnd16_stop
#define xsnd_getoverrun  xsnd16_getoverrun
#define xsnd_getblknum  xsnd16_getblknum
#define xsnd_getnblk  xsnd16_getnblk
#define xsnd_initialize  xsnd16_initialize
#define xsnd_srate  xsnd16_srate
#define xsnd_getsrate  xsnd16_getsrate

/**********************************************************/

UINT16 xsnd16_open( BOOL record, UINT16 srate, BOOL stereo,
		UINT32 blklen, UINT16 numblk, VOID (PTRF usrproc) ( BOOL last) );
UINT16 xsnd16_close( VOID );
pfINT16 xsnd16_getblk( VOID );
UINT16 xsnd16_addblk( VOID );
UINT16 xsnd16_addlastblk( UINT32 len );
BOOL xsnd16_stopped( VOID );
BOOL xsnd16_blocked( VOID );

UINT16 xsnd16_reset( VOID );
UINT16 xsnd16_start( VOID );
UINT16 xsnd16_stop( VOID );
UINT16 xsnd16_getoverrun( VOID );

pfINT16 xsnd16_getblknum( UINT2 nblk );
UINT16 xsnd16_getnblk( VOID );

UINT16 xsnd16_srate( UINT16 srate );
DOUBLE xsnd16_getsrate( VOID );

UINT16 xsnd16_initialize( VOID );

/**********************************************************/

UINT16 xsnd8_open( BOOL record, UINT16 srate, BOOL stereo,
		UINT32 blklen, UINT16 numblk, VOID (PTRF usrproc) ( BOOL last) );
UINT16 xsnd8_close( VOID );
pfUINT8 xsnd8_getblk( VOID );
UINT16 xsnd8_addblk( VOID );
BOOL xsnd8_stopped( VOID );
BOOL xsnd8_blocked( VOID );

UINT16 xsnd8_reset( VOID );
UINT16 xsnd8_start( VOID );
UINT16 xsnd8_stop( VOID );
UINT16 xsnd8_getoverrun( VOID );

pfUINT8 xsnd8_getblknum( UINT2 nblk );
UINT16 xsnd8_getnblk( VOID );

UINT16 xsnd8_srate( UINT16 srate );
DOUBLE xsnd8_getsrate( VOID );

UINT16 xsnd8_initialize( VOID );

/**********************************************************/

#ifdef __cplusplus
}  /* extern "C" */
#endif

/**********************************************************/

#endif
