procedure MatrixO is

  type Task_Types is (Multiplier, Source, Sink, Zero, Result);

  Size: constant Integer := 3;
  type Vector is array(1..Size) of Integer;
  Matrix1: array(1..Size) of Vector := 
    ((1,2,3),(4,5,6),(7,8,9));
  Matrix2: array(1..Size) of Vector :=
    ((1,0,2),(0,1,2),(1,0,0));

  type Channels is range 1..2*Size*(Size+1)+1;
  type Tasks(Task_Type: Task_Types);
  type Task_Ptr is access Tasks;

  task type Multiplier_Task is
    entry Init(Coeff: Integer; T: Task_Ptr);
    entry Input (Channels)(I: in  Integer);
  end Multiplier_Task;

  task type Source_Task is
    entry Init(V: Vector; T: Task_Ptr);
  end Source_Task;

  task type Sink_Task is
    entry Init(T: Task_Ptr);
    entry Input (Channels)(I: in  Integer);
  end Sink_Task;

  task type Zero_Task is
    entry Init(T: Task_Ptr);
  end Zero_Task;

  task type Result_Task is
    entry Init(ID: Integer; T: Task_Ptr);
    entry Input (Channels)(I: in  Integer);
  end Result_Task;

  type Tasks(Task_Type: Task_Types) is
    record
      North, East, South, West: Channels;
      case Task_Type is
        when Multiplier => M: Multiplier_Task;
        when Source     => S: Source_Task;
        when Sink       => T: Sink_Task;
        when Zero       => Z: Zero_Task;
        when Result     => R: Result_Task;
      end case;
    end record;

  task type Channel_Task is
    entry Destination(T_Ptr: Task_Ptr; Chan: Channels);
    entry Output(I: in Integer);
  end Channel_Task;

  M: array(1..Size, 1..Size) of Task_Ptr;
  S: array(1..Size) of Task_Ptr;
  T: array(1..Size) of Task_Ptr;
  Z: array(1..Size) of Task_Ptr;
  R: array(1..Size) of Task_Ptr;

  Channel: array(Channels range 1..Channels'Last-1) of Channel_Task;

  task body Multiplier_Task is separate;
  task body Source_Task     is separate;
  task body Sink_Task       is separate;
  task body Zero_Task       is separate;
  task body Result_Task     is separate;
  task body Channel_Task    is separate;

  procedure Activate is
  begin
    M := (others => (others => new Tasks(Multiplier)));
    S := (others => new Tasks(Source));
    T := (others => new Tasks(Sink));
    Z := (others => new Tasks(Zero));
    R := (others => new Tasks(Result));
  end Activate;

  procedure Configure is               
    N: Channels;
  begin
    N := 1;
    for I in 1..Size loop
      S(I).South := N;
      M(1,I).North := N;
      N := N + 1;
      Z(I).West := N;
      M(I,Size).East := N;
      N := N + 1;
      T(I).North := N;
      M(Size,I).South := N;
      N := N + 1;
      R(I).East := N;
      M(I,1).West := N;
      N := N + 1;
      for J in 2..Size loop
        M(I,J).West := N;
        M(I,J-1).East := N;
        N := N + 1;
      end loop;
      if I /= Size then
        for J in 1..Size loop
          M(I,J).South := N;
          M(I+1,J).North := N;
          N := N + 1;
        end loop;
      end if;
    end loop;
  end Configure;

  procedure Init is
  begin
    for I in 1..Size loop
      R(I).R.Init(I, R(I));
      S(I).S.Init(Matrix2(I), S(I));
      T(I).T.Init(T(I));
      Z(I).Z.Init(Z(I));
      for J in 1..Size loop
        M(I,J).M.Init(Matrix1(I)(J), M(I,J));
      end loop;
    end loop;
  end Init;

begin
  Activate;
  Configure;
  Init;
end MatrixO;
