'STGEN.BAS  -  USRSTATS generic door
'Version 1.07R 12/14/95
'Written by Joseph C. Frankiewicz
'
'Modifications by Michael Conley for flow control, pagination 12/14/95
'
'Added /H handshaking option to command line, where 0=none, 1=Xon/Xoff
'and 2=CTS, 3=Both.
'
'Added pagination and abort to STGINTRO.TXT and STGEXIT.TXT displays
'
'Added parsing of DOOR.SYS for video mode, bbs node, and CallerMode
'
'Added screen headers
'
'Added I4 for host modem settings
'
'For QuickBASIC 4.5 or Basic PDS 7.1

'Released to the public domain.

'Retrieve and display modem's on-line status reports

'requires:
'Companion program USRSTAT2.EXE
'US Robotics Courier/Sportster high-speed modems that support
'the  I4, I6, I7, I11, and Y11 commands.

'modem init string can be modified to ATZ^M~~~AT&D1
'to use DTR switching, but modem will not store &D in NVRAM.

'install in it's own directory as a standard DOOR, no .SYS files
'needed, but reads DOOR.SYS if available to set video mode.

'multi-node aware if node # is passed properly by the calling batch file

'-----------------------------------------------------------------------
 'Externs for QBSerial library, version 3.20

 DECLARE SUB OpenComm CDECL ALIAS "_open_comm" (BYVAL Port%, IRQ%, BYVAL Wlen%, BYVAL Parity%, BYVAL Bits%, BYVAL Baud&, BYVAL HS%, BYVAL FOSSIL%)
 DECLARE SUB CloseComm CDECL ALIAS "_close_comm" ()
 DECLARE FUNCTION WriteChar% CDECL (BYVAL c%)
 DECLARE FUNCTION ReadChar% CDECL ()
 DECLARE SUB transmit CDECL ALIAS "_transmit_string" (addr$)
 DECLARE FUNCTION DataWaiting% CDECL ALIAS "_data_waiting" ()
 DECLARE SUB ClearInputBuffer CDECL ALIAS "_clear_input_buffer" ()
 DECLARE SUB CarrierDetect CDECL ALIAS "_carrier_detect_flag" (BYVAL OnOff%)
 DECLARE FUNCTION CarrierLost% CDECL ALIAS "_carrier_state" ()
 DECLARE FUNCTION DriverCopyright% CDECL ()
 DECLARE SUB DTRcontrol CDECL ALIAS "_dtr" (BYVAL OnOff%)
 DECLARE SUB RTScontrol CDECL ALIAS "_rts" (BYVAL Onff%)
 DECLARE FUNCTION ModemStatus% CDECL ALIAS "_inputstatus" ()
 DECLARE SUB BREAKcontrol CDECL ALIAS "_break_state" (BYVAL state%)

'==========================================================================
'constants
 False% = 0 : True% = NOT False%
 DIM INFO$(36) 'for DOOR.SYS
 CrLf$ = CHR$(13) + CHR$(10)
 Rub$  = CHR$(29) + CHR$(32) + CHR$(29) ' del chr left / local
 tempfilepath$ = ENVIRON$("STGTMP")

'==========================================================================
'start of main code

 'catch-all error handler
 ON ERROR GOTO bombout

 LOCATE , , 1

 PRINT
 PRINT
 PRINT "STGEN (USRSTATS GENERIC) Version 1.07R, 12/14/95"
 PRINT "Written by Joseph C. Frankiewicz"
 PRINT "Revisions by Michael A. Conley"
 PRINT

'-----------------------------------------------
'parse command line

'command line parms:
' port : irq (0=default) :  node :  esc char (256=dtr)  : fossil  :  filename (optional)

 x$ = COMMAND$

 IF x$ = "" THEN
   PRINT "Usage is:"
   PRINT
   PRINT "STGEN <port> <irq> <node> <esc char> <fossil> <logfile> </Mx> </Hx> </NOXMIT>"
   PRINT
   PRINT "        PORT: comm or FOSSIL port number, or DECIMAL base address"
   PRINT "         IRQ: 1-15, or 0 for default"
   PRINT "        NODE: BBS node number, or 0 if single-node"
   PRINT "    ESC CHAR: 0-127 matching modem S2 register, or 256=DTR toggle"
   PRINT "      FOSSIL: 0=no FOSSIL, 1=use FOSSIL"
   PRINT "     LOGFILE: optional, name of report history file"
   PRINT "         /Mx: optional, x=video mode passed to USRSTAT2.EXE"
   PRINT "         /Hx: optional, x=flow control: 0=none, 1=Xon, 2=CTS, 3=Both"
   PRINT "     /NOXMIT: optional, use when running from a comm program instead of BBS"
   PRINT
   PRINT "      STGTMP: optional environment variable, path for temporary files, with \"
   PRINT "STGINTRO.TXT: optional file to display in door mode"
   PRINT " STGEXIT.TXT: optional file to display in door mode"
   PRINT
   GOTO bombout
 END IF

 'pick off command line options from right to left

 'add /NOXMIT at end of line, and nothing will
 'be sent out serial port.  This will allow CALLERS to use it also.

 'set CallerMode, default is 0

 CallerMode% = 0
 pointer = INSTR(x$, "/NOXMIT")
 IF pointer > 0 THEN
    CallerMode% = 1 'is noxmit
    MID$(x$, pointer, 7) = "       "
 END IF

 'set video mode, default=6

 videomode$ = "6"
 pointer = INSTR(x$, "/M")
 IF pointer > 0 THEN
    videomode$ = MID$(x$, pointer + 2, 1)
    MID$(x$, pointer, 3) = "   "
 END IF

 'set handshaking, default=2 (cts)

 hsmode$ = "2" 'default
 pointer = INSTR(x$, "/H")
 IF pointer > 0 THEN
    hsmode$ = MID$(x$, pointer + 2, 1)
    MID$(x$, pointer, 3) = "   "
 END IF
 hs% = INT(val(hsmode$))
 IF (hs% < 0) OR (hs% > 3) THEN hs% = 2

 'now process the rest

 x$ = LTRIM$(RTRIM$(x$))
 temp$ = ""
 WHILE LEFT$(x$, 1) <> " " AND LEN(x$) > 0
 temp$ = temp$ + LEFT$(x$, 1)
    x$ = RIGHT$(x$, LEN(x$) - 1)
 WEND

 comport% = VAL(temp$)

 x$ = LTRIM$(x$)
 temp$ = ""
 WHILE LEFT$(x$, 1) <> " " AND LEN(x$) > 0
    temp$ = temp$ + LEFT$(x$, 1)
    x$ = RIGHT$(x$, LEN(x$) - 1)
 WEND

 comirq% = VAL(temp$)

 x$ = LTRIM$(x$)
 temp$ = ""
 WHILE LEFT$(x$, 1) <> " " AND LEN(x$) > 0
    temp$ = temp$ + LEFT$(x$, 1)
    x$ = RIGHT$(x$, LEN(x$) - 1)
 WEND

 bbsnode% = VAL(temp$)

 x$ = LTRIM$(x$)
 temp$ = ""
 WHILE LEFT$(x$, 1) <> " " AND LEN(x$) > 0
    temp$ = temp$ + LEFT$(x$, 1)
    x$ = RIGHT$(x$, LEN(x$) - 1)
 WEND

 escchar% = VAL(temp$)

 x$ = LTRIM$(x$)
 temp$ = ""
 WHILE LEFT$(x$, 1) <> " " AND LEN(x$) > 0
    temp$ = temp$ + LEFT$(x$, 1)
    x$ = RIGHT$(x$, LEN(x$) - 1)
 WEND

 usefossil% = VAL(temp$)

 logfile$ = LTRIM$(RTRIM$(x$))


 PRINT "PORT="; comport%; " IRQ="; comirq%; "NODE="; bbsnode%; "ESC CHAR="; escchar%; "FOSSIL="; usefossil%; " HANDSHAKE=";LTRIM$(STR$(hs%));" VIDEO= "; videomode$
 PRINT "LOGFILE= "; logfile$
 PRINT "STGTMP= "; tempfilepath$
 PRINT

 GOSUB ReadDoorSys

 'open the port using default speed, 8 bits, no parity, handshake as parsed
 'default baud rate

 OpenComm comport%, comirq%, 8, 0, 1, 0, hs%, usefossil%


 'turn off carrier detect checking
 CarrierDetect 0

 'check for local logon
 IF CarrierLost THEN
    PRINT "No carrier detected, STGEN cannot run."
    PRINT
    GOTO bombout
 END IF


'if in door mode, and if file STGINTRO.TXT is present, display it and wait for keypress

 DispFile$ = "STGINTRO.TXT"
 GOSUB ShowFile

'=========================

 GOSUB NewLine
 Ln$ = "Please wait, retrieving status info from modem..."
 GOSUB Yellow
 GOSUB PutWords

'=========================================================

 'delete any old TMPA and TMPB files if present

 'this is a kludge because QB has no EXIST function

 OPEN tempfilepath$ + "tmpa" + LTRIM$(RTRIM$(STR$(bbsnode%))) FOR OUTPUT AS #1
 CLOSE #1
 KILL tempfilepath$ + "tmpa" + LTRIM$(RTRIM$(STR$(bbsnode%)))

 OPEN tempfilepath$ + "tmpb" + LTRIM$(RTRIM$(STR$(bbsnode%))) FOR OUTPUT AS #1
 CLOSE #1
 KILL tempfilepath$ + "tmpb" + LTRIM$(RTRIM$(STR$(bbsnode%)))

 '==========================================================

 'open the temp  file with unique name for any node,
 'put in the current directory.
 'open the file in overwrite mode

 OPEN tempfilepath$ + "tmpa" + LTRIM$(RTRIM$(STR$(bbsnode%))) FOR OUTPUT AS #1

 '--------------------------------
 'get the modem into command mode

 IF escchar% = 256 THEN
    'since the modem is set to &D1, dropping the DTR lead
    'here will cause it to go into on-line command mode,
    'where we can issue our diagnostic commands

    'drop dtr
    DTRcontrol 0

    'wait a sec for the modem to go into command mode
    zzz = TIMER + .6
    WHILE TIMER < zzz
    WEND

    'turn dtr back on
    DTRcontrol 1

    'wait a bit so the modem sees DTR
    zzz = TIMER + .6
    WHILE TIMER < zzz
    WEND

 END IF

 IF escchar% < 256 THEN
    GOSUB Black
    GOSUB PutWords 'set color to black, then pause for modem cmd request
    zzz = TIMER + 1.7
    WHILE TIMER < zzz
    WEND
    ln$ = CHR$(escchar%) + CHR$(escchar%) + CHR$(escchar%)
    transmit ln$
    zzz = TIMER + 1.7
    WHILE TIMER < zzz
    WEND
 END IF

 'if CD is gone then modem is misconfigured

 IF CarrierLost THEN
    PRINT "Modem is incorrectly configured!"
    PRINT
    GOTO bombout
 END IF

'===================================================

 'see if I'm really in command mode by sending an AT
 'and looking for OK or 0 response
 'if not in command mode, abort

 transmit "AT"
 transmit crlf$
 zzz = TIMER + .6
 WHILE TIMER < zzz
 WEND

 'now loop, grabbing chars and saving in string until no more come in

 atcheck$ = ""

 WHILE DataWaiting%
    atcheck$ = atcheck$ + CHR$(ReadChar%)
 WEND

 IF INSTR(atcheck$, "OK") = 0 AND INSTR(atcheck$, "0") = 0 THEN
    'send ato just in case
    transmit "ATO"
    transmit crlf$
    SLEEP 1
    GOSUB ClearRcv
    GOSUB NewLine
    GOSUB White
    ln$ = "STGEN cannot get modem into command mode!"
    GOSUB PutLine
    GOTO bombout
 END IF
 GOSUB ClearRcv

 transmit "ATI11Y11"
 transmit crlf$
 GOSUB mdmtodisk

 transmit "ATI4I6I7O"
 transmit crlf$
 GOSUB mdmtodisk

'close the input file

 CLOSE #1

 'now shell out to USRSTAT2 program to do the dirty work

 '-------------------------------------------------------------------------

 'use this one for USRSTAT2.EXE V4.xx

 SHELL "USRSTAT2.EXE " + tempfilepath$ + "tmpa" + LTRIM$(RTRIM$(STR$(bbsnode%))) + " " + tempfilepath$ + "tmpb" + LTRIM$(RTRIM$(STR$(bbsnode%))) + " 0 /M" + videomode$ + " /P3"

 '-------------------------------------------------------------------------

 'empty the RX buffer just in case

  GOSUB ClearRcv

 'display the file
 'if return file does not exist then error handler will catch it


 'this crlf ends the PLEASE WAIT... message on caller's screen
 GOSUB NewPage
 OPEN tempfilepath$ + "tmpb" + LTRIM$(RTRIM$(STR$(bbsnode%))) FOR INPUT AS #1
 'append to history file also
 IF logfile$ <> "" THEN OPEN logfile$ FOR APPEND AS #2
 Finish%  = False
 NoBreak% = False
 GOSUB Gray
 DO WHILE NOT EOF(1)
    LINE INPUT #1, ln$
    IF instr(ln$,"MORE:") <1 THEN
       IF logfile$ <> "" THEN PRINT #2, ln$
       GOSUB PutLine
    ELSE
       Page = Page + 1
       GOSUB PageBreak
       IF Finish% = True% THEN EXIT DO
       Ln$ = ""
       IF Page = 1 THEN
            GOSUB Yellow
            Ln$ = "FREQUENCY RESPONSE TABLE:"
            GOSUB PutLine
            GOSUB PutWords
        END IF
        IF Page = 2 THEN
            GOSUB Yellow
            Ln$ = "HOST MODEM SETTINGS:"
            GOSUB PutLine
            GOSUB Cyan
            GOSUB PutWords
        END IF
    END IF
 LOOP
 CLOSE #1
 IF logfile$ <> "" THEN CLOSE #2
 'check for forced modem retrain

 IF CallerMode% = 0 THEN
    GOSUB NewLine
    Ln$ = "Force modem retrain? (NO/yes) "
    GOSUB Yellow
    GOSUB PutWords
 ELSE

 END IF

 zzz = TIMER + 300
 yn$ = ""
 WHILE DataWaiting% = 0 AND yn$ = "" AND TIMER < zzz
    IF CarrierLost THEN GOTO bombout
    yn$ = INKEY$
 WEND

 IF DataWaiting% <> 0 THEN
    yn$ = CHR$(ReadChar%)
 END IF

 yn$ = UCASE$(yn$)

 IF CallerMode% = 0 THEN
    GOSUB NewLine
 END IF

 IF yn$ = "Y" THEN

    '--------------------------------
    'get the modem into command mode

    IF escchar% = 256 THEN
       'since the modem is set to &D1, dropping the DTR lead
       'here will cause it to go into on-line command mode,
       'where we can issue our diagnostic commands

       'drop dtr
       DTRcontrol 0

       'wait a sec for the modem to go into command mode
       zzz = TIMER + .5
       WHILE TIMER < zzz
       WEND

       'turn dtr back on
       DTRcontrol 1

       'wait a bit so the modem sees DTR
       zzz = TIMER + .3
       WHILE TIMER < zzz
       WEND

    END IF

    IF escchar% < 256 THEN
       GOSUB Black
       GOSUB PutWords
       ln$ = CHR$(escchar%) + CHR$(escchar%) + CHR$(escchar%)
       zzz = TIMER + 1.7
       WHILE TIMER < zzz
       WEND
       transmit ln$
       'wait for ok instead?
       zzz = TIMER + 1.7
       WHILE TIMER < zzz
       WEND
    END IF

    'if CD is gone then modem is misconfigured

    IF CarrierLost THEN
       PRINT "Modem is incorrectly configured!"
       PRINT
       GOTO bombout
    END IF

   '===================================================

    'see if im really in command mode by sending an AT
    'and looking for OK or 0 response
    'if not in command mode, abort

    transmit "AT"
    transmit crlf$
    zzz = TIMER + .6
    WHILE TIMER < zzz
    WEND

    'now loop, grabbing chars and saving in string until no more come in

    atcheck$ = ""

    WHILE DataWaiting%
       atcheck$ = atcheck$ + CHR$(ReadChar%)
    WEND


    IF INSTR(atcheck$, "OK") = 0 AND INSTR(atcheck$, "0") = 0 THEN
       'send ato just in case
       transmit "ATO"
       transmit crlf$
       zzz = TIMER + 3
       WHILE TIMER < zzz
       WEND
       GOSUB PutLine
       GOSUB ClearRcv

       GOSUB NewLine
       GOSUB Yellow
       ln$ = "STGEN cannot get modem into command mode!"
       GOSUB PutLine
       GOTO bombout
    END IF
    GOSUB ClearRcv

    'issue ato1 to modem
    transmit "ATO1"
    transmit crlf$
    'wait 3 sec for the modem to process the command

    zzz = TIMER + 3
    WHILE (TIMER < zzz)
    WEND
    IF CallerMode% = 0 THEN
        'if not using DTR switching, send 3 backspaces
        for bk = 1 to 3
           transmit Bksp$
           print rub$;
        next
        GOSUB Yellow
        ln$ = "Modem Retrain successfully completed ..."
        GOSUB PutLine
    END IF
    GOSUB ClearRcv
 END IF

'if in door mode, and if file STGEXIT.TXT is present, display it and wait for keypress

    GOSUB NewLine
    ln$ = "Do you want to view an explanation of these screens? [y/N]: "
    gosub yellow
    gosub putwords
    zzz = TIMER + 300
    yn$ = ""
    WHILE DataWaiting% = 0 AND yn$ = "" AND TIMER < zzz
       IF CarrierLost THEN GOTO bombout
       yn$ = INKEY$
    WEND
    IF DataWaiting% <> 0 THEN
       yn$ = CHR$(ReadChar%)
    END IF
    yn$ = UCASE$(yn$)
    PRINT
    IF CallerMode% = 0 THEN
        GOSUB NewLine
    END IF
    IF yn$ <> "Y" THEN GOTO noexitfileb 'don't show it
    DispFile$ = "STGEXIT.TXT"
    GOSUB ShowFile
noexitfileb:
    CLOSE #1
    ON ERROR GOTO bombout

bombout:
 CLOSE
 CloseComm

 LOCATE , , 0
 END

'end of main code

'=========================================================================
'get from modem and write to disk, file 1 is already opened

mdmtodisk:

 mbuff$ = ""

 'wait up to 5 seconds for first character to arrive
 zzzz = TIMER + 5
 WHILE TIMER < zzzz AND DataWaiting% = 0
 WEND

 'if no chars have arrived, then something is wrong, so just exit
 IF DataWaiting% = 0 THEN RETURN


mdmtodisk2:

 'loop, getting characters from modem and writing
 'to disk file until no more come in
 WHILE DataWaiting%
    mbuff$ = mbuff$ + CHR$(ReadChar%)
 WEND

 'wait up to 3 seconds to see if another character arrives
 zzzz = TIMER + 3
 WHILE TIMER < zzzz AND DataWaiting% = 0
 WEND

 'if another character came in then go back into the read loop
 IF DataWaiting% THEN GOTO mdmtodisk2

 PRINT #1, mbuff$;

 RETURN

'===================================================================
ShowFile:
    GOSUB NewPage
    ON ERROR GOTO noshowfile
    OPEN DispFile$ FOR INPUT AS #1
    Finish%  = False%
    NoBreak% = False%
    LCount% = 0
    GOSUB Yellow
    DO WHILE NOT EOF(1)
       LINE INPUT #1, ln$
       IF INSTR(ln$,"MORE:") > 0 THEN
          GOSUB PageBreak
          LCount% = 0
       ELSE
           LCount% = LCount% + 1
           GOSUB PutLine
       END IF
       IF LCount% > (ScrLen& -1) THEN
          GOSUB PageBreak
          LCount% = 0
       END IF
       IF (Finish% = True%) THEN EXIT DO
    LOOP
    CLOSE #1
    IF (Finish% = FALSE) THEN GOSUB PageBreak
noshowfileB:
    CLOSE #1
    ON ERROR GOTO bombout
    RETURN

noshowfile:
  RESUME noshowfileB

'===================================================================
ClearRcv:
    WHILE DataWaiting%
       dummy% = ReadChar%
       ClearInputBuffer
    WEND
    ClearInputBuffer
    RETURN

'===================================================================
ReadDoorSys:
    ON ERROR GOTO NoDoorSys
     OPEN "I",#1,"DOOR.SYS"
    FOR X = 1 TO 36
        IF EOF(1) THEN EXIT FOR
        LINE INPUT #1, INFO$(X)
    NEXT X
    CLOSE #1
'
'assign the data to variables
'
'note that most aren't used in this program, but it's all kept to
'maintain a generic routine '

    FULLNAME$ = INFO$(10)       'user's full name
    BAUDRATE$ = INFO$(2)        'code for user's baud, no convert needed
    CITY$     = INFO$(11)        'city and state of origin
    Security& = VAL(INFO$(15))   'security level
    MinLeft&  = VAL(INFO$(19))   'minutes remaining this call
    GRAPHIC$  = INFO$(20)        'COLOR or MONO
    PASSWORD$ = INFO$(14)        'user's password (lower case)
    UserRec&  = VAL(INFO$(26))   'user record number
    FOLDER$   = INFO$(23)       'folders (conferences) joined
    DayDlKBt& = VAL(INFO$(30))  'download kbytes today
    DayDlKBM& = VAL(INFO$(31))  'max download kbytes allowed today
    PHONE$    = INFO$(12)       'users phone number
    HLPLVL$   = INFO$(22)       'EXPERT or NOVICE
    DEFDLP$   = INFO$(27)       'preferred protocol or All
    CallCnt&  = VAL(INFO$(16))  'times called total
    ScrLen&   = VAL(INFO$(21))  'lines per page
    ULCount&  = VAL(INFO$(28))  'upload count total
    DLCount&  = VAL(INFO$(29))  'download count total
    Databits  = VAL(INFO$(3))  'databits (7 or 8)
    WHERE$    = INFO$(1)       'REMOTE or LOCAL
    CMPT$     = INFO$(1)       'active com port
    PORTBAUD$ = INFO$(5)       'baud rate of com port
    NodeID    = VAL(INFO$(4))  'node number


BaudConv:
    'these may be used to calculate transfer times or whatever, but
     'PORTBAUD$ is used for actual communications baud rate
     '
    IF BAUDRATE$ = "0" THEN BAUDRATE$ = "2400"
    IF BAUDRATE$ = "1" THEN BAUDRATE$ =  "300"
    IF BAUDRATE$ = "2" THEN BAUDRATE$ = "1200"
    IF BAUDRATE$ = "3" THEN BAUDRATE$ = "9600"
    IF BAUDRATE$ = "4" THEN BAUDRATE$ = "19200"
    IF BAUDRATE$ = "5" THEN BAUDRATE$ = "38400"
    IF Databits = 7 THEN
        Parity = 2
    ELSE
        Parity = 0
    END IF
    Cmpt$ = LEFT$(Cmpt$,4)

    IF WHERE$ = "COM0:" THEN
        WHERE$ = "LOCAL"
    ELSE
        WHERE$ = "REMOTE"
    END IF

    IF HLPLVL$ = "Y" THEN
        HLPLVL$ = "EXPERT"
    ELSE
        HLPLVL$ = "NOVICE"
    END IF

    IF BBSNode = 0 THEN BBSNode = NodeID
    IF Where$ = "LOCAL" THEN CallerMode = 1
    IF ScrLen& = 0 THEN ScrLen& = 23
    IF INSTR(GRAPHIC$,"GR") > 0 THEN
        GRAPHIC$ = "COLOR"
        VideoMode$ = "3"
    END IF
    IF INSTR(GRAPHIC$,"RIP") > 0 THEN
        GRAPHIC$ = "COLOR"
        VideoMode$ = "3"
    END IF
'
Grafix:
    ESC$=CHR$(27)                   'Escape character
    IF GRAPHIC$ = "COLOR" THEN
         GRAPHICS = True%
         BLACK$   = ESC$+"[0;40;30m"
         BLUE$    = ESC$+"[1;34;40m"
         GREEN$   = ESC$+"[1;32;40m"
         CYAN$    = ESC$+"[1;36;40m"
         RED$     = ESC$+"[1;31;40m"
         MAGENTA$ = ESC$+"[1;35;40m"
         YELLOW$  = ESC$+"[1;33;40m"
         WHITE$   = ESC$+"[1;37;40m"
         GRAY$    = ESC$+"[0;37;40m"
     ELSE
         GRAPHICS = False%
         BLACK$   = ""
         BLUE$    = ""
         GREEN$   = ""
         CYAN$    = ""
         RED$     = ""
         MAGENTA$ = ""
         YELLOW$  = ""
         WHITE$   = ""
         GRAY$    = ""
     END IF

     GPOS=INSTR(FULLNAME$," ")
     IF GPOS > 0 AND (LEN(FullName$) > GPos) THEN
        FIRST$ = LEFT$(FULLNAME$,GPOS-1)
        LAST$  = MID$(FULLNAME$,GPOS+1)
     ELSE
        FIRST$ = FULLNAME$
     END IF
     RETURN

BLACK:
     IF Graphics = False% THEN GOTO MONO
     COLOR 0,0
     OT1$=BLACK$
     RETURN

BLUE:
	IF Graphics = False% THEN GOTO MONO
	COLOR 9,0
	OT1$=BLUE$
	RETURN

GREEN:
	IF Graphics = False% THEN GOTO MONO
	COLOR 10,0
	OT1$=GREEN$
	RETURN

CYAN:
	IF Graphics = False% THEN GOTO MONO
	COLOR 11,0
	OT1$=CYAN$
	RETURN

RED:
	IF Graphics = False% THEN GOTO MONO
	COLOR 12,0
	OT1$=RED$
	RETURN

MAGENTA:
	IF Graphics = False% THEN GOTO MONO
	COLOR 13,0
	OT1$=MAGENTA$
	RETURN

YELLOW:
	IF Graphics = False% THEN GOTO MONO
	COLOR 14,0
	OT1$=YELLOW$
	RETURN

WHITE:
	IF Graphics = False% THEN GOTO MONO
	COLOR 15,0
	OT1$=WHITE$
	RETURN

GRAY:
	IF Graphics = False% THEN GOTO MONO
	COLOR  7,0
	OT1$=GRAY$
	RETURN

MONO:
	COLOR 7, 0
	OT1$ = ""
	RETURN

'---------------------------------------------------------------------------
PutLine:
	GOSUB PutWords
	GOSUB NewLine
	RETURN

'---------------------------------------------------------------------------
PutWords:
	if CallerMode% = 1 THEN GOTO PutWords1
        IF Ot1$ <> "" THEN
           Transmit Ot1$ 'color info
           Ot1$ = "" 'then null out
	END IF
	IF Ln$ = "" THEN GOTO PutWords99 'don't call with nul$
        Transmit Ln$
PutWords1:
	PRINT Ln$;
PutWords99:
        Ln$ = ""
        RETURN

'---------------------------------------------------------------------------
NewLine:
	if CallerMode% = 1 THEN GOTO NewLine1
        Transmit CrLf$
NewLine1:
	PRINT
        IF ScrLen& = 0 THEN GOTO NewLine2
	LCount% = LCount% + 1
        IF NoBreak% = True% THEN LCount% = 0
        IF LCount% > ScrLen& THEN GOSUB PageBreak
NewLine2:
	RETURN

'---------------------------------------------------------------------------
NewPage:
	if CallerMode% = 1 THEN GOTO NewPage1
	Ln$ = ""
        Transmit CHR$(12)
NewPage1:
        CLS
	LCount% = 0
	RETURN

'---------------------------------------------------------------------------
EraseLine:
	FOR EL = 1 TO Backup
           if CallerMode% = 1 THEN GOTO EraseLine1
           Status = WriteChar(8)
           IF Status = 0 THEN GOTO EraseLine99
           Status = WriteChar(32)
           IF Status = 0 THEN GOTO EraseLine99
           Status = WriteChar(8)
           IF Status = 0 THEN GOTO EraseLine99
EraseLine1:
           PRINT Rub$;
	NEXT
EraseLine99:
        RETURN

'---------------------------------------------------------------------------
PageBreak:
        IF NoBreak% = True% THEN   'we don't pause
            LCount% = 0
            GOTO PageBreak99
        END IF
        Ln$ = " [C]ontinue, [S]top, [N]onstop: "
	GOSUB Yellow
	GOSUB PutWords
        GOSUB GetChar
        Char$ = UCASE$(Char$)
        IF Char$ <> CHR$(13) THEN
                Transmit Char$
                PRINT Char$;
        END IF
        IF Char$ = "N" THEN
                NoBreak% = True%
        ELSE
                NoBreak% = False%
        END IF
        IF Char$ = "S" THEN Finish% = True%
        LCount% = 0
	IF Char$ = CHR$(13) THEN
                Backup = 32
	ELSE
                Backup = 33
	END IF
	GOSUB EraseLine
PageBreak99:
	RETURN

'---------------------------------------------------------------------------
GetLine:
	Accept$ = ""
	InWork$ = ""
GetLine1:
	GOSUB GetChar
        IF ASC(Char$) = 127 THEN Char$ = CHR$(8)
        LW = LEN(InWork$)
        IF ASC(Char$) = 8 THEN
            IF (LW = 0) THEN
                GOTO GetLine1
            ELSE
                Backup = 1
                GOSUB EraseLine
                Char$ = ""
                IF LW > 1 THEN
                    InWork$ = LEFT$(InWork$,LW-1)
                ELSE
                    InWork$ = ""
                END IF
            END IF
        END IF
        if CallerMode% = 1 THEN GOTO GetLine2
	IF Char$ = CHR$(13) THEN
                Transmit CrLf$
	END IF
GetLine2:
	IF Char$ = CHR$(13) THEN
            PRINT
            GOTO GetLine3
        END IF
        IF Char$ <> "" THEN
            Transmit Char$
            PRINT Char$; 'show character locally
            InWork$ = InWork$ + Char$
        END IF
        GOTO GetLine1
GetLine3:
	RETURN

'---------------------------------------------------------------------------
GetChar:
	Char$ = INKEY$
	IF Char$ <> "" THEN GOTO GetChar2
	if CallerMode% = 1 THEN GOTO GetChar
GetChar1:
        IF DataWaiting THEN
            Char$ = CHR$(ReadChar%)
        ELSE
            GOTO GetChar
        END IF
GetChar2:
        IF Accept$ <> "" THEN
            Char$ = UCASE$(Char$)
            IF INSTR(Accept$,Char$) = 0 THEN GOTO GetChar
            Accept$ = ""
        END IF
        RETURN

'---------------------------------------------------------------------------
NoDoorSys:
    RESUME NoDoorSys1
NoDoorSys1:
    ON ERROR GOTO bombout
    IF VideoMode$ = "3" THEN
        Graphic$ = "COLOR"
    ELSE
        Graphic$ = "MONO"
    END IF
    IF ScrLen& = 0 THEN ScrLen& = 23
    GOTO Grafix
'---------------------------------------------------------------------------

