#define EZY110

#include <time.h>
#include <getopt.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <io.h>
#include <share.h>
#include <alloc.h>
#include <sys\stat.h>
#include <fcntl.h>
#include <string.h>
#include <process.h>
#include <stdarg.h>
#include "lib\ezy.hpp"
#include "lib\tasker.hpp"
#include "lib\misc.h"
#include "lib\keys.h"
#include "lib\vio.h"
#include "lib\scaldate.hpp"
#include "help.h"

// Program related definitions for development, etc
#define PROG "The Ultimate Multi-purpose Utility 1.2 -- Copyright 1995 Matthew Smith"
#define PROGVER EZYVER

#define H_STRING  1
#define H_INTEGER 2
#define H_LONGINT 3

#define VAR_CHAR '@'
#define BUFFER 100
#define MAXAREAS 65000      /* Maximum Area # -- 400 for Ezycom 1.02 */
#define FILEREADBUFFER 10   /* File record buffer -- (reading filexxx.bbs)*/
#define HEADERBUFFER 4001   /* Length of Header */ // get rid of this.
#define TRUE    1
#define FALSE   0

// Interpreters for DOS Packed DateTime
#define ts_year(ts)  ((int)((ts >> 25) & 0x7f) + 1980)
#define ts_month(ts) ((int)(ts >> 21) & 0x0f)      /* 1..12 means Jan..Dec */
#define ts_day(ts)   ((int)(ts >> 16) & 0x1f)      /* 1..31 means 1st..31st */
#define ts_hour(ts)  ((int)(ts >> 11) & 0x1f)
#define ts_min(ts)   ((int)(ts >> 5) & 0x3f)
#define ts_sec(ts)   ((int)((ts & 0x1f) * 2))

// 0 based!
#define WINDOW(x1,y1,x2,y2) {Vleft=x1; Vright=x2; Vtop=y1; Vbottom=y2;}
#define SAVEcur() {savex=VIOwherex(); savey=VIOwherey();}
#define RESTcur() {VIOgotoxy(savex,savey);}

static int savex=0,savey=0;
static int Vtop=0,Vbottom=24,Vleft=0,Vright=79;
int function_number = 0;        // Function that run this execution

ezycom ezy;

// UMPU sub-tasks
void print_help(void);
void exit_prog(void);
void wait_sem(char *filename, int checkseconds, int noesc);
void set_uinfo(int wnode, char *towhat);
void set_ninfo(int wnode, char *towhat);
void view_dbatch(int wnode);

// MESSAGES.EZY
void create_abbs    (unsigned int start, unsigned int end, char group, char egroup, char *aname, int tagonly);
void icomb          (unsigned int start, unsigned int end, char group, char egroup, int offon, int whocares);
void import_na      (unsigned int start, unsigned int end, char group, char egroup, int redesc, char *nafilename, int column);
void list_mtag      (unsigned int start, unsigned int end, char group, char egroup, char *mtag);

// Filebase
void replace_desc   (unsigned int start, unsigned int end, char group, char *oldstr, char *newstr);
void create_dscfiles(unsigned int start, unsigned int end, char group, char filesbbs[13], int makehidden, int alt, int nopipe, int onelinedesc, int nostrip);
void remove_fbcr    (unsigned int start, unsigned int end, char group, int nohi);
void import_fbbs    (unsigned int start, unsigned int end, char group, int cdrom, int fileid, int nodelete, int dpos, int ignorecr);
void create_headers (unsigned int start, unsigned int end, char group, char *hconfig);
void del_fbbs       (unsigned int start, unsigned int end, char group, char *aname);
void mlist_set      (unsigned int start, unsigned int end, char group, int onset, int mastset);
void assign_queue   (unsigned int start, unsigned int end, char group, char *pathstr, int queuenum);
void del_old_files  (unsigned int start, unsigned int end, char group, int daysold, int nodelete, int usedate);

// Userbase (Users.bbs and usersext.bbs)
void apply_system_colors       (unsigned int userfrom, unsigned int userto, char sec_logic[2], unsigned int security, unsigned char flag_mask[4][8], char age_logic[2], unsigned int age, char lc_logic[2], unsigned int lc, char phonestr[15]);
void list_users                (unsigned int userfrom, unsigned int userto, char sec_logic[2], unsigned int security, unsigned char flag_mask[4][8], char age_logic[2], unsigned int age, char lc_logic[2], unsigned int lc, char phonestr[15]);
void create_user_expire_profile(unsigned int userfrom, unsigned int userto, char sec_logic[2], unsigned int security, unsigned char flag_mask[4][8], char age_logic[2], unsigned int age, char lc_logic[2], unsigned int lc, char phonestr[15], int report, char *outputfile, char day_logic[2], unsigned int days, int send_msg);
void apply_end_rego_dates      (unsigned int userfrom, unsigned int userto, char sec_logic[2], unsigned int security, unsigned char flag_mask[4][8], char age_logic[2], unsigned int age, char lc_logic[2], unsigned int lc, char phonestr[15], int options);

// MSGFAST.BBS
void compress_message_fast(unsigned int userfrom, unsigned int userto);


// Questionnaire files
int purge_qa(char *filename, char *saveold);

// Ezycom type support functions (validation stuff)
int valid_security(char sec_logic[2], unsigned int security, unsigned int user_sec);
int valid_flags(FlagType flags[4], unsigned char flag_mask[3][8]);
int determine_age(unsigned int month, unsigned int day, unsigned int year);
unsigned int days_since_lastcall(long lastcall_date);


// Misc support functions
void toggle_hidden(char *filename, int onoff);
void VIOprintf(char *control, ...);
long filesize(FILE *stream);
unsigned getkey(void);

int bit_s(unsigned char bbyte, int bnum);  // 0 based bit numbers (#0 = bit1)

extern "C" { unsigned long far pascal _export crc32(void far *pBuf, unsigned int len, unsigned long crc); }
size_t commafmt(char *buf,int bufsize, long N);
char *StrReplace(char *Str, char *OldStr, char *NewStr);

int main(int argc,char *argv[])
{
if(argc < 1)
   {
      /* Check that EXE filename has been provided. */
      printf("\r\nEXE file name is unknown.\r\n");
      return(0);
   }

/*
    Value of function_number        Function Manipulates
        
       0 through 999                    Messagebase
       1000 through 1999                Filebase
       2000 through 2999                Userbase
       3000 through 3999                --------
       4000 through 4999                MSGFAST.BBS
       5000 through 5999                Questionnaire files
       6000 through 6999                Misc
       7000 through xxxx                Multi-line stuff
    Specifically

     1 = Create Areas.bbs
     2 = -------------------
     3 = import fidonet.na
     4 = turn int combined on
     5 = turn int combined off
     6 = List message area tags
  1001 = replace desc.
  1002 = create files.bbs
  1003 = remove newlines in descs
  1004 = import files.bbs
  1005 = Delete old files
  1006 = File area headers         (with template)
  1007 = delete files.bbs
  1008 = set masterlist
  1009 = Assign Queue number
  2000 = apply system colors
  2001 = list users
  2002 = create expire profile
  2003 = apply end-rego dates
  4000 = Compress MSGFAST.BBS
  5000 = Compress Questionnaire response file
  5001 = Compress Questionnaire response file (saving purged responses to file)
  6000 = Log text to file
  6001 = Wait for semaphore
  6002 = View Download batch
  7000 = Set NodeInfo.x
  7001 = Set UserInfo.x
  7002 = Send online message
  7003 = Set Nodes Basic Info
*/

unsigned int from = 1;
unsigned int to = 65000;
int node = 0;
int column = 0;
int helprequested = 0;
char templ[13] = "HEADER1.CFG";
char assignqueue[15] = "\0";
char logtext[81] = "\0";
char oldstr[81] = "\0";
char newstr[81] = "\0";
char sec_logic[2] = "]=";
char day_logic[2] = "]=";
char lc_logic[2] = "]=";
char age_logic[2] = "]=";
char saveold[MAXFILEPATHLENGTH] = "\0";
unsigned int lc = 0;
unsigned int security = 0;
unsigned int days = 0;
unsigned int age = 0;
int delage = -1;
int tagonly = 0;
int redesc = 0;
int ezymast = 0;
int mastonline = 0;
int mlist = 0;
int createheaders = 0;
int nodelete = 0;
int cdrom = 0;
int fileid = 0;
int impfbbs = 0;
int dpos = 0;
int ignorecr = 0;
int abbs = 0;
int createfbbs = 0;
int cmpmsgfast = 0;
int hidefbbs = 0;
int delfbbs = 0;
AreaTagStr mtag = "\0";
char semwaitfile[13] = "\0";
char aname[13] = "\0";
char group[1] = "*";
char egroup[1] = "*";
char ic[4] = "\0";
int xprofile = 0;
int altfbbs = 0;
int sendomessage = 0;
char fuser[36] = "\0";
char sninfo[161] = "\0";
char suinfo[41] = "\0";
char phonestr[15] = "\0";
int app_colors = 0;
int ulist = 0;
int removecr = 0;
int nohi = 0;
int dnode = 0;                  // destination node
int nostrip = 0;
int end_rego = 0;
int onode = 0;                  // origin node
int nopipe = 0;
char onmsg[81] = "\0";
int omsgprivate = 0;
char na2ezyfile[13] = "\0";
int checkseconds = 5;
int usedate = 1;
int noesc = 0;
int vdbatch = 0;
int setnode = 0;
int nodisturb = 0;
int report = 0;
int smsg = 0;
int onelinedesc = 0;
unsigned char u_flags[4][8];
char purgeqafile[MAXFILEPATHLENGTH] = "\0";
OnlineRecord setnoderec;

        for(int h=0;h<=3;h++)
        {
            for(int i=0;i<=7;i++)
            {
            u_flags[h][i]='-';
            }
            u_flags[h][8]=NULL;
        }

opt_t opttable[] =
{
    { "from", OPTINT, &from },
    { "to", OPTINT, &to },
    { "template", OPTSTR, templ },
    { "log", OPTSTR, logtext },
    { "node", OPTINT, &node },
    { "?", OPTBOOL, &helprequested },
    { "Help", OPTBOOL, &helprequested },
    { "headers", OPTBOOL, &createheaders },
    { "fbbs", OPTBOOL, &createfbbs },
    { "hide", OPTBOOL, &hidefbbs },
    { "aname", OPTSTR, aname },
    { "afbbs", OPTBOOL, &altfbbs },
    { "onmsg", OPTBOOL, &sendomessage },
    { "fu", OPTSTR, fuser },
    { "tn", OPTINT, &dnode },
    { "fn", OPTINT, &onode },
    { "msg", OPTSTR, onmsg },
    { "pvt", OPTBOOL, &omsgprivate },
    { "dma", OPTSTR, na2ezyfile },
    { "dfbbs", OPTBOOL, &delfbbs },
    { "sui", OPTSTR, suinfo },
    { "sni", OPTSTR, sninfo },
    { "vdbatch", OPTBOOL, &vdbatch },
    { "setnode", OPTBOOL, &setnode },
    { "user", OPTSTR, setnoderec.Name },
    { "alias", OPTSTR, setnoderec.Alias },
    { "location", OPTSTR, setnoderec.Location },
    { "dnd", OPTBOOL, &nodisturb },
    { "status", OPTINT, &setnoderec.Status },
    { "baud", OPTLONG, &setnoderec.Baud },
    { "purgeqa", OPTSTR, purgeqafile },
    { "cmpmsgfast", OPTBOOL, &cmpmsgfast },
    { "nopipe", OPTBOOL, &nopipe },
    { "oneline", OPTBOOL, &onelinedesc },
    { "nostrip", OPTBOOL, &nostrip },
    { "removecr", OPTBOOL, &removecr },
    { "nohi", OPTBOOL, &nohi },
    { "waitsem", OPTSTR, semwaitfile },
    { "seconds", OPTINT, &checkseconds },
    { "noesc", OPTBOOL, &noesc },
    { "d_replace", OPTSTR, oldstr },
    { "with", OPTSTR, newstr },
    { "column", OPTINT, &column },
    { "areasbbs", OPTBOOL, &abbs },
    { "egroup", OPTSTR, egroup },
    { "group", OPTSTR, group },
    { "icomb", OPTSTR, ic },
    { "ifbbs", OPTBOOL, &impfbbs },
    { "fileid", OPTBOOL, &fileid },
    { "cdrom", OPTBOOL, &cdrom },
    { "nodelete", OPTBOOL, &nodelete },
    { "aflag", OPTSTR, u_flags[0] },
    { "bflag", OPTSTR, u_flags[1] },
    { "cflag", OPTSTR, u_flags[2] },
    { "dflag", OPTSTR, u_flags[3] },
    { "ulist", OPTBOOL, &ulist },
    { "sl", OPTSTR, sec_logic },
    { "dl", OPTSTR, day_logic },
    { "lcl", OPTSTR, lc_logic },
    { "al", OPTSTR, age_logic },
    { "age", OPTINT, &age },
    { "lcall", OPTINT, &lc },
    { "security", OPTINT, &security },
    { "applycolors", OPTBOOL, &app_colors },
    { "xprofile", OPTBOOL, &xprofile },
    { "days", OPTINT, &days },
    { "smsg", OPTBOOL, &smsg },
    { "report", OPTINT, &report },
    { "redesc", OPTBOOL, &redesc},
    { "desc", OPTINT, &dpos },
    { "ignorecr", OPTBOOL, &ignorecr },
    { "applyendregdates", OPTBOOL, &end_rego },
    { "ezymast", OPTINT, &mastonline },
    { "ezyonline", OPTINT, &ezymast },
    { "mlistset", OPTBOOL, &mlist },
    { "phone", OPTSTR, phonestr },
    { "tagonly", OPTBOOL, &tagonly },
    { "saveold", OPTSTR, saveold },
    { "listmtag", OPTSTR, &mtag },
    { "assignqueue", OPTSTR, &assignqueue },
    { "deloldfiles", OPTINT, &delage },
    { "usedate", OPTINT, &usedate },
    { NULL, 0, NULL }

};

getopts(argc,argv,opttable);

change_(onmsg);
change_(fuser);

if(abbs)                   function_number = 1;
if(0)                      function_number = 2;
if(na2ezyfile[0] != NULL)  function_number = 3;
if(ic[0])
 if(strcmpi(ic,"on") == 0) function_number = 4;
    else                   function_number = 5;
if(mtag[0])                function_number = 6;
if(oldstr[0] != NULL)      function_number = 1001;
if(createfbbs)             function_number = 1002;
if(removecr)               function_number = 1003;
if(impfbbs)                function_number = 1004;
if(delage > -1)            function_number = 1005;
if(createheaders)          function_number = 1006;
if(delfbbs)                function_number = 1007;
if(mlist)                  function_number = 1008;
if(assignqueue[0])         function_number = 1009;
if(app_colors)             function_number = 2000;
if(ulist)                  function_number = 2001;
if(xprofile)               function_number = 2002;
if(end_rego)               function_number = 2003;
if(cmpmsgfast)             function_number = 4000;
if(purgeqafile[0] != NULL)
                if (saveold[0] == NULL)
                           function_number = 5000;
                    else
                           function_number = 5001;
if(logtext[0] != NULL)     function_number = 6000;
if(semwaitfile[0] != NULL) function_number = 6001;
if(vdbatch && node != 0)   function_number = 6002;
if(sninfo[0] != NULL &&
   node != 0)              function_number = 7000;
if(suinfo[0] != NULL &&
   node != 0)              function_number = 7001;
if(sendomessage &&
   fuser[0] != NULL &&
   dnode >=1 && dnode <=255
   && onode >=1 && dnode <=255
   && onmsg[0] != NULL)    function_number = 7002;
if(setnode && node != 0)   function_number = 7003;

if(VIOopen() != 0)
    {
    printf(" Error Initializing Screen handler");
    exit(1);
    }
else
    {
    atexit(exit_prog);
    }

clrscr();
VIOclear(0,0,79,24);
VIOprintf(" UMPU %s Public Domain Version by Matthew Smith\r\n",PROGVER);
VIOprintf(" UMPU -? for Command Line Help\r\n");

VIOsetfore(7);

if(helprequested)
    {
    print_help();
    exit(1);
    }
else
    {
        switch(ezy.load_config(NULL))
        {
            case 0:
                VIOprintf("Unable to Locate Config.ezy");
                exit(1);
            case 1: // Successful
                // VIOprintf(" %s loaded.\r\n",ezy.configfile);
                // VIOprintf(" %s loaded.\r\n",ezy.constantfile);
                break;
            case 2:
                VIOprintf("Ezycom environment variable not set\r\n");
                exit(1);
            case 3:
                VIOprintf("Unsuccessful loading %s\r\n", ezy.configfile);
                exit(1);
            case 4:
                VIOprintf("Unable to read %s\r\n",ezy.configfile);
                VIOprintf("Corrupted Config file/unsuccesful reading from config file.\r\n");
                exit(1);
            case 5:
                VIOprintf("Unsuccessful locating constant.ezy\r\n");
                exit(1);
            case 6:
                VIOprintf("Unsuccessful loading %s\r\n", ezy.constantfile);
                exit(1);
            case 7:
                VIOprintf("Unable to read %s\r\n",ezy.constantfile);
                VIOprintf("Corrupted Constant file/unsuccessful reading from constant file.\r\n");
                exit(1);
            }

            out:
    }


if(function_number >= 1000 && function_number < 2000 && to > ezy.Constant.MaxFile)
{
    to=ezy.Constant.MaxFile;
}
else
if(function_number >= 1 && function_number < 1000 && to > ezy.Constant.MaxMess)
{
    to=ezy.Constant.MaxMess;
}

if(from <= 0) from = 1;

switch(function_number) {
        case     1:
            create_abbs(from,to,group[0],egroup[0],aname,tagonly);
            break;
        case     2:
            break;
        case     3:
            import_na(from,to,group[0],egroup[0],redesc,na2ezyfile,column);
            break;
        case     4:
            icomb(from,to,group[0],egroup[0],1,0);
            break;
        case     5:
            icomb(from,to,group[0],egroup[0],0,1);
            break;
        case     6:
            list_mtag(from,to,group[0],egroup[0],mtag);
            break;
        case  1001:
            replace_desc(from,to,group[0],oldstr,newstr);
            break;
        case  1002:
            create_dscfiles(from,to,group[0],aname,hidefbbs,altfbbs,nopipe,onelinedesc,nostrip);
            break;
        case  1003:
            remove_fbcr(from,to,group[0],nohi);
            break;
        case  1004:
            import_fbbs(from,to,group[0],cdrom,fileid,nodelete,dpos,ignorecr);
            break;
        case  1005:
            del_old_files(from,to,group[0],delage,nodelete,usedate);
            break;
        case  1006:
            create_headers(from,to,group[0],templ);
            break;
        case  1007:
            del_fbbs(from,to,group[0],aname);
            break;
        case 1008:
            mlist_set(from, to, group[0], mastonline, ezymast);
            break;
        case 1009:
            char pathstring[MAXFILEPATHLENGTH];
            int queue_number = 0;
            sscanf(assignqueue, "%d,%s", &queue_number, &pathstring);
            assign_queue(from,to,group[0], pathstring, queue_number);
            break;
        case  2000:
            apply_system_colors(from,to,sec_logic,security,u_flags,age_logic,age,lc_logic,lc,phonestr);
            break;
        case  2001:
            list_users(from,to,sec_logic,security,u_flags,age_logic,age,lc_logic,lc,phonestr);
            break;
        case  2002:
            create_user_expire_profile(from, to, sec_logic, security, u_flags, age_logic, age, lc_logic, lc, phonestr, report, aname, day_logic, days, smsg);
            break;
        case  2003:
            apply_end_rego_dates(from,to,sec_logic,security,u_flags, age_logic, age, lc_logic, lc, phonestr, 0);
            break;
        case  4000:
            compress_message_fast(from,to);
            break;
        case  5000:
            purge_qa(purgeqafile, NULL);
            break;
        case  5001:
            purge_qa(purgeqafile, saveold);
            break;
        case  6000:
            int stream;
            struct time t;
            char nodestring[4];
            char logline[81];
            change_(logtext);
            gettime(&t);
            sprintf(nodestring,"%d",node);
            StrReplace(ezy.config.LogPath,"*N",nodestring);
            sprintf(logline,"> %02d:%02d:%02d  %s\n",t.ti_hour,t.ti_min,t.ti_sec,logtext);
            VIOprintf("\r\n Opening %s",ezy.config.LogPath);
            if(!exists(ezy.config.LogPath))
                {
                VIOprintf("\r\n Log File does not exist");
                exit(1);
                }
            else
                if((stream=sopen(ezy.config.LogPath, O_CREAT|O_APPEND|O_TEXT|O_WRONLY,S_IWRITE|SH_DENYNO)) < 1)
                    {
                    VIOprintf("\r\n Error opening Log File\r\n");
                    exit(1);
                    }
            VIOprintf("\r\n Node       : %d",node);
            VIOprintf("\r\n Writing to : %s",ezy.config.LogPath);
            write(stream,logline,strlen(logline));
            close(stream);
            break;
        case  6001:
            wait_sem(semwaitfile, checkseconds, noesc);
            break;
        case  6002:
            view_dbatch(node);
            break;
        case  7000:
            set_ninfo(node,sninfo);
            break;
        case  7001:
            set_uinfo(node,suinfo);
            break;
        case  7002:
            VIOprintf("Sending Online Message . . .\r\n");
            ezy.send_omessage(fuser, onode, dnode, onmsg, omsgprivate);
            break;
        case  7003:
            VIOprintf("Setting Node info for node %d. . .\r\n",node);
            if(nodisturb)
                setnoderec.Attribute |= 0x01;     // Turn on the 'Do not disturb'
            ezy.set_node(node,&setnoderec);
            break;
        case 0:
        default:
            VIOprintf("Nothing to Do . . . \r\n");
            break;
}

// gotoxy(1,VIOwherey()+1);
return(0);
}

char *handle_string(int type, void *variable, int justlength, char justtype, char fillchar, char commait, int soffset)
{
    char *newstring;
    char formstring[50];
    char comma_num[20];
    char justchar = '-';


    if(justtype == 'L') justchar = '-';
    else
    if(justtype == 'R') justchar = '+';
    else
    if(justtype == 'C') justchar = '-';

    if((newstring = (char *)malloc(justlength+1)) == NULL)
        return("");

    switch(type) {
        case H_STRING: // String
            sprintf(formstring, "%%%c%d.%ds", justchar, justlength, justlength);
            sprintf(newstring, formstring, (char *)variable);
            break;
        case H_INTEGER: // Integer
            if(commait)
            {
                long templong = (*(int *)variable);
                sprintf(formstring, "%%%c%d.%ds", justchar, justlength, justlength);
                commafmt(comma_num,20,templong);
                sprintf(newstring, formstring, comma_num);
            }
            else
            {
                sprintf(formstring, "%%%c%d.%dd", justchar, justlength, justlength);
                sprintf(newstring, formstring, *((int *)variable));
            }
            break;
        case H_LONGINT: // Longint
            if(commait)
            {
                commafmt(comma_num,20,*((long *)variable));
                sprintf(formstring, "%%%c%d.%ds", justchar, justlength, justlength);
                sprintf(newstring, formstring, comma_num);
            }
            else
            {
                sprintf(formstring, "%%%c%d.%dld", justchar, justlength, justlength);
                sprintf(newstring, formstring, *((long *)variable));
            }
            break;
        }


/*    if(justtype == 'C' && justlength > 2) // Center string
    {
        int startpos = 0;

        if(justlength % 2 == 0)
            startpos = (justlength / 2) -
        else
            startpos =


    }
*/

            // Change fill character if necessary
            if(fillchar != ' ')
            {
                    if(justtype == 'L' || justtype == 'C')
                    {
                    for(int tc=0;newstring[++tc] == ' ';)
                        if(newstring[tc] == ' ')
                           newstring[tc] = fillchar;
                   }
                 if(justtype == 'R' || justtype == 'C')
                    {
                    for(int tc=strlen(newstring)-1;newstring[--tc]==' ';)
                        if(newstring[tc] == ' ')
                           newstring[tc] = fillchar;

                    }
            }

return(&newstring[soffset]);
}

int determine_newsize(char *inbuf)
{
int newsize = 0;
char basename[60];
int soffset = 0;
int justlength;
char varname[80];
int counter2;
char justtype,commait,padchar;

    for(int counter=0; counter < strlen(inbuf); counter++)
    {
        if(inbuf[counter] == VAR_CHAR) // Variable start
        {
            if(inbuf[counter+1] == VAR_CHAR)
            {
                counter++;      // Skip @@
                newsize++;      // Still count it though
            }
            else    // Process variable
            {       
                counter++; // Skip '@'
                for(counter2=0;inbuf[counter] != VAR_CHAR && counter2 < 80 && counter < strlen(inbuf);counter2++,counter++)
                {
                    varname[counter2] = inbuf[counter];
                }
                varname[counter2] = 0;

                justlength = -1;
                justtype = 'L';
                commait = 'N';
                padchar = ' ';
                soffset = 0;

                sscanf(varname,"%s %d,%c,%c,%c,%d",&basename,&justlength,&justtype,&commait,&padchar,&soffset);

                if(justlength == -1)
                    {
                        if(strcmpi(basename,"A") == 0)
                            justlength=5;
                        else
                        if(strcmpi(basename,"AREANAME") == 0)
                            justlength=30;
                        else
                        if(strcmpi(basename,"FILES") == 0)
                            justlength=5;
                        else
                        if(strcmpi(basename,"TDLS") == 0)
                            justlength=6;
                        else
                        if(strcmpi(basename,"AREABYTES") == 0)
                            justlength=12;
                        else
                        if(strcmpi(basename,"P") == 0)
                            justlength=3;
                        else
                        if(strcmpi(basename,"POPULAR") == 0)
                            justlength=12;
                        else
                        if(strcmpi(basename,"POPSIZE") == 0)
                            justlength=9;
                        else
                        if(strcmpi(basename,"POPDESC") == 0)
                            justlength=46;
                    }

                newsize+=justlength;

                memset(basename,0,60);
                memset(varname,0,80);
            }
        }
        else    // Normal character
        {
            newsize++;
        }
    }

return(newsize);
}

//
//  Processes a header buffer..... converting control codes, etc.
//
//      outbuf should be a pointer of an unallocated amount.
//
int process_header(char *inbuf, char *outbuf, unsigned int areanumber, char areaname[30], unsigned int areafiles, unsigned int areadownloads, long areabytes, unsigned int mostpopulardownloads, char mostpopular[13], long mostpopularsize, char mostpopulardesc[FLTMAXSIZE+1])
{
int counter2;
char basename[60];
int justlength;
char varname[80];
int soffset = 0;
int counter;
char justtype,commait,padchar;


    for(counter=0; counter < strlen(inbuf)-1; counter++)
    {
        if(inbuf[counter] == VAR_CHAR) // Variable start
        {
            if(inbuf[counter+1] == VAR_CHAR)
            {
                counter++;      // Skip @@
                outbuf[strlen(outbuf)+1] = 0;
                outbuf[strlen(outbuf)] = VAR_CHAR;
            }
            else    // Process variable
            {       
                counter++; // Skip '@'
                for(counter2=0;inbuf[counter] != VAR_CHAR && counter2 < 80 && counter < strlen(inbuf);counter2++,counter++)
                {
                    varname[counter2] = inbuf[counter];
                }
                varname[counter2] = 0;

                justlength = -1;
                justtype = 'L';
                commait = 'N';
                padchar = ' ';
                soffset = 0;

                sscanf(varname,"%s %d,%c,%c,%c,%d",&basename,&justlength,&justtype,&commait,&padchar,&soffset);

                if(justlength == -1)        // Use Defaults
                    {
                        if(strcmpi(basename,"A") == 0)
                            justlength=5;
                        else
                        if(strcmpi(basename,"AREANAME") == 0)
                            justlength=30;
                        else
                        if(strcmpi(basename,"FILES") == 0)
                            justlength=5;
                        else
                        if(strcmpi(basename,"TDLS") == 0)
                            justlength=6;
                        else
                        if(strcmpi(basename,"AREABYTES") == 0)
                            justlength=12;
                        else
                        if(strcmpi(basename,"P") == 0)
                            justlength=3;
                        else
                        if(strcmpi(basename,"POPULAR") == 0)
                            justlength=12;
                        else
                        if(strcmpi(basename,"POPSIZE") == 0)
                            justlength=9;
                        else
                        if(strcmpi(basename,"POPDESC") == 0)
                            justlength=46;
                    }

                        if(strcmpi(basename,"A") == 0)
                            strcat(outbuf,handle_string(H_INTEGER,&areanumber,justlength,justtype,padchar,commait,soffset));
                        else
                        if(strcmpi(basename,"AREANAME") == 0)
                            strcat(outbuf,handle_string(H_STRING,areaname,justlength,justtype,padchar,commait,soffset));
                        else
                        if(strcmpi(basename,"FILES") == 0)
                            strcat(outbuf,handle_string(H_INTEGER,&areafiles,justlength,justtype,padchar,commait,soffset));
                        else
                        if(strcmpi(basename,"TDLS") == 0)
                            strcat(outbuf,handle_string(H_INTEGER,&areadownloads,justlength,justtype,padchar,commait,soffset));
                        else
                        if(strcmpi(basename,"AREABYTES") == 0)
                            strcat(outbuf,handle_string(H_LONGINT,&areabytes,justlength,justtype,padchar,commait,soffset));
                        else
                        if(strcmpi(basename,"P") == 0)
                            strcat(outbuf,handle_string(H_INTEGER,&mostpopulardownloads,justlength,justtype,padchar,commait,soffset));
                        else
                        if(strcmpi(basename,"POPULAR") == 0)
                            strcat(outbuf,handle_string(H_STRING,mostpopular,justlength,justtype,padchar,commait,soffset));
                        else
                        if(strcmpi(basename,"POPSIZE") == 0)
                            strcat(outbuf,handle_string(H_LONGINT,&mostpopularsize,justlength,justtype,padchar,commait,soffset));
                        else
                        if(strcmpi(basename,"POPDESC") == 0)
                            strcat(outbuf,handle_string(H_STRING,mostpopulardesc,justlength,justtype,padchar,commait,soffset));
            }
            memset(basename,0,60);
            memset(varname,0,80);

        }
        else    // Normal character
        {
            outbuf[strlen(outbuf)+1] = 0;
            outbuf[strlen(outbuf)] = inbuf[counter];
        }
    }

    return(1);
}

void del_old_files  (unsigned int start, unsigned int end, char group, int daysold, int nodelete, int usedate)
{
FilesEzyRecord area;        /* FILES.EZY   */
FilePathRecord fpath;           // FILEPATH.EZY
FileLineRecord curfile;         // FLHxxxxx.BBS
long bytesread = 0;
char openfile[80];           // FLH?????.BBS
char openfile2[80];          // FILES.EZY
char openfile3[80];          // FILEPATH.EZY
char fullname[MAXFILEPATHLENGTH];  // full name of file to delete
int stream = 0;                 // FLH?????.BBS
int stream2 = 0;                // FILES.EZY
int stream3 = 0;                // FILEPATH.EZY
int filenum = 0;

long fdel = 0L;
long fsizedel = 0L;

long work_date,today;
long age_days;
unsigned int y1,d1,m1;
struct date d;

/* Open EzyCom's FILES.EZY so we can get area names when we need them */
sprintf(openfile2, "%sFILES.EZY", ezy.ezydir);
VIOprintf("\r\n Opening %s", openfile2);
if((stream2=sopen(openfile2,O_BINARY|O_RDONLY, SH_DENYNONE)) < 1)
    {
    VIOprintf("\r\n Error opening %s\r\n", openfile2);
    exit(1);
    }

/* Open EzyCom's FILEPATH.EZY so we can get filepaths when we need 'em */
sprintf(openfile3, "%sFILEPATH.EZY", ezy.ezydir);
VIOprintf("\r\n Opening %s", openfile3);
if((stream3=sopen(openfile3,O_BINARY|O_RDONLY, SH_DENYNONE)) < 1)
    {
    VIOprintf("\r\n Error opening %s\r\n", openfile3);
    exit(1);
    }


getdate(&d);
today=ymd_to_scalar(d.da_year, d.da_mon, d.da_day);

  for(unsigned int x=start;x<=end;x++)
  {
    lseek(stream2,(long)((long)sizeof(area)*(long)((long)x-1L)),SEEK_SET);

    /* Read in areaname for this area (out of FILES.EZY) */
    read(stream2, &area, sizeof(area));
    ezy.pas_to_c(area.Name);

    /* Determine full path of current 'filexxx.bbs' */
    sprintf(openfile, "%sAREA%d\\FLH%5.5d.BBS",ezy.config.FilePath,((x-1)/100)+1,x);

/* Make sure it's a valid area...check name/file/access */
if(area.Name[0] != NULL &&
   ((group == '*') ? 1 : group == area.FileGroup) &&
   exists(openfile) &&
   ((stream=sopen(openfile, O_BINARY|O_RDWR, SH_DENYNO)) > 0))
    {

    VIOprintf("\r\n Working on File Area #%d (%s)\r\n",x,area.Name);

    while(read(stream, &curfile, sizeof(FileLineRecord)))
        {
            filenum++;  // number of file currently on.
            ezy.pas_to_c(curfile.FileName);
//            VIOprintf("Processing %s", curfile.FileName);

            switch(usedate)
            {
                case 1:
                    int2dat(curfile.ArrivalDate,&y1,&m1,&d1);
                    work_date = ymd_to_scalar(y1,m1,d1);
                    break;
                case 2:
                    int2dat(curfile.FDate,&y1,&m1,&d1);
                    work_date = ymd_to_scalar(y1,m1,d1);
                    break;
                case 3:
                    if(curfile.Downloads < 1)
                        {
                           int2dat(curfile.ArrivalDate,&y1,&m1,&d1);
                           work_date = ymd_to_scalar(y1,m1,d1);
                        }
                    else
                        {
                           int2dat(curfile.DownloadDate,&y1,&m1,&d1);
                           work_date = ymd_to_scalar(y1,m1,d1);
                        }
                    break;
                default:
                    VIOprintf("\r\n No valid Date format Specified\r\n");
                    close(stream);
                    close(stream2);
                    close(stream3);
                    return;
            }

            age_days = today-work_date;

            if(!(curfile.Attribute & 2) && age_days >= daysold
               && !(curfile.Attribute & 4) && !(curfile.Attribute & 32))
            {
                VIOprintf("\r\n- Deleting %s", curfile.FileName);
                fdel++;
                fsizedel+=curfile.FSize;

                if(!nodelete)
                    {

                    if (curfile.FilePath < 1)
                        {
                           VIOprintf(" -- Unable to locate the file . . .\r\n");
                        }
                    else
                        {
                           lseek(stream3,(long)((long)sizeof(fpath)*(long)((long)curfile.FilePath-1L)),SEEK_SET);
                           read(stream3,&fpath,sizeof(fpath));
                           ezy.pas_to_c(fpath.FilePath);
                           sprintf(fullname,"%s\\%s",fpath.FilePath,curfile.FileName);
                           remove(fullname);
                           ezy.c_to_pas(curfile.FileName);
                           curfile.Attribute |= 32;  // set deleted flag
                           lseek(stream,(long)(filenum-1)*sizeof(curfile),SEEK_SET);
                           write(stream,&curfile,sizeof(curfile));
                        }

                    }
            }
            else
                {
                    ;
                    //  VIOprintf("");
                }
        }
    close(stream);
   }

  }
close(stream2);
close(stream3);
VIOprintf("\r\nTotal Files Deleted:  %ld.  Total Bytes Deleted:  %ld\r\n",fdel,fsizedel);
}


void create_headers(unsigned int start, unsigned int end, char group, char *hconfig)
{
FilesEzyRecord area;        /* FILES.EZY   */

int newsize = 0;
char mostpopularsizes[20] = "\0";
char areabytess[20] = "\0";
char areafiless[10] = "\0";
char areadownloadss[10] = "\0";
char areanumber[6] = "\0";
long areabytes=0L;
unsigned int areafiles=0;
unsigned int areadownloads=0;
char mostpopular[13]="\0";
unsigned int mostpopulardownloads=0;
char mostpopulardesc[FLTMAXSIZE+1]="\0";
long mostpopularsize=0;

long bytesread = 0;

char temp[200];
char mpd[4];

char *hdr=NULL;
char openfile[80] = "\0";       // FILE???.BBS
char openfile2[80] = "\0";      // FILES.EZY
char dfile[80] = "\0";          // FLT?????.BBS
char writefile[80] = "\0";      // FL?????.ASC (the header)
int stream = 0;                 // FLH?????.BBS
int stream2 = 0;                // FILES.EZY
int dstream = 0;                // FLT?????.BBS
int writestream = 0;            // FILE???.ASC
int template_size = 0;
int hcstream;
char head[HEADERBUFFER] = "\0";
char *outbuf = NULL;
FileLineRecord curfile[FILEREADBUFFER]; /* FLHxxxxx.BBS */

/*
FileLineRecord *curfile;

  if((curfile = (FileLineRecord *) calloc(FILEREADBUFFER, sizeof(FileLineRecord))) == NULL)
    {
    VIOprintf("Error Allocating memory\r\n");
    return;
    }
*/

    if((hcstream=sopen(hconfig,O_BINARY|O_RDONLY, SH_DENYNONE)) < 1)
        {
           VIOprintf("\r\n Error opening %s\r\n", hconfig);
           exit(1);
        }
    else
        {
           template_size = (int)filelength(hcstream);
           VIOprintf("Allocating %d bytes for Template file\r\n", template_size);

           if((hdr = (char *) malloc(template_size+1)) == NULL)
               {
                VIOprintf("Error Allocating memory to load Header template");
                return;
                }

           memset(&hdr[0],0,template_size+1);   // clears & Null terminates
           bytesread=read(hcstream, &hdr[0], template_size);
           close(hcstream);

           newsize=determine_newsize(hdr);

            VIOprintf("Output size :  %d\r\n", newsize);

           if((outbuf = (char *)malloc(newsize)) == NULL)
              {
                  VIOprintf("\r\n Error Allocating %d bytes for outbuffer\r\n", newsize);
                  exit(0);
              }
        }


/* Open EzyCom's FILES.EZY so we can get area names when we need them */
sprintf(openfile2, "%sFILES.EZY", ezy.ezydir);
VIOprintf("\r\n Opening %s", openfile2);
if((stream2=sopen(openfile2,O_BINARY|O_RDONLY, SH_DENYNONE)) < 1)
    {
    VIOprintf("\r\n Error opening %s\r\n", openfile2);
    exit(1);
    }

  for(unsigned int x=start;x<=end;x++)
  {
    memset(outbuf,0,newsize);
    lseek(stream2,(long)((long)sizeof(area)*(long)((long)x-1L)),SEEK_SET);

    /* Read in areaname for this area (out of FILES.EZY) */
    read(stream2, &area, sizeof(area));
    ezy.pas_to_c(area.Name);

    /* Reset variables for New Area */
    areabytes=0L;
    areafiles=0;
    areadownloads=0;
    mostpopular[0]='\0';
    mostpopulardownloads=0;
    mostpopulardesc[0]='\0';
    mostpopularsize=0;

    /* Determine full path of current 'filexxx.bbs' */
    sprintf(openfile, "%sAREA%d\\FLH%5.5d.BBS",ezy.config.FilePath,((x-1)/100)+1,x);
    sprintf(dfile, "%sAREA%d\\FLT%5.5d.BBS",ezy.config.FilePath,((x-1)/100)+1,x);

/* Make sure it's a valid area...check name/file/access */

if( area.Name[0] != NULL &&
   ((group == '*') ? 1 : group == area.FileGroup) &&
   exists(openfile) &&
   exists(dfile) &&
   ((stream=sopen(openfile, O_BINARY|O_RDONLY, SH_DENYNO)) > 0) &&
   ((dstream=sopen(dfile,O_BINARY|O_RDONLY, SH_DENYNO)) > 0))
    {

    VIOprintf("\r\n Working on File Area #%d (%s)",x,area.Name);


    while((bytesread=read(stream, &curfile, sizeof(FileLineRecord)*FILEREADBUFFER)) >= sizeof(FileLineRecord))
        {
          for(int b=0;b<(bytesread/sizeof(FileLineRecord));b++)
          {
            ezy.pas_to_c(curfile[b].FileName);

            if(!(curfile[b].Attribute & 32))
            {
                if((unsigned int)curfile[b].Downloads > mostpopulardownloads)
                    {
                    strcpy(mostpopular,curfile[b].FileName);
                    mostpopulardownloads=(unsigned int)curfile[b].Downloads;
                    mostpopularsize=curfile[b].FSize;

                    lseek(dstream, curfile[b].FltStart, SEEK_SET);
                    read(dstream, &mostpopulardesc, curfile[b].FltLength);
                    }

                areafiles++;
                areabytes+=(long)curfile[b].FSize;
                areadownloads+=curfile[b].Downloads;
            }

          }

        }

    StrReplace(mostpopulardesc, "\r", " ");
	itoa(areafiles, areafiless, 10);
	itoa(areadownloads, areadownloadss, 10);
	itoa(x, areanumber, 10);
    commafmt(mostpopularsizes, 20, mostpopularsize);
    commafmt(areabytess, 20, areabytes);

    VIOprintf("\r\n\tBytes: %s. Files: %d. Downloads: %d.",areabytess,areafiles,areadownloads);
    close(stream);
    close(dstream);

    // Create the Actual Header!
    sprintf(writefile, "%sAREA%d\\FL%5.5d.ASC",ezy.config.FilePath,((x-1)/100)+1,x);
    if((writestream=sopen(writefile, O_CREAT|O_TRUNC|O_TEXT|O_WRONLY, SH_DENYNONE, S_IWRITE)) < 1)
	    {
        VIOprintf("\r\n Error opening %s\r\n", writefile);
        goto end;
	    }

            process_header(hdr,outbuf,x,area.Name,areafiles,areadownloads,areabytes,mostpopulardownloads,mostpopular,mostpopularsize,mostpopulardesc);

            write(writestream, outbuf, strlen(outbuf));
            close(writestream);

    }

  } /* End of the 'for' loop */

end:
free(outbuf);
close(stream2);
}



char *StrReplace(char *Str, char *OldStr, char *NewStr)
{
      int OldLen, NewLen;
      char *p, *q;

      if(NULL == (p = strstr(Str, OldStr)))
            return p;
      OldLen = strlen(OldStr);
      NewLen = strlen(NewStr);
      memmove(q = p+NewLen, p+OldLen, strlen(p+OldLen)+1);
      memcpy(p, NewStr, NewLen);
      return q;
}

size_t commafmt(char   *buf,            /* Buffer for formatted string  */
                int     bufsize,        /* Size of buffer               */
                long    N)              /* Number to convert            */
{
        int len = 1, posn = 1, sign = 1;
        char *ptr = buf + bufsize - 1;

        if (2 > bufsize)
        {
ABORT:          *buf = NULL;
                return 0;
        }

        *ptr-- = NULL;
        --bufsize;
        if (0L > N)
        {
                sign = -1;
                N = -N;
        }

        for ( ; len <= bufsize; ++len, ++posn)
        {
                *ptr-- = (char)((N % 10L) + '0');
                if (0L == (N /= 10L))
                        break;
                if (0 == (posn % 3))
                {
                        *ptr-- = ',';
                        ++len;
                }
                if (len >= bufsize)
                        goto ABORT;
        }

        if (0 > sign)
        {
                if (0 == bufsize)
                        goto ABORT;
                *ptr-- = '-';
                ++len;
        }

        strcpy(buf, ++ptr);
        return (size_t)len;
}

void create_dscfiles(unsigned int start, unsigned int end, char group, char filesbbs[13], int makehidden, int alt, int nopipe, int onelinedesc, int nostrip)
{
FileLineRecord curfile; /* FLHxxxxx.BBS */
FilesEzyRecord area;    /* FILES.EZY    */
FilePathRecord fpath;   /* FILEPATH.EZY */

unsigned int fyear,fmon,fday;
unsigned int x = 0;
unsigned int y = 0;
int p = 0;
size_t len;
long N;
char buf[BUFFER + (FLTMAXSIZE * 3)];
char fdescription[FLTMAXSIZE * 3] = "\0";
char openfile[80];
char openfile2[80];
char openfile3[80];
char writefile[80];
char dfile[80];
char repstring[81];
char *writestreamp;
char *tmp;
int stream;
int stream2;
int stream3;
int dstream;
int writestream;

/* Open EzyCom's FILES.EZY so we can get area names when we need them */
sprintf(openfile2, "%sFILES.EZY", ezy.ezydir);
VIOprintf("\r\n Opening %s", openfile2);
if((stream2=sopen(openfile2,O_BINARY|O_RDONLY, SH_DENYNONE)) < 1)
    {
    VIOprintf("\r\n Error opening %s\r\n", openfile2);
    return;
    }
y=start;

  for(x=start;x<=end;x++)
  {
        // lseek(stream2,sizeof(,SEEK_SET);

        /* Following code handles stuff if the starting area isn't #1 */
        if(y > 1)
        {
            for(y=1;y<start;y++)
            {
               read(stream2, &area, sizeof(area));
            }
        y=0;
        }
    }

/* Open EzyCom's FILEPATH.EZY so we can get area names when we need them */
sprintf(openfile3, "%sFILEPATH.EZY", ezy.ezydir);
VIOprintf("\r\n Opening %s", openfile3);
if((stream3=sopen(openfile3,O_BINARY|O_RDONLY, SH_DENYNONE)) < 1)
    {
    VIOprintf("\r\n Error opening %s\r\n", openfile3);
    return;
    }
y=start;

  for(x=start;x<=end;x++)
  {

    /* Following code handles stuff if the starting area isn't #1 */
    /*if(y > 1)
    {
        for(y=1;y<start;y++)
        {
        read(stream3, &fpath, sizeof(fpath));
        }
    y=0;
    }*/

    /* Read in areaname for this area (out of FILES.EZY) */
    read(stream2, &area, sizeof(area));
    strcpy(area.Name, ezy.pas_to_c(area.Name));

    lseek(stream3,(long)(sizeof(fpath)*(long)(area.AreaPath-1)),SEEK_SET);
    read(stream3, &fpath, sizeof(fpath));
    strcpy(fpath.FilePath, ezy.pas_to_c(fpath.FilePath));

    /* Determine full path of current 'filexxx.bbs' */
    sprintf(openfile, "%sAREA%d\\FLH%5.5d.BBS",ezy.config.FilePath,((x-1)/100)+1,x);
    sprintf(dfile, "%sAREA%d\\FLT%5.5d.BBS",ezy.config.FilePath,((x-1)/100)+1,x);

/* If the Area name is blank, don't even bother trying to create a header,etc*/
if(area.Name[0] != '\0' ) {

/* Check for existence before starting everything */
if(exists(openfile) && exists(dfile))
    if(
    ((group == '*') ? 1 : group == area.FileGroup) &&
    ((stream=sopen(openfile,O_BINARY|O_RDONLY, SH_DENYNO)) > 0) &&
    ((dstream=sopen(dfile,O_BINARY|O_RDONLY, SH_DENYNO)) > 0))
	{
    VIOprintf("\r\n Working on File Area #%d (%s)",x,area.Name);

        if(fpath.Attribute & 1)
        {
            VIOprintf(" - Skipped (CD-rom)");
            close(stream);
            close(dstream);
            goto next;
        }

        if(filesbbs[0]=='\0')
            sprintf(writefile, "%s\\FILES.BBS",fpath.FilePath);
        else
            sprintf(writefile, "%s\\%s",fpath.FilePath,filesbbs);



        writestreamp=&writefile[0];     /* Point to first character */
        toggle_hidden(writestreamp,0);  /* If it's hidden, make it 'available' */
        if((writestream=sopen(writefile, O_CREAT|O_TRUNC|O_BINARY|O_WRONLY, SH_DENYNONE, S_IWRITE)) < 1)
            {
            VIOprintf("- Couldn't Write %s", writefile);
            close(stream);
            close(dstream);
            goto next;
            }

	/* Read in All available file records for this area */
    while(read(stream, &curfile, sizeof(curfile)) == sizeof(curfile))
	    {
        if(!(curfile.Attribute & 16))
            {
            strcpy(curfile.FileName, ezy.pas_to_c(curfile.FileName));
            lseek(dstream,curfile.FltStart,SEEK_SET);
            read(dstream,&fdescription,curfile.FltLength+1);
            buf[0]='\0';

            if(fdescription[strlen(fdescription)-1] == '\x0D')
                fdescription[strlen(fdescription)-1] = NULL;

            sprintf(repstring, "%s%s", onelinedesc ? " " : (alt ? "\n                              " : "\n            "), onelinedesc ? "" : (nopipe ? " " : " |"));

            while (NULL != (tmp=StrReplace(fdescription, "\x0D", repstring)))
                ;

            if (!nostrip)
                {
                while (NULL != (tmp=StrReplace(fdescription, "|00", "")))
                    ;
                while (NULL != (tmp=StrReplace(fdescription, "|01", "")))
                    ;
                while (NULL != (tmp=StrReplace(fdescription, "|02", "")))
                    ;
                while (NULL != (tmp=StrReplace(fdescription, "|03", "")))
                    ;
                while (NULL != (tmp=StrReplace(fdescription, "|04", "")))
                    ;
                while (NULL != (tmp=StrReplace(fdescription, "|05", "")))
                    ;
                while (NULL != (tmp=StrReplace(fdescription, "|06", "")))
                    ;
                while (NULL != (tmp=StrReplace(fdescription, "|07", "")))
                    ;
                while (NULL != (tmp=StrReplace(fdescription, "|08", "")))
                    ;
                while (NULL != (tmp=StrReplace(fdescription, "|09", "")))
                    ;
                while (NULL != (tmp=StrReplace(fdescription, "|10", "")))
                    ;
                while (NULL != (tmp=StrReplace(fdescription, "|11", "")))
                    ;
                while (NULL != (tmp=StrReplace(fdescription, "|12", "")))
                    ;
                while (NULL != (tmp=StrReplace(fdescription, "|13", "")))
                    ;
                while (NULL != (tmp=StrReplace(fdescription, "|14", "")))
                    ;
                while (NULL != (tmp=StrReplace(fdescription, "|15", "")))
                    ;
                }

            if(alt)
                {
                int2dat(curfile.FDate,&fyear,&fmon,&fday);
                if(ezy.config.USDateForSysop)
                    sprintf(buf, "%-12.12s %8ld %02d-%02d-%02d %s\n", curfile.FileName,curfile.FSize,fmon,fday,fyear - 1900,fdescription);
                else
                    sprintf(buf, "%-12.12s %8ld %02d-%02d-%02d %s\n", curfile.FileName,curfile.FSize,fday,fmon,fyear - 1900,fdescription);
                }
            else
                {
                sprintf(buf, "%-12.12s %s\n", curfile.FileName, fdescription);
                }
            write(writestream, buf, strlen(buf));
            }
       }
    close(writestream);
    if(makehidden)
        toggle_hidden(writestreamp,1); /* Make the file hidden */
    else
        toggle_hidden(writestreamp,0); /* Unhide the file */
    close(stream);
    close(dstream);
	}

    }
  next:
  }
end:
close(stream2);
close(stream3);
}

void toggle_hidden(char *filename, int onoff)
{
if(onoff)
    {
    if(_chmod(filename, 0) != FA_HIDDEN)
        _chmod(filename, 1, FA_HIDDEN);
    }
else
    {
    if(_chmod(filename, 0) == FA_HIDDEN)
        _chmod(filename, 1, FA_HIDDEN);
    }
}

void del_fbbs(unsigned int start, unsigned int end, char group, char *aname)
{
char filep[MAXFILEPATHLENGTH];      // FILEPATH.EZY path/filename
char filesezy[MAXFILEPATHLENGTH];   // FILES.EZY
int fileph;                         // FILEPATH.EZY file handle
int filesezyh;                      // FILES.EZY file handle
FilePathRecord area;
FilesEzyRecord arearec;
char filesbbsname[MAXFILEPATHLENGTH];
char ezyutil[MAXFILEPATHLENGTH];
char area_arg[6];

sprintf(filep, "%sFILEPATH.EZY", ezy.ezydir);
VIOprintf("\r\n Opening %s", filep);
if((fileph=sopen(filep,O_BINARY|O_RDONLY, SH_DENYNONE)) < 1)
    {
    VIOprintf("\r\n Error opening %s\r\n", filep);
    exit(1);
    }

sprintf(filesezy, "%sFILES.EZY", ezy.ezydir);
VIOprintf("\r\n Opening %s", filesezy);
if((filesezyh=sopen(filesezy,O_BINARY|O_RDONLY, SH_DENYNONE)) < 1)
    {
    VIOprintf("\r\n Error opening %s\r\n", filep);
    exit(1);
    }

  for(unsigned int x=start;x<=end;x++)
  {
    lseek(fileph,(long)(sizeof(area)*(x-1)),SEEK_SET);
    lseek(filesezyh,(long)(sizeof(arearec)*(area.UploadArea-1)),SEEK_SET);

    /* Read in areaname for this area (out of FILES.EZY) */
    read(fileph, &area, sizeof(area));
    read(filesezyh, &arearec, sizeof(arearec));
    ezy.pas_to_c(area.FilePath);
    ezy.fixslash(area.FilePath);
    if(aname == NULL)
        strcpy(filesbbsname, ezy.pas_to_c(area.FilesBBS));
    else
        sprintf(filesbbsname, "%s%s",area.FilePath,aname);

    if(area.Attribute & 1)
        VIOprintf("\r\n Area #%d -- CD-rom path/skipped",x);
    else
        if(exists(filesbbsname) &&
          ((group == '*') ? 1 : group == arearec.FileGroup))
            {
            VIOprintf("\r\n Area #%d  --  ", area.UploadArea);
            toggle_hidden(filesbbsname,0); /* Unhide the file */
            if(remove(filesbbsname)==0)
                {
                VIOprintf("%s deleted.",filesbbsname);
                }
            else
                {
                VIOprintf("Unable to delete %s",filesbbsname);
                }
            }

  }

close(fileph);
close(filesezyh);
}

void VIOprintf(char *control, ...)
{
va_list parms;
unsigned char buff[512], *ptr;
ptr = buff;
va_start(parms, control);
vsprintf(buff, control, parms);

while(*ptr)
{

    switch(*ptr)
    {
        case '\n':
            if(VIOwherey() == Vbottom)
                 {
                 VIOscrollup(Vleft,Vtop,Vright,Vbottom,1);
                 }
            else
                VIOgotoxy(VIOwherex(),VIOwherey()+1);
            ptr++;
            break;
        case '\r':
            VIOgotoxy(0,VIOwherey());
            ptr++;
            break;
        case '\t':
            VIOgotoxy(VIOwherex()+5,VIOwherey());
            ptr++;
            break;
        case '`' :      // Syntax : `\x1\x16 would be blue on black
            ptr++;
            if(*ptr == '\16')
                {
                VIOsetfore(0);
                ptr++;
                }
            else
                VIOsetfore(*ptr++);

            if(*ptr == '\16')
                {
                VIOsetback(0);
                ptr++;
                }
            else
                VIOsetback(*ptr++);
            break;
        case '\v':
            VIOgotoxy(VIOwherex(),VIOwherey()+5);
            ptr++;
            break;
        default:
            VIOputc(*ptr++);
            break;
    }
}

va_end(parms);
}


void set_uinfo(int wnode, char *towhat)
{
int stream;
char userdpath[MAXFILEPATHLENGTH];

sprintf(userdpath, "%sUSERDOES.%d", ezy.ezydir, wnode);
VIOprintf("Setting Userinfo for node %d to %s\r\n",wnode,towhat);
if((stream=sopen(userdpath,O_BINARY|O_CREAT|O_TRUNC|O_WRONLY, SH_DENYNONE)) < 1)
    {
    VIOprintf("\r\n Error opening %s\r\n", userdpath);
    }
else
    {
    write(stream, towhat, strlen(towhat));
    close(stream);
    }
}

void set_ninfo(int wnode, char *towhat)
{
int stream;
char nodeinfopath[MAXFILEPATHLENGTH];

sprintf(nodeinfopath, "%sNODEINFO.%d", ezy.ezydir, wnode);
VIOprintf("Setting Nodeinfo for node %d to %s\r\n",wnode,towhat);
if((stream=sopen(nodeinfopath,O_BINARY|O_CREAT|O_TRUNC|O_WRONLY, SH_DENYNONE)) < 1)
    {
    VIOprintf("\r\n Error opening %s\r\n", nodeinfopath);
    }
else
    {
    write(stream, towhat, strlen(towhat));
    close(stream);
    }
}

void exit_prog(void)
{
gotoxy(VIOwherex()+1,VIOwherey()+1);
VIOclose();
}

void view_dbatch(int wnode)
{
PreDownloadRecord down;
char pdloc[MAXFILEPATHLENGTH];
int files_count = 0;
long files_size = 0L;

sprintf(pdloc,"%sEZYDOWN.%d",ezy.config.TempPath,wnode);

if(!exists(pdloc))
    {
    VIOprintf("No download batch for that node exists.");
    exit(1);
    }

int stream;
if((stream=sopen(pdloc,O_BINARY|O_RDONLY, SH_DENYNONE)) < 1)
    {
    VIOprintf("\r\n Error opening %s\r\n", pdloc);
    exit(1);
    }

VIOprintf("Download batch for node %d:\r\n\r\n",wnode);
VIOprintf("Filename      Filepath                 Filesize  Free?\r\n");
VIOprintf("\r\n");

for(int x=0;x<filelength(stream)/sizeof(down);x++)
{
read(stream, &down, sizeof(down));
ezy.pas_to_c(down.FileName);
ezy.pas_to_c(down.LocationFile);

VIOprintf("%13.13s %-25.25s % -6.6ldk    %s\r\n",down.FileName,down.LocationFile,down.FSize,down.FreeDown ? "Yes" : "No");
files_count++;
files_size+=(long)down.FSize;
}

VIOprintf("%d file(s) totaling   %ld k", files_count, files_size);

close(stream);
}

void import_na(unsigned int start, unsigned int end, char group, char egroup, int redesc, char *nafilename, int column)
{
int nafile;             // .na file handle
int bytesread = 0;
char far *fptr;

if(!exists(nafilename))
{
    VIOprintf(" %s does not exist\r\n",nafilename);
    return;
}

if((nafile=sopen(nafilename,O_BINARY|O_RDONLY, SH_DENYNONE)) < 1)
    {
    VIOprintf(" Error opening %s\r\n", nafilename);
    return;
    }

fptr = (char far *) farmalloc(filelength(nafile)+2);  // + 2 for the 'NULL'
                                                      // and the first newline

if(fptr == NULL)
    VIOprintf(" Error Allocating memory to load %s\r\n", nafilename);
else
    VIOprintf(" %ld bytes allocated for reading in %s\r\n", filelength(nafile)+1,nafilename);
fptr[0]='\n';

bytesread=read(nafile,&fptr[1],filelength(nafile));
fptr[bytesread+1] = NULL;
close(nafile);


int mezyfile;                            // File Handle
char mezyname[MAXFILEPATHLENGTH];        // File Name


sprintf(mezyname,"%sMESSAGES.EZY",ezy.ezydir);


if(!exists(mezyname))
    {
    farfree(fptr);      // Free up memory where xxxxxxx.na is stored
    VIOprintf(" %s does not exist!\r\n", mezyname);
    exit(1);
    }

    if((mezyfile=sopen(mezyname, O_RDWR|O_BINARY, SH_DENYWR)) < 1)
        {
        VIOprintf(" Error Opening %s\r\n", mezyname);
        farfree(fptr);      // Free up memory where xxxxxxx.na is stored
        exit(1);
        }

        for(unsigned int x=start;x<=end;x++)      // Begin 'for' loop
        {

            MessageRecord msgrecord;                 // Message area record
            char far *ptr = NULL;
            char nechotag[21];
            char description[31];
            char areatag[31];
            int len1,len2;

            len1=0;
            len2=0;
            memset(&msgrecord,0,sizeof(msgrecord));
            memset(nechotag,0,21);
            memset(description,0,31);
            memset(areatag,0,31);

            // Seek to position just before record
            lseek(mezyfile,(long)((long)sizeof(msgrecord)*(long)(x-1)),SEEK_SET);

            // Read in record and convert certain info
            read(mezyfile, &msgrecord, sizeof(msgrecord));
            strcpy(msgrecord.Name, ezy.pas_to_c(msgrecord.Name));
            strcpy(msgrecord.AreaTag, ezy.pas_to_c(msgrecord.AreaTag));

            // If area is an area, and its areatag and description are the same
            if((msgrecord.Name[0] != '\0') &&
            ((group == '*') ? 1 : group == msgrecord.MessGroup) &&
            ((egroup == '*') ? 1 : egroup == msgrecord.AreaGroup) &&
            (redesc ? 1 : (strcmpi(msgrecord.Name, msgrecord.AreaTag) == 0)))
                {

                VIOprintf("\tWorking on Area #%d (%s)\r\n",x,msgrecord.Name);
                // ----- Beginning of search routine -------
                strcpy(areatag,msgrecord.AreaTag);

                sprintf(nechotag, "\n%s", msgrecord.AreaTag);
                ptr = _fstrstr(fptr, nechotag);          // Search fptr for 'echotag'

                if(ptr==NULL)
                    {
                    VIOprintf(" Unable to locate that Echotag: %s\r\n", nechotag);
                    }
                else
                    {

                        if(column == 0)             // Default (not-specified)
                        {
                        if(*(ptr + 19) == ' ')      // Skip pointer to beginning of description
                            ptr+=20;                // Which usually starts at the 20th
                        else                        // or
                            ptr+=19;                // the 19th character
                        }
                        else
                        {
                            ptr+=column;
                        }

                        for(int y=0;(*ptr != '\r' && *ptr != '\n' && y<30);y++)        // Copy description to
                            description[y]=*ptr++;            // different buffer
                        description[y]='\0';                  // and NULL terminate it

                        stripcr(description);

                        len1=strlen(description)+1;
                        len2=strlen(areatag)+1;

                        strncpy(msgrecord.Name, ezy.c_to_pas(description),len1);
                        strncpy(msgrecord.AreaTag, ezy.c_to_pas(areatag),len2);

                        // Seek back, and write out new record
                        lseek(mezyfile,(long)((long)sizeof(msgrecord)*(long)(x-1)),SEEK_SET);
                        write(mezyfile,&msgrecord,sizeof(msgrecord));
                    }

                // ----- End of search Routine -------
                }

            } // End of for() loop


close(mezyfile);
farfree(fptr);      // Free up memory where xxxxxxx.na is stored
}

int purge_qa(char *filename, char *saveold)
{
char var1[81], name[36],
    ASWFILE[MAXFILEPATHLENGTH], ASWTEMP[MAXFILEPATHLENGTH],
    *loc1, *loc2;
UsersRecord user;
char userbase[81];
int userbaseh;
unsigned int numusers;
int match=0;
FILE *new_users, *new_asw, *save_file;

struct name_idx {
    char username[36];
};

name_idx *names;

if (saveold != NULL)
        save_file = fopen(saveold,"wb");

sprintf(userbase, "%sUSERS.BBS", ezy.config.UserBasePath);

if((userbaseh=sopen(userbase,O_RDONLY|O_BINARY,SH_DENYNO)) < 1)
    {
        VIOprintf("Error opening %s\r\n",userbase);
        return(0);
    }

numusers=(unsigned int)(filelength(userbaseh) / (long)sizeof(user));

VIOprintf("Allocating Memory for %d usernames (%ld bytes)\r\n", numusers, (long)numusers * (long)sizeof(name_idx));
if((names = (name_idx *) calloc(numusers,sizeof(name_idx))) == NULL)
    {
        VIOprintf("Error Allocating memory\r\n");
        return(0);
    }

for(unsigned int x=0;x<numusers;x++)
{
memset(&user,0,sizeof(user));
VIOprintf("Gathering User Data . . . %d/%d\r",x+1,numusers);
lseek(userbaseh,(long)((long)x * (long)sizeof(user)),SEEK_SET);
read(userbaseh, &user, sizeof(user));
ezy.pas_to_c(user.Name);
strcpy(names[x].username, user.Name);
}
close(userbaseh);


    strcpy(ASWFILE,filename);
    strcpy(ASWTEMP,"$EZQ$.TMP");

    VIOprintf("\r\nUsing %s\r\n",ASWFILE);

    if(rename(ASWFILE,ASWTEMP) != 0)
    {
        VIOprintf("Error creating temp file $EZQ$.TMP\r\n");
        return(1);
    }

if (saveold != NULL)
    save_file = fopen(saveold,"wb");

    new_users = fopen(ASWTEMP,"rb");
    new_asw   = fopen(ASWFILE,"wb");
    
    if(new_users==NULL || new_asw==NULL || save_file == NULL)
    {                
        VIOprintf("Error opening one of the data files.\r\n");
        exit(1);
    }

    VIOprintf("\r\n");

    gotoxy(1,VIOwherey()+1);

    while (fgets(var1,sizeof(var1),new_users)!=NULL)
    {

        memset(name,0,sizeof(name));
        loc1=strstr(var1,"*** ");
        loc2=strstr(var1," completed");
        if (loc1 != NULL && loc2 != NULL)
        {
            strncpy(name,&var1[4],loc2-var1-4);

        for(int y=0;y<numusers;y++)    // Step through users
            {
            if(strcmpi(names[y].username,name) == 0)
                {
                    match=1;
                    goto goit;
                }
            else
                {
                    match=0;
                }
            }

            goit:

            if (match != 0)
            {
                printf("%3.3d%% %s -- Still a user              \r\n",(int)((ftell(new_users)*100)/filesize(new_users)),name);
                fputs(var1,new_asw); //Output the line if user exists in userbase
            }
            else
                {
                if(saveold != NULL)
                    fputs(var1,save_file);
                printf("%3.3d%% Removing %s's responses           \r\n",(int)((ftell(new_users)*100)/filesize(new_users)),name);
                }
        }
        else
            if (match!=0)
                fputs(var1,new_asw);
            else
                if(saveold != NULL)
                    fputs(var1,save_file);
           

    }
    fclose(new_asw);
    fclose(new_users);

    if(saveold != NULL)
        fclose(save_file);

    if (remove(ASWTEMP)!=0)
        VIOprintf("Error removing $EZQ$.TMP");
    free(names);
}

long filesize(FILE *stream)
{
       long curpos, length;

      curpos = ftell(stream);
      fseek(stream, 0L, SEEK_END);
      length = ftell(stream);
      fseek(stream, curpos, SEEK_SET);
      return length;
}

unsigned getkey(void)
{
   unsigned key;

    while(!kbhit())
        {
        // Slice to a multi-tasker here maybe (?)
        }
    if((key = getch() ) == 0)
        key = getch() << 8;

return(key);
}

void print_help(void)
{

    int z;
    int lines;
    int curline = 0;
    unsigned keypress;

    // Count the lines
    for(lines=0;help_asc[lines] != NULL;lines++)
        ;

    lines--;    // In this case, 0 counts as a line too....

    _setcursortype(_NOCURSOR);

    // structure:
    //      (With top and bottom Status line)
    // 1. Starting at 'curline' print out 23 lines on screen
    //  . Clear area for each line just before printing out
    // 2. Process keypress, if an arrow, use scroll, then reprint
    //    top or bottom line, if pgup/pgdn/home/end, modify value of
    //    'curline' and return to step one

    // Put up Status Lines
    VIOgotoxy(0,0);
    VIOsetfore(15);
    VIOsetback(1);
    VIOputs(" UMPU command line switches                                                     ");
    VIOgotoxy(0,24);
    VIOputs("         Use PgUp/PgDn/Home/End/Arrow Keys to browse text, ESC to exit          ");
    VIOsetfore(7);
    VIOsetback(0);

    redraw:
    VIOclear(0,1,79,23);

    for(z=curline;z<=(22+curline);z++)
    {
        VIOgotoxy(0,(z+1)-curline);
        VIOputs(help_asc[z]);
    }

    while((keypress=getkey()) != KEY_ESC)
    {
        switch(keypress)
        {
            case KEY_UARROW:
                if(curline != 0)
                    {
                    curline--;
                    VIOscrolldown(0,1,79,23,1);
                    VIOgotoxy(0,1);
                    VIOputs(help_asc[curline]);
                    }
                break;
            case KEY_DARROW:
                if(curline != lines-22)
                    {
                    curline++;
                    VIOscrollup(0,1,79,23,1);
                    VIOgotoxy(0,23);
                    VIOputs(help_asc[curline+22]);
                    }
                break;
            case KEY_HOME:
                if(curline != 0)
                    {
                    curline=0;
                    goto redraw;
                    }
                break;
            case KEY_END:
                if(curline != lines-22)
                {
                    curline=lines-22;
                    goto redraw;
                }
                break;
            case KEY_PGUP:
                if(curline != 0)
                {
                    curline-=22;
                    if(curline < 0)
                        curline=0;
                    goto redraw;
                }
                break;
            case KEY_PGDN:
                if(curline != lines-22)
                {
                    curline+=22;
                    if(curline>(lines-22))
                        curline=lines-22;
                    goto redraw;
                }
                break;

        }

    }

    VIOclear(0,24,79,24);       // Clear last line of screen (status line)
    VIOgotoxy(0,23);
    gotoxy(1,25);
    _setcursortype(_NORMALCURSOR);
}

void compress_message_fast(unsigned int userfrom, unsigned int userto)
{
char userbase[MAXFILEPATHLENGTH];
char mf[MAXFILEPATHLENGTH];
int userbaseh, mfh;
long mflength;
int newmfh;
char newmf[MAXFILEPATHLENGTH];
long bytesread = 0;
long numusers;
UsersRecord user;
MsgFastRecord mfr[2000];
unsigned int memoffset = 0;

struct CRCS {
    long int namecrc;
    long int aliascrc;
    };

CRCS *user_crc;

sprintf(userbase, "%sUSERS.BBS", ezy.config.UserBasePath);

if((userbaseh=sopen(userbase,O_RDONLY|O_BINARY,SH_DENYNO)) < 1)
    {
        VIOprintf("Error opening %s\r\n",userbase);
        return;
    }

if(userto > (filelength(userbaseh)/sizeof(user)))       // Check if userto is
    userto=filelength(userbaseh)/sizeof(user);          // to large

numusers=(userto-userfrom)+1+1;  // +1 for allmail, +1 for offset


VIOprintf("Allocating Memory for %ld users (%ld bytes)\r\n", numusers-1, (numusers) * sizeof(CRCS));
if((user_crc = (CRCS *) calloc(numusers,sizeof(CRCS))) == NULL)
    {
        VIOprintf("Error Allocating memory\r\n");
        return;
    }

memset(user_crc,0,sizeof(user_crc));

unsigned int z;

for(z=userfrom;z<(userfrom+numusers-1);z++)
{
    memset(&user,0,sizeof(user));
    memoffset = z - userfrom;
    VIOprintf("Gathering User Data . . . %d/%d\r",z,userto);
    lseek(userbaseh,(long)(z-1) * (long)sizeof(user),SEEK_SET);
    read(userbaseh, &user, sizeof(user));
    ezy.pas_to_c(user.Name);
    ezy.pas_to_c(user.Alias);
    strupr(user.Name);
    strupr(user.Alias);
    user_crc[memoffset].namecrc=crc32((void far *)&user.Name, (unsigned long)strlen(user.Name), 0xffffffffL);
    user_crc[memoffset].aliascrc=crc32((void far *)&user.Alias, (unsigned long)strlen(user.Alias), 0xffffffffL);
}
close(userbaseh);

user_crc[memoffset+1].namecrc=crc32((void far *)"ALL", (unsigned long)3, 0xffffffffL);
user_crc[memoffset+1].aliascrc=crc32((void far *)"ALL", (unsigned long)3, 0xffffffffL);


sprintf(mf, "%sMSGFAST.BBS", ezy.config.MsgPath);
if((mfh=sopen(mf,O_RDONLY|O_BINARY,SH_DENYNO)) < 1)
    {
    VIOprintf("\nError opening %s\r\n",mf);
    free(user_crc);
    return;
    }

VIOprintf("\n");

sprintf(newmf, "%sMSGFTMP.BBS", ezy.config.MsgPath);
if((newmfh=sopen(newmf,O_CREAT|O_WRONLY|O_BINARY,SH_DENYWR,S_IWRITE)) < 1)
    {
    VIOprintf("\nError opening %s\r\n",newmf);
    free(user_crc);
    close(mfh);
    return;
    }


mflength = filelength(mfh);

memset(&mfr,0,sizeof(mfr));

while((bytesread=read(mfh, &mfr, sizeof(mfr))) > 0L)
    {
    VIOprintf("Compressing Mail Scan Index file ... %03d%% (%ld/%ld)\r", (int)((tell(mfh)*100)/mflength), tell(mfh), mflength);

        for(unsigned int x=0;x<((bytesread/sizeof(MsgFastRecord))+1);x++)    // step through recs
        {
                for(unsigned int uf=userfrom;uf<(userfrom+numusers);uf++)    // Step through users
                    {
                    if((mfr[x].WhoTo == user_crc[uf-userfrom].namecrc) || (mfr[x].WhoTo == user_crc[uf-userfrom].aliascrc))
                        {
                        write(newmfh,&mfr[x],sizeof(MsgFastRecord));
                        }
                    }
        }
    memset(&mfr,0,sizeof(mfr));
    }
    VIOprintf("\n");

close(newmfh);
close(mfh);

remove(mf);             // Delete MSGFAST.BBS
rename(newmf,mf);       // rename MSGFTMP.BBS, MSGFAST.BBS
}


void wait_sem(char *filename, int checkseconds, int noesc)
{
        clock_t t1;

        get_os();


        VIOprintf("%s %d.%d detected\r\n",t_os_name[t_os],
                                     t_os_ver[t_os].maj,
                                     t_os_ver[t_os].min);

        VIOprintf("Waiting for %s to exist...(%d seconds between checks)", filename, checkseconds);

        if(!noesc)
            VIOprintf("\r\nPress any key to abort");

        while(!exists(filename) && (noesc ? 1 : !kbhit()) )
            {
                t1 = clock() + ((clock_t)(checkseconds) * (clock_t)CLOCKS_PER_SEC);

                while(clock() < t1)
                    t_slice();

            }

        if(kbhit())
            {
            getch();
            VIOprintf("\r\nKeypress received.  Waiting aborted.");
            }
        else
            {
            VIOprintf("\r\nFound and removed!");
            remove(filename);
            }

}


void remove_fbcr(unsigned int start, unsigned int end, char group, int nohi)
{
FilesEzyRecord area;        /* FILES.EZY   */
FileLineRecord curfile[FILEREADBUFFER]; /* FLHxxxxx.BBS */

/* -- Buffer'd reading related stuff -- */
long bytesread = 0;

char temp[200];
char *tmp;

char openfile[80] = "\0";       // FILE???.BBS
char openfile2[80] = "\0";      // FILES.EZY
char dfile[80] = "\0";          // FLT?????.BBS
int stream = 0;                 // FLH?????.BBS
int stream2 = 0;                // FILES.EZY
int dstream = 0;                // FLT?????.BBS
char fdesc[(FLTMAXSIZE*2)+1];       // File Description
char *fd = &fdesc[0];

/* Open EzyCom's FILES.EZY so we can get area names when we need them */
sprintf(openfile2, "%sFILES.EZY", ezy.ezydir);
VIOprintf("\r\n Opening %s", openfile2);
if((stream2=sopen(openfile2,O_BINARY|O_RDONLY, SH_DENYNONE)) < 1)
    {
    VIOprintf("\r\n Error opening %s\r\n", openfile2);
    exit(1);
    }

  for(unsigned int x=start;x<=end;x++)
  {
    lseek(stream2,(long)(sizeof(area)*(x-1)),SEEK_SET);

    /* Read in areaname for this area (out of FILES.EZY) */
    read(stream2, &area, sizeof(area));
    ezy.pas_to_c(area.Name);

    /* Determine full path of current 'filexxx.bbs' */
    sprintf(openfile, "%sAREA%d\\FLH%5.5d.BBS",ezy.config.FilePath,((x-1)/100)+1,x);
    sprintf(dfile, "%sAREA%d\\FLT%5.5d.BBS",ezy.config.FilePath,((x-1)/100)+1,x);

/* Make sure it's a valid area...check name/file/access */
if(area.Name[0] != NULL &&
   exists(openfile) &&
   exists(dfile) &&
   ((group == '*') ? 1 : group == area.FileGroup) &&
   ((stream=sopen(openfile, O_BINARY|O_RDONLY, SH_DENYNO)) > 0) &&
   ((dstream=sopen(dfile,O_BINARY|O_RDWR, SH_DENYNO)) > 0))
    {

    VIOprintf("\r\n Working on File Area #%d (%s)",x,area.Name);

    while((bytesread=read(stream, &curfile, sizeof(curfile))) >= sizeof(curfile[0]))
        {
          for(int b=0;b<(bytesread/sizeof(curfile[0]));b++)
          {
            ezy.pas_to_c(curfile[b].FileName);

            lseek(dstream, curfile[b].FltStart, SEEK_SET);
            read(dstream, &fdesc, curfile[b].FltLength);

            int found=0;

            if(!nohi)
                {
                while (NULL != (tmp=StrReplace(fdesc, "\x0D", " ")))
                    ;
                found=1;
                }
            else
                {

                    for(int ds = 128; (ds <=254 && !found); ds++)
                    {
                    if(strchr(fdesc,ds) != NULL)
                        found=1;
                    }

                if(!found)
                    {
                    while (NULL != (tmp=StrReplace(fdesc, "\x0D", " ")))
                        ;
                    found=1;
                    }
                }
            if(found)
            {
            lseek(dstream, curfile[b].FltStart, SEEK_SET);
            write(dstream, &fdesc, strlen(fdesc)+1);
            }
          }
       }
	close(stream);
    close(dstream);
    }

  }

close(stream2);
}

void replace_desc(unsigned int start, unsigned int end, char group, char *oldstr, char *newstr)
{
FilesEzyRecord area;        /* FILES.EZY   */
FileLineRecord curfile[FILEREADBUFFER]; /* FLHxxxxx.BBS */

/* -- Buffer'd reading related stuff -- */
long bytesread = 0;

char temp[200];
char *tmp;

char openfile[80] = "\0";       // FILE???.BBS
char openfile2[80] = "\0";      // FILES.EZY
char dfile[80] = "\0";          // FLT?????.BBS
int stream = 0;                 // FLH?????.BBS
int stream2 = 0;                // FILES.EZY
int dstream = 0;                // FLT?????.BBS
char fdesc[(FLTMAXSIZE*2)+1];       // File Description
char *fd = &fdesc[0];

/* Open EzyCom's FILES.EZY so we can get area names when we need them */
sprintf(openfile2, "%sFILES.EZY", ezy.ezydir);
VIOprintf("\r\n Opening %s", openfile2);
if((stream2=sopen(openfile2,O_BINARY|O_RDONLY, SH_DENYNONE)) < 1)
    {
        VIOprintf("\r\n Error opening %s\r\n", openfile2);
        exit(1);
    }
VIOprintf("\r\nReplacing \"%s\" with \"%s\"\r\n",oldstr,newstr);
if(strlen(newstr) > strlen(oldstr))
{
VIOprintf("Replacement string cannot be longer than original string\r\n");
exit(1);
}

  for(unsigned int x=start;x<=end;x++)
  {
    lseek(stream2,(long)(sizeof(area)*(x-1)),SEEK_SET);

    /* Read in areaname for this area (out of FILES.EZY) */
    read(stream2, &area, sizeof(area));
    ezy.pas_to_c(area.Name);

    /* Determine full path of current 'filexxx.bbs' */
    sprintf(openfile, "%sAREA%d\\FLH%5.5d.BBS",ezy.config.FilePath,((x-1)/100)+1,x);
    sprintf(dfile, "%sAREA%d\\FLT%5.5d.BBS",ezy.config.FilePath,((x-1)/100)+1,x);

/* Make sure it's a valid area...check name/file/access */
if(area.Name[0] != NULL &&
   exists(openfile) &&
   exists(dfile) &&
   ((group == '*') ? 1 : group == area.FileGroup) &&
   ((stream=sopen(openfile, O_BINARY|O_RDONLY, SH_DENYNO)) > 0) &&
   ((dstream=sopen(dfile,O_BINARY|O_RDWR, SH_DENYNO)) > 0))
    {

    VIOprintf("\r\n Working on File Area #%d (%s)",x,area.Name);

    while((bytesread=read(stream, &curfile, sizeof(curfile))) >= sizeof(curfile[0]))
        {
          for(int b=0;b<(bytesread/sizeof(curfile[0]));b++)
          {
            ezy.pas_to_c(curfile[b].FileName);

            lseek(dstream, curfile[b].FltStart, SEEK_SET);

            char ch = '-';
            int x=0;
            for(;ch != 0 && x<=(FLTMAXSIZE-1);x++)
            {
            read(dstream,&ch,1);
            fdesc[x]=ch;
            }

            loop:
            if(StrReplace(fd, oldstr, newstr) != NULL)
                goto loop;

            lseek(dstream, curfile[b].FltStart, SEEK_SET);
            write(dstream, fd, strlen(fdesc) + 1);
          }
       }
	close(stream);
    close(dstream);
    }

  }

close(stream2);
}

// Create Areas.bbs file
void create_abbs(unsigned int start, unsigned int end, char group, char egroup, char *aname, int tagonly)
{
int astream;
char areabbs[MAXFILEPATHLENGTH];
char workbuf[200];

if(aname[0] == NULL)
    strcpy(areabbs, "AREAS.BBS");
else
    strcpy(areabbs, aname);

if((astream=sopen(areabbs,O_WRONLY|O_BINARY|O_CREAT|O_TRUNC,SH_DENYNO,S_IWRITE)) < 1)
{
    VIOprintf("Error Opening %s\r\n",areabbs);
    exit(1);
}

int mezyfile;                            // File Handle
char mezyname[MAXFILEPATHLENGTH];        // File Name
MessageRecord msgrecord;                 // Message area record

sprintf(mezyname,"%sMESSAGES.EZY",ezy.ezydir);

    if((mezyfile=sopen(mezyname, O_RDWR|O_BINARY, SH_DENYWR)) < 1)
        {
        VIOprintf(" Error Opening %s\r\n", mezyname);
        exit(1);
        }

        if(tagonly)
            ;
        else
            sprintf(workbuf, "%s * %s ! %s\n",ezy.Constant.System,ezy.Constant.SystemLocation,ezy.Constant.SysopName);

        write(astream, workbuf, strlen(workbuf));

        for(unsigned int x=start;x<=end;x++)
        {
            // Seek to position just before record
            lseek(mezyfile,(long)((long)sizeof(msgrecord)*(long)(x-1)),SEEK_SET);

            // Read in record and convert certain info
            read(mezyfile, &msgrecord, sizeof(msgrecord));
            strcpy(msgrecord.Name, ezy.pas_to_c(msgrecord.Name));
            strcpy(msgrecord.AreaTag, ezy.pas_to_c(msgrecord.AreaTag));

            // If area is an area, and its areatag and description are the same
            if(msgrecord.Name[0] != '\0'
               && ((group == '*') ? 1 : group == msgrecord.MessGroup)
               && ((egroup == '*') ? 1 : egroup == msgrecord.AreaGroup)
               && (msgrecord.Typ > 0 && msgrecord.Typ < 4))
                {
                VIOprintf("\tWorking on Area #%d (%s)\r\n",x,msgrecord.Name);

                if(tagonly)
                    sprintf(workbuf, "%s\n", msgrecord.AreaTag);
                else
                sprintf(workbuf, "%c %-22.22s %-16.16s\n",
                        msgrecord.Typ == 3 ? '#' : ' ', ezy.config.MsgPath,
                        msgrecord.AreaTag);

                write(astream,workbuf,strlen(workbuf));
                }

        }


close(mezyfile);
close(astream);
}

void list_mtag      (unsigned int start, unsigned int end, char group, char egroup, char *mtag)
{
int mezyfile;                            // File Handle
char mezyname[MAXFILEPATHLENGTH];        // File Name
MessageRecord msgrecord;                 // Message area record
char name[80];

sprintf(mezyname,"%sMESSAGES.EZY",ezy.ezydir);

    if((mezyfile=sopen(mezyname, O_RDWR|O_BINARY, SH_DENYWR)) < 1)
        {
        VIOprintf(" Error Opening %s\r\n", mezyname);
        exit(1);
        }

        for(unsigned int x=start;x<=end;x++)
        {
            memset(&msgrecord,0,sizeof(msgrecord));
            memset(&name,0,80);

            // Seek to position just before record
            lseek(mezyfile,(long)((long)sizeof(msgrecord)*(long)(x-1)),SEEK_SET);

            // Read in record and convert certain info
            read(mezyfile, &msgrecord, sizeof(msgrecord));

            strcpy(msgrecord.Name, ezy.pas_to_c(msgrecord.Name));
            strcpy(msgrecord.AreaTag, ezy.pas_to_c(msgrecord.AreaTag));

            // If area is an area, and its areatag and description are the same
            if(msgrecord.Name[0] != '\0'
               && ((group == '*') ? 1 : group == msgrecord.MessGroup)
               && ((egroup == '*') ? 1 : egroup == msgrecord.AreaGroup)
               && (strstr(msgrecord.AreaTag,mtag))
               )
                {
                VIOprintf("\tArea #%d - %s - %s\r\n",x,msgrecord.AreaTag, msgrecord.Name);
                }

        }


close(mezyfile);

}

void icomb(unsigned int start, unsigned int end, char group, char egroup, int offon, int whocares)
{
int mezyfile;                            // File Handle
char mezyname[MAXFILEPATHLENGTH];        // File Name
MessageRecord msgrecord;                 // Message area record
char name[80];

sprintf(mezyname,"%sMESSAGES.EZY",ezy.ezydir);

    if((mezyfile=sopen(mezyname, O_RDWR|O_BINARY, SH_DENYWR)) < 1)
        {
        VIOprintf(" Error Opening %s\r\n", mezyname);
        exit(1);
        }

        for(unsigned int x=start;x<=end;x++)
        {
            memset(&msgrecord,0,sizeof(msgrecord));
            memset(&name,0,80);

            // Seek to position just before record
            lseek(mezyfile,(long)((long)sizeof(msgrecord)*(long)(x-1)),SEEK_SET);

            // Read in record and convert certain info
            read(mezyfile, &msgrecord, sizeof(msgrecord));

            strcpy(name, msgrecord.Name);
            strcpy(name, ezy.pas_to_c(name));

            // If area is an area, and its areatag and description are the same
            if((msgrecord.Name[0] != '\0' || whocares)
               && ((group == '*') ? 1 : group == msgrecord.MessGroup)
               && ((egroup == '*') ? 1 : egroup == msgrecord.AreaGroup)
               )
                {
                VIOprintf("\tWorking on Area #%d (%s)\r\n",x,name);

                if(offon)
                    msgrecord.Attribute2 |= 64; // Bit 6 = Int combined access
                else
                    msgrecord.Attribute2 &=~ 64; // Bit 6 = 64 or 0x040

                lseek(mezyfile,(long)((long)sizeof(msgrecord)*(long)(x-1)),SEEK_SET);
                write(mezyfile, &msgrecord, sizeof(msgrecord));
                }

        }


close(mezyfile);
}

/*******************************************************************************
    Returns whether [user_sec] will pass the security mask specified by
    [sec_logic] [security]

     Return values :
     -1 = Error in parameters
      0 = Didn't pass
      1 = Passed security test
*******************************************************************************/

int valid_security(char sec_logic[2], unsigned int security, unsigned int user_sec)
{
int logictype = 0; // 0 = Unknown, 1 = !=, 2 = ==, 3 = >=, 4 = <=, 5 = <, 6 = >

if(strcmp(sec_logic, "!=") == 0 || strcmp(sec_logic, "<>") == 0 || strcmp(sec_logic, "NE") == 0)
    logictype=1;

if(strcmp(sec_logic, "==") == 0 || strcmp(sec_logic, "=") == 0 || strcmpi(sec_logic, "EQ") == 0)
    logictype=2;

if(strcmp(sec_logic, "]=") == 0 || strcmp(sec_logic,"}=") == 0 || strcmp(sec_logic,">=") == 0)
    logictype=3;

if(strcmp(sec_logic, "[=") == 0 || strcmp(sec_logic,"{=") == 0 || strcmp(sec_logic,"<=") == 0)
    logictype=4;

if(strcmp(sec_logic, "[") == 0 || strcmp(sec_logic,"{") == 0 || strcmp(sec_logic,"<") == 0)
    logictype=5;

if(strcmp(sec_logic, "]") == 0 || strcmp(sec_logic,"}") == 0 || strcmp(sec_logic,">") == 0)
    logictype=6;

switch(logictype) {
        case 0:
            return(-1);
        case 1:
            if(user_sec != security)
                return(1);
            else
                return(0);
        case 2:
            if(user_sec == security)
                return(1);
            else
                return(0);
        case 3:
            if(user_sec >= security)
                return(1);
            else
                return(0);
        case 4:
            if(user_sec <= security)
                return(1);
            else
                return(0);
        case 5:
            if(user_sec < security)
                return(1);
            else
                return(0);
        case 6:
            if(user_sec > security)
                return(1);
            else
                return(0);
        default:
            return(0);
}

}

void import_fbbs(unsigned int start, unsigned int end, char group, int cdrom, int fileid, int nodelete, int dpos, int ignorecr)
{
char filep[MAXFILEPATHLENGTH];      // FILEPATH.EZY path/filename
char filesezy[MAXFILEPATHLENGTH];   // FILES.EZY path
int fileph;                         // FILEPATH.EZY file handle
int filesezyh;                      // FILES.EZY file handle
FilePathRecord area;
FilesEzyRecord arearec;
char filesbbsname[MAXFILEPATHLENGTH];
char ezyutil[MAXFILEPATHLENGTH];
char arg1[20];
char arg2[20];
char arg3[20];
char arg4[20];
char arg5[20] = "\0";
char arg6[20] = "\0";
char arg7[20] = "\0";
char arg8[20] = "\0";

sprintf(filep, "%sFILEPATH.EZY", ezy.ezydir);
printf("\r\n Opening %s", filep);
if((fileph=sopen(filep,O_BINARY|O_RDONLY, SH_DENYNONE)) < 1)
    {
    VIOprintf("\r\n Error opening %s\r\n", filep);
    exit(1);
    }

sprintf(filesezy, "%sFILES.EZY", ezy.ezydir);
printf("\r\n Opening %s", filesezy);
if((filesezyh=sopen(filesezy,O_BINARY|O_RDONLY, SH_DENYNONE)) < 1)
    {
    VIOprintf("\r\n Error opening %s\r\n", filep);
    exit(1);
    }

    SAVEcur();
    VIOgotoxy(0,12);
    VIOprintf("[ Scanning for Existance of FILES.BBS, and importing with Ezyadopt ]\r\n");
    RESTcur();

  if(fileid)
    sprintf(arg5, "-FILEID");

  if(cdrom)
    sprintf(arg6, "-CDROM");

  if(ignorecr)
    sprintf(arg7, "-IGNORECR");

  if(dpos != 0)
    sprintf(arg8, "-DESC%d", dpos);

  for(unsigned int x=start;x<=end;x++)
  {
    WINDOW(0,0,79,11);
    lseek(fileph,(long)((long)sizeof(area)*(long)(x-1)),SEEK_SET);
    lseek(filesezyh,(long)((long)sizeof(arearec)*(long)(area.UploadArea-1)),SEEK_SET);

    /* Read in areaname for this area (out of FILES.EZY) */
    read(fileph, &area, sizeof(area));
    read(filesezyh, &arearec, sizeof(arearec));
    ezy.pas_to_c(area.FilePath);
    strcpy(filesbbsname, ezy.pas_to_c(area.FilesBBS));

    if((strcmp(area.FilePath,"\\") != 0) &&
      ((area.Attribute & 1) ? cdrom : 1) &&
      exists(filesbbsname) &&
      ((group == '*') ? 1 : group == arearec.FileGroup))
        {
        VIOprintf("Checking for %s (Area #%d)\r\n",filesbbsname,area.UploadArea);
        SAVEcur();
        VIOclear(0,13,79,24);
        VIOgotoxy(0,13); // 0 based
        gotoxy(1,14); // 1 based
        sprintf(ezyutil, "%sEZYADOPT.EXE",ezy.ezydir);
        sprintf(arg3, "-FROM%d", x);
        sprintf(arg4, "-TO%d", x);
        sprintf(arg1, "-AFROM%d", x);
        sprintf(arg2, "-ATO%d", x);
        spawnl(P_WAIT, ezyutil, ezyutil, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, NULL);
        if(!nodelete)
            remove(filesbbsname);
        RESTcur();
        }


  }

WINDOW(0,0,79,24); // Restore default settings to current window
close(fileph);
close(filesezyh);
}


int valid_flags(FlagType flags, unsigned char flag_mask[4][8])
{
    for(int a = 0; a<=3; a++)
    {
        for(int z = 0; z <=7; z++)
        {
         switch(flag_mask[a][z]) {
            case 'o':
            case 'O': // Must be off
                if(bit_s(flags[a], z))
                    return(0);
                break;
            case 'x':
            case 'X': // Must be on
                if(!bit_s(flags[a], z))
                    return(0);
                break;
            case '-': // Leave unchanged
                break;
            case 0: // Got to the end of the string somehow ??? (NULL)
                break;
            default:
                return(0);
            }
        }
    }

return(1);
}

int bit_s(unsigned char bbyte, int bnum)
{
switch(bnum)
{
    case 0:
        if(bbyte & 1)
            return(1);
        break;
    case 1:
        if(bbyte & 2)
            return(1);
        break;
    case 2:
        if(bbyte & 4)
            return(1);
        break;
    case 3:
        if(bbyte & 8)
            return(1);
        break;
    case 4:
        if(bbyte & 16)
            return(1);
        break;
    case 5:
        if(bbyte & 32)
            return(1);
        break;
    case 6:
        if(bbyte & 64)
            return(1);
        break;
    case 7:
        if(bbyte & 128)
            return(1);
        break;

}
return(0);
}

int determine_age(unsigned int month, unsigned int day, unsigned int year)
{
long today,work_date;
struct date d;
getdate(&d);
today=ymd_to_scalar(d.da_year, d.da_mon, d.da_day);
work_date=ymd_to_scalar(year,month,day);
return((today-work_date)/365L);
}

unsigned int days_since_lastcall(long lastcall_date)
{
struct date d;
long today,work_date;
unsigned int dslc = 0;
getdate(&d);
today=ymd_to_scalar(d.da_year, d.da_mon, d.da_day);
work_date=ymd_to_scalar(ts_year(lastcall_date), ts_month(lastcall_date),ts_day(lastcall_date));
dslc=today-work_date;
return(dslc);
}

void list_users(unsigned int userfrom, unsigned int userto, char sec_logic[2], unsigned int security, unsigned char flag_mask[4][8], char age_logic[2], unsigned int age, char lc_logic[2], unsigned int lc, char phonestr[15])
{
char userbase[MAXFILEPATHLENGTH];
char userextra[MAXFILEPATHLENGTH];
int userbaseh,numusers;
int userextrah;
unsigned int userage = 0;
unsigned int lastcall = 0;
unsigned int d1,y1,m1;
int users_used = 0;

UsersRecord user;
UsersExtraRecord uextra;

sprintf(userbase, "%sUSERS.BBS", ezy.config.UserBasePath);
sprintf(userextra, "%sUSERSEXT.BBS", ezy.config.UserBasePath);

if((userbaseh=sopen(userbase,O_RDONLY|O_BINARY,SH_DENYNO)) < 1)
    {
        VIOprintf("Error opening %s\r\n",userbase);
        return;
    }
if((userextrah=sopen(userextra,O_RDONLY|O_BINARY,SH_DENYNO)) < 1)
    {
        VIOprintf("Error opening %s\r\n",userextra);
        return;
    }
numusers=filelength(userbaseh) / sizeof(user);

gotoxy(1,VIOwherey()+1);

for(unsigned int x=userfrom;x <= userto && x <= numusers;x++)
{
lseek(userbaseh,(long)(x-1) * (long)sizeof(user),SEEK_SET);
lseek(userextrah,(long)(x-1) * (long)sizeof(uextra),SEEK_SET);
read(userbaseh, &user, sizeof(user));
read(userextrah, &uextra, sizeof(uextra));
ezy.pas_to_c(user.Name);
ezy.pas_to_c(user.VoicePhone);
ezy.pas_to_c(user.DataPhone);

userage=determine_age((unsigned int)uextra.DateOfBirth.Month,(unsigned int)uextra.DateOfBirth.Day,uextra.DateOfBirth.Year);
lastcall=days_since_lastcall(uextra.LastTimeDate);

if(user.Name[0] != NULL
    && valid_flags(user.Flags,flag_mask)
    && valid_security(sec_logic, security, user.Security)
    && valid_security(age_logic, age, userage)
    && valid_security(lc_logic, lc, lastcall)
    && ((phonestr[0] == NULL) ? 1 : ((strstr(user.VoicePhone,phonestr) != NULL) ? 1 : (strstr(user.DataPhone,phonestr) != NULL) ? 1 : 0))
    )
    {
    users_used++;
    printf("%s\n",user.Name);
    gotoxy(1,wherey());
    }
}
VIOgotoxy(wherex()-1, wherey()-1);
VIOprintf("%d%% of users listed (%d out of %d)", (int)(((long)users_used*100L)/(long)numusers),users_used,numusers);

close(userbaseh);
close(userextrah);
}

void apply_system_colors(unsigned int userfrom, unsigned int userto, char sec_logic[2], unsigned int security, unsigned char flag_mask[4][8], char age_logic[2], unsigned int age, char lc_logic[2], unsigned int lc, char phonestr[15])
{
char userbase[MAXFILEPATHLENGTH];
char userext[MAXFILEPATHLENGTH];
int userbaseh,numusers,userexth;
UsersRecord user;
UsersExtraRecord uextra;
unsigned int userage = 0;
unsigned int lastcall = 0;
int users_used = 0;

sprintf(userbase, "%sUSERS.BBS", ezy.config.UserBasePath);
sprintf(userext, "%sUSERSEXT.BBS", ezy.config.UserBasePath);


if((userbaseh=sopen(userbase,O_RDWR|O_BINARY,SH_DENYNO)) < 1 )
    {
        VIOprintf("Error opening %s\r\n",userbase);
        return;
    }

if((userexth=sopen(userext,O_RDWR|O_BINARY,SH_DENYNO)) < 1 )
    {
        VIOprintf("Error opening %s\r\n",userext);
        close(userbaseh);
        return;
    }


numusers=filelength(userbaseh) / sizeof(user);

VIOprintf("\n");

for(unsigned int x=userfrom;x <= userto && x < numusers;x++)
{
lseek(userbaseh,(long)(x-1) * (long)sizeof(user),SEEK_SET);
lseek(userexth,(long)(x-1) * (long)sizeof(uextra),SEEK_SET);
read(userbaseh, &user, sizeof(user));
read(userexth, &uextra, sizeof(uextra));
ezy.pas_to_c(user.Name);    // No need to convert back -- not writing <-user->
ezy.pas_to_c(user.VoicePhone);
ezy.pas_to_c(user.DataPhone);

userage=determine_age((unsigned int)uextra.DateOfBirth.Month,(unsigned int)uextra.DateOfBirth.Day,uextra.DateOfBirth.Year);
lastcall=days_since_lastcall(uextra.LastTimeDate);

if(user.Name[0] != NULL
    && valid_flags(user.Flags,flag_mask)
    && valid_security(sec_logic, security, user.Security)
    && valid_security(age_logic, age, userage)
    && valid_security(lc_logic, lc, lastcall)
    && ((phonestr[0] == NULL) ? 1 : ((strstr(user.VoicePhone,phonestr) != NULL) ? 1 : (strstr(user.DataPhone,phonestr) != NULL) ? 1 : 0))
    )
    {
        users_used++;
        uextra.Colour1_2=ezy.config.UserCol1_2;
        uextra.Colour3_4=ezy.config.UserCol3_4;
        uextra.Colour5_6=ezy.config.UserCol5_6;
        uextra.Colour7_8=ezy.config.UserCol7_8;
        uextra.BKColour=ezy.config.UserBKCol;

        VIOprintf("Modifying %s's colors.\r", user.Name);
        lseek(userexth,(long)(x-1) * (long)sizeof(uextra),SEEK_SET);
        write(userexth, &uextra, sizeof(uextra));
    }
}

VIOprintf("%d%% of all users modified (%d out of %d)", (int)(((long)users_used*100L)/(long)numusers),users_used,numusers);
close(userexth);
close(userbaseh);
VIOprintf("\n");
}


void create_user_expire_profile(unsigned int userfrom, unsigned int userto, char sec_logic[2], unsigned int security, unsigned char flag_mask[4][8], char age_logic[2], unsigned int age, char lc_logic[2], unsigned int lc, char phonestr[15], int report, char *outputfile, char day_logic[2], unsigned int days, int send_msg )
{
char userbase[MAXFILEPATHLENGTH];
char limitsezy[MAXFILEPATHLENGTH];
char userextra[MAXFILEPATHLENGTH];
int limitsezyh, userbaseh, numusers, numlimits, y, userextrah;
long work_date,today,work_date2;
long int lastcalld;
unsigned int expdays;
struct date d;

UsersRecord user;
LIMITSRECORD limits;
UsersExtraRecord uextra;

unsigned int y1,m1,d1,y2,m2,d2;

unsigned int userage = 0;
unsigned int lastcall = 0;

sprintf(userbase, "%sUSERS.BBS", ezy.config.UserBasePath);
sprintf(userextra, "%sUSERSEXT.BBS", ezy.config.UserBasePath);
sprintf(limitsezy, "%sLIMITS.EZY", ezy.ezydir);

if((userbaseh=sopen(userbase, O_RDONLY|O_BINARY,SH_DENYNO)) < 1)
    {
        VIOprintf("Error opening %s\r\n",userbase);
        return;
    }

if((userextrah=sopen(userextra, O_RDONLY|O_BINARY,SH_DENYNO)) < 1)
    {
        VIOprintf("Error opening %s\r\n",userextra);
        close(userbaseh);
        return;
    }

if((limitsezyh=sopen(limitsezy, O_RDONLY|O_BINARY, SH_DENYNO)) < 1)
    {
        VIOprintf("Error opening %s\r\n", limitsezy);
        close(userbaseh);
        close(userextrah);
        return;
    }

numusers=filelength(userbaseh) / sizeof(user);
numlimits=filelength(limitsezyh) / sizeof(limits);

gotoxy(1,VIOwherey()+1);

for(unsigned int x=userfrom;x <= userto && x < numusers;x++)
{
lseek(userbaseh,(long)(x-1) * (long)sizeof(user),SEEK_SET);
lseek(userextrah,(long)(x-1) * (long)sizeof(uextra),SEEK_SET);
read(userbaseh, &user, sizeof(user));
read(userextrah, &uextra, sizeof(uextra));
ezy.pas_to_c(user.Name);
ezy.pas_to_c(user.VoicePhone);
ezy.pas_to_c(user.DataPhone);

getdate(&d);
lastcalld=uextra.LastTimeDate;      // copy to work variable
today=ymd_to_scalar(d.da_year, d.da_mon, d.da_day);
work_date=ymd_to_scalar(uextra.DateOfBirth.Year,(unsigned int)uextra.DateOfBirth.Month,(unsigned int)uextra.DateOfBirth.Day);
work_date2=ymd_to_scalar(ts_year(lastcalld), ts_month(lastcalld),ts_day(lastcalld));

userage=(today-work_date)/365L;
lastcall=today-work_date2;



if(user.Name[0] != NULL
    && valid_flags(user.Flags,flag_mask)
    && valid_security(sec_logic, security, user.Security)
    && valid_security(age_logic, age, userage)
    && valid_security(lc_logic, lc, lastcall)
    && ((phonestr[0] == NULL) ? 1 : ((strstr(user.VoicePhone,phonestr) != NULL) ? 1 : (strstr(user.DataPhone,phonestr) != NULL) ? 1 : 0))
    )
    {
        int found = 0;

        for(y=0;y<numlimits && !found;y++)      // Find Security Profile
        {
        lseek(limitsezyh,(long)(y-1) * (long)sizeof(limits), SEEK_SET);
        read(limitsezyh, &limits, sizeof(limits));
        if(limits.Security == user.Security)
            found=1;
        }

        int2dat(uextra.RegoDate,&y1,&m1,&d1);   // Convert regodate to mm dd yy
        work_date=ymd_to_scalar(y1,m1,d1);      // convert mm dd yy to scalar
        work_date+=(long)limits.RegoDays;       // add limits.RegoDays to scalar
        scalar_to_ymd(work_date, &y1, &m1, &d1);// convert scalar to mm dd yy
        uextra.EndRegoDate=dat2int(y1,m1,d1);   // convert mm dd yy to regodate

    if((long)limits.RegoDays == 0L)
        {
        expdays=365*85;
        m1=99;
        y1=9999;
        d1=99;
        }
    else
    {
        // Calculate Difference between Today, and expire date (days registration will expire in)
        getdate(&d);
        expdays=work_date-today;
    }


    if(valid_security(day_logic, days, expdays))
        {
        if(ezy.config.USDateForSysop)
            printf("%-25.25s -- Registration Ends: %02d-%02d-%d (%d days)\r\n",user.Name,m1,d1,y1,expdays);
        else
            printf("%-25.25s -- Registration Ends: %02d-%02d-%d (%d days)\r\n",user.Name,d1,m1,y1,expdays);
        }
    if(send_msg)
        ; // Send a message to User/sysop
    }
}

close(userbaseh);
close(userextrah);
close(limitsezyh);
}


void apply_end_rego_dates(unsigned int userfrom, unsigned int userto, char
    sec_logic[2], unsigned int security, unsigned char flag_mask[4][8],
    char age_logic[2], unsigned int age, char lc_logic[2], unsigned int lc, char phonestr[15],
    int options)
{
char userbase[MAXFILEPATHLENGTH];
char limitsezy[MAXFILEPATHLENGTH];
char userextra[MAXFILEPATHLENGTH];
int limitsezyh, userbaseh, numusers, numlimits, y, userextrah;
long work_date,today;

unsigned int userage = 0;
unsigned int lastcall = 0;

UsersRecord user;
LimitsRecord limits;
UsersExtraRecord uextra;

unsigned int y1,m1,d1,y2,m2,d2;

sprintf(userbase, "%sUSERS.BBS", ezy.config.UserBasePath);
sprintf(userextra, "%sUSERSEXT.BBS", ezy.config.UserBasePath);
sprintf(limitsezy, "%sLIMITS.EZY", ezy.ezydir);

if((userbaseh=sopen(userbase, O_RDONLY|O_BINARY,SH_DENYNO)) < 1)
    {
        VIOprintf("Error opening %s\r\n",userbase);
        return;
    }

if((userextrah=sopen(userextra, O_RDWR|O_BINARY,SH_DENYNO)) < 1)
    {
        VIOprintf("Error opening %s\r\n",userextra);
        close(userbaseh);
        return;
    }

if((limitsezyh=sopen(limitsezy, O_RDONLY|O_BINARY, SH_DENYNO)) < 1)
    {
        VIOprintf("Error opening %s\r\n", limitsezy);
        close(userbaseh);
        close(userextrah);
        return;
    }

numusers=filelength(userbaseh) / sizeof(user);
numlimits=filelength(limitsezyh) / sizeof(limits);

for(unsigned int x=userfrom;x <= userto && x < numusers;x++)
{
lseek(userbaseh,(long)(x-1) * (long)sizeof(user),SEEK_SET);
lseek(userextrah,(long)(x-1) * (long)sizeof(uextra),SEEK_SET);
read(userbaseh, &user, sizeof(user));
read(userextrah, &uextra, sizeof(uextra));

ezy.pas_to_c(user.Name);
userage=determine_age((unsigned int)uextra.DateOfBirth.Month,(unsigned int)uextra.DateOfBirth.Day,uextra.DateOfBirth.Year);
lastcall=days_since_lastcall(uextra.LastTimeDate);

if(user.Name[0] != NULL
    && valid_flags(user.Flags,flag_mask)
    && valid_security(sec_logic, security, user.Security)
    && valid_security(age_logic, age, userage)
    && valid_security(lc_logic, lc, lastcall)
    && ((phonestr[0] == NULL) ? 1 : ((strstr(user.VoicePhone,phonestr) != NULL) ? 1 : (strstr(user.DataPhone,phonestr) != NULL) ? 1 : 0))
    )
    {
        int found = 0;

        for(y=0;y<numlimits && !found;y++)      // Find Security Profile
        {
        lseek(limitsezyh,(long)(y-1) * (long)sizeof(limits), SEEK_SET);
        read(limitsezyh, &limits, sizeof(limits));
        if(limits.Security == user.Security)
            found=1;
        }



    if((long)limits.RegoDays == 0L)
    {
        m1=99;
        y1=9999;
        d1=99;
    }
    else
    {
        int2dat(uextra.RegoDate,&y1,&m1,&d1);   // Convert regodate to mm dd yy
        work_date=ymd_to_scalar(y1,m1,d1);      // convert mm dd yy to scalar
        work_date+=(long)limits.RegoDays;       // add limits.RegoDays to scalar
        scalar_to_ymd(work_date, &y1, &m1, &d1);// convert scalar to mm dd yy
        uextra.EndRegoDate=dat2int(y1,m1,d1);   // convert mm dd yy to regodate
        lseek(userextrah,(long)(x-1) * (long)sizeof(uextra),SEEK_SET);
        write(userextrah, &uextra, sizeof(uextra));
        if(ezy.config.USDateForSysop)
            VIOprintf("%-25.25s -- Endregodate: %02d-%02d-%d\r\n",user.Name,m1,d1,y1);
        else
            VIOprintf("%-25.25s -- Endregodate: %02d-%02d-%d\r\n",user.Name,d1,m1,y1);
    }

    }

}

close(userbaseh);
close(userextrah);
close(limitsezyh);
}

void assign_queue(unsigned int start, unsigned int end, char group, char *pathstr, int queuenum)
{
char filepath[MAXFILEPATHLENGTH];   // FILES.EZY path
int filepathh;                      // FILES.EZY file handle
FilePathRecord arearec;
char areaname[100];

sprintf(filepath, "%sFILEPATH.EZY", ezy.ezydir);
printf("\r\n Opening %s", filepath);
if((filepathh=sopen(filepath,O_BINARY|O_RDWR, SH_DENYNONE)) < 1)
    {
    VIOprintf("\r\n Error opening %s\r\n", filepath);
    exit(1);
    }

VIOprintf("Assigning Queue #%d to paths containing \"%s\"\r\n",queuenum,pathstr);

  for(unsigned int x=start;x<=end;x++)
  {
    lseek(filepathh,(long)((long)sizeof(arearec)*(long)((long)x-1L)),SEEK_SET);

    read(filepathh, &arearec, sizeof(arearec));

    strcpy(areaname, arearec.FilePath);
    strcpy(areaname, ezy.pas_to_c(areaname));

    if((arearec.FilePath[0] != 0) &&
       strstr(areaname,pathstr)
       )
        {
            VIOprintf("Working on Path (%s)\r\n",areaname);
            arearec.CDRomStack = queuenum;

            lseek(filepathh,(long)((long)sizeof(arearec)*(long)((long)x-1L)),SEEK_SET);
            write(filepathh, &arearec, sizeof(arearec));
        }



  }

close(filepathh);
}

// onset/mastset
// 0 = Do nothing
// 1 = Turn on
// 2 = Turn off
// 3 = Toggle
void mlist_set(unsigned int start, unsigned int end, char group, int onset, int mastset)
{
char filesezy[MAXFILEPATHLENGTH];   // FILES.EZY path
int filesezyh;                      // FILES.EZY file handle
FilesEzyRecord arearec;
char areaname[100];

sprintf(filesezy, "%sFILES.EZY", ezy.ezydir);
printf("\r\n Opening %s", filesezy);
if((filesezyh=sopen(filesezy,O_BINARY|O_RDWR, SH_DENYNONE)) < 1)
    {
    VIOprintf("\r\n Error opening %s\r\n", filesezy);
    exit(1);
    }

  for(unsigned int x=start;x<=end;x++)
  {
    lseek(filesezyh,(long)((long)sizeof(arearec)*(long)((long)x-1L)),SEEK_SET);

    read(filesezyh, &arearec, sizeof(arearec));

    if((arearec.Name[0] != 0) &&
      ((group == '*') ? 1 : group == arearec.FileGroup))
        {
            strcpy(areaname, arearec.Name);
            strcpy(areaname, ezy.pas_to_c(areaname));
            VIOprintf("Working on Area #%d (%s)\r\n",x,areaname);
            switch(onset) {
                case 0: break;
                case 1: arearec.Attribute |= 16; break;
                case 2: arearec.Attribute &=~ 16; break;
                case 3: if(arearec.Attribute & 16) arearec.Attribute &=~ 16;
                    else arearec.Attribute |= 16; break;
                default: break;
            }

            switch(mastset) {
                case 0: break;
                case 1: arearec.Attribute |= 128; break;
                case 2: arearec.Attribute &=~ 128; break;
                case 3: if(arearec.Attribute & 128) arearec.Attribute &=~ 128;
                    else arearec.Attribute |= 128; break;
                default: break;
            }

            lseek(filesezyh,(long)((long)sizeof(arearec)*(long)((long)x-1L)),SEEK_SET);
            write(filesezyh, &arearec, sizeof(arearec));
        }



  }

close(filesezyh);
}

