*--- PUBLIC DOMAIN SOFTWARE
*--- made by Branislav Stofko Trebisovska 21   821 01 Bratislava  Slovakia
*--- This source code for database compiler FORCE may bee freelly modified
*--- and after them translated with other compilers. Please remove my name,
*--- from source, if you make any modifications.
*--- I am not responsible for any damages made in with this code.
*---
#include fileio.hdr
#include string.hdr
#include system.hdr
*-------------------
PROCEDURE FORCE_MAIN
PARAMETERS CONST CHAR(127) Cmnd_line
*-------------------
VARDEF
  UINT		  Blanks, Increment, Position_of_then
  UINT		  Line_counter, Line_length
  FILE		  Input_handle, Output_handle
  CHAR(4)	  Previous_line
  CHAR(8)	  File_name
  CHAR(255)       Original_line, Upper_line
  LOGICAL         Structure_on, Second_line, Virgin
ENDDEF
*--- this is the best solution (default)
Increment     = 2
Structure_on  = .F.
Previous_line = ""
*--- get file_name and increment from command line
Upper_line = UPPER(TRIM(Cmnd_line))
*--- determine if there is a INCREMENT switch
Blanks = AT("/I:",Upper_line)
IF Blanks > 0
  Increment = I_val(SUBSTR(Upper_line,Blanks+3,1))
ENDIF
*--- determine if there is a STRUCTURE switch
Blanks = AT("/S",Upper_line)
IF Blanks > 0
  Structure_on = .T.
ENDIF
*--- now get file_name from command line
*--- really max. 8 chars are copied because File_name has length 8 !!!
File_name = Upper_line
*--- strip out eventually extension
Blanks = AT(".",File_name)
IF Blanks > 0
  File_name = SUBSTR(File_name,1,Blanks-1)
ENDIF
*--- first character "/" ends the file name
Blanks = AT("/",File_name)
IF Blanks > 0
  File_name = SUBSTR(File_name,1,Blanks-1)
ENDIF
*--- I hope we have at end some name
IF File_name = ""
  ? " CLIPPER source file reformatter           FREEWARE B.Stofko"
  ?
  ? " Syntax: CLF <filename> [options]"
  ?
  ? " Options: /I:n  use increment of n blanks for indent, default = 2"
  ?
  ? " Options: /S    generate comment lines before and after PROCEDURE and FUNCTION"
  ?
  ? " Output:        the same filename !!!"
  ?
ELSE
  *--- the name is defined, but I dont know if really exist
  IF EXIST(File_name+".PRG")
    IF F_open(Input_handle,File_name+".PRG",&F_read)
      *--- the same name but with extension .LST will be created
      IF F_open(Output_handle,File_name+".LST",&F_create)
        Blanks       = 0
        Line_counter = 0
        Virgin       = .T.
        *--- go thru whole input file
        DO WHILE .NOT. F_eof(Input_handle)
          IF F_getln(Input_handle,Original_line)
            *--- strip out spaces from begin and end of line
            Original_line = LTRIM(TRIM(Original_line))
            *--- Supress blank lines with no code , no comment, no money
            *--- FORCEs function F_putln produces CR and LF before line
            *--- After reformating you can see a blank line at begin
            *--- of reformated source. This will be partially eliminated
            *--- vith variable Virgin
            IF Original_line = "" .AND. Virgin
              *--- do nothing as NEXT SENTENCE in old COBOL
            ELSE
              *--- change eventually FORCE comments to CLIPERs // - !!!
              IF SUBSTR(Original_line,1,3) = "*--"
                Original_line = "// " + SUBSTR(Original_line,4,255)
              ENDIF
              *--- convert to UPPER CASE characters
              Upper_line = UPPER(Original_line)
              *--- delete CLIPPERs STATIC keyword
              IF AT("STATIC",Upper_line) = 1
                Upper_line = LTRIM(SUBSTR(Upper_line,7,255))
              ENDIF
              *--- give my some signals on CRT
              IF Line_counter = 10
                ?? "X"
                Line_counter = 0
              ELSE
                Line_counter = Line_counter + 1
              ENDIF
              *--- END must be proccesed before output
              IF AT("END",Upper_line) = 1
                Original_line = "END" + SUBSTR(Original_line,4,255)
                IF Blanks => Increment
                  Blanks = Blanks - Increment
                ENDIF
              ENDIF
              *--- ELSE too , but after output of line go back please
              IF AT("ELSE",Upper_line) = 1
                Original_line = "ELSE" + SUBSTR(Original_line,5,255)
                IF Blanks => Increment
                  Blanks = Blanks - Increment
                ENDIF
              ENDIF
              *--- NEXT must be proccesed before output
              IF AT("NEXT",Upper_line) = 1
                Original_line = "NEXT" + SUBSTR(Original_line,5,255)
                IF Blanks => Increment
                  Blanks = Blanks - Increment
                ENDIF
              ENDIF
              *--- change keywords to UPPER CASE
              IF AT("PROCEDURE",Upper_line) = 1
                Original_line = "PROCEDURE" + SUBSTR(Original_line,10,255)
              ELSE
                IF AT("FUNCTION",Upper_line) = 1
                  Original_line = "FUNCTION" + SUBSTR(Original_line,9,255)
                ELSE
                  IF AT("IF",Upper_line) = 1
                    Original_line = "IF" + SUBSTR(Original_line,3,255)
                  ELSE
                    IF AT("FOR",Upper_line) = 1
                      Original_line = "FOR" + SUBSTR(Original_line,4,255)
                    ENDIF
                  ENDIF
                ENDIF
              ENDIF
              *--- set flag for PROCEDURE and FUNCTION underline
              Second_line = .F.
              *--- if STRUCTURE ON then make
              *--- first additionally line before and after
              IF AT("PROCEDURE",Upper_line) = 1 .OR. ;
                AT("FUNCTION",Upper_line) = 1
                *--- but only if is this wanted too
                IF Structure_on
                  Line_length = Blanks + LEN(Original_line) - 1
                  *--- make no addionally line if there was before !!!
                  *--- may be some peoples are reformating source code twice
                  *--- I am dooing this every day
                  IF Previous_line <> "// -"
                    F_putln(Output_handle,"// "+REPLICATE("-",Line_length-2))
                    Second_line = .T.
                  ENDIF
                ENDIF
              ENDIF
              *--- and this is all for this moment
              F_putln(Output_handle,REPLICATE(" ",Blanks)+Original_line)
              *--- only 4 character are really stored for next comparision
              Previous_line = Original_line
              *--- if STRUCTURE ON make second extra line after if wanted
              IF Second_line
                F_putln(Output_handle,"// "+REPLICATE("-",Line_length-2))
              ENDIF
              *--- set new position of next line after some words
              IF AT("IF ",Upper_line) = 1
                Blanks = Blanks + Increment
              ENDIF
              IF AT("ELSE",Upper_line) = 1
                Blanks = Blanks + Increment
              ENDIF
              IF AT("FOR",Upper_line) = 1
                Blanks = Blanks + Increment
              ENDIF
              IF AT("DO CASE",Upper_line) = 1
                Blanks = Blanks + Increment
              ENDIF
              IF AT("DO",Upper_line) = 1 .AND. AT("WHILE",Upper_line) > 1
                Blanks = Blanks + Increment
              ENDIF
              *--- other blank lines will be processed
              Virgin = .F.
            ENDIF
          ELSE
            ?
            ?? "Sorry, read error has been detected"
          ENDIF
          *--- next line please
        ENDDO
        *--- close both files
        F_close(Output_handle)
      ENDIF
      F_close(Input_handle)
      ? " "
      *--- and now will be new file renamed to old one
      ERASE File_name + ".PRG"
      RENAME File_name + ".LST" TO File_name + ".PRG"
    ENDIF
  ELSE
    ? "Source file "
    ?? File_name
    ?? ".PRG not found !"
  ENDIF
ENDIF
ENDPRO
